/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUiHandlerImpl;
import git4idea.branch.GitBranchWorker;
import git4idea.branch.GitBrancher;
import git4idea.commands.Git;
import git4idea.repo.GitRepository;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitBrancherImpl
implements GitBrancher {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;

    GitBrancherImpl(@NotNull Project project, @NotNull Git git) {
        if (project == null) {
            GitBrancherImpl.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitBrancherImpl.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myGit = git;
    }

    @Override
    public void checkoutNewBranch(final @NotNull String name, final @NotNull List<GitRepository> repositories) {
        if (name == null) {
            GitBrancherImpl.$$$reportNull$$$0(2);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(3);
        }
        new CommonBackgroundTask(this.myProject, "Checking out new branch " + name, null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).checkoutNewBranch(name, repositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$1", "execute"));
            }
        }.runInBackground();
    }

    private GitBranchWorker newWorker(ProgressIndicator indicator) {
        return new GitBranchWorker(this.myProject, this.myGit, new GitBranchUiHandlerImpl(this.myProject, this.myGit, indicator));
    }

    @Override
    public void createBranch(final @NotNull String name, final @NotNull Map<GitRepository, String> startPoints) {
        if (name == null) {
            GitBrancherImpl.$$$reportNull$$$0(4);
        }
        if (startPoints == null) {
            GitBrancherImpl.$$$reportNull$$$0(5);
        }
        new CommonBackgroundTask(this.myProject, "Creating branch " + name, null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).createBranch(name, startPoints);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$2", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void createNewTag(final @NotNull String name, final @NotNull String reference, final @NotNull List<GitRepository> repositories, @Nullable Runnable callInAwtLater) {
        if (name == null) {
            GitBrancherImpl.$$$reportNull$$$0(6);
        }
        if (reference == null) {
            GitBrancherImpl.$$$reportNull$$$0(7);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(8);
        }
        new CommonBackgroundTask(this.myProject, "Checking out new branch " + name, callInAwtLater){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).createNewTag(name, reference, repositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$3", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void checkout(final @NotNull String reference, final boolean detach, final @NotNull List<GitRepository> repositories, @Nullable Runnable callInAwtLater) {
        if (reference == null) {
            GitBrancherImpl.$$$reportNull$$$0(9);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(10);
        }
        new CommonBackgroundTask(this.myProject, "Checking out " + reference, callInAwtLater){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).checkout(reference, detach, repositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$4", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void checkoutNewBranchStartingFrom(final @NotNull String newBranchName, final @NotNull String startPoint, final @NotNull List<GitRepository> repositories, @Nullable Runnable callInAwtLater) {
        if (newBranchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(11);
        }
        if (startPoint == null) {
            GitBrancherImpl.$$$reportNull$$$0(12);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(13);
        }
        new CommonBackgroundTask(this.myProject, String.format("Checking out %s from %s", newBranchName, startPoint), callInAwtLater){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).checkoutNewBranchStartingFrom(newBranchName, startPoint, repositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$5", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void deleteBranch(final @NotNull String branchName, final @NotNull List<GitRepository> repositories) {
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(14);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(15);
        }
        new CommonBackgroundTask(this.myProject, "Deleting " + branchName, null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    6.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).deleteBranch(branchName, repositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$6", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void deleteRemoteBranch(final @NotNull String branchName, final @NotNull List<GitRepository> repositories) {
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(16);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(17);
        }
        new CommonBackgroundTask(this.myProject, "Deleting " + branchName, null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    7.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).deleteRemoteBranch(branchName, repositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$7", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void compare(final @NotNull String branchName, final @NotNull List<GitRepository> repositories, final @NotNull GitRepository selectedRepository) {
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(18);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(19);
        }
        if (selectedRepository == null) {
            GitBrancherImpl.$$$reportNull$$$0(20);
        }
        new CommonBackgroundTask(this.myProject, "Comparing with " + branchName, null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    8.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).compare(branchName, repositories, selectedRepository);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$8", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void merge(final @NotNull String branchName, final @NotNull GitBrancher.DeleteOnMergeOption deleteOnMerge, final @NotNull List<GitRepository> repositories) {
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(21);
        }
        if (deleteOnMerge == null) {
            GitBrancherImpl.$$$reportNull$$$0(22);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(23);
        }
        new CommonBackgroundTask(this.myProject, "Merging " + branchName, null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    9.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).merge(branchName, deleteOnMerge, repositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$9", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void rebase(final @NotNull List<GitRepository> repositories, final @NotNull String branchName) {
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(24);
        }
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(25);
        }
        new CommonBackgroundTask(this.myProject, "Rebasing onto " + branchName, null){

            @Override
            void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    10.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).rebase(repositories, branchName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$10", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void rebaseOnCurrent(final @NotNull List<GitRepository> repositories, final @NotNull String branchName) {
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(26);
        }
        if (branchName == null) {
            GitBrancherImpl.$$$reportNull$$$0(27);
        }
        new CommonBackgroundTask(this.myProject, "Rebasing " + branchName + "...", null){

            @Override
            void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    11.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).rebaseOnCurrent(repositories, branchName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$11", "execute"));
            }
        }.runInBackground();
    }

    @Override
    public void renameBranch(final @NotNull String currentName, final @NotNull String newName, final @NotNull List<GitRepository> repositories) {
        if (currentName == null) {
            GitBrancherImpl.$$$reportNull$$$0(28);
        }
        if (newName == null) {
            GitBrancherImpl.$$$reportNull$$$0(29);
        }
        if (repositories == null) {
            GitBrancherImpl.$$$reportNull$$$0(30);
        }
        new CommonBackgroundTask(this.myProject, "Renaming " + currentName + " to " + newName + "...", null){

            @Override
            void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    12.$$$reportNull$$$0(0);
                }
                GitBrancherImpl.this.newWorker(indicator).renameBranch(currentName, newName, repositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBrancherImpl$12", "execute"));
            }
        }.runInBackground();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 23: 
            case 24: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPoints";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newBranchName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPoint";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRepository";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleteOnMerge";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentName";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        objectArray2[1] = "git4idea/branch/GitBrancherImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkoutNewBranch";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createBranch";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createNewTag";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "checkout";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "checkoutNewBranchStartingFrom";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteBranch";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteRemoteBranch";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "compare";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "merge";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "rebase";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "rebaseOnCurrent";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "renameBranch";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class CommonBackgroundTask
    extends Task.Backgroundable {
        @Nullable
        private final Runnable myCallInAwtAfterExecution;

        private CommonBackgroundTask(@Nullable Project project, @NotNull String title, @Nullable Runnable callInAwtAfterExecution) {
            if (title == null) {
                CommonBackgroundTask.$$$reportNull$$$0(0);
            }
            super(project, title);
            this.myCallInAwtAfterExecution = callInAwtAfterExecution;
        }

        public final void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                CommonBackgroundTask.$$$reportNull$$$0(1);
            }
            DumbService.getInstance((Project)this.myProject).suspendIndexingAndRun(this.getTitle(), () -> {
                if (indicator == null) {
                    CommonBackgroundTask.$$$reportNull$$$0(2);
                }
                this.execute(indicator);
            });
            if (this.myCallInAwtAfterExecution != null) {
                Application application = ApplicationManager.getApplication();
                if (application.isUnitTestMode()) {
                    this.myCallInAwtAfterExecution.run();
                } else {
                    application.invokeLater(this.myCallInAwtAfterExecution, application.getDefaultModalityState());
                }
            }
        }

        abstract void execute(@NotNull ProgressIndicator var1);

        void runInBackground() {
            GitVcs.runInBackground(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "git4idea/branch/GitBrancherImpl$CommonBackgroundTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$run$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

