/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandlerListener;
import git4idea.commands.GitTextHandler;
import git4idea.i18n.GitBundle;
import java.io.File;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class GitSimpleHandler
extends GitTextHandler {
    public static final String DURING_EXECUTING_ERROR_MESSAGE = "during executing";
    private final StringBuilder myStderr;
    private final StringBuilder myStderrLine;
    private final StringBuilder myStdout;
    private final StringBuilder myStdoutLine;
    private final HashSet<Integer> myIgnoredErrorCodes;

    public GitSimpleHandler(@NotNull Project project, @NotNull File directory, @NotNull GitCommand command) {
        if (project == null) {
            GitSimpleHandler.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            GitSimpleHandler.$$$reportNull$$$0(1);
        }
        if (command == null) {
            GitSimpleHandler.$$$reportNull$$$0(2);
        }
        super(project, directory, command);
        this.myStderr = new StringBuilder();
        this.myStderrLine = new StringBuilder();
        this.myStdout = new StringBuilder();
        this.myStdoutLine = new StringBuilder();
        this.myIgnoredErrorCodes = new HashSet();
    }

    public GitSimpleHandler(@NotNull Project project, @NotNull VirtualFile directory, @NotNull GitCommand command) {
        if (project == null) {
            GitSimpleHandler.$$$reportNull$$$0(3);
        }
        if (directory == null) {
            GitSimpleHandler.$$$reportNull$$$0(4);
        }
        if (command == null) {
            GitSimpleHandler.$$$reportNull$$$0(5);
        }
        super(project, directory, command);
        this.myStderr = new StringBuilder();
        this.myStderrLine = new StringBuilder();
        this.myStdout = new StringBuilder();
        this.myStdoutLine = new StringBuilder();
        this.myIgnoredErrorCodes = new HashSet();
    }

    @Override
    protected void processTerminated(int exitCode) {
        String stdout = this.myStdoutLine.toString();
        String stderr = this.myStderrLine.toString();
        if (!this.isStdoutSuppressed() && !StringUtil.isEmptyOrSpaces((String)stdout)) {
            LOG.info(stdout.trim());
            this.myStdoutLine.setLength(0);
        } else if (!this.isStderrSuppressed() && !StringUtil.isEmptyOrSpaces((String)stderr)) {
            LOG.info(stderr.trim());
            this.myStderrLine.setLength(0);
        } else {
            LOG.debug(stderr.trim());
            OUTPUT_LOG.debug(stdout.trim());
        }
    }

    @Deprecated
    public void unsilence() {
    }

    @Override
    protected void onTextAvailable(String text, Key outputType) {
        boolean suppressed;
        StringBuilder lineRest;
        StringBuilder entire;
        if (ProcessOutputTypes.STDOUT == outputType) {
            entire = this.myStdout;
            lineRest = this.myStdoutLine;
            suppressed = this.isStdoutSuppressed();
        } else if (ProcessOutputTypes.STDERR == outputType) {
            entire = this.myStderr;
            lineRest = this.myStderrLine;
            suppressed = this.isStderrSuppressed();
        } else {
            return;
        }
        entire.append(text);
        if (suppressed && !LOG.isDebugEnabled()) {
            return;
        }
        char last = lineRest.length() > 0 ? (char)lineRest.charAt(lineRest.length() - 1) : (char)'\uffffffff';
        int start = 0;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (last == '\n' || last == '\r') {
                int savedPos = (ch == '\n' || ch == '\r') && ch != last ? i - 1 : i;
                if (last != '\r' || savedPos != i) {
                    String line;
                    if (lineRest.length() == 0) {
                        line = lineRest.append(text.substring(start, savedPos)).toString();
                        lineRest.setLength(0);
                    } else {
                        line = text.substring(start, savedPos);
                    }
                    if (!StringUtil.isEmptyOrSpaces((String)line)) {
                        if (!suppressed) {
                            LOG.info(line.trim());
                        } else {
                            LOG.debug(line.trim());
                        }
                    }
                }
                start = savedPos;
            }
            last = ch;
        }
        if (start != text.length()) {
            lineRest.append(text.substring(start));
        }
    }

    public String getStderr() {
        return this.myStderr.toString();
    }

    public String getStdout() {
        return this.myStdout.toString();
    }

    public String run() throws VcsException {
        final Ref exRef = Ref.create();
        final Ref resultRef = Ref.create();
        this.addListener(new GitHandlerListener(){

            public void processTerminated(int exitCode) {
                try {
                    if (exitCode == 0 || GitSimpleHandler.this.isIgnoredErrorCode(exitCode)) {
                        resultRef.set((Object)GitSimpleHandler.this.getStdout());
                    } else {
                        String msg = GitSimpleHandler.this.getStderr();
                        if (msg.length() == 0) {
                            msg = GitSimpleHandler.this.getStdout();
                        }
                        if (msg.length() == 0) {
                            msg = GitBundle.message("git.error.exit", exitCode);
                        }
                        exRef.set((Object)new VcsException(msg));
                    }
                }
                catch (Throwable t) {
                    exRef.set((Object)new VcsException(t.toString(), t));
                }
            }

            public void startFailed(Throwable exception) {
                exRef.set((Object)new VcsException("Process failed to start (" + GitSimpleHandler.this.myCommandLine.getCommandLineString() + "): " + exception.toString(), exception));
            }
        });
        this.runInCurrentThread();
        if (!exRef.isNull()) {
            throw new VcsException(((VcsException)((Object)exRef.get())).getMessage() + " " + DURING_EXECUTING_ERROR_MESSAGE + " " + this.printableCommandLine(), (Throwable)exRef.get());
        }
        if (resultRef.isNull()) {
            throw new VcsException("The git command returned null: " + this.printableCommandLine());
        }
        return (String)resultRef.get();
    }

    public void ignoreErrorCode(int code) {
        this.myIgnoredErrorCodes.add(code);
    }

    public boolean isIgnoredErrorCode(int code) {
        return this.myIgnoredErrorCodes.contains(code);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "directory";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "command";
                break;
            }
        }
        objectArray[1] = "git4idea/commands/GitSimpleHandler";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

