/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.push.OutgoingCommitsProvider;
import com.intellij.dvcs.push.PushSettings;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.Pusher;
import com.intellij.dvcs.push.VcsPushOptionsPanel;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.util.ObjectUtils;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitSharedSettings;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersionSpecialty;
import git4idea.push.GitOutgoingCommitsProvider;
import git4idea.push.GitPushOptionsPanel;
import git4idea.push.GitPushSource;
import git4idea.push.GitPushTarget;
import git4idea.push.GitPushTargetPanel;
import git4idea.push.GitPusher;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitHooksInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPushSupport
extends PushSupport<GitRepository, GitPushSource, GitPushTarget> {
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final GitVcs myVcs;
    @NotNull
    private final Pusher<GitRepository, GitPushSource, GitPushTarget> myPusher;
    @NotNull
    private final OutgoingCommitsProvider<GitRepository, GitPushSource, GitPushTarget> myOutgoingCommitsProvider;
    @NotNull
    private final GitVcsSettings mySettings;
    private final GitSharedSettings mySharedSettings;
    @NotNull
    private final PushSettings myCommonPushSettings;

    private GitPushSupport(@NotNull Project project, @NotNull GitRepositoryManager repositoryManager) {
        if (project == null) {
            GitPushSupport.$$$reportNull$$$0(0);
        }
        if (repositoryManager == null) {
            GitPushSupport.$$$reportNull$$$0(1);
        }
        this.myRepositoryManager = repositoryManager;
        this.myVcs = GitVcs.getInstance(project);
        this.mySettings = GitVcsSettings.getInstance(project);
        this.myPusher = new GitPusher(project, this.mySettings, this);
        this.myOutgoingCommitsProvider = new GitOutgoingCommitsProvider(project);
        this.mySharedSettings = (GitSharedSettings)ServiceManager.getService((Project)project, GitSharedSettings.class);
        this.myCommonPushSettings = (PushSettings)ServiceManager.getService((Project)project, PushSettings.class);
    }

    @NotNull
    public AbstractVcs getVcs() {
        GitVcs gitVcs = this.myVcs;
        if (gitVcs == null) {
            GitPushSupport.$$$reportNull$$$0(2);
        }
        return gitVcs;
    }

    @NotNull
    public Pusher<GitRepository, GitPushSource, GitPushTarget> getPusher() {
        Pusher<GitRepository, GitPushSource, GitPushTarget> pusher = this.myPusher;
        if (pusher == null) {
            GitPushSupport.$$$reportNull$$$0(3);
        }
        return pusher;
    }

    @NotNull
    public OutgoingCommitsProvider<GitRepository, GitPushSource, GitPushTarget> getOutgoingCommitsProvider() {
        OutgoingCommitsProvider<GitRepository, GitPushSource, GitPushTarget> outgoingCommitsProvider = this.myOutgoingCommitsProvider;
        if (outgoingCommitsProvider == null) {
            GitPushSupport.$$$reportNull$$$0(4);
        }
        return outgoingCommitsProvider;
    }

    @Nullable
    public GitPushTarget getDefaultTarget(@NotNull GitRepository repository) {
        if (repository == null) {
            GitPushSupport.$$$reportNull$$$0(5);
        }
        if (repository.isFresh()) {
            return null;
        }
        GitLocalBranch currentBranch = repository.getCurrentBranch();
        if (currentBranch == null) {
            return null;
        }
        GitPushTarget pushSpecTarget = GitPushTarget.getFromPushSpec(repository, currentBranch);
        if (pushSpecTarget != null) {
            return pushSpecTarget;
        }
        GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfoForBranch(repository, currentBranch);
        if (trackInfo != null) {
            return new GitPushTarget(trackInfo.getRemoteBranch(), false);
        }
        return GitPushSupport.proposeTargetForNewBranch(repository, currentBranch);
    }

    private static GitPushTarget proposeTargetForNewBranch(@NotNull GitRepository repository, @NotNull GitLocalBranch currentBranch) {
        GitRemote remote;
        if (repository == null) {
            GitPushSupport.$$$reportNull$$$0(6);
        }
        if (currentBranch == null) {
            GitPushSupport.$$$reportNull$$$0(7);
        }
        if ((remote = GitUtil.getDefaultOrFirstRemote(repository.getRemotes())) == null) {
            return null;
        }
        return GitPushSupport.makeTargetForNewBranch(repository, remote, currentBranch);
    }

    @NotNull
    private static GitPushTarget makeTargetForNewBranch(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull GitLocalBranch currentBranch) {
        GitRemoteBranch existingRemoteBranch;
        if (repository == null) {
            GitPushSupport.$$$reportNull$$$0(8);
        }
        if (remote == null) {
            GitPushSupport.$$$reportNull$$$0(9);
        }
        if (currentBranch == null) {
            GitPushSupport.$$$reportNull$$$0(10);
        }
        if ((existingRemoteBranch = GitUtil.findRemoteBranch(repository, remote, currentBranch.getName())) != null) {
            GitPushTarget gitPushTarget = new GitPushTarget(existingRemoteBranch, false);
            if (gitPushTarget == null) {
                GitPushSupport.$$$reportNull$$$0(11);
            }
            return gitPushTarget;
        }
        GitPushTarget gitPushTarget = new GitPushTarget(new GitStandardRemoteBranch(remote, currentBranch.getName()), true);
        if (gitPushTarget == null) {
            GitPushSupport.$$$reportNull$$$0(12);
        }
        return gitPushTarget;
    }

    @NotNull
    public GitPushSource getSource(@NotNull GitRepository repository) {
        GitLocalBranch currentBranch;
        if (repository == null) {
            GitPushSupport.$$$reportNull$$$0(13);
        }
        GitPushSource gitPushSource = (currentBranch = repository.getCurrentBranch()) != null ? GitPushSource.create(currentBranch) : GitPushSource.create((String)ObjectUtils.assertNotNull((Object)repository.getCurrentRevision()));
        if (gitPushSource == null) {
            GitPushSupport.$$$reportNull$$$0(14);
        }
        return gitPushSource;
    }

    @NotNull
    public RepositoryManager<GitRepository> getRepositoryManager() {
        GitRepositoryManager gitRepositoryManager = this.myRepositoryManager;
        if (gitRepositoryManager == null) {
            GitPushSupport.$$$reportNull$$$0(15);
        }
        return gitRepositoryManager;
    }

    @NotNull
    public PushTargetPanel<GitPushTarget> createTargetPanel(@NotNull GitRepository repository, @Nullable GitPushTarget defaultTarget) {
        if (repository == null) {
            GitPushSupport.$$$reportNull$$$0(16);
        }
        GitPushTargetPanel gitPushTargetPanel = new GitPushTargetPanel(this, repository, defaultTarget);
        if (gitPushTargetPanel == null) {
            GitPushSupport.$$$reportNull$$$0(17);
        }
        return gitPushTargetPanel;
    }

    public boolean isForcePushAllowed(@NotNull GitRepository repo, @NotNull GitPushTarget target) {
        String targetBranch;
        if (repo == null) {
            GitPushSupport.$$$reportNull$$$0(18);
        }
        if (target == null) {
            GitPushSupport.$$$reportNull$$$0(19);
        }
        return !this.mySharedSettings.isBranchProtected(targetBranch = target.getBranch().getNameForRemoteOperations());
    }

    @Nullable
    public VcsPushOptionsPanel createOptionsPanel() {
        return new GitPushOptionsPanel(this.mySettings.getPushTagMode(), GitVersionSpecialty.SUPPORTS_FOLLOW_TAGS.existsIn(this.myVcs.getVersion()), this.shouldShowSkipHookOption());
    }

    private boolean shouldShowSkipHookOption() {
        return GitVersionSpecialty.PRE_PUSH_HOOK.existsIn(this.myVcs.getVersion()) && this.getRepositoryManager().getRepositories().stream().map(e -> e.getInfo().getHooksInfo()).anyMatch(GitHooksInfo::isPrePushHookAvailable);
    }

    public boolean isSilentForcePushAllowed(@NotNull GitPushTarget target) {
        if (target == null) {
            GitPushSupport.$$$reportNull$$$0(20);
        }
        return this.myCommonPushSettings.containsForcePushTarget(target.getBranch().getRemote().getName(), target.getBranch().getNameForRemoteOperations());
    }

    public void saveSilentForcePushTarget(@NotNull GitPushTarget target) {
        if (target == null) {
            GitPushSupport.$$$reportNull$$$0(21);
        }
        this.myCommonPushSettings.addForcePushTarget(target.getBranch().getRemote().getName(), target.getBranch().getNameForRemoteOperations());
    }

    public boolean mayChangeTargetsSync() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryManager";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/push/GitPushSupport";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentBranch";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repo";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/push/GitPushSupport";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcs";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPusher";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutgoingCommitsProvider";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "makeTargetForNewBranch";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSource";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryManager";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargetPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTarget";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "proposeTargetForNewBranch";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "makeTargetForNewBranch";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSource";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createTargetPanel";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isForcePushAllowed";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isSilentForcePushAllowed";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "saveSilentForcePushTarget";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

