/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.ContainingBranchesGetter;
import com.intellij.vcs.log.data.VcsLogData;
import git4idea.GitUtil;
import git4idea.rebase.GitCommitEditingAction$WhenMappings;
import git4idea.rebase.GitRebaseUtilsKt;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002J&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J\b\u0010\u0015\u001a\u00020\u0004H$J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0004J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0004J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\nH\u0004J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\nH\u0004J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\nH\u0004J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\t\u001a\u00020\nH\u0004J\"\u0010!\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u00042\b\b\u0002\u0010#\u001a\u00020 H\u0004J\u0010\u0010$\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lgit4idea/rebase/GitCommitEditingAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "COMMIT_NOT_IN_HEAD", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "commitPushedToProtectedBranchError", "protectedBranch", "findContainingBranches", "", "data", "Lcom/intellij/vcs/log/data/VcsLogData;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "hash", "Lcom/intellij/vcs/log/Hash;", "getFailureTitle", "getLog", "Lcom/intellij/vcs/log/VcsLog;", "getLogData", "getRepository", "Lgit4idea/repo/GitRepository;", "getSelectedCommit", "Lcom/intellij/vcs/log/VcsShortCommitDetails;", "getUi", "Lcom/intellij/vcs/log/VcsLogUi;", "isHeadCommit", "", "prohibitRebaseDuringRebase", "operation", "allowRebaseIfHeadCommit", "update", "intellij.vcs.git"})
public abstract class GitCommitEditingAction
extends DumbAwareAction {
    private final Logger LOG;
    private final String COMMIT_NOT_IN_HEAD = "The commit is not in the current branch";

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        super.update(e);
        Project project = e.getProject();
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        VcsLogData data = (VcsLogData)e.getData(VcsLogDataKeys.VCS_LOG_DATA_PROVIDER);
        VcsLogUi ui = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        if (project == null || log == null || data == null || ui == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        int selectedCommits = log.getSelectedShortDetails().size();
        if (selectedCommits != 1) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        VcsShortCommitDetails commit2 = (VcsShortCommitDetails)log.getSelectedShortDetails().get(0);
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(commit2.getRoot());
        if (repository == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        int parents = commit2.getParents().size();
        if (parents != 1) {
            e.getPresentation().setEnabled(false);
            e.getPresentation().setDescription("Selected commit has " + parents + " parents");
            return;
        }
        Collection branches = log.getContainingBranches((Hash)commit2.getId(), commit2.getRoot());
        if (branches != null) {
            if (!branches.contains("HEAD")) {
                e.getPresentation().setEnabled(false);
                e.getPresentation().setDescription(this.COMMIT_NOT_IN_HEAD);
                return;
            }
            String protectedBranch = GitRebaseUtilsKt.findProtectedRemoteBranch(repository, branches);
            if (protectedBranch != null) {
                e.getPresentation().setEnabled(false);
                e.getPresentation().setDescription(this.commitPushedToProtectedBranchError(protectedBranch));
                return;
            }
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        Object object = e.getRequiredData(VcsLogDataKeys.VCS_LOG_DATA_PROVIDER);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.vcs.log.data.VcsLogData");
        }
        VcsLogData data = (VcsLogData)object;
        VcsLog log = (VcsLog)e.getRequiredData(VcsLogDataKeys.VCS_LOG);
        VcsShortCommitDetails commit2 = (VcsShortCommitDetails)log.getSelectedShortDetails().get(0);
        Repository repository = GitUtil.getRepositoryManager(project).getRepositoryForRoot(commit2.getRoot());
        if (repository == null) {
            Intrinsics.throwNpe();
        }
        GitRepository repository2 = (GitRepository)repository;
        VirtualFile virtualFile = commit2.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"commit.root");
        Hash hash = (Hash)commit2.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)hash, (String)"commit.id");
        List<String> branches = this.findContainingBranches(data, virtualFile, hash);
        if (!branches.contains("HEAD")) {
            Messages.showErrorDialog((Project)project, (String)this.COMMIT_NOT_IN_HEAD, (String)this.getFailureTitle());
            return;
        }
        GitRepository gitRepository = repository2;
        Intrinsics.checkExpressionValueIsNotNull((Object)gitRepository, (String)"repository");
        String protectedBranch = GitRebaseUtilsKt.findProtectedRemoteBranch(gitRepository, (Collection<String>)branches);
        if (protectedBranch != null) {
            Messages.showErrorDialog((Project)project, (String)this.commitPushedToProtectedBranchError(protectedBranch), (String)this.getFailureTitle());
            return;
        }
    }

    @NotNull
    protected final VcsLog getLog(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        return (VcsLog)e.getRequiredData(VcsLogDataKeys.VCS_LOG);
    }

    @NotNull
    protected final VcsLogData getLogData(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Object object = e.getRequiredData(VcsLogDataKeys.VCS_LOG_DATA_PROVIDER);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.vcs.log.data.VcsLogData");
        }
        return (VcsLogData)object;
    }

    @NotNull
    protected final VcsLogUi getUi(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        return (VcsLogUi)e.getRequiredData(VcsLogDataKeys.VCS_LOG_UI);
    }

    @NotNull
    protected final VcsShortCommitDetails getSelectedCommit(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Object e2 = this.getLog(e).getSelectedShortDetails().get(0);
        if (e2 == null) {
            Intrinsics.throwNpe();
        }
        return (VcsShortCommitDetails)e2;
    }

    @NotNull
    protected final GitRepository getRepository(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            Intrinsics.throwNpe();
        }
        Repository repository = GitUtil.getRepositoryManager(project).getRepositoryForRoot(this.getSelectedCommit(e).getRoot());
        if (repository == null) {
            Intrinsics.throwNpe();
        }
        return (GitRepository)repository;
    }

    @NotNull
    protected abstract String getFailureTitle();

    @NotNull
    protected final List<String> findContainingBranches(@NotNull VcsLogData data, @NotNull VirtualFile root, @NotNull Hash hash) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        ContainingBranchesGetter branchesGetter = data.getContainingBranchesGetter();
        List list = branchesGetter.getContainingBranchesQuickly(root, hash);
        if (list == null) {
            Object object = ProgressManager.getInstance().runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<List<? extends String>, RuntimeException>(branchesGetter, root, hash){
                final /* synthetic */ ContainingBranchesGetter $branchesGetter;
                final /* synthetic */ VirtualFile $root;
                final /* synthetic */ Hash $hash;

                @NotNull
                public final List<String> compute() {
                    return this.$branchesGetter.getContainingBranchesSynchronously(this.$root, this.$hash);
                }
                {
                    this.$branchesGetter = containingBranchesGetter;
                    this.$root = virtualFile;
                    this.$hash = hash;
                }
            }, "Searching for branches containing the selected commit", true, data.getProject());
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ProgressManager.getInsta\u2026mit\", true, data.project)");
            list = (List)object;
        }
        return list;
    }

    private final String commitPushedToProtectedBranchError(String protectedBranch) {
        return "The commit is already pushed to protected branch '" + protectedBranch + '\'';
    }

    protected final void prohibitRebaseDuringRebase(@NotNull AnActionEvent e, @NotNull String operation, boolean allowRebaseIfHeadCommit) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        if (e.getPresentation().isEnabledAndVisible()) {
            String string;
            Repository.State state = this.getRepository(e).getState();
            if (Intrinsics.areEqual((Object)state, (Object)Repository.State.NORMAL) || Intrinsics.areEqual((Object)state, (Object)Repository.State.DETACHED)) {
                return;
            }
            if (Intrinsics.areEqual((Object)state, (Object)Repository.State.REBASING) && allowRebaseIfHeadCommit && this.isHeadCommit(e)) {
                return;
            }
            e.getPresentation().setEnabled(false);
            Presentation presentation = e.getPresentation();
            switch (GitCommitEditingAction$WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: {
                    string = "Can't " + operation + " during rebase";
                    break;
                }
                case 2: {
                    string = "Can't " + operation + " during merge";
                    break;
                }
                default: {
                    this.LOG.error((Throwable)new IllegalStateException("Unexpected state: " + state));
                    string = "Can't " + operation + " during " + state;
                }
            }
            presentation.setDescription(string);
        }
    }

    public static /* bridge */ /* synthetic */ void prohibitRebaseDuringRebase$default(GitCommitEditingAction gitCommitEditingAction, AnActionEvent anActionEvent, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: prohibitRebaseDuringRebase");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        gitCommitEditingAction.prohibitRebaseDuringRebase(anActionEvent, string, bl);
    }

    protected final boolean isHeadCommit(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        return Intrinsics.areEqual((Object)((Hash)this.getSelectedCommit(e).getId()).asString(), (Object)this.getRepository(e).getCurrentRevision());
    }

    public GitCommitEditingAction() {
        Logger logger;
        GitCommitEditingAction gitCommitEditingAction = this;
        Logger logger2 = Logger.getInstance(GitCommitEditingAction.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        gitCommitEditingAction.LOG = logger = logger2;
        this.COMMIT_NOT_IN_HEAD = "The commit is not in the current branch";
    }
}

