/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.TextCopyProvider;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ComboBoxTableCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.table.ComboBoxTableCellEditor;
import git4idea.GitUtil;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseEntry;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRebaseEditor
extends DialogWrapper
implements DataProvider {
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final MyTableModel myTableModel;
    @NotNull
    private final JBTable myCommitsTable;
    @NotNull
    private final CopyProvider myCopyProvider;

    protected GitRebaseEditor(@NotNull Project project, @NotNull VirtualFile gitRoot, @NotNull List<GitRebaseEntry> entries) {
        if (project == null) {
            GitRebaseEditor.$$$reportNull$$$0(0);
        }
        if (gitRoot == null) {
            GitRebaseEditor.$$$reportNull$$$0(1);
        }
        if (entries == null) {
            GitRebaseEditor.$$$reportNull$$$0(2);
        }
        super(project, true);
        this.myProject = project;
        this.myRoot = gitRoot;
        this.setTitle(GitBundle.getString("rebase.editor.title"));
        this.setOKButtonText(GitBundle.getString("rebase.editor.button"));
        this.myTableModel = new MyTableModel(entries);
        this.myTableModel.addTableModelListener(e -> this.validateFields());
        this.myCommitsTable = new JBTable((TableModel)this.myTableModel);
        this.myCommitsTable.setSelectionMode(1);
        this.myCommitsTable.setIntercellSpacing((Dimension)JBUI.emptySize());
        PopupHandler.installRowSelectionTablePopup((JTable)this.myCommitsTable, (ActionGroup)this.generateSelectRebaseActionActionGroup(), (String)"EditorPopup", (ActionManager)ActionManager.getInstance());
        this.myCommitsTable.setDefaultRenderer(String.class, (TableCellRenderer)new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                if (value != null) {
                    this.append(value.toString());
                    SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)GitRebaseEditor.this.myCommitsTable, (SimpleColoredComponent)this, (boolean)true, (boolean)selected);
                }
            }
        });
        TableColumn actionColumn = this.myCommitsTable.getColumnModel().getColumn(0);
        actionColumn.setCellEditor((TableCellEditor)ComboBoxTableCellEditor.INSTANCE);
        actionColumn.setCellRenderer(ComboBoxTableCellRenderer.INSTANCE);
        this.installSpeedSearch();
        this.myCopyProvider = new MyCopyProvider();
        this.adjustColumnWidth(0);
        this.adjustColumnWidth(1);
        this.init();
    }

    private void installSpeedSearch() {
        new TableSpeedSearch((JTable)this.myCommitsTable, (o, cell) -> cell.column == 0 ? null : String.valueOf(o));
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myCommitsTable;
    }

    private void adjustColumnWidth(int columnIndex) {
        int contentWidth = this.myCommitsTable.getExpandedColumnWidth(columnIndex) + 10;
        TableColumn column = this.myCommitsTable.getColumnModel().getColumn(columnIndex);
        column.setMaxWidth(contentWidth);
        column.setPreferredWidth(contentWidth);
    }

    private void validateFields() {
        GitRebaseEntry.Action action;
        int i;
        List entries = this.myTableModel.myEntries;
        if (entries.size() == 0) {
            this.setErrorText(GitBundle.getString("rebase.editor.invalid.entryset"), (JComponent)this.myCommitsTable);
            this.setOKActionEnabled(false);
            return;
        }
        for (i = 0; i < entries.size() && ((GitRebaseEntry)entries.get(i)).getAction() == GitRebaseEntry.Action.skip; ++i) {
        }
        if (i < entries.size() && ((action = ((GitRebaseEntry)entries.get(i)).getAction()) == GitRebaseEntry.Action.squash || action == GitRebaseEntry.Action.fixup)) {
            this.setErrorText(GitBundle.message("rebase.editor.invalid.squash", StringUtil.toLowerCase((String)action.name())), (JComponent)this.myCommitsTable);
            this.setOKActionEnabled(false);
            return;
        }
        this.setErrorText(null);
        this.setOKActionEnabled(true);
    }

    protected JComponent createCenterPanel() {
        return ToolbarDecorator.createDecorator((JTable)this.myCommitsTable).disableAddAction().disableRemoveAction().addExtraAction((AnActionButton)new MyDiffAction()).setMoveUpAction((AnActionButtonRunnable)new MoveUpDownActionListener(MoveDirection.UP)).setMoveDownAction((AnActionButtonRunnable)new MoveUpDownActionListener(MoveDirection.DOWN)).createPanel();
    }

    @NotNull
    private ActionGroup generateSelectRebaseActionActionGroup() {
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(ContainerUtil.map((Object[])GitRebaseEntry.Action.values(), action -> new AnAction(action.toString(), (GitRebaseEntry.Action)((Object)action)){
            final /* synthetic */ GitRebaseEntry.Action val$action;
            {
                this.val$action = action;
                super(arg0);
            }

            public void actionPerformed(AnActionEvent e) {
                int[] selectedRows;
                for (int i : selectedRows = GitRebaseEditor.this.myCommitsTable.getSelectedRows()) {
                    GitRebaseEditor.this.myTableModel.setValueAt((Object)this.val$action, i, 0);
                }
            }
        }));
        if (defaultActionGroup == null) {
            GitRebaseEditor.$$$reportNull$$$0(3);
        }
        return defaultActionGroup;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.RebaseCommits";
    }

    @NotNull
    public List<GitRebaseEntry> getEntries() {
        List list = this.myTableModel.myEntries;
        if (list == null) {
            GitRebaseEditor.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myCopyProvider;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitRoot";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/rebase/GitRebaseEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/rebase/GitRebaseEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "generateSelectRebaseActionActionGroup";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyCopyProvider
    extends TextCopyProvider {
        private MyCopyProvider() {
        }

        @Nullable
        public Collection<String> getTextLinesToCopy() {
            if (GitRebaseEditor.this.myCommitsTable.getSelectedRowCount() > 0) {
                ArrayList lines = ContainerUtil.newArrayList();
                for (int row : GitRebaseEditor.this.myCommitsTable.getSelectedRows()) {
                    lines.add(GitRebaseEditor.this.myTableModel.getStringToCopy(row));
                }
                return lines;
            }
            return null;
        }
    }

    private class MoveUpDownActionListener
    implements AnActionButtonRunnable {
        private final MoveDirection direction;

        public MoveUpDownActionListener(MoveDirection direction) {
            if (direction == null) {
                MoveUpDownActionListener.$$$reportNull$$$0(0);
            }
            this.direction = direction;
        }

        public void run(AnActionButton button) {
            GitRebaseEditor.this.myTableModel.moveRows(GitRebaseEditor.this.myCommitsTable.getSelectedRows(), this.direction);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "direction", "git4idea/rebase/GitRebaseEditor$MoveUpDownActionListener", "<init>"));
        }
    }

    private class MyDiffAction
    extends ToolbarDecorator.ElementActionButton
    implements DumbAware {
        MyDiffAction() {
            super("View", "View commit contents", AllIcons.Actions.ListChanges);
            this.registerCustomShortcutSet(CommonShortcuts.getDiff(), (JComponent)GitRebaseEditor.this.myCommitsTable);
        }

        public void actionPerformed(AnActionEvent e) {
            int row = GitRebaseEditor.this.myCommitsTable.getSelectedRow();
            assert (row >= 0 && row < GitRebaseEditor.this.myTableModel.getRowCount());
            GitRebaseEntry entry = (GitRebaseEntry)GitRebaseEditor.this.myTableModel.myEntries.get(row);
            GitUtil.showSubmittedFiles(GitRebaseEditor.this.myProject, entry.getCommit(), GitRebaseEditor.this.myRoot, false, false);
        }

        public boolean isEnabled() {
            return super.isEnabled() && GitRebaseEditor.this.myCommitsTable.getSelectedRowCount() == 1;
        }
    }

    private static enum MoveDirection {
        UP,
        DOWN;


        public int offset() {
            return this == UP ? -1 : 1;
        }

        public int[] preprocessRowIndexes(int[] selection) {
            int[] copy = (int[])selection.clone();
            Arrays.sort(copy);
            return this == UP ? copy : ArrayUtil.reverseArray((int[])copy);
        }
    }

    private static class ContiguousIntIntervalTracker {
        private Integer myMin = null;
        private Integer myMax = null;
        private static final int UNSET_VALUE = -1;

        private ContiguousIntIntervalTracker() {
        }

        public Integer getMin() {
            return this.myMin == null ? -1 : this.myMin;
        }

        public Integer getMax() {
            return this.myMax == null ? -1 : this.myMax;
        }

        public void track(int ... entries) {
            for (int entry : entries) {
                this.checkMax(entry);
                this.checkMin(entry);
            }
        }

        private void checkMax(int entry) {
            if (null == this.myMax || entry > this.myMax) {
                this.myMax = entry;
            }
        }

        private void checkMin(int entry) {
            if (null == this.myMin || entry < this.myMin) {
                this.myMin = entry;
            }
        }

        public boolean hasValues() {
            return null != this.myMin && null != this.myMax;
        }
    }

    private class MyTableModel
    extends AbstractTableModel
    implements EditableModel {
        private static final int ACTION_COLUMN = 0;
        private static final int HASH_COLUMN = 1;
        private static final int SUBJECT_COLUMN = 2;
        @NotNull
        private final List<GitRebaseEntry> myEntries;
        private int[] myLastEditableSelectedRows;

        MyTableModel(List<GitRebaseEntry> entries) {
            if (entries == null) {
                MyTableModel.$$$reportNull$$$0(0);
            }
            this.myLastEditableSelectedRows = new int[0];
            this.myEntries = entries;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 0 ? GitRebaseEntry.Action.class : String.class;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return GitBundle.getString("rebase.editor.action.column");
                }
                case 1: {
                    return GitBundle.getString("rebase.editor.commit.column");
                }
                case 2: {
                    return GitBundle.getString("rebase.editor.comment.column");
                }
            }
            throw new IllegalArgumentException("Unsupported column index: " + column);
        }

        @Override
        public int getRowCount() {
            return this.myEntries.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            GitRebaseEntry e = this.myEntries.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return e.getAction();
                }
                case 1: {
                    return e.getCommit();
                }
                case 2: {
                    return e.getSubject();
                }
            }
            throw new IllegalArgumentException("Unsupported column index: " + columnIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            assert (columnIndex == 0);
            if (ArrayUtil.indexOf((int[])this.myLastEditableSelectedRows, (int)rowIndex) > -1) {
                ContiguousIntIntervalTracker intervalBuilder = new ContiguousIntIntervalTracker();
                for (int lastEditableSelectedRow : this.myLastEditableSelectedRows) {
                    intervalBuilder.track(lastEditableSelectedRow);
                    this.setRowAction(aValue, lastEditableSelectedRow, columnIndex);
                }
                this.setSelection(intervalBuilder);
            } else {
                this.setRowAction(aValue, rowIndex, columnIndex);
            }
        }

        public void addRow() {
            throw new UnsupportedOperationException();
        }

        public void exchangeRows(int oldIndex, int newIndex) {
            GitRebaseEntry movingElement = this.myEntries.remove(oldIndex);
            this.myEntries.add(newIndex, movingElement);
            this.fireTableRowsUpdated(Math.min(oldIndex, newIndex), Math.max(oldIndex, newIndex));
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return true;
        }

        public void removeRow(int idx) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public String getStringToCopy(int row) {
            if (row < 0 || row >= this.myEntries.size()) {
                return null;
            }
            GitRebaseEntry e = this.myEntries.get(row);
            return e.getCommit() + " " + e.getSubject();
        }

        private void setSelection(@NotNull ContiguousIntIntervalTracker intervalBuilder) {
            if (intervalBuilder == null) {
                MyTableModel.$$$reportNull$$$0(1);
            }
            GitRebaseEditor.this.myCommitsTable.getSelectionModel().setSelectionInterval(intervalBuilder.getMin(), intervalBuilder.getMax());
        }

        private void setRowAction(@NotNull Object aValue, int rowIndex, int columnIndex) {
            if (aValue == null) {
                MyTableModel.$$$reportNull$$$0(2);
            }
            GitRebaseEntry e = this.myEntries.get(rowIndex);
            e.setAction((GitRebaseEntry.Action)((Object)aValue));
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            this.myLastEditableSelectedRows = GitRebaseEditor.this.myCommitsTable.getSelectedRows();
            return columnIndex == 0;
        }

        public void moveRows(@NotNull int[] rows, @NotNull MoveDirection direction) {
            if (rows == null) {
                MyTableModel.$$$reportNull$$$0(3);
            }
            if (direction == null) {
                MyTableModel.$$$reportNull$$$0(4);
            }
            GitRebaseEditor.this.myCommitsTable.removeEditor();
            ContiguousIntIntervalTracker selectionInterval = new ContiguousIntIntervalTracker();
            ContiguousIntIntervalTracker rowsUpdatedInterval = new ContiguousIntIntervalTracker();
            for (int row : direction.preprocessRowIndexes(rows)) {
                int targetIndex = row + direction.offset();
                this.assertIndexInRange(row, targetIndex);
                Collections.swap(this.myEntries, row, targetIndex);
                rowsUpdatedInterval.track(targetIndex, row);
                selectionInterval.track(targetIndex);
            }
            if (selectionInterval.hasValues()) {
                this.setSelection(selectionInterval);
                this.fireTableRowsUpdated(rowsUpdatedInterval.getMin(), rowsUpdatedInterval.getMax());
            }
        }

        private void assertIndexInRange(int ... rowIndexes) {
            for (int rowIndex : rowIndexes) {
                assert (rowIndex >= 0);
                assert (rowIndex < this.myEntries.size());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entries";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "intervalBuilder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aValue";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rows";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "direction";
                    break;
                }
            }
            objectArray2[1] = "git4idea/rebase/GitRebaseEditor$MyTableModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelection";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setRowAction";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moveRows";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

