/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleExtensionImpl;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidJpsProjectUtil {
    @NonNls
    public static final String ANDROID_STORAGE_DIR = "android";
    @NonNls
    public static final String GENERATED_RESOURCES_DIR_NAME = "generated_resources";
    @NonNls
    private static final String GENERATED_SOURCES_FOLDER_NAME = "generated_sources";
    @NonNls
    private static final String COPIED_SOURCES_FOLDER_NAME = "copied_sources";

    static JpsAndroidModuleExtension getExtension(@NotNull JpsModule module) {
        if (module == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(0);
        }
        return (JpsAndroidModuleExtension)module.getContainer().getChild(JpsAndroidModuleExtensionImpl.KIND);
    }

    public static boolean isAndroidProjectWithoutGradleFacet(@NotNull JpsProject project) {
        if (project == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(1);
        }
        return AndroidJpsProjectUtil.isAndroidProjectWithoutGradleFacet(project.getModules());
    }

    public static boolean isAndroidProjectWithoutGradleFacet(@NotNull ModuleChunk chunk) {
        if (chunk == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(2);
        }
        return AndroidJpsProjectUtil.isAndroidProjectWithoutGradleFacet(chunk.getModules());
    }

    private static boolean isAndroidProjectWithoutGradleFacet(@NotNull Collection<JpsModule> modules) {
        if (modules == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(3);
        }
        boolean hasAndroidFacet = false;
        for (JpsModule module : modules) {
            JpsAndroidModuleExtension androidFacet = AndroidJpsProjectUtil.getExtension(module);
            if (androidFacet == null) continue;
            hasAndroidFacet = true;
            if (!androidFacet.isGradleProject()) continue;
            return false;
        }
        return hasAndroidFacet;
    }

    @NotNull
    public static File getGeneratedResourcesStorage(@NotNull JpsModule module, BuildDataManager dataManager) {
        if (module == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(4);
        }
        File file = AndroidJpsProjectUtil.getGeneratedResourcesStorage(module, dataManager.getDataPaths());
        if (file == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(5);
        }
        return file;
    }

    @NotNull
    static File getGeneratedResourcesStorage(@NotNull JpsModule module, @NotNull BuildDataPaths dataPaths) {
        if (module == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(6);
        }
        if (dataPaths == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(7);
        }
        File targetDataRoot = dataPaths.getTargetDataRoot((BuildTarget)new ModuleBuildTarget(module, JavaModuleBuildTargetType.PRODUCTION));
        File file = AndroidJpsProjectUtil.getStorageDir(targetDataRoot, GENERATED_RESOURCES_DIR_NAME);
        if (file == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(8);
        }
        return file;
    }

    @NotNull
    public static File getStorageFile(@NotNull File dataStorageRoot, @NotNull String storageName) {
        if (dataStorageRoot == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(9);
        }
        if (storageName == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(10);
        }
        File file = new File(AndroidJpsProjectUtil.getStorageDir(dataStorageRoot, storageName), storageName);
        if (file == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(11);
        }
        return file;
    }

    @NotNull
    public static File getStorageDir(@NotNull File dataStorageRoot, @NotNull String storageName) {
        if (dataStorageRoot == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(12);
        }
        if (storageName == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(13);
        }
        File file = new File(new File(dataStorageRoot, ANDROID_STORAGE_DIR), storageName);
        if (file == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(14);
        }
        return file;
    }

    @NotNull
    public static File getGeneratedSourcesStorage(@NotNull JpsModule module, BuildDataPaths dataPaths) {
        if (module == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(15);
        }
        File targetDataRoot = dataPaths.getTargetDataRoot((BuildTarget)new ModuleBuildTarget(module, JavaModuleBuildTargetType.PRODUCTION));
        File file = AndroidJpsProjectUtil.getStorageDir(targetDataRoot, GENERATED_SOURCES_FOLDER_NAME);
        if (file == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(16);
        }
        return file;
    }

    @NotNull
    public static File getCopiedSourcesStorage(@NotNull JpsModule module, @NotNull BuildDataPaths dataPaths) {
        if (module == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(17);
        }
        if (dataPaths == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(18);
        }
        File targetDataRoot = dataPaths.getTargetDataRoot((BuildTarget)new ModuleBuildTarget(module, JavaModuleBuildTargetType.PRODUCTION));
        File file = AndroidJpsProjectUtil.getStorageDir(targetDataRoot, COPIED_SOURCES_FOLDER_NAME);
        if (file == null) {
            AndroidJpsProjectUtil.$$$reportNull$$$0(19);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/android/AndroidJpsProjectUtil";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPaths";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStorageRoot";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/android/AndroidJpsProjectUtil";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratedResourcesStorage";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageFile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageDir";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratedSourcesStorage";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCopiedSourcesStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAndroidProjectWithoutGradleFacet";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getGeneratedResourcesStorage";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 19: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getStorageFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getStorageDir";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getGeneratedSourcesStorage";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCopiedSourcesStorage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

