/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build.output;

import com.intellij.build.BuildProgressListener;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import com.intellij.openapi.util.Ref;
import java.io.Closeable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildOutputInstantReaderImpl
implements Appendable,
Closeable,
BuildOutputInstantReader {
    private static final int MAX_LINES_BUFFER_SIZE = 50;
    private final Object myBuildId;
    @Nullable
    private StringBuilder myBuffer;
    private final BlockingQueue<String> myQueue;
    private int myCurrentIndex;
    private LinkedList<String> myLinesBuffer;
    public static final String SHUTDOWN_PILL = new String("Poison Pill Shutdown");
    private Thread myThread;
    private final AtomicBoolean myStarted;
    private final AtomicBoolean myClosed;

    public BuildOutputInstantReaderImpl(@NotNull Object buildId, @NotNull BuildProgressListener buildProgressListener, @NotNull List<BuildOutputParser> parsers) {
        if (buildId == null) {
            BuildOutputInstantReaderImpl.$$$reportNull$$$0(0);
        }
        if (buildProgressListener == null) {
            BuildOutputInstantReaderImpl.$$$reportNull$$$0(1);
        }
        if (parsers == null) {
            BuildOutputInstantReaderImpl.$$$reportNull$$$0(2);
        }
        this.myQueue = new LinkedTransferQueue<String>();
        this.myCurrentIndex = -1;
        this.myLinesBuffer = new LinkedList();
        this.myStarted = new AtomicBoolean();
        this.myClosed = new AtomicBoolean();
        this.myBuildId = buildId;
        this.myThread = new Thread(() -> {
            String line;
            if (buildProgressListener == null) {
                BuildOutputInstantReaderImpl.$$$reportNull$$$0(3);
            }
            if (parsers == null) {
                BuildOutputInstantReaderImpl.$$$reportNull$$$0(4);
            }
            Ref lastMessageRef = Ref.create();
            Consumer<MessageEvent> messageConsumer = event -> {
                if (buildProgressListener == null) {
                    BuildOutputInstantReaderImpl.$$$reportNull$$$0(5);
                }
                if (!event.equals(lastMessageRef.get())) {
                    buildProgressListener.onEvent((BuildEvent)event);
                }
                lastMessageRef.set(event);
            };
            while ((line = this.readLine()) != null) {
                BuildOutputParser parser;
                if (line.trim().isEmpty()) continue;
                Iterator iterator = parsers.iterator();
                while (iterator.hasNext() && !(parser = (BuildOutputParser)iterator.next()).parse(line, this, messageConsumer)) {
                }
            }
        }, "Build output processor");
    }

    @Override
    public Object getBuildId() {
        return this.myBuildId;
    }

    @Override
    public Appendable append(CharSequence csq) {
        for (int i = 0; i < csq.length(); ++i) {
            this.append(csq.charAt(i));
        }
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) {
        this.append(csq.subSequence(start, end));
        return this;
    }

    @Override
    public Appendable append(char c) {
        if (this.myBuffer == null) {
            this.myBuffer = new StringBuilder();
        }
        if (c == '\n') {
            this.doFlush();
        } else {
            this.myBuffer.append(c);
        }
        return this;
    }

    @Override
    public void close() {
        this.doFlush();
        try {
            this.myQueue.put(SHUTDOWN_PILL);
            this.myThread.join(TimeUnit.MINUTES.toMillis(1L));
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.myClosed.set(true);
        }
    }

    private void doFlush() {
        if (this.myBuffer == null) {
            return;
        }
        String line = this.myBuffer.toString();
        this.myBuffer.setLength(0);
        try {
            if (this.myStarted.compareAndSet(false, true)) {
                this.myThread.start();
            }
            this.myQueue.put(line);
        }
        catch (InterruptedException ignore) {
            this.myClosed.set(true);
        }
    }

    @Override
    @Nullable
    public String readLine() {
        if (this.myClosed.get()) {
            return null;
        }
        ++this.myCurrentIndex;
        if (this.myLinesBuffer.size() > this.myCurrentIndex) {
            return this.myLinesBuffer.get(this.myCurrentIndex);
        }
        try {
            String line = this.myQueue.take();
            if (line == SHUTDOWN_PILL) {
                this.myClosed.set(true);
                return null;
            }
            this.myLinesBuffer.addLast(line);
            if (this.myLinesBuffer.size() > 50) {
                this.myLinesBuffer.removeFirst();
            }
            return line;
        }
        catch (InterruptedException ignore) {
            this.myClosed.set(true);
            return null;
        }
    }

    @Override
    public void pushBack() {
        --this.myCurrentIndex;
    }

    @Override
    public void pushBack(int numberOfLines) {
        this.myCurrentIndex -= numberOfLines;
    }

    @Override
    public String getCurrentLine() {
        return this.myLinesBuffer.size() > this.myCurrentIndex ? this.myLinesBuffer.get(this.myCurrentIndex) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildId";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildProgressListener";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsers";
                break;
            }
        }
        objectArray2[1] = "com/intellij/build/output/BuildOutputInstantReaderImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$new$1";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

