/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.CommonBundle;
import com.intellij.compiler.impl.CleanStaleModuleOutputsActivity;
import com.intellij.compiler.impl.CleanStaleModuleOutputsActivity$runActivity$;
import com.intellij.compiler.server.BuildManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J,\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/compiler/impl/CleanStaleModuleOutputsActivity;", "Lcom/intellij/openapi/startup/StartupActivity;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "collectStaleOutputs", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "runActivity", "", "runCleanup", "outputs", "onSuccess", "Lkotlin/Function0;", "intellij.java.compiler.impl"})
public final class CleanStaleModuleOutputsActivity
implements StartupActivity,
DumbAware {
    public void runActivity(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        File markerFile = new File(BuildManager.getInstance().getProjectSystemDirectory(project2), "stale_outputs_checked");
        if (markerFile.exists()) {
            return;
        }
        Function0<Unit> createMarker$ = new Function0<Unit>(markerFile){
            final /* synthetic */ File $markerFile;

            public final void invoke() {
                FileUtil.createIfDoesntExist((File)this.$markerFile);
            }
            {
                this.$markerFile = file;
                super(0);
            }
        };
        List staleOutputs = (List)ApplicationManager.getApplication().runReadAction(new Computable<T>(this, project2){
            final /* synthetic */ CleanStaleModuleOutputsActivity this$0;
            final /* synthetic */ Project $project$inlined;
            {
                this.this$0 = cleanStaleModuleOutputsActivity;
                this.$project$inlined = project2;
            }

            public final T compute() {
                return (T)CleanStaleModuleOutputsActivity.access$collectStaleOutputs(this.this$0, this.$project$inlined);
            }
        });
        if (staleOutputs.isEmpty()) {
            createMarker$.invoke();
            return;
        }
        ApplicationManager.getApplication().runReadAction(new Computable<T>(this, project2, staleOutputs, createMarker$){
            final /* synthetic */ CleanStaleModuleOutputsActivity this$0;
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ List $staleOutputs$inlined;
            final /* synthetic */ runActivity.1 $createMarker$1$inlined;
            {
                this.this$0 = cleanStaleModuleOutputsActivity;
                this.$project$inlined = project2;
                this.$staleOutputs$inlined = list;
                this.$createMarker$1$inlined = var4_4;
            }

            public final T compute() {
                CompilerProjectExtension compilerProjectExtension = CompilerProjectExtension.getInstance((Project)this.$project$inlined);
                if (compilerProjectExtension == null) {
                    Intrinsics.throwNpe();
                }
                VirtualFile virtualFile = compilerProjectExtension.getCompilerOutput();
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                String outputPath = virtualFile.getPresentableUrl();
                Notification notification = new Notification("Build", CompilerBundle.message((String)"notification.title.delete.old.output.directories", (Object[])new Object[0]), CompilerBundle.message((String)"notification.content.delete.old.output.directories", (Object[])new Object[]{this.$staleOutputs$inlined.size(), outputPath}), NotificationType.INFORMATION).addAction((AnAction)new NotificationAction(CompilerBundle.message((String)"notification.action.text.cleanup", (Object[])new Object[0]), this){
                    final /* synthetic */ runActivity$$inlined$runReadAction$2 this$0;
                    {
                        this.this$0 = var2_2;
                        super($super_call_param$1);
                    }

                    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                        Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
                        notification.expire();
                        CleanStaleModuleOutputsActivity.access$runCleanup(this.this$0.this$0, this.this$0.$staleOutputs$inlined, this.this$0.$project$inlined, (Function0)new Function0<Unit>(this){
                            final /* synthetic */ runActivity$$inlined$runReadAction$2$lambda$1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }

                            public final void invoke() {
                                this.this$0.this$0.$createMarker$1$inlined.invoke();
                            }

                            public final KDeclarationContainer getOwner() {
                                return null;
                            }

                            public final String getName() {
                                return "createMarker";
                            }

                            public final String getSignature() {
                                return "invoke()V";
                            }
                        });
                    }
                }).addAction((AnAction)new NotificationAction(CompilerBundle.message((String)"notification.action.text.do.not.ask", (Object[])new Object[0]), this){
                    final /* synthetic */ runActivity$$inlined$runReadAction$2 this$0;
                    {
                        this.this$0 = var2_2;
                        super($super_call_param$1);
                    }

                    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                        Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
                        notification.expire();
                        this.this$0.$createMarker$1$inlined.invoke();
                    }
                });
                Notifications.Bus.notify((Notification)notification, (Project)this.$project$inlined);
                return (T)Unit.INSTANCE;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void runCleanup(List<? extends VirtualFile> outputs, Project project2, Function0<Unit> onSuccess) {
        void $receiver$iv$iv;
        Iterable destination$iv$iv;
        Object object;
        Collection collection;
        String outputsString;
        int threshold = 50;
        if (outputs.size() <= threshold + 2) {
            outputsString = CollectionsKt.joinToString$default((Iterable)outputs, (CharSequence)"<br>", null, null, (int)0, null, (Function1)runCleanup.1.INSTANCE, (int)30, null);
        } else {
            VirtualFile it;
            Iterable $receiver$iv$iv2;
            Iterable $receiver$iv;
            Iterable iterable = outputs.subList(threshold, outputs.size());
            Iterable destination$iv = new LinkedHashSet();
            for (Object item$iv : $receiver$iv) {
                void it2;
                VirtualFile virtualFile = (VirtualFile)item$iv;
                collection = destination$iv;
                object = it2.getParent();
                collection.add(object);
            }
            List parents = CollectionsKt.toList((Iterable)destination$iv);
            $receiver$iv = outputs.subList(0, threshold);
            destination$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                VirtualFile $i$a$1$mapTo = (VirtualFile)item$iv$iv;
                collection = destination$iv$iv;
                object = it.getPresentableUrl();
                collection.add(object);
            }
            $receiver$iv = CollectionsKt.drop((Iterable)parents, (int)1);
            collection = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)CollectionsKt.listOf((Object)("" + (outputs.size() - threshold) + " more directories under " + ((VirtualFile)CollectionsKt.first((List)parents)).getPresentableUrl())));
            $receiver$iv$iv2 = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                it = (VirtualFile)item$iv$iv;
                object = destination$iv$iv;
                String string = "and " + it.getPresentableUrl();
                object.add(string);
            }
            object = (List)destination$iv$iv;
            outputsString = CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object)), (CharSequence)"<br>", null, null, (int)0, null, null, (int)62, null);
        }
        int answer = Messages.showOkCancelDialog((Project)project2, (String)CompilerBundle.message((String)"dialog.text.delete.old.outputs", (Object[])new Object[]{outputs.size(), outputsString}), (String)CompilerBundle.message((String)"dialog.title.delete.old.outputs", (Object[])new Object[0]), (String)CompilerBundle.message((String)"button.text.delete.old.outputs", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), null);
        if (answer == 2) {
            return;
        }
        Iterable $receiver$iv = outputs;
        destination$iv$iv = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            VirtualFile $i$a$3$map = (VirtualFile)item$iv$iv;
            collection = destination$iv$iv2;
            object = VfsUtil.virtualToIoFile((VirtualFile)it);
            collection.add(object);
        }
        List filesToDelete = (List)destination$iv$iv2;
        new Task.Backgroundable(filesToDelete, onSuccess, project2, project2, CompilerBundle.message((String)"dialog.title.delete.old.outputs", (Object[])new Object[0])){
            final /* synthetic */ List $filesToDelete;
            final /* synthetic */ Function0 $onSuccess;
            final /* synthetic */ Project $project;

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(false);
                Iterable $receiver$iv = this.$filesToDelete;
                int index$iv = 0;
                for (T item$iv : $receiver$iv) {
                    void file;
                    int n = index$iv++;
                    File file2 = (File)item$iv;
                    int i = n;
                    indicator.checkCanceled();
                    indicator.setFraction((double)i / (double)this.$filesToDelete.size());
                    indicator.setText(CompilerBundle.message((String)"progress.text.deleting.directory", (Object[])new Object[]{file.getAbsolutePath()}));
                    FileUtil.delete((File)file);
                }
                this.$onSuccess.invoke();
                indicator.setText(CompilerBundle.message((String)"progress.text.synchronizing.output.directories", (Object[])new Object[0]));
                LocalFileSystem.getInstance().refreshIoFiles((Iterable)this.$filesToDelete, true, false, null);
            }
            {
                this.$filesToDelete = $captured_local_variable$0;
                this.$onSuccess = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
            }
        }.queue();
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> collectStaleOutputs(Project project2) {
        void $receiver$iv$iv;
        Object[] $receiver$iv;
        void $receiver$iv$iv2;
        void $receiver$iv2;
        VirtualFile projectOutput;
        CompilerProjectExtension compilerProjectExtension = CompilerProjectExtension.getInstance((Project)project2);
        Object object = projectOutput = compilerProjectExtension != null ? compilerProjectExtension.getCompilerOutput() : null;
        if (projectOutput == null) {
            return CollectionsKt.emptyList();
        }
        Iterable iterable = CollectionsKt.listOf((Object[])new String[]{"production", "test"});
        void var5_4 = $receiver$iv2;
        Object[] destination$iv$iv = (Object[])new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            String it = (String)element$iv$iv;
            Object object2 = projectOutput.findChild(it);
            if (object2 == null || (object2 = object2.getChildren()) == null || (object2 = ArraysKt.asIterable((Object[])object2)) == null) {
                object2 = CollectionsKt.emptyList();
            }
            Object list$iv$iv = object2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List outputsOnDisk = (List)destination$iv$iv;
        destination$iv$iv = $receiver$iv = (Object[])ModuleManager.getInstance((Project)project2).getModules();
        Collection destination$iv$iv2 = new ArrayList();
        for (void element$iv$iv : $receiver$iv$iv) {
            Module it = (Module)element$iv$iv;
            CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)it);
            Object[] objectArray = new VirtualFile[2];
            CompilerModuleExtension compilerModuleExtension = extension;
            objectArray[0] = compilerModuleExtension != null ? compilerModuleExtension.getCompilerOutputPath() : null;
            CompilerModuleExtension compilerModuleExtension2 = extension;
            objectArray[1] = compilerModuleExtension2 != null ? compilerModuleExtension2.getCompilerOutputPathForTests() : null;
            Iterable list$iv$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List currentOutputs = (List)destination$iv$iv2;
        return CollectionsKt.minus((Iterable)outputsOnDisk, (Iterable)currentOutputs);
    }

    @NotNull
    public static final /* synthetic */ List access$collectStaleOutputs(CleanStaleModuleOutputsActivity $this, @NotNull Project project2) {
        return $this.collectStaleOutputs(project2);
    }

    public static final /* synthetic */ void access$runCleanup(CleanStaleModuleOutputsActivity $this, @NotNull List outputs, @NotNull Project project2, @NotNull Function0 onSuccess) {
        $this.runCleanup(outputs, project2, (Function0<Unit>)onSuccess);
    }
}

