/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.vcs;

import com.intellij.CommonBundle;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.util.LinkedHashSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnloadedModulesCompilationCheckinHandler
extends CheckinHandler {
    private final Project myProject;
    private final CheckinProjectPanel myCheckinPanel;

    public UnloadedModulesCompilationCheckinHandler(Project project2, CheckinProjectPanel checkinPanel) {
        this.myProject = project2;
        this.myCheckinPanel = checkinPanel;
    }

    @Nullable
    public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
        if (ModuleManager.getInstance((Project)this.myProject).getUnloadedModuleDescriptions().isEmpty()) {
            return null;
        }
        NonFocusableCheckBox checkBox = new NonFocusableCheckBox(CompilerBundle.message((String)"checkbox.text.compile.affected.unloaded.modules", (Object[])new Object[0]));
        return new RefreshableOnComponent((JCheckBox)checkBox){
            final /* synthetic */ JCheckBox val$checkBox;
            {
                this.val$checkBox = jCheckBox;
            }

            public JComponent getComponent() {
                return JBUI.Panels.simplePanel().addToLeft((Component)this.val$checkBox);
            }

            public void refresh() {
            }

            public void saveState() {
                CompilerWorkspaceConfiguration.getInstance((Project)((UnloadedModulesCompilationCheckinHandler)UnloadedModulesCompilationCheckinHandler.this).myProject).COMPILE_AFFECTED_UNLOADED_MODULES_BEFORE_COMMIT = this.val$checkBox.isSelected();
            }

            public void restoreState() {
                this.val$checkBox.setSelected(CompilerWorkspaceConfiguration.getInstance((Project)((UnloadedModulesCompilationCheckinHandler)UnloadedModulesCompilationCheckinHandler.this).myProject).COMPILE_AFFECTED_UNLOADED_MODULES_BEFORE_COMMIT);
            }
        };
    }

    public CheckinHandler.ReturnResult beforeCheckin(@Nullable CommitExecutor executor, PairConsumer<Object, Object> additionalDataConsumer) {
        if (!CompilerWorkspaceConfiguration.getInstance((Project)this.myProject).COMPILE_AFFECTED_UNLOADED_MODULES_BEFORE_COMMIT || ModuleManager.getInstance((Project)this.myProject).getUnloadedModuleDescriptions().isEmpty()) {
            return CheckinHandler.ReturnResult.COMMIT;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)this.myProject);
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
        LinkedHashSet<Module> affectedModules = new LinkedHashSet<Module>();
        for (Object file : this.myCheckinPanel.getVirtualFiles()) {
            if (!compilerManager.isCompilableFileType(file.getFileType())) continue;
            ContainerUtil.addIfNotNull(affectedModules, (Object)fileIndex.getModuleForFile((VirtualFile)file));
        }
        LinkedHashSet<String> affectedUnloadedModules = new LinkedHashSet<String>();
        for (Module module2 : affectedModules) {
            affectedUnloadedModules.addAll(DirectoryIndex.getInstance((Project)this.myProject).getDependentUnloadedModules(module2));
        }
        if (affectedUnloadedModules.isEmpty()) {
            return CheckinHandler.ReturnResult.COMMIT;
        }
        final AtomicReference result = new AtomicReference();
        compilerManager.makeWithModalProgress((CompileScope)new ModuleCompileScope(this.myProject, affectedModules, affectedUnloadedModules, true, false), new CompileStatusNotification(){

            public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                result.set(aborted ? BuildResult.CANCELED : (errors > 0 ? BuildResult.FAILED : BuildResult.SUCCESSFUL));
            }
        });
        if (result.get() == BuildResult.SUCCESSFUL) {
            return CheckinHandler.ReturnResult.COMMIT;
        }
        String message = CompilerBundle.message((String)"dialog.message.compilation.of.unloaded.modules.failed", (Object[])new Object[0]);
        int answer = Messages.showYesNoCancelDialog((Project)this.myProject, (String)XmlStringUtil.wrapInHtml((CharSequence)message), (String)CompilerBundle.message((String)"dialog.title.compilation.failed", (Object[])new Object[0]), (String)CompilerBundle.message((String)"button.text.checkin.handler.commit", (Object[])new Object[0]), (String)CompilerBundle.message((String)"button.text.checkin.handler.show.errors", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), null);
        if (answer == 2) {
            return CheckinHandler.ReturnResult.CANCEL;
        }
        if (answer == 0) {
            return CheckinHandler.ReturnResult.COMMIT;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.MESSAGES_WINDOW);
            if (toolWindow != null) {
                toolWindow.activate(null, false);
            }
        }, ModalityState.NON_MODAL);
        return CheckinHandler.ReturnResult.CLOSE_WINDOW;
    }

    public static class Factory
    extends CheckinHandlerFactory {
        @NotNull
        public CheckinHandler createHandler(@NotNull CheckinProjectPanel panel, @NotNull CommitContext commitContext) {
            if (panel == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (commitContext == null) {
                Factory.$$$reportNull$$$0(1);
            }
            UnloadedModulesCompilationCheckinHandler unloadedModulesCompilationCheckinHandler = new UnloadedModulesCompilationCheckinHandler(panel.getProject(), panel);
            if (unloadedModulesCompilationCheckinHandler == null) {
                Factory.$$$reportNull$$$0(2);
            }
            return unloadedModulesCompilationCheckinHandler;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/compiler/impl/vcs/UnloadedModulesCompilationCheckinHandler$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/compiler/impl/vcs/UnloadedModulesCompilationCheckinHandler$Factory";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createHandler";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum BuildResult {
        SUCCESSFUL,
        FAILED,
        CANCELED;

    }
}

