/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.unscramble.ThreadDumpParser;
import com.intellij.unscramble.ThreadState;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebugSession;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.Location;
import com.sun.jdi.LongValue;
import com.sun.jdi.MonitorInfo;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ThreadDumpAction
extends AnAction
implements AnAction.TransparentUpdate {
    public void actionPerformed(AnActionEvent e) {
        final Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(project2).getContext();
        final DebuggerSession session = context.getDebuggerSession();
        if (session != null && session.isAttached()) {
            final DebugProcessImpl process2 = context.getDebugProcess();
            process2.getManagerThread().invoke(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    VirtualMachineProxyImpl vm = process2.getVirtualMachineProxy();
                    vm.suspend();
                    try {
                        List<ThreadState> threads = ThreadDumpAction.buildThreadStates(vm);
                        ApplicationManager.getApplication().invokeLater(() -> {
                            XDebugSession xSession = session.getXDebugSession();
                            if (xSession != null) {
                                DebuggerUtilsEx.addThreadDump(project2, threads, xSession.getUI(), session);
                            }
                        }, ModalityState.NON_MODAL);
                    }
                    finally {
                        vm.resume();
                    }
                }
            });
        }
    }

    public static List<ThreadState> buildThreadStates(VirtualMachineProxyImpl vmProxy) {
        List<ThreadReference> threads = vmProxy.getVirtualMachine().allThreads();
        ArrayList<ThreadState> result = new ArrayList<ThreadState>();
        HashMap<String, ThreadState> nameToThreadMap = new HashMap<String, ThreadState>();
        HashMap<String, String> waitingMap = new HashMap<String, String>();
        for (ThreadReference threadReference : threads) {
            String state;
            Object tid;
            StringBuilder buffer = new StringBuilder();
            boolean hasEmptyStack = true;
            int threadStatus = threadReference.status();
            if (threadStatus == 0) continue;
            String threadName = ThreadDumpAction.threadName(threadReference);
            ThreadState threadState = new ThreadState(threadName, ThreadDumpAction.threadStatusToState(threadStatus));
            nameToThreadMap.put(threadName, threadState);
            result.add(threadState);
            threadState.setJavaThreadState(ThreadDumpAction.threadStatusToJavaThreadState(threadStatus));
            buffer.append("\"").append(threadName).append("\"");
            ReferenceType referenceType = threadReference.referenceType();
            if (referenceType != null) {
                Value value;
                Value value2;
                Field priority;
                Value value3;
                Field daemon = referenceType.fieldByName("daemon");
                if (daemon != null && (value3 = threadReference.getValue(daemon)) instanceof BooleanValue && ((BooleanValue)value3).booleanValue()) {
                    buffer.append(" ").append(DebuggerBundle.message((String)"threads.export.attribute.label.daemon", (Object[])new Object[0]));
                    threadState.setDaemon(true);
                }
                if ((priority = referenceType.fieldByName("priority")) != null && (value2 = threadReference.getValue(priority)) instanceof IntegerValue) {
                    buffer.append(" ").append(DebuggerBundle.message((String)"threads.export.attribute.label.priority", (Object[])new Object[]{((IntegerValue)value2).intValue()}));
                }
                if ((tid = referenceType.fieldByName("tid")) != null && (value = threadReference.getValue((Field)tid)) instanceof LongValue) {
                    buffer.append(" ").append(DebuggerBundle.message((String)"threads.export.attribute.label.tid", (Object[])new Object[]{Long.toHexString(((LongValue)value).longValue())}));
                    buffer.append(" nid=NA");
                }
            }
            if ((state = threadState.getState()) != null) {
                buffer.append(" ").append(state);
            }
            buffer.append("\n  java.lang.Thread.State: ").append(threadState.getJavaThreadState());
            try {
                List<StackFrame> frames;
                ThreadReference waitedMonitorOwner;
                ObjectReference waitedMonitor;
                if (vmProxy.canGetOwnedMonitorInfo() && vmProxy.canGetMonitorInfo()) {
                    List<ObjectReference> list = threadReference.ownedMonitors();
                    tid = list.iterator();
                    while (tid.hasNext()) {
                        ObjectReference reference = (ObjectReference)tid.next();
                        if (!vmProxy.canGetMonitorFrameInfo()) {
                            buffer.append("\n\t ").append(ThreadDumpAction.renderLockedObject(reference));
                        }
                        List<ThreadReference> waiting = reference.waitingThreads();
                        Iterator<ThreadReference> iterator = waiting.iterator();
                        while (iterator.hasNext()) {
                            ThreadReference thread = iterator.next();
                            String waitingThreadName = ThreadDumpAction.threadName(thread);
                            waitingMap.put(waitingThreadName, threadName);
                            buffer.append("\n\t ").append(DebuggerBundle.message((String)"threads.export.attribute.label.blocks.thread", (Object[])new Object[]{waitingThreadName}));
                        }
                    }
                }
                ObjectReference objectReference = waitedMonitor = vmProxy.canGetCurrentContendedMonitor() ? threadReference.currentContendedMonitor() : null;
                if (waitedMonitor != null && vmProxy.canGetMonitorInfo() && (waitedMonitorOwner = waitedMonitor.owningThread()) != null) {
                    String monitorOwningThreadName = ThreadDumpAction.threadName(waitedMonitorOwner);
                    waitingMap.put(threadName, monitorOwningThreadName);
                    buffer.append("\n\t ").append(DebuggerBundle.message((String)"threads.export.attribute.label.waiting.for.thread", (Object[])new Object[]{monitorOwningThreadName, ThreadDumpAction.renderObject(waitedMonitor)}));
                }
                hasEmptyStack = (frames = threadReference.frames()).size() == 0;
                TIntObjectHashMap lockedAt = new TIntObjectHashMap();
                if (vmProxy.canGetMonitorFrameInfo()) {
                    for (MonitorInfo info : threadReference.ownedMonitorsAndFrames()) {
                        int stackDepth = info.stackDepth();
                        List monitors = (List)lockedAt.get(stackDepth);
                        if (monitors == null) {
                            monitors = new SmartList();
                            lockedAt.put(stackDepth, (Object)monitors);
                        }
                        monitors.add(info.monitor());
                    }
                }
                int framesSize = frames.size();
                for (int i = 0; i < framesSize; ++i) {
                    StackFrame stackFrame = frames.get(i);
                    try {
                        Location location = stackFrame.location();
                        buffer.append("\n\t  ").append(ThreadDumpAction.renderLocation(location));
                        List monitors = (List)lockedAt.get(i);
                        if (monitors == null) continue;
                        for (ObjectReference monitor : monitors) {
                            buffer.append("\n\t  - ").append(ThreadDumpAction.renderLockedObject(monitor));
                        }
                        continue;
                    }
                    catch (InvalidStackFrameException e) {
                        buffer.append("\n\t  Invalid stack frame: ").append(e.getMessage());
                    }
                }
            }
            catch (IncompatibleThreadStateException e) {
                buffer.append("\n\t ").append(DebuggerBundle.message((String)"threads.export.attribute.error.incompatible.state", (Object[])new Object[0]));
            }
            threadState.setStackTrace(buffer.toString(), hasEmptyStack);
            ThreadDumpParser.inferThreadStateDetail((ThreadState)threadState);
        }
        for (String waiting : waitingMap.keySet()) {
            ThreadState waitingThread = (ThreadState)nameToThreadMap.get(waiting);
            ThreadState awaitedThread = (ThreadState)nameToThreadMap.get(waitingMap.get(waiting));
            if (waitingThread == null || awaitedThread == null) continue;
            awaitedThread.addWaitingThread(waitingThread);
        }
        for (ThreadState thread : result) {
            for (ThreadState awaitingThread : thread.getAwaitingThreads()) {
                if (!awaitingThread.isAwaitedBy(thread)) continue;
                thread.addDeadlockedThread(awaitingThread);
                awaitingThread.addDeadlockedThread(thread);
            }
        }
        ThreadDumpParser.sortThreads(result);
        return result;
    }

    private static String renderLockedObject(ObjectReference monitor) {
        return DebuggerBundle.message((String)"threads.export.attribute.label.locked", (Object[])new Object[]{ThreadDumpAction.renderObject(monitor)});
    }

    public static String renderObject(ObjectReference monitor) {
        String monitorTypeName;
        try {
            monitorTypeName = monitor.referenceType().name();
        }
        catch (Throwable e) {
            monitorTypeName = "Error getting object type: '" + e.getMessage() + "'";
        }
        return DebuggerBundle.message((String)"threads.export.attribute.label.object-id", (Object[])new Object[]{Long.toHexString(monitor.uniqueID()), monitorTypeName});
    }

    private static String threadStatusToJavaThreadState(int status) {
        switch (status) {
            case 3: {
                return Thread.State.BLOCKED.name();
            }
            case 5: {
                return Thread.State.NEW.name();
            }
            case 1: {
                return Thread.State.RUNNABLE.name();
            }
            case 2: {
                return Thread.State.TIMED_WAITING.name();
            }
            case 4: {
                return Thread.State.WAITING.name();
            }
            case 0: {
                return Thread.State.TERMINATED.name();
            }
            case -1: {
                return "unknown";
            }
        }
        return "undefined";
    }

    private static String threadStatusToState(int status) {
        switch (status) {
            case 3: {
                return "waiting for monitor entry";
            }
            case 5: {
                return "not started";
            }
            case 1: {
                return "runnable";
            }
            case 2: {
                return "sleeping";
            }
            case 4: {
                return "waiting";
            }
            case 0: {
                return "zombie";
            }
            case -1: {
                return "unknown";
            }
        }
        return "undefined";
    }

    public static String renderLocation(Location location) {
        return DebuggerBundle.message((String)"export.threads.stackframe.format", (Object[])new Object[]{DebuggerUtilsEx.getLocationMethodQName(location), DebuggerUtilsEx.getSourceName(location, e -> "Unknown Source"), DebuggerUtilsEx.getLineNumber(location, false)});
    }

    private static String threadName(ThreadReference threadReference) {
        return threadReference.name() + "@" + threadReference.uniqueID();
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project2 = e.getProject();
        if (project2 == null) {
            presentation.setEnabled(false);
            return;
        }
        DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx(project2).getContext().getDebuggerSession();
        presentation.setEnabled(debuggerSession != null && debuggerSession.isAttached());
    }
}

