/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.JavaExceptionBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaFieldBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaMethodBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaWildcardMethodBreakpointType;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaBreakpointHandler
extends XBreakpointHandler {
    protected final DebugProcessImpl myProcess;

    public JavaBreakpointHandler(@NotNull Class<? extends XBreakpointType<?, ?>> breakpointTypeClass, DebugProcessImpl process2) {
        if (breakpointTypeClass == null) {
            JavaBreakpointHandler.$$$reportNull$$$0(0);
        }
        super(breakpointTypeClass);
        this.myProcess = process2;
    }

    @Nullable
    protected Breakpoint createJavaBreakpoint(@NotNull XBreakpoint xBreakpoint) {
        if (xBreakpoint == null) {
            JavaBreakpointHandler.$$$reportNull$$$0(1);
        }
        return null;
    }

    public void registerBreakpoint(@NotNull XBreakpoint breakpoint) {
        Breakpoint javaBreakpoint;
        if (breakpoint == null) {
            JavaBreakpointHandler.$$$reportNull$$$0(2);
        }
        if ((javaBreakpoint = BreakpointManager.getJavaBreakpoint(breakpoint)) == null) {
            javaBreakpoint = this.createJavaBreakpoint(breakpoint);
            breakpoint.putUserData(Breakpoint.DATA_KEY, (Object)javaBreakpoint);
        }
        if (javaBreakpoint != null) {
            final Breakpoint bpt = javaBreakpoint;
            BreakpointManager.addBreakpoint(bpt);
            this.myProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    bpt.createRequest(JavaBreakpointHandler.this.myProcess);
                }

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.HIGH;
                }
            });
        }
    }

    public void unregisterBreakpoint(@NotNull XBreakpoint breakpoint, boolean temporary) {
        Breakpoint javaBreakpoint;
        if (breakpoint == null) {
            JavaBreakpointHandler.$$$reportNull$$$0(3);
        }
        if ((javaBreakpoint = BreakpointManager.getJavaBreakpoint(breakpoint)) != null) {
            this.myProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    JavaBreakpointHandler.this.myProcess.getRequestsManager().deleteRequest(javaBreakpoint);
                }

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.HIGH;
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpointTypeClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xBreakpoint";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/JavaBreakpointHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createJavaBreakpoint";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "registerBreakpoint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterBreakpoint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class JavaFieldBreakpointHandler
    extends JavaBreakpointHandler {
        public JavaFieldBreakpointHandler(DebugProcessImpl process2) {
            super(JavaFieldBreakpointType.class, process2);
        }
    }

    public static class JavaWildcardBreakpointHandler
    extends JavaBreakpointHandler {
        public JavaWildcardBreakpointHandler(DebugProcessImpl process2) {
            super(JavaWildcardMethodBreakpointType.class, process2);
        }
    }

    public static class JavaMethodBreakpointHandler
    extends JavaBreakpointHandler {
        public JavaMethodBreakpointHandler(DebugProcessImpl process2) {
            super(JavaMethodBreakpointType.class, process2);
        }
    }

    public static class JavaExceptionBreakpointHandler
    extends JavaBreakpointHandler {
        public JavaExceptionBreakpointHandler(DebugProcessImpl process2) {
            super(JavaExceptionBreakpointType.class, process2);
        }
    }

    public static class JavaLineBreakpointHandler
    extends JavaBreakpointHandler {
        public JavaLineBreakpointHandler(DebugProcessImpl process2) {
            super(JavaLineBreakpointType.class, process2);
        }
    }
}

