/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.impl.EventQueue;
import com.intellij.debugger.impl.EventQueueClosedException;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.sun.jdi.VMDisconnectedException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.Debugger;
import org.jetbrains.annotations.NotNull;

public abstract class InvokeThread<E extends PrioritizedTask> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.impl.InvokeThread");
    private static final ThreadLocal<WorkerThreadRequest> ourWorkerRequest = new ThreadLocal();
    protected final Project myProject;
    protected final EventQueue<E> myEvents;
    private volatile WorkerThreadRequest myCurrentRequest = null;

    public InvokeThread(Project project2) {
        this.myProject = project2;
        this.myEvents = new EventQueue(PrioritizedTask.Priority.values().length);
        this.startNewWorkerThread();
    }

    protected abstract void processEvent(E var1);

    protected void startNewWorkerThread() {
        WorkerThreadRequest workerRequest;
        this.myCurrentRequest = workerRequest = new WorkerThreadRequest(this);
        workerRequest.setRequestFuture(ApplicationManager.getApplication().executeOnPooledThread(workerRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(@NotNull WorkerThreadRequest threadRequest) {
        block21: {
            if (threadRequest == null) {
                InvokeThread.$$$reportNull$$$0(0);
            }
            String oldThreadName = Thread.currentThread().getName();
            Thread.currentThread().setName("DebuggerManagerThread");
            try {
                DumbService.getInstance((Project)this.myProject).setAlternativeResolveEnabled(true);
                while (true) {
                    try {
                        while (true) {
                            if (threadRequest.isStopRequested()) {
                                break block21;
                            }
                            WorkerThreadRequest currentRequest = this.getCurrentRequest();
                            if (currentRequest != threadRequest) {
                                LOG.error("Expected " + threadRequest + " instead of " + currentRequest);
                                if (currentRequest != null && !currentRequest.isDone()) continue;
                            }
                            this.processEvent((PrioritizedTask)this.myEvents.get());
                        }
                    }
                    catch (VMDisconnectedException ignored) {
                    }
                    catch (EventQueueClosedException ignored) {
                    }
                    catch (ProcessCanceledException ignored) {
                        continue;
                    }
                    catch (RuntimeException e) {
                        if (e.getCause() instanceof InterruptedException) {
                            break;
                        }
                        LOG.error((Throwable)e);
                        continue;
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (threadRequest == this.getCurrentRequest()) {
                    for (PrioritizedTask event : this.myEvents.clearQueue()) {
                        try {
                            this.processEvent(event);
                        }
                        catch (Throwable throwable) {}
                    }
                }
                LOG.debug("Request " + this.toString() + " exited");
                DumbService.getInstance((Project)this.myProject).setAlternativeResolveEnabled(false);
                Thread.currentThread().setName(oldThreadName);
            }
        }
    }

    protected static InvokeThread currentThread() {
        WorkerThreadRequest request = InvokeThread.getCurrentThreadRequest();
        return request != null ? request.getOwner() : null;
    }

    public boolean schedule(@Debugger.Capture E r) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("schedule " + r + " in " + this);
        }
        return this.myEvents.put(r, r.getPriority().ordinal());
    }

    public boolean pushBack(E r) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("pushBack " + r + " in " + this);
        }
        return this.myEvents.pushBack(r, r.getPriority().ordinal());
    }

    protected void switchToRequest(WorkerThreadRequest newRequest) {
        WorkerThreadRequest currentThreadRequest = InvokeThread.getCurrentThreadRequest();
        LOG.assertTrue(currentThreadRequest != null);
        this.myCurrentRequest = newRequest;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closing " + currentThreadRequest + " new request = " + newRequest);
        }
        currentThreadRequest.requestStop();
    }

    public WorkerThreadRequest getCurrentRequest() {
        return this.myCurrentRequest;
    }

    public static WorkerThreadRequest getCurrentThreadRequest() {
        return ourWorkerRequest.get();
    }

    public void close() {
        this.myEvents.close();
        LOG.debug("Closing evaluation");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadRequest", "com/intellij/debugger/impl/InvokeThread", "run"));
    }

    public static final class WorkerThreadRequest<E extends PrioritizedTask>
    implements Runnable {
        private final InvokeThread<E> myOwner;
        private volatile Future<?> myRequestFuture;
        private volatile boolean myStopRequested = false;

        WorkerThreadRequest(InvokeThread<E> owner2) {
            this.myOwner = owner2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            WorkerThreadRequest workerThreadRequest = this;
            synchronized (workerThreadRequest) {
                while (this.myRequestFuture == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            ourWorkerRequest.set(this);
            try {
                ((InvokeThread)this.myOwner).run(this);
            }
            finally {
                ourWorkerRequest.set(null);
                boolean bl = Thread.interrupted();
            }
        }

        public void requestStop() {
            Future<?> future = this.myRequestFuture;
            assert (future != null);
            this.myStopRequested = true;
            future.cancel(true);
        }

        public boolean isStopRequested() {
            Future<?> future = this.myRequestFuture;
            assert (future != null);
            return this.myStopRequested || future.isCancelled() || future.isDone();
        }

        public void join() throws InterruptedException, ExecutionException {
            assert (this.myRequestFuture != null);
            try {
                this.myRequestFuture.get();
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
        }

        public void join(long timeout) throws InterruptedException, ExecutionException {
            assert (this.myRequestFuture != null);
            try {
                this.myRequestFuture.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (CancellationException | TimeoutException exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void setRequestFuture(Future<?> requestFuture) {
            WorkerThreadRequest workerThreadRequest = this;
            synchronized (workerThreadRequest) {
                this.myRequestFuture = requestFuture;
                this.notifyAll();
            }
        }

        public InvokeThread<E> getOwner() {
            return this.myOwner;
        }

        public boolean isDone() {
            assert (this.myRequestFuture != null);
            return this.myRequestFuture.isDone() && ourWorkerRequest.get() == null;
        }
    }
}

