/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.memory.component.InstancesTracker;
import com.intellij.debugger.memory.component.MemoryViewDebugProcessData;
import com.intellij.debugger.memory.component.MemoryViewManager;
import com.intellij.debugger.memory.component.MemoryViewManagerState;
import com.intellij.debugger.memory.event.InstancesTrackerListener;
import com.intellij.debugger.memory.event.MemoryViewManagerListener;
import com.intellij.debugger.memory.tracking.ConstructorInstancesTracker;
import com.intellij.debugger.memory.tracking.TrackerForNewInstances;
import com.intellij.debugger.memory.tracking.TrackingType;
import com.intellij.debugger.memory.ui.ClassesTable;
import com.intellij.debugger.memory.ui.InstancesWindow;
import com.intellij.debugger.memory.utils.AndroidUtil;
import com.intellij.debugger.memory.utils.KeyboardUtils;
import com.intellij.debugger.memory.utils.LowestPriorityCommand;
import com.intellij.debugger.memory.utils.SingleAlarmWithMutableDelay;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.requests.Requestor;
import com.intellij.icons.AllIcons;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.ClassPrepareRequest;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassesFilteredView
extends BorderLayoutPanel
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ClassesFilteredView.class);
    private static final double DELAY_BEFORE_INSTANCES_QUERY_COEFFICIENT = 0.5;
    private static final double MAX_DELAY_MILLIS = TimeUnit.SECONDS.toMillis(2L);
    private static final int DEFAULT_BATCH_SIZE = Integer.MAX_VALUE;
    private static final String EMPTY_TABLE_CONTENT_WHEN_RUNNING = "The application is running";
    private static final String EMPTY_TABLE_CONTENT_WHEN_STOPPED = "Classes are not available";
    private static final String CLICKABLE_TABLE_CONTENT = "Click to load the classes list";
    private final Project myProject;
    private final SingleAlarmWithMutableDelay mySingleAlarm;
    private final SearchTextField myFilterTextField;
    private final ClassesTable myTable;
    private final InstancesTracker myInstancesTracker;
    private final Map<ReferenceType, ConstructorInstancesTracker> myConstructorTrackedClasses;
    private final MyDebuggerSessionListener myDebugSessionListener;
    private final AtomicInteger myTime;
    private final AtomicInteger myLastUpdatingTime;
    private final AtomicBoolean myIsTrackersActivated;
    private volatile boolean myIsActive;

    public ClassesFilteredView(final @NotNull XDebugSession debugSession, final @NotNull DebugProcessImpl debugProcess, final @NotNull InstancesTracker tracker) {
        if (debugSession == null) {
            ClassesFilteredView.$$$reportNull$$$0(0);
        }
        if (debugProcess == null) {
            ClassesFilteredView.$$$reportNull$$$0(1);
        }
        if (tracker == null) {
            ClassesFilteredView.$$$reportNull$$$0(2);
        }
        this.myFilterTextField = new FilterTextField();
        this.myConstructorTrackedClasses = new ConcurrentHashMap<ReferenceType, ConstructorInstancesTracker>();
        this.myTime = new AtomicInteger(0);
        this.myLastUpdatingTime = new AtomicInteger(Integer.MIN_VALUE);
        this.myIsTrackersActivated = new AtomicBoolean(false);
        this.myProject = debugSession.getProject();
        final DebuggerManagerThreadImpl managerThread = debugProcess.getManagerThread();
        this.myInstancesTracker = tracker;
        final InstancesTrackerListener instancesTrackerListener = new InstancesTrackerListener(){

            @Override
            public void classChanged(@NotNull String name2, final @NotNull TrackingType type) {
                ReferenceType ref;
                if (name2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (type == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((ref = ClassesFilteredView.this.myTable.getClassByName(name2)) != null) {
                    final boolean activated = ClassesFilteredView.this.myIsTrackersActivated.get();
                    managerThread.schedule(new DebuggerCommandImpl(){

                        @Override
                        protected void action() {
                            ClassesFilteredView.this.trackClass(debugSession, ref, type, activated);
                        }
                    });
                }
                ClassesFilteredView.this.myTable.repaint();
            }

            @Override
            public void classRemoved(@NotNull String name2) {
                ReferenceType ref;
                if (name2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((ref = ClassesFilteredView.this.myTable.getClassByName(name2)) != null && ClassesFilteredView.this.myConstructorTrackedClasses.containsKey(ref)) {
                    ConstructorInstancesTracker removed = (ConstructorInstancesTracker)ClassesFilteredView.this.myConstructorTrackedClasses.remove(ref);
                    Disposer.dispose((Disposable)removed);
                    ClassesFilteredView.this.myTable.getRowSorter().allRowsChanged();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/debugger/memory/ui/ClassesFilteredView$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "classChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "classRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        debugSession.addSessionListener(new XDebugSessionListener(){

            public void sessionStopped() {
                debugSession.removeSessionListener((XDebugSessionListener)this);
                ClassesFilteredView.this.myInstancesTracker.removeTrackerListener(instancesTrackerListener);
            }
        });
        debugProcess.addDebugProcessListener(new DebugProcessListener(){

            public void processAttached(DebugProcess process2) {
                debugProcess.removeDebugProcessListener(this);
                managerThread.invoke(new DebuggerCommandImpl(){

                    @Override
                    protected void action() {
                        boolean activated = ClassesFilteredView.this.myIsTrackersActivated.get();
                        VirtualMachineProxyImpl proxy = debugProcess.getVirtualMachineProxy();
                        tracker.getTrackedClasses().forEach((className, type) -> {
                            List<ReferenceType> classes;
                            if (debugSession == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (debugProcess == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            if ((classes = proxy.classesByName((String)className)).isEmpty()) {
                                this.trackWhenPrepared(className, debugSession, debugProcess, type);
                            } else {
                                for (ReferenceType ref : classes) {
                                    ClassesFilteredView.this.trackClass(debugSession, ref, type, activated);
                                }
                            }
                        });
                        tracker.addTrackerListener(instancesTrackerListener);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "debugSession";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "debugProcess";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/debugger/memory/ui/ClassesFilteredView$3$1";
                        objectArray[2] = "lambda$action$0";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }

            private void trackWhenPrepared(@NotNull String className, final @NotNull XDebugSession session, final @NotNull DebugProcessImpl process2, final @NotNull TrackingType type) {
                if (className == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (session == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (process2 == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (type == null) {
                    3.$$$reportNull$$$0(3);
                }
                ClassPrepareRequestor request = new ClassPrepareRequestor(){

                    public void processClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType) {
                        process2.getRequestsManager().deleteRequest((Requestor)this);
                        ClassesFilteredView.this.trackClass(session, referenceType, type, ClassesFilteredView.this.myIsTrackersActivated.get());
                    }
                };
                ClassPrepareRequest classPrepareRequest = process2.getRequestsManager().createClassPrepareRequest(request, className);
                if (classPrepareRequest != null) {
                    classPrepareRequest.enable();
                } else {
                    LOG.warn("Cannot create a 'class prepare' request. Class " + className + " not tracked.");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "className";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "session";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "process";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/memory/ui/ClassesFilteredView$3";
                objectArray[2] = "trackWhenPrepared";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        MemoryViewManagerState memoryViewManagerState = MemoryViewManager.getInstance().getState();
        this.myTable = new ClassesTable(tracker, this, memoryViewManagerState.isShowWithDiffOnly, memoryViewManagerState.isShowWithInstancesOnly, memoryViewManagerState.isShowTrackedOnly);
        this.myTable.getEmptyText().setText(EMPTY_TABLE_CONTENT_WHEN_RUNNING);
        Disposer.register((Disposable)this, (Disposable)this.myTable);
        this.myTable.addMouseMotionListener(new MyMouseMotionListener());
        this.myTable.addMouseListener(new MyOpenNewInstancesListener());
        new MyDoubleClickListener().installOn((Component)((Object)this.myTable));
        this.myTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (KeyboardUtils.isEnterKey(keyCode)) {
                    ClassesFilteredView.this.handleClassSelection(ClassesFilteredView.this.myTable.getSelectedClass());
                } else if (KeyboardUtils.isCharacter(keyCode) || KeyboardUtils.isBackSpace(keyCode)) {
                    String text = ClassesFilteredView.this.myFilterTextField.getText();
                    String newText = KeyboardUtils.isBackSpace(keyCode) ? text.substring(0, text.length() - 1) : text + e.getKeyChar();
                    ClassesFilteredView.this.myFilterTextField.setText(newText);
                    IdeFocusManager.getInstance((Project)ClassesFilteredView.this.myProject).requestFocus((Component)ClassesFilteredView.this.myFilterTextField, false);
                }
            }
        });
        this.myFilterTextField.addKeyboardListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                this.dispatch(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.dispatch(e);
            }

            private void dispatch(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (ClassesFilteredView.this.myTable.isInClickableMode() && (KeyboardUtils.isCharacter(keyCode) || KeyboardUtils.isEnterKey(keyCode))) {
                    ClassesFilteredView.this.myTable.exitClickableMode();
                    ClassesFilteredView.this.updateClassesAndCounts(true);
                } else if (KeyboardUtils.isUpDownKey(keyCode) || KeyboardUtils.isEnterKey(keyCode)) {
                    ClassesFilteredView.this.myTable.dispatchEvent(e);
                }
            }
        });
        this.myFilterTextField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ClassesFilteredView.this.myTable.setFilterPattern(ClassesFilteredView.this.myFilterTextField.getText());
            }
        });
        MemoryViewManagerListener memoryViewManagerListener = state -> {
            this.myTable.setFilteringByDiffNonZero(state.isShowWithDiffOnly);
            this.myTable.setFilteringByInstanceExists(state.isShowWithInstancesOnly);
            this.myTable.setFilteringByTrackingState(state.isShowTrackedOnly);
            if (state.isAutoUpdateModeOn && this.myTable.isInClickableMode()) {
                this.updateClassesAndCounts(true);
            }
        };
        MemoryViewManager.getInstance().addMemoryViewManagerListener(memoryViewManagerListener, this);
        this.myDebugSessionListener = new MyDebuggerSessionListener();
        debugSession.addSessionListener((XDebugSessionListener)this.myDebugSessionListener, (Disposable)this);
        this.mySingleAlarm = new SingleAlarmWithMutableDelay(suspendContext -> {
            ApplicationManager.getApplication().invokeLater(() -> this.myTable.setBusy(true));
            suspendContext.getDebugProcess().getManagerThread().schedule(new MyUpdateClassesCommand(suspendContext));
        }, this);
        this.mySingleAlarm.setDelay((int)TimeUnit.MILLISECONDS.toMillis(500L));
        this.myTable.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionPopupMenu menu = ClassesFilteredView.createContextMenu();
                menu.getComponent().show(comp, x, y);
            }
        });
        JScrollPane scroll = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTable), (int)2);
        DefaultActionGroup group = (DefaultActionGroup)ActionManager.getInstance().getAction("MemoryView.SettingsPopupActionGroup");
        group.setPopup(true);
        Presentation actionsPresentation = new Presentation("Memory View Settings");
        actionsPresentation.setIcon(AllIcons.General.SecondaryGroup);
        ActionButton button = new ActionButton((AnAction)group, actionsPresentation, "unknown", (Dimension)new JBDimension(25, 25));
        BorderLayoutPanel topPanel = new BorderLayoutPanel();
        topPanel.addToCenter((Component)this.myFilterTextField);
        topPanel.addToRight((Component)button);
        this.addToTop((Component)topPanel);
        this.addToCenter(scroll);
    }

    @Nullable
    TrackerForNewInstances getStrategy(@NotNull ReferenceType ref) {
        if (ref == null) {
            ClassesFilteredView.$$$reportNull$$$0(3);
        }
        return this.myConstructorTrackedClasses.getOrDefault(ref, null);
    }

    private void trackClass(@NotNull XDebugSession session, @NotNull ReferenceType ref, @NotNull TrackingType type, boolean isTrackerEnabled) {
        if (session == null) {
            ClassesFilteredView.$$$reportNull$$$0(4);
        }
        if (ref == null) {
            ClassesFilteredView.$$$reportNull$$$0(5);
        }
        if (type == null) {
            ClassesFilteredView.$$$reportNull$$$0(6);
        }
        LOG.assertTrue(DebuggerManager.getInstance((Project)this.myProject).isDebuggerManagerThread());
        if (type == TrackingType.CREATION) {
            ConstructorInstancesTracker old = this.myConstructorTrackedClasses.getOrDefault(ref, null);
            if (old != null) {
                Disposer.dispose((Disposable)old);
            }
            ConstructorInstancesTracker tracker = new ConstructorInstancesTracker(ref, session, this.myInstancesTracker);
            tracker.setBackgroundMode(!this.myIsActive);
            if (isTrackerEnabled) {
                tracker.enable();
            } else {
                tracker.disable();
            }
            this.myConstructorTrackedClasses.put(ref, tracker);
        }
    }

    private void handleClassSelection(@Nullable ReferenceType ref) {
        XDebugSession debugSession = XDebuggerManager.getInstance((Project)this.myProject).getCurrentSession();
        if (ref != null && debugSession != null && debugSession.isSuspended()) {
            if (!ref.virtualMachine().canGetInstanceInfo()) {
                XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification("The virtual machine implementation does not provide an ability to get instances", NotificationType.INFORMATION).notify(debugSession.getProject());
                return;
            }
            new InstancesWindow(debugSession, limit -> {
                List<ObjectReference> instances = ref.instances(limit);
                return instances == null ? Collections.emptyList() : instances;
            }, ref.name()).show();
        }
    }

    private void commitAllTrackers() {
        this.myConstructorTrackedClasses.values().forEach(ConstructorInstancesTracker::commitTracked);
    }

    private void updateClassesAndCounts(boolean immediate) {
        ApplicationManager.getApplication().invokeLater(() -> {
            DebugProcessImpl process2;
            SuspendContextImpl context;
            DebugProcess debugProcess;
            XDebugSession debugSession = XDebuggerManager.getInstance((Project)this.myProject).getCurrentSession();
            if (debugSession != null && (debugProcess = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess(debugSession.getDebugProcess().getProcessHandler())) != null && debugProcess.isAttached() && debugProcess instanceof DebugProcessImpl && (context = (process2 = (DebugProcessImpl)debugProcess).getDebuggerContext().getSuspendContext()) != null) {
                if (immediate) {
                    this.mySingleAlarm.cancelAndRequestImmediate(context);
                } else {
                    this.mySingleAlarm.cancelAndRequest(context);
                }
            }
        }, this.myProject.getDisposed());
    }

    private static ActionPopupMenu createContextMenu() {
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("MemoryView.ClassesPopupActionGroup");
        return ActionManager.getInstance().createActionPopupMenu("MemoryView.ClassesPopupActionGroup", group);
    }

    public void dispose() {
        this.myConstructorTrackedClasses.clear();
    }

    public void setActive(final boolean active, @NotNull DebuggerManagerThreadImpl managerThread) {
        if (managerThread == null) {
            ClassesFilteredView.$$$reportNull$$$0(7);
        }
        if (this.myIsActive == active) {
            return;
        }
        this.myIsActive = active;
        managerThread.schedule(new DebuggerCommandImpl(){

            @Override
            protected void action() {
                if (active) {
                    ClassesFilteredView.this.doActivate();
                } else {
                    ClassesFilteredView.this.doPause();
                }
            }
        });
    }

    private void doActivate() {
        this.myDebugSessionListener.setActive(true);
        this.myConstructorTrackedClasses.values().forEach(x -> x.setBackgroundMode(false));
        if (this.isNeedUpdateView()) {
            if (MemoryViewManager.getInstance().isAutoUpdateModeEnabled()) {
                this.updateClassesAndCounts(true);
            } else {
                this.makeTableClickable();
            }
        }
    }

    private void makeTableClickable() {
        ApplicationManager.getApplication().invokeLater(() -> this.myTable.makeClickable(CLICKABLE_TABLE_CONTENT, () -> this.updateClassesAndCounts(true)));
    }

    private void doPause() {
        this.myDebugSessionListener.setActive(false);
        this.mySingleAlarm.cancelAllRequests();
        this.myConstructorTrackedClasses.values().forEach(x -> x.setBackgroundMode(true));
    }

    private boolean isNeedUpdateView() {
        return this.myLastUpdatingTime.get() != this.myTime.get();
    }

    private void viewUpdated() {
        this.myLastUpdatingTime.set(this.myTime.get());
    }

    private boolean isShowNewInstancesEvent(@NotNull MouseEvent e) {
        if (e == null) {
            ClassesFilteredView.$$$reportNull$$$0(8);
        }
        int col = this.myTable.columnAtPoint(e.getPoint());
        int row = this.myTable.rowAtPoint(e.getPoint());
        if (col == -1 || row == -1 || this.myTable.convertColumnIndexToModel(col) != 2) {
            return false;
        }
        int modelRow = this.myTable.convertRowIndexToModel(row);
        ReferenceType ref = (ReferenceType)this.myTable.getModel().getValueAt(modelRow, 0);
        ConstructorInstancesTracker tracker = this.myConstructorTrackedClasses.getOrDefault(ref, null);
        return tracker != null && tracker.isReady() && tracker.getCount() > 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugSession";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "managerThread";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/memory/ui/ClassesFilteredView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getStrategy";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "trackClass";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setActive";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isShowNewInstancesEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyDebuggerSessionListener
    implements XDebugSessionListener {
        private volatile boolean myIsActive = false;

        private MyDebuggerSessionListener() {
        }

        void setActive(boolean value) {
            this.myIsActive = value;
        }

        public void sessionResumed() {
            if (this.myIsActive) {
                ClassesFilteredView.this.myConstructorTrackedClasses.values().forEach(ConstructorInstancesTracker::obsolete);
                ApplicationManager.getApplication().invokeLater(() -> ClassesFilteredView.this.myTable.hideContent(ClassesFilteredView.EMPTY_TABLE_CONTENT_WHEN_RUNNING));
                ClassesFilteredView.this.mySingleAlarm.cancelAllRequests();
            }
        }

        public void sessionStopped() {
            ClassesFilteredView.this.myConstructorTrackedClasses.values().forEach(Disposer::dispose);
            ClassesFilteredView.this.myConstructorTrackedClasses.clear();
            ClassesFilteredView.this.mySingleAlarm.cancelAllRequests();
            ApplicationManager.getApplication().invokeLater(() -> ClassesFilteredView.this.myTable.clean(ClassesFilteredView.EMPTY_TABLE_CONTENT_WHEN_STOPPED));
        }

        public void sessionPaused() {
            ClassesFilteredView.this.myTime.incrementAndGet();
            if (this.myIsActive) {
                if (MemoryViewManager.getInstance().isAutoUpdateModeEnabled()) {
                    ClassesFilteredView.this.updateClassesAndCounts(false);
                } else {
                    ClassesFilteredView.this.makeTableClickable();
                }
            }
        }
    }

    private class MyMouseMotionListener
    implements MouseMotionListener {
        private MyMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (ClassesFilteredView.this.myTable.isInClickableMode()) {
                return;
            }
            if (ClassesFilteredView.this.isShowNewInstancesEvent(e)) {
                ClassesFilteredView.this.myTable.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                ClassesFilteredView.this.myTable.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private class MyDoubleClickListener
    extends DoubleClickListener {
        private MyDoubleClickListener() {
        }

        protected boolean onDoubleClick(MouseEvent event) {
            if (!ClassesFilteredView.this.isShowNewInstancesEvent(event)) {
                ClassesFilteredView.this.handleClassSelection(ClassesFilteredView.this.myTable.getSelectedClass());
                return true;
            }
            return false;
        }
    }

    private class MyOpenNewInstancesListener
    extends MouseAdapter {
        private MyOpenNewInstancesListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() != 1 || e.getButton() != 1 || !ClassesFilteredView.this.isShowNewInstancesEvent(e)) {
                return;
            }
            ReferenceType ref = ClassesFilteredView.this.myTable.getSelectedClass();
            TrackerForNewInstances strategy = ref == null ? null : ClassesFilteredView.this.getStrategy(ref);
            XDebugSession debugSession = XDebuggerManager.getInstance((Project)ClassesFilteredView.this.myProject).getCurrentSession();
            if (strategy != null && debugSession != null) {
                DebugProcess debugProcess = DebuggerManager.getInstance((Project)ClassesFilteredView.this.myProject).getDebugProcess(debugSession.getDebugProcess().getProcessHandler());
                MemoryViewDebugProcessData data = (MemoryViewDebugProcessData)debugProcess.getUserData(MemoryViewDebugProcessData.KEY);
                if (data != null) {
                    List<ObjectReference> newInstances = strategy.getNewInstances();
                    data.getTrackedStacks().pinStacks(ref);
                    InstancesWindow instancesWindow = new InstancesWindow(debugSession, limit -> newInstances, ref.name());
                    Disposer.register((Disposable)instancesWindow.getDisposable(), () -> data.getTrackedStacks().unpinStacks(ref));
                    instancesWindow.show();
                } else {
                    LOG.warn("MemoryViewDebugProcessData not found in debug session user data");
                }
            }
        }
    }

    private static class FilterTextField
    extends SearchTextField {
        FilterTextField() {
            super(false);
        }

        protected void showPopup() {
        }

        protected boolean hasIconsOutsideOfTextField() {
            return false;
        }
    }

    private final class MyUpdateClassesCommand
    extends LowestPriorityCommand {
        MyUpdateClassesCommand(SuspendContextImpl suspendContext) {
            super(suspendContext);
        }

        @Override
        public void contextAction(@NotNull SuspendContextImpl suspendContext) {
            if (suspendContext == null) {
                MyUpdateClassesCommand.$$$reportNull$$$0(0);
            }
            this.handleTrackers();
            VirtualMachineProxyImpl proxy = suspendContext.getDebugProcess().getVirtualMachineProxy();
            List<ReferenceType> classes = proxy.allClasses();
            if (!classes.isEmpty()) {
                VirtualMachine vm = classes.get(0).virtualMachine();
                if (proxy.canGetInstanceInfo()) {
                    Map<ReferenceType, Long> counts = this.getInstancesCounts(classes, vm);
                    ApplicationManager.getApplication().invokeLater(() -> ClassesFilteredView.this.myTable.updateContent(counts));
                } else {
                    ApplicationManager.getApplication().invokeLater(() -> ClassesFilteredView.this.myTable.updateClassesOnly(classes));
                }
            }
            ApplicationManager.getApplication().invokeLater(() -> ClassesFilteredView.this.myTable.setBusy(false));
            ClassesFilteredView.this.viewUpdated();
        }

        private void handleTrackers() {
            if (!ClassesFilteredView.this.myIsTrackersActivated.get()) {
                ClassesFilteredView.this.myConstructorTrackedClasses.values().forEach(ConstructorInstancesTracker::enable);
                ClassesFilteredView.this.myIsTrackersActivated.set(true);
            } else {
                ClassesFilteredView.this.commitAllTrackers();
            }
        }

        private Map<ReferenceType, Long> getInstancesCounts(@NotNull List<ReferenceType> classes, @NotNull VirtualMachine vm) {
            if (classes == null) {
                MyUpdateClassesCommand.$$$reportNull$$$0(1);
            }
            if (vm == null) {
                MyUpdateClassesCommand.$$$reportNull$$$0(2);
            }
            int batchSize = AndroidUtil.isAndroidVM(vm) ? 500 : Integer.MAX_VALUE;
            int size = classes.size();
            LinkedHashMap<ReferenceType, Long> result = new LinkedHashMap<ReferenceType, Long>();
            int begin = 0;
            int end = Math.min(batchSize, size);
            while (begin != size) {
                List<ReferenceType> batch = classes.subList(begin, end);
                long start = System.nanoTime();
                long[] counts = vm.instanceCounts(batch);
                long delay = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
                for (int i = 0; i < batch.size(); ++i) {
                    result.put(batch.get(i), counts[i]);
                }
                int waitTime = (int)Math.min(0.5 * (double)delay, MAX_DELAY_MILLIS);
                ClassesFilteredView.this.mySingleAlarm.setDelay(waitTime);
                LOG.debug(String.format("Instances query time = %d ms. Count of classes = %d", delay, batch.size()));
                begin = end;
                end = Math.min(end + batchSize, size);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suspendContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vm";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/memory/ui/ClassesFilteredView$MyUpdateClassesCommand";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contextAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getInstancesCounts";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

