/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.frame.XDebuggerFramesList;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class StackFrameList
extends XDebuggerFramesList {
    private static final MyOpenFilesState myEditorState = new MyOpenFilesState();
    private final DebugProcessImpl myDebugProcess;

    StackFrameList(DebugProcessImpl debugProcess) {
        super(debugProcess.getProject());
        this.myDebugProcess = debugProcess;
    }

    void setFrameItems(@NotNull List<StackFrameItem> items) {
        if (items == null) {
            StackFrameList.$$$reportNull$$$0(0);
        }
        this.setFrameItems(items, null);
    }

    void setFrameItems(final @NotNull List<StackFrameItem> items, final Runnable onDone) {
        if (items == null) {
            StackFrameList.$$$reportNull$$$0(1);
        }
        this.clear();
        if (!items.isEmpty()) {
            this.myDebugProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    boolean separator = false;
                    for (StackFrameItem frameInfo : items) {
                        if (frameInfo == null) {
                            separator = true;
                            continue;
                        }
                        StackFrameItem.CapturedStackFrame frame = frameInfo.createFrame(StackFrameList.this.myDebugProcess);
                        frame.setWithSeparator(separator);
                        DebuggerUIUtil.invokeLater(() -> StackFrameList.this.getModel().add((Object)frame));
                        separator = false;
                    }
                    if (onDone != null) {
                        onDone.run();
                    }
                }
            });
        }
    }

    protected void onFrameChanged(Object selectedValue) {
        this.navigateTo(selectedValue, false);
    }

    void navigateToSelectedValue(boolean focusOnEditor) {
        this.navigateTo(this.getSelectedValue(), focusOnEditor);
    }

    private void navigateTo(Object frame, boolean focusOnEditor) {
        if (frame instanceof XStackFrame) {
            this.navigateToFrame((XStackFrame)frame, focusOnEditor);
        }
    }

    private void navigateToFrame(@NotNull XStackFrame frame, boolean focusOnEditor) {
        XSourcePosition position;
        if (frame == null) {
            StackFrameList.$$$reportNull$$$0(2);
        }
        if ((position = frame.getSourcePosition()) == null) {
            return;
        }
        VirtualFile file = position.getFile();
        int line = position.getLine();
        Project project2 = this.myDebugProcess.getProject();
        OpenFileHyperlinkInfo info = new OpenFileHyperlinkInfo(project2, file, line);
        OpenFileDescriptor descriptor2 = info.getDescriptor();
        if (descriptor2 != null) {
            FileEditorManagerImpl manager = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)project2);
            VirtualFile lastFile = StackFrameList.myEditorState.myLastOpenedFile;
            if (StackFrameList.myEditorState.myIsNeedToCloseLastOpenedFile && lastFile != null && manager.isFileOpen(lastFile) && !lastFile.equals(descriptor2.getFile())) {
                manager.closeFile(StackFrameList.myEditorState.myLastOpenedFile, false, true);
            }
            descriptor2.setScrollType(ScrollType.CENTER);
            descriptor2.setUseCurrentWindow(true);
            if (lastFile == null || !lastFile.equals(descriptor2.getFile())) {
                StackFrameList.myEditorState.myIsNeedToCloseLastOpenedFile = !manager.isFileOpen(descriptor2.getFile());
            }
            descriptor2.navigateInEditor(project2, focusOnEditor);
            FileEditor[] editors = manager.getEditors(descriptor2.getFile());
            if (editors.length != 0) {
                StackFrameList.myEditorState.myLastOpenedFile = descriptor2.getFile();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/memory/ui/StackFrameList";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setFrameItems";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "navigateToFrame";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyOpenFilesState {
        VirtualFile myLastOpenedFile;
        boolean myIsNeedToCloseLastOpenedFile;

        private MyOpenFilesState() {
        }
    }
}

