/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.settings.CaptureConfigurable;
import com.intellij.debugger.settings.CapturePoint;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;

public class CaptureSettingsProvider {
    private static final List<AgentCapturePoint> CAPTURE_POINTS = new ArrayList<AgentCapturePoint>();
    private static final List<AgentInsertPoint> INSERT_POINTS = new ArrayList<AgentInsertPoint>();
    private static final List<CapturePoint> IDE_INSERT_POINTS;
    private static final KeyProvider THIS_KEY;
    private static final KeyProvider FIRST_PARAM;

    public static List<AgentPoint> getPoints() {
        List res = ContainerUtil.concat(CAPTURE_POINTS, INSERT_POINTS);
        if (Registry.is((String)"debugger.capture.points.agent.annotations")) {
            res = ContainerUtil.concat((List)res, CaptureSettingsProvider.getAnnotationPoints());
        }
        return res;
    }

    public static List<CapturePoint> getIdeInsertPoints() {
        List res = Collections.unmodifiableList(IDE_INSERT_POINTS);
        if (Registry.is((String)"debugger.capture.points.agent.annotations")) {
            res = ContainerUtil.concat(res, (List)StreamEx.of(CaptureSettingsProvider.getAnnotationPoints()).select(AgentInsertPoint.class).map(p -> p.myInsertPoint).nonNull().toList());
        }
        return res;
    }

    private static List<AgentPoint> getAnnotationPoints() {
        return (List)ReadAction.compute(() -> {
            ArrayList annotationPoints = new ArrayList();
            CaptureConfigurable.processCaptureAnnotations((capture, e) -> {
                PsiAnnotationMemberValue keyExpressionValue;
                PsiAnnotation annotation;
                KeyProvider keyProvider;
                PsiMethod method;
                if (e instanceof PsiMethod) {
                    method = (PsiMethod)e;
                    keyProvider = THIS_KEY;
                } else if (e instanceof PsiParameter) {
                    PsiParameter psiParameter = (PsiParameter)e;
                    method = (PsiMethod)psiParameter.getDeclarationScope();
                    keyProvider = CaptureSettingsProvider.param(method.getParameterList().getParameterIndex(psiParameter));
                } else {
                    return;
                }
                String className = JVMNameUtil.getNonAnonymousClassName(method.getContainingClass()).replaceAll("\\.", "/");
                String methodName = JVMNameUtil.getJVMMethodName(method);
                PsiModifierList modifierList = e.getModifierList();
                if (modifierList != null && (annotation = modifierList.findAnnotation(CaptureConfigurable.getAnnotationName(capture))) != null && (keyExpressionValue = annotation.findAttributeValue("keyExpression")) != null && !"\"\"".equals(keyExpressionValue.getText())) {
                    keyProvider = new FieldKeyProvider(className, StringUtil.unquoteString((String)keyExpressionValue.getText()));
                }
                AgentPoint point = capture != false ? new AgentCapturePoint(className, methodName, keyProvider) : new AgentInsertPoint(className, methodName, keyProvider);
                annotationPoints.add(point);
            });
            return annotationPoints;
        });
    }

    private static KeyProvider param(int idx) {
        return new StringKeyProvider(Integer.toString(idx));
    }

    private static void addCapture(String className, String methodName, KeyProvider key) {
        CAPTURE_POINTS.add(new AgentCapturePoint(className, methodName, key));
    }

    private static void addInsert(String className, String methodName, KeyProvider key) {
        INSERT_POINTS.add(new AgentInsertPoint(className, methodName, key));
    }

    static {
        THIS_KEY = new StringKeyProvider("this");
        FIRST_PARAM = CaptureSettingsProvider.param(0);
        CaptureSettingsProvider.addCapture("java/awt/event/InvocationEvent", "<init>", THIS_KEY);
        CaptureSettingsProvider.addInsert("java/awt/event/InvocationEvent", "dispatch", THIS_KEY);
        CaptureSettingsProvider.addCapture("java/lang/Thread", "start", THIS_KEY);
        CaptureSettingsProvider.addInsert("java/lang/Thread", "run", THIS_KEY);
        CaptureSettingsProvider.addCapture("java/util/concurrent/FutureTask", "<init>", THIS_KEY);
        CaptureSettingsProvider.addInsert("java/util/concurrent/FutureTask", "run", THIS_KEY);
        CaptureSettingsProvider.addInsert("java/util/concurrent/FutureTask", "runAndReset", THIS_KEY);
        CaptureSettingsProvider.addCapture("java/util/concurrent/CompletableFuture", "supplyAsync", FIRST_PARAM);
        AgentInsertPoint point = new AgentInsertPoint("java/util/concurrent/CompletableFuture$AsyncSupply", "run", new FieldKeyProvider("java/util/concurrent/CompletableFuture$AsyncSupply", "fn"));
        point.myInsertPoint.myInsertMethodName = "run$$$capture";
        point.myInsertPoint.myInsertKeyExpression = "f";
        INSERT_POINTS.add(point);
        CaptureSettingsProvider.addCapture("java/util/concurrent/CompletableFuture", "runAsync", FIRST_PARAM);
        point = new AgentInsertPoint("java/util/concurrent/CompletableFuture$AsyncRun", "run", new FieldKeyProvider("java/util/concurrent/CompletableFuture$AsyncRun", "fn"));
        point.myInsertPoint.myInsertMethodName = "run$$$capture";
        point.myInsertPoint.myInsertKeyExpression = "f";
        INSERT_POINTS.add(point);
        CaptureSettingsProvider.addCapture("java/util/concurrent/CompletableFuture", "thenAcceptAsync", FIRST_PARAM);
        CaptureSettingsProvider.addInsert("java/util/concurrent/CompletableFuture$UniAccept", "tryFire", new FieldKeyProvider("java/util/concurrent/CompletableFuture$UniAccept", "fn"));
        CaptureSettingsProvider.addCapture("java/util/concurrent/CompletableFuture", "thenRunAsync", FIRST_PARAM);
        CaptureSettingsProvider.addInsert("java/util/concurrent/CompletableFuture$UniRun", "tryFire", new FieldKeyProvider("java/util/concurrent/CompletableFuture$UniRun", "fn"));
        CaptureSettingsProvider.addCapture("io/netty/util/concurrent/SingleThreadEventExecutor", "addTask", FIRST_PARAM);
        CaptureSettingsProvider.addInsert("io/netty/util/concurrent/AbstractEventExecutor", "safeExecute", FIRST_PARAM);
        CaptureSettingsProvider.addCapture("scala/concurrent/impl/Future$PromiseCompletingRunnable", "<init>", THIS_KEY);
        CaptureSettingsProvider.addInsert("scala/concurrent/impl/Future$PromiseCompletingRunnable", "run", THIS_KEY);
        CaptureSettingsProvider.addCapture("scala/concurrent/impl/CallbackRunnable", "<init>", THIS_KEY);
        CaptureSettingsProvider.addInsert("scala/concurrent/impl/CallbackRunnable", "run", THIS_KEY);
        CaptureSettingsProvider.addCapture("akka/actor/ScalaActorRef", "$bang", FIRST_PARAM);
        CaptureSettingsProvider.addCapture("akka/actor/RepointableActorRef", "$bang", FIRST_PARAM);
        CaptureSettingsProvider.addCapture("akka/actor/LocalActorRef", "$bang", FIRST_PARAM);
        CaptureSettingsProvider.addInsert("akka/actor/Actor$class", "aroundReceive", CaptureSettingsProvider.param(2));
        IDE_INSERT_POINTS = StreamEx.of(INSERT_POINTS).map(p -> p.myInsertPoint).nonNull().toList();
    }

    private static class FieldKeyProvider
    implements KeyProvider {
        private final String myClassName;
        private final String myFieldName;

        public FieldKeyProvider(String className, String fieldName) {
            this.myClassName = className;
            this.myFieldName = fieldName;
        }

        @Override
        public String asString() {
            return this.myClassName + " " + this.myFieldName;
        }
    }

    private static class StringKeyProvider
    implements KeyProvider {
        private final String myValue;

        public StringKeyProvider(String value) {
            this.myValue = value;
        }

        @Override
        public String asString() {
            return this.myValue;
        }
    }

    public static interface KeyProvider {
        public String asString();
    }

    public static class AgentInsertPoint
    extends AgentPoint {
        public final CapturePoint myInsertPoint = new CapturePoint();

        public AgentInsertPoint(String className, String methodName, KeyProvider key) {
            super(className, methodName, key);
            this.myInsertPoint.myInsertClassName = className.replaceAll("/", ".");
            this.myInsertPoint.myInsertMethodName = methodName;
            if (this.myKey instanceof FieldKeyProvider) {
                this.myInsertPoint.myInsertKeyExpression = ((FieldKeyProvider)this.myKey).myFieldName;
            } else {
                String keyStr = key.asString();
                try {
                    this.myInsertPoint.myInsertKeyExpression = "param_" + Integer.parseInt(keyStr);
                }
                catch (NumberFormatException ignored) {
                    this.myInsertPoint.myInsertKeyExpression = keyStr;
                }
            }
        }

        @Override
        public boolean isCapture() {
            return false;
        }
    }

    public static class AgentCapturePoint
    extends AgentPoint {
        public AgentCapturePoint(String className, String methodName, KeyProvider key) {
            super(className, methodName, key);
        }

        @Override
        public boolean isCapture() {
            return true;
        }
    }

    public static abstract class AgentPoint {
        public final String myClassName;
        public final String myMethodName;
        public final KeyProvider myKey;
        public static final String SEPARATOR = " ";

        public AgentPoint(String className, String methodName, KeyProvider key) {
            assert (!className.contains(".")) : "Classname should not contain . here";
            this.myClassName = className;
            this.myMethodName = methodName;
            this.myKey = key;
        }

        public abstract boolean isCapture();
    }
}

