/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointTypeBase;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.debugger.ui.breakpoints.RunToCursorBreakpoint;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;

public class JavaLineBreakpointType
extends JavaLineBreakpointTypeBase<JavaLineBreakpointProperties>
implements JavaBreakpointType<JavaLineBreakpointProperties> {
    public JavaLineBreakpointType() {
        super("java-line", DebuggerBundle.message((String)"line.breakpoints.tab.title", (Object[])new Object[0]));
    }

    protected JavaLineBreakpointType(@NonNls @NotNull String id, @Nls @NotNull String title) {
        if (id == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(0);
        }
        if (title == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(1);
        }
        super(id, title);
    }

    protected String getHelpID() {
        return "debugging.lineBreakpoint";
    }

    public String getDisplayName() {
        return DebuggerBundle.message((String)"line.breakpoints.tab.title", (Object[])new Object[0]);
    }

    public List<XBreakpointGroupingRule<XLineBreakpoint<JavaLineBreakpointProperties>, ?>> getGroupingRules() {
        return XDebuggerUtil.getInstance().getGroupingByFileRuleAsList();
    }

    @Nullable
    public JavaLineBreakpointProperties createProperties() {
        return new JavaLineBreakpointProperties();
    }

    @NotNull
    public JavaLineBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        if (file == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(2);
        }
        JavaLineBreakpointProperties javaLineBreakpointProperties = new JavaLineBreakpointProperties();
        if (javaLineBreakpointProperties == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(3);
        }
        return javaLineBreakpointProperties;
    }

    @Override
    @NotNull
    public Breakpoint<JavaLineBreakpointProperties> createJavaBreakpoint(Project project2, XBreakpoint breakpoint) {
        LineBreakpoint<JavaLineBreakpointProperties> lineBreakpoint = new LineBreakpoint<JavaLineBreakpointProperties>(project2, breakpoint);
        if (lineBreakpoint == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(4);
        }
        return lineBreakpoint;
    }

    public int getPriority() {
        return 100;
    }

    @NotNull
    public List<JavaBreakpointVariant> computeVariants(@NotNull Project project2, @NotNull XSourcePosition position) {
        SourcePosition pos;
        if (project2 == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(5);
        }
        if (position == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(6);
        }
        if ((pos = DebuggerUtilsEx.toSourcePosition(position, project2)) == null) {
            List<JavaBreakpointVariant> list = Collections.emptyList();
            if (list == null) {
                JavaLineBreakpointType.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<PsiLambdaExpression> lambdas = DebuggerUtilsEx.collectLambdas(pos, true);
        if (lambdas.isEmpty()) {
            List<JavaBreakpointVariant> list = Collections.emptyList();
            if (list == null) {
                JavaLineBreakpointType.$$$reportNull$$$0(8);
            }
            return list;
        }
        PsiElement startMethod = DebuggerUtilsEx.getContainingMethod(pos);
        if (lambdas.contains(startMethod) && lambdas.size() == 1) {
            List<JavaBreakpointVariant> list = Collections.emptyList();
            if (list == null) {
                JavaLineBreakpointType.$$$reportNull$$$0(9);
            }
            return list;
        }
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(pos.getFile());
        if (document == null) {
            List<JavaBreakpointVariant> list = Collections.emptyList();
            if (list == null) {
                JavaLineBreakpointType.$$$reportNull$$$0(10);
            }
            return list;
        }
        SmartList res = new SmartList();
        if (!(startMethod instanceof PsiLambdaExpression)) {
            res.add(new LineJavaBreakpointVariant(position, startMethod, -1));
        }
        int ordinal = 0;
        for (PsiLambdaExpression lambda2 : lambdas) {
            PsiElement firstElem = DebuggerUtilsEx.getFirstElementOnTheLine(lambda2, document, position.getLine());
            XSourcePositionImpl elementPosition = XSourcePositionImpl.createByElement((PsiElement)firstElem);
            if (elementPosition == null) continue;
            if (lambda2 == startMethod) {
                res.add(0, new LineJavaBreakpointVariant((XSourcePosition)elementPosition, (PsiElement)lambda2, ordinal++));
                continue;
            }
            res.add(new LambdaJavaBreakpointVariant((XSourcePosition)elementPosition, (PsiElement)lambda2, ordinal++));
        }
        res.add(new JavaBreakpointVariant(position));
        SmartList smartList = res;
        if (smartList == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(11);
        }
        return smartList;
    }

    public boolean matchesPosition(@NotNull LineBreakpoint<?> breakpoint, @NotNull SourcePosition position) {
        Object properties;
        if (breakpoint == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(12);
        }
        if (position == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(13);
        }
        if ((properties = breakpoint.getProperties()) instanceof JavaLineBreakpointProperties) {
            if (!(breakpoint instanceof RunToCursorBreakpoint) && ((JavaLineBreakpointProperties)((Object)properties)).getLambdaOrdinal() == null) {
                return true;
            }
            PsiElement containingMethod = this.getContainingMethod(breakpoint);
            if (containingMethod == null) {
                return false;
            }
            return DebuggerUtilsEx.inTheMethod(position, containingMethod);
        }
        return true;
    }

    @Nullable
    public PsiElement getContainingMethod(@NotNull LineBreakpoint<?> breakpoint) {
        Integer ordinal;
        SourcePosition position;
        if (breakpoint == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(14);
        }
        if ((position = breakpoint.getSourcePosition()) == null) {
            return null;
        }
        Object properties = breakpoint.getProperties();
        if (properties instanceof JavaLineBreakpointProperties && !(breakpoint instanceof RunToCursorBreakpoint) && (ordinal = ((JavaLineBreakpointProperties)((Object)properties)).getLambdaOrdinal()) > -1) {
            List<PsiLambdaExpression> lambdas = DebuggerUtilsEx.collectLambdas(position, true);
            if (ordinal < lambdas.size()) {
                return (PsiElement)lambdas.get(ordinal);
            }
        }
        return DebuggerUtilsEx.getContainingMethod(position);
    }

    @Nullable
    public TextRange getHighlightRange(XLineBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        PsiElement method;
        Breakpoint javaBreakpoint;
        Integer ordinal = JavaLineBreakpointType.getLambdaOrdinal(breakpoint);
        if (ordinal != null && (javaBreakpoint = BreakpointManager.getJavaBreakpoint(breakpoint)) instanceof LineBreakpoint && (method = this.getContainingMethod((LineBreakpoint)javaBreakpoint)) != null) {
            return method.getTextRange();
        }
        return null;
    }

    public XSourcePosition getSourcePosition(@NotNull XBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        SourcePosition linePosition;
        Integer ordinal;
        if (breakpoint == null) {
            JavaLineBreakpointType.$$$reportNull$$$0(15);
        }
        if ((ordinal = JavaLineBreakpointType.getLambdaOrdinal(breakpoint)) != null && ordinal > -1 && (linePosition = JavaLineBreakpointType.createLineSourcePosition((XLineBreakpointImpl)breakpoint)) != null) {
            return DebuggerUtilsEx.toXSourcePosition(new PositionManagerImpl.JavaSourcePosition(linePosition, ordinal));
        }
        return null;
    }

    @Nullable
    private static Integer getLambdaOrdinal(XBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        JavaLineBreakpointProperties properties = (JavaLineBreakpointProperties)breakpoint.getProperties();
        return properties != null ? properties.getLambdaOrdinal() : null;
    }

    @Nullable
    private static SourcePosition createLineSourcePosition(XLineBreakpointImpl breakpoint) {
        PsiFile psiFile;
        VirtualFile file = breakpoint.getFile();
        if (file != null && (psiFile = PsiManager.getInstance((Project)breakpoint.getProject()).findFile(file)) != null) {
            return SourcePosition.createFromLine((PsiFile)psiFile, (int)breakpoint.getLine());
        }
        return null;
    }

    public boolean canBeHitInOtherPlaces() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createBreakpointProperties";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createJavaBreakpoint";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "computeVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createBreakpointProperties";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeVariants";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "matchesPosition";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getContainingMethod";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSourcePosition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class LambdaJavaBreakpointVariant
    extends ExactJavaBreakpointVariant {
        public LambdaJavaBreakpointVariant(@NotNull XSourcePosition position, PsiElement element, Integer lambdaOrdinal) {
            if (position == null) {
                LambdaJavaBreakpointVariant.$$$reportNull$$$0(0);
            }
            if (element == null) {
                LambdaJavaBreakpointVariant.$$$reportNull$$$0(1);
            }
            super(position, element, lambdaOrdinal);
        }

        @Override
        public Icon getIcon() {
            return AllIcons.Debugger.LambdaBreakpoint;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "position";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$LambdaJavaBreakpointVariant";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class LineJavaBreakpointVariant
    extends ExactJavaBreakpointVariant {
        public LineJavaBreakpointVariant(@Nullable XSourcePosition position, PsiElement element, Integer lambdaOrdinal) {
            if (position == null) {
                LineJavaBreakpointVariant.$$$reportNull$$$0(0);
            }
            super(position, element, lambdaOrdinal);
        }

        @Override
        public String getText() {
            return "Line";
        }

        @Override
        public Icon getIcon() {
            return AllIcons.Debugger.Db_set_breakpoint;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$LineJavaBreakpointVariant", "<init>"));
        }
    }

    public class ExactJavaBreakpointVariant
    extends JavaBreakpointVariant {
        private final PsiElement myElement;
        private final Integer myLambdaOrdinal;

        public ExactJavaBreakpointVariant(@Nullable XSourcePosition position, PsiElement element, Integer lambdaOrdinal) {
            if (position == null) {
                ExactJavaBreakpointVariant.$$$reportNull$$$0(0);
            }
            super(position);
            this.myElement = element;
            this.myLambdaOrdinal = lambdaOrdinal;
        }

        public Icon getIcon() {
            return this.myElement != null ? this.myElement.getIcon(0) : AllIcons.Debugger.Db_set_breakpoint;
        }

        public String getText() {
            return this.myElement != null ? StringUtil.shortenTextWithEllipsis((String)this.myElement.getText(), (int)100, (int)0) : "Line";
        }

        public TextRange getHighlightRange() {
            return this.myElement != null ? this.myElement.getTextRange() : null;
        }

        @NotNull
        public JavaLineBreakpointProperties createProperties() {
            JavaLineBreakpointProperties properties = (JavaLineBreakpointProperties)super.createProperties();
            assert (properties != null);
            properties.setLambdaOrdinal(this.myLambdaOrdinal);
            JavaLineBreakpointProperties javaLineBreakpointProperties = properties;
            if (javaLineBreakpointProperties == null) {
                ExactJavaBreakpointVariant.$$$reportNull$$$0(1);
            }
            return javaLineBreakpointProperties;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$ExactJavaBreakpointVariant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$ExactJavaBreakpointVariant";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createProperties";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class JavaBreakpointVariant
    extends XLineBreakpointType.XLineBreakpointAllVariant {
        public JavaBreakpointVariant(XSourcePosition position) {
            if (position == null) {
                JavaBreakpointVariant.$$$reportNull$$$0(0);
            }
            super((XLineBreakpointType)JavaLineBreakpointType.this, position);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$JavaBreakpointVariant", "<init>"));
        }
    }
}

