/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluatorImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.ClassesByNameProvider;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.GeneratedLocation;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.settings.CapturePoint;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.breakpoints.WildcardMethodBreakpoint;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import com.sun.jdi.event.LocatableEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;

public class StackCapturingLineBreakpoint
extends WildcardMethodBreakpoint {
    private static final Logger LOG = Logger.getInstance(StackCapturingLineBreakpoint.class);
    private final CapturePoint myCapturePoint;
    private final String mySignature;
    private final MyEvaluator myCaptureEvaluator;
    private final MyEvaluator myInsertEvaluator;
    public static final Key<List<StackCapturingLineBreakpoint>> CAPTURE_BREAKPOINTS = Key.create((String)"CAPTURE_BREAKPOINTS");
    private static final Key<Map<Object, List<StackFrameItem>>> CAPTURED_STACKS = Key.create((String)"CAPTURED_STACKS");
    private static final int MAX_STORED_STACKS = 1000;
    public static final int MAX_STACK_LENGTH = 500;
    private final JavaMethodBreakpointProperties myProperties = new JavaMethodBreakpointProperties();
    private static final Key<Pair<ClassType, Method>> CAPTURE_STORAGE_METHOD = Key.create((String)"CAPTURE_STORAGE_METHOD");
    public static final Pair<ClassType, Method> NO_CAPTURE_AGENT = Pair.empty();

    public StackCapturingLineBreakpoint(Project project2, CapturePoint capturePoint) {
        super(project2, (XBreakpoint<JavaMethodBreakpointProperties>)null);
        this.myCapturePoint = capturePoint;
        this.mySignature = null;
        this.myProperties.EMULATED = true;
        this.myProperties.WATCH_EXIT = false;
        this.myProperties.myClassPattern = this.myCapturePoint.myClassName;
        this.myProperties.myMethodName = this.myCapturePoint.myMethodName;
        this.myCaptureEvaluator = new MyEvaluator(this.myCapturePoint.myCaptureKeyExpression);
        this.myInsertEvaluator = new MyEvaluator(this.myCapturePoint.myInsertKeyExpression);
    }

    @Override
    @NotNull
    protected JavaMethodBreakpointProperties getProperties() {
        JavaMethodBreakpointProperties javaMethodBreakpointProperties = this.myProperties;
        if (javaMethodBreakpointProperties == null) {
            StackCapturingLineBreakpoint.$$$reportNull$$$0(0);
        }
        return javaMethodBreakpointProperties;
    }

    @Override
    public String getSuspendPolicy() {
        return "SuspendThread";
    }

    @Override
    public boolean processLocatableEvent(SuspendContextCommandImpl action, LocatableEvent event) throws LocatableEventRequestor.EventProcessingException {
        ThreadReferenceProxyImpl thread;
        SuspendContextImpl suspendContext = action.getSuspendContext();
        if (suspendContext != null && (thread = suspendContext.getThread()) != null) {
            DebugProcessImpl process2 = suspendContext.getDebugProcess();
            try {
                StackFrameProxyImpl frameProxy = (StackFrameProxyImpl)ContainerUtil.getFirstItem(thread.forceFrames());
                if (frameProxy != null) {
                    Value key;
                    Map stacks = (Map)process2.getUserData(CAPTURED_STACKS);
                    if (stacks == null) {
                        stacks = new CapturedStacksMap();
                        StackCapturingLineBreakpoint.putProcessUserData(CAPTURED_STACKS, Collections.synchronizedMap(stacks), process2);
                    }
                    if ((key = this.myCaptureEvaluator.evaluate(new EvaluationContextImpl(suspendContext, frameProxy))) instanceof ObjectReference) {
                        List<StackFrameItem> frames = StackFrameItem.createFrames(suspendContext, true);
                        if (frames.size() > 500) {
                            frames = frames.subList(0, 500);
                        }
                        stacks.put(StackCapturingLineBreakpoint.getKey((ObjectReference)key), frames);
                    }
                }
            }
            catch (EvaluateException e) {
                LOG.debug((Throwable)e);
                process2.printToConsole(DebuggerBundle.message((String)"error.unable.to.evaluate.capture.expression", (Object[])new Object[]{e.getMessage()}) + "\n");
            }
        }
        return false;
    }

    @Override
    protected void fireBreakpointChanged() {
    }

    @Override
    public StreamEx matchingMethods(StreamEx<Method> methods, DebugProcessImpl debugProcess) {
        String methodName = this.getMethodName();
        return (StreamEx)((StreamEx)methods.filter(m -> Comparing.equal((String)methodName, (String)m.name()) && (this.mySignature == null || Comparing.equal((String)this.mySignature, (String)m.signature())))).limit(1L);
    }

    public static void deleteAll(DebugProcessImpl debugProcess) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        List bpts = (List)debugProcess.getUserData(CAPTURE_BREAKPOINTS);
        if (!ContainerUtil.isEmpty((Collection)bpts)) {
            bpts.forEach(debugProcess.getRequestsManager()::deleteRequest);
            bpts.clear();
        }
    }

    public static void createAll(DebugProcessImpl debugProcess) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        StreamEx points = (StreamEx)StreamEx.of(DebuggerSettings.getInstance().getCapturePoints()).filter(c -> c.myEnabled);
        if (StackCapturingLineBreakpoint.isAgentEnabled()) {
            points = points.append(debugProcess.getAgentInsertPoints());
        }
        points.forEach(c -> StackCapturingLineBreakpoint.track(debugProcess, c));
    }

    public static void clearCaches(DebugProcessImpl debugProcess) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        List bpts = (List)debugProcess.getUserData(CAPTURE_BREAKPOINTS);
        if (!ContainerUtil.isEmpty((Collection)bpts)) {
            bpts.forEach(b -> {
                b.myCaptureEvaluator.clearCache();
                b.myInsertEvaluator.clearCache();
            });
        }
    }

    @Override
    public void createRequest(DebugProcessImpl debugProcess) {
        if (!StringUtil.isEmpty((String)this.getClassName())) {
            super.createRequest(debugProcess);
        }
    }

    @Override
    public void customizeRenderer(SimpleColoredComponent renderer) {
        renderer.append("Capture point at " + this.myCapturePoint.myClassName + "." + this.myCapturePoint.myMethodName);
    }

    @Override
    public boolean isEnabled() {
        return this.myCapturePoint.myEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myCapturePoint.myEnabled = enabled;
        DebuggerSettings.getInstance().setCapturePoints(DebuggerSettings.getInstance().getCapturePoints());
    }

    private static void track(DebugProcessImpl debugProcess, CapturePoint capturePoint) {
        StackCapturingLineBreakpoint breakpoint = new StackCapturingLineBreakpoint(debugProcess.getProject(), capturePoint);
        breakpoint.createRequest(debugProcess);
        CopyOnWriteArrayList<StackCapturingLineBreakpoint> bpts = (CopyOnWriteArrayList<StackCapturingLineBreakpoint>)debugProcess.getUserData(CAPTURE_BREAKPOINTS);
        if (bpts == null) {
            bpts = new CopyOnWriteArrayList<StackCapturingLineBreakpoint>();
            StackCapturingLineBreakpoint.putProcessUserData(CAPTURE_BREAKPOINTS, bpts, debugProcess);
        }
        bpts.add(breakpoint);
    }

    public static <T> void putProcessUserData(final @NotNull Key<T> key, @Nullable T value, DebugProcessImpl debugProcess) {
        if (key == null) {
            StackCapturingLineBreakpoint.$$$reportNull$$$0(1);
        }
        debugProcess.putUserData(key, value);
        debugProcess.addDebugProcessListener(new DebugProcessListener(){

            public void processDetached(DebugProcess process2, boolean closedByUser) {
                process2.putUserData(key, null);
            }
        });
    }

    @Nullable
    public static CapturePoint getMatchingDisabledInsertionPoint(@NotNull StackFrameProxyImpl frame) {
        List<CapturePoint> capturePoints;
        if (frame == null) {
            StackCapturingLineBreakpoint.$$$reportNull$$$0(2);
        }
        if (!(capturePoints = DebuggerSettings.getInstance().getCapturePoints()).isEmpty()) {
            try {
                Location location = frame.location();
                String className = location.declaringType().name();
                String methodName = location.method().name();
                for (CapturePoint c : capturePoints) {
                    if (c.myEnabled || !StringUtil.equals((CharSequence)c.myInsertClassName, (CharSequence)className) || !StringUtil.equals((CharSequence)c.myInsertMethodName, (CharSequence)methodName)) continue;
                    return c;
                }
            }
            catch (EvaluateException | InternalException e) {
                LOG.debug(e);
            }
        }
        return null;
    }

    @Nullable
    public static List<StackFrameItem> getRelatedStack(@NotNull StackFrameProxyImpl frame, @NotNull SuspendContextImpl suspendContext, boolean checkInProcessData) {
        DebugProcessImpl debugProcess;
        Map capturedStacks;
        if (frame == null) {
            StackCapturingLineBreakpoint.$$$reportNull$$$0(3);
        }
        if (suspendContext == null) {
            StackCapturingLineBreakpoint.$$$reportNull$$$0(4);
        }
        if (ContainerUtil.isEmpty((Map)(capturedStacks = (Map)(debugProcess = suspendContext.getDebugProcess()).getUserData(CAPTURED_STACKS))) && !StackCapturingLineBreakpoint.isAgentEnabled()) {
            return null;
        }
        List captureBreakpoints = (List)debugProcess.getUserData(CAPTURE_BREAKPOINTS);
        if (ContainerUtil.isEmpty((Collection)captureBreakpoints)) {
            return null;
        }
        try {
            Location location = frame.location();
            String className = location.declaringType().name();
            String methodName = location.method().name();
            for (StackCapturingLineBreakpoint b : captureBreakpoints) {
                String insertClassName = b.myCapturePoint.myInsertClassName;
                if (!StringUtil.isEmpty((String)insertClassName) && !StringUtil.equals((CharSequence)insertClassName, (CharSequence)className) || !StringUtil.equals((CharSequence)b.myCapturePoint.myInsertMethodName, (CharSequence)methodName)) continue;
                try {
                    EvaluationContextImpl evaluationContext = new EvaluationContextImpl(suspendContext, frame);
                    Value key = b.myInsertEvaluator.evaluate(evaluationContext);
                    List<StackFrameItem> items = null;
                    if (key instanceof ObjectReference) {
                        if (capturedStacks != null) {
                            items = (List<StackFrameItem>)capturedStacks.get(StackCapturingLineBreakpoint.getKey((ObjectReference)key));
                        }
                        if (items == null && checkInProcessData) {
                            items = StackCapturingLineBreakpoint.getProcessCapturedStack(key, evaluationContext);
                        }
                    }
                    return items;
                }
                catch (EvaluateException e) {
                    LOG.debug((Throwable)e);
                    if (e.getCause() instanceof IncompatibleThreadStateException) continue;
                    debugProcess.printToConsole(DebuggerBundle.message((String)"error.unable.to.evaluate.insert.expression", (Object[])new Object[]{e.getMessage()}) + "\n");
                }
            }
        }
        catch (EvaluateException e) {
            LOG.debug((Throwable)e);
        }
        return null;
    }

    private static List<StackFrameItem> getProcessCapturedStack(Value key, EvaluationContextImpl evaluationContext) throws EvaluateException {
        DebugProcessImpl process2 = (evaluationContext = evaluationContext.withAutoLoadClasses(false)).getDebugProcess();
        Pair methodPair = (Pair)process2.getUserData(CAPTURE_STORAGE_METHOD);
        if (methodPair == null) {
            try {
                ClassType captureClass = (ClassType)process2.findClass(evaluationContext, "com.intellij.rt.debugger.agent.CaptureStorage", null);
                if (captureClass == null) {
                    methodPair = NO_CAPTURE_AGENT;
                    LOG.debug("Error loading debug agent", new Object[]{"agent class not found"});
                } else {
                    methodPair = Pair.create((Object)captureClass, (Object)captureClass.methodsByName("getRelatedStack").get(0));
                }
            }
            catch (EvaluateException e) {
                methodPair = NO_CAPTURE_AGENT;
                LOG.debug("Error loading debug agent", (Throwable)e);
            }
            StackCapturingLineBreakpoint.putProcessUserData(CAPTURE_STORAGE_METHOD, methodPair, process2);
        }
        if (methodPair == NO_CAPTURE_AGENT) {
            return null;
        }
        VirtualMachineProxyImpl virtualMachineProxy = process2.getVirtualMachineProxy();
        List<Value> args = Arrays.asList(key, virtualMachineProxy.mirrorOf(500));
        Value resArray = process2.invokeMethod(evaluationContext, (ClassType)methodPair.first, (Method)methodPair.second, args, 1, true);
        DebuggerUtilsEx.keep(resArray, evaluationContext);
        if (resArray instanceof ArrayReference) {
            List<Value> values = ((ArrayReference)resArray).getValues();
            ArrayList<StackFrameItem> res = new ArrayList<StackFrameItem>(values.size());
            ClassesByNameProvider classesByName = ClassesByNameProvider.createCache(virtualMachineProxy.allClasses());
            for (Value value : values) {
                if (value == null) {
                    res.add(null);
                    continue;
                }
                List<Value> values1 = ((ArrayReference)value).getValues();
                String className = StackCapturingLineBreakpoint.getStringRefValue((StringReference)values1.get(0));
                String methodName = StackCapturingLineBreakpoint.getStringRefValue((StringReference)values1.get(2));
                int line = Integer.parseInt(((StringReference)values1.get(3)).value());
                Location location = StackCapturingLineBreakpoint.findLocation(process2, (ReferenceType)ContainerUtil.getFirstItem(classesByName.get(className)), methodName, line);
                res.add(new ProcessStackFrameItem(location, className, methodName));
            }
            return res;
        }
        return null;
    }

    private static String getStringRefValue(StringReference ref) {
        return ref != null ? ref.value() : null;
    }

    private static Location findLocation(DebugProcessImpl debugProcess, ReferenceType type, String methodName, int line) {
        if (type != null && line >= 0) {
            try {
                Location location = type.locationsOfLine("Java", null, line).stream().filter(l -> l.method().name().equals(methodName)).findFirst().orElse(null);
                if (location != null) {
                    return location;
                }
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
        }
        return new GeneratedLocation(debugProcess, type, methodName, line);
    }

    @Nullable
    public static List<StackFrameItem> getRelatedStack(@Nullable ObjectReference key, @Nullable DebugProcessImpl process2) {
        Map data;
        if (process2 != null && key != null && (data = (Map)process2.getUserData(CAPTURED_STACKS)) != null) {
            return (List)data.get(key);
        }
        return null;
    }

    private static Object getKey(ObjectReference reference) {
        return reference instanceof StringReference ? ((StringReference)reference).value() : reference;
    }

    public static boolean isAgentEnabled() {
        return DebuggerSettings.getInstance().INSTRUMENTING_AGENT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/StackCapturingLineBreakpoint";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/StackCapturingLineBreakpoint";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "putProcessUserData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMatchingDisabledInsertionPoint";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedStack";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyEvaluator {
        private final String myExpression;
        private ExpressionEvaluator myEvaluator;
        private final Map<Location, ExpressionEvaluator> myEvaluatorCache = ContainerUtil.createWeakMap();

        public MyEvaluator(String expression) {
            boolean paramEvaluator;
            this.myExpression = expression;
            final int paramId = DecompiledLocalVariable.getParamId(this.myExpression);
            boolean bl = paramEvaluator = paramId > -1;
            if (paramEvaluator) {
                this.myEvaluator = new ExpressionEvaluatorImpl(new Evaluator(){

                    @Override
                    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
                        List<Value> argumentValues = context.getFrameProxy().getArgumentValues();
                        if (paramId >= argumentValues.size()) {
                            throw new EvaluateException("Param index " + paramId + " requested, but only " + argumentValues.size() + " available");
                        }
                        return argumentValues.get(paramId);
                    }
                });
            }
        }

        @Nullable
        Value evaluate(EvaluationContext context) throws EvaluateException {
            Location location;
            ExpressionEvaluator evaluator = this.myEvaluator;
            if (evaluator == null && (evaluator = this.myEvaluatorCache.get(location = context.getFrameProxy().location())) == null && !StringUtil.isEmpty((String)this.myExpression)) {
                evaluator = (ExpressionEvaluator)ApplicationManager.getApplication().runReadAction(() -> {
                    SourcePosition sourcePosition = ContextUtil.getSourcePosition((StackFrameContext)context);
                    PsiElement contextElement = ContextUtil.getContextElement(sourcePosition);
                    return EvaluatorBuilderImpl.build(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, this.myExpression), contextElement, sourcePosition, context.getProject());
                });
                this.myEvaluatorCache.put(location, evaluator);
            }
            if (evaluator != null) {
                return evaluator.evaluate(context);
            }
            return null;
        }

        void clearCache() {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            this.myEvaluatorCache.clear();
        }
    }

    private static class ProcessStackFrameItem
    extends StackFrameItem {
        final String myClass;
        final String myMethod;

        public ProcessStackFrameItem(Location location, String aClass, String method) {
            super(location, null);
            this.myClass = aClass;
            this.myMethod = method;
        }

        @Override
        @NotNull
        public String path() {
            String string = this.myClass;
            if (string == null) {
                ProcessStackFrameItem.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String method() {
            String string = this.myMethod;
            if (string == null) {
                ProcessStackFrameItem.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public String toString() {
            return this.myClass + "." + this.myMethod + ":" + this.line();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/debugger/ui/breakpoints/StackCapturingLineBreakpoint$ProcessStackFrameItem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "path";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "method";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class CapturedStacksMap
    extends LinkedHashMap<Object, List<StackFrameItem>> {
        private CapturedStacksMap() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 1000;
        }
    }
}

