/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ByteType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.IntegerType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongType;
import com.sun.jdi.LongValue;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ShortType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.Type;
import com.sun.jdi.Value;

public class BinaryRenderer
extends NodeRendererImpl {
    private static final Logger LOG = Logger.getInstance(BinaryRenderer.class);

    @Override
    public String calcLabel(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, DescriptorLabelListener listener) throws EvaluateException {
        int i;
        Value value = valueDescriptor.getValue();
        if (value == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder("0b");
        int prefixLength = buf.length();
        String valueStr = "";
        if (value instanceof ByteValue) {
            valueStr = Integer.toBinaryString(0xFF & ((ByteValue)value).byteValue());
        } else if (value instanceof ShortValue) {
            valueStr = Integer.toBinaryString(0xFFFF & ((ShortValue)value).shortValue());
        } else if (value instanceof IntegerValue) {
            valueStr = Integer.toBinaryString(((PrimitiveValue)value).intValue());
        } else if (value instanceof LongValue) {
            valueStr = Long.toBinaryString(((LongValue)value).longValue());
        } else {
            LOG.error("Unsupported value " + value);
        }
        int remainder = valueStr.length() % 8;
        if (remainder != 0) {
            for (i = 0; i < 8 - remainder; ++i) {
                buf.append('0');
            }
        }
        buf.append(valueStr);
        for (i = buf.length() - 8; i > prefixLength; i -= 8) {
            buf.insert(i, '_');
        }
        return buf.toString();
    }

    @Override
    public String getName() {
        return "Binary";
    }

    @Override
    public String getUniqueId() {
        return "BinaryRenderer";
    }

    @Override
    public boolean isApplicable(Type t) {
        if (t == null) {
            return false;
        }
        return t instanceof ByteType || t instanceof ShortType || t instanceof IntegerType || t instanceof LongType;
    }
}

