/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathsList;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class TestClassCollector {
    private static final Logger LOG = Logger.getInstance(TestClassCollector.class);

    public static String[] collectClassFQNames(final String packageName, @Nullable Path rootPath, JavaTestConfigurationBase configuration, Function<ClassLoader, Predicate<Class<?>>> predicateProducer) {
        Module module2 = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        final ClassLoader classLoader = TestClassCollector.createUsersClassLoader(configuration);
        final HashSet classes = new HashSet();
        try {
            String packagePath = packageName.replace('.', '/');
            Enumeration<URL> resources = classLoader.getResources(packagePath);
            final Predicate<Class<?>> classPredicate = predicateProducer.apply(classLoader);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                if ("jar".equals(url.getProtocol())) continue;
                final Path baseDir = Paths.get(url.toURI());
                if (rootPath != null && !baseDir.startsWith(rootPath)) continue;
                final String pathSeparator = baseDir.getFileSystem().getSeparator();
                Files.walkFileTree(baseDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        ProgressManager.checkCanceled();
                        FileVisitResult result = super.visitFile(file, attrs);
                        File f = file.toFile();
                        String fName = f.getName();
                        if (fName.endsWith(".class")) {
                            try {
                                Path relativePath = baseDir.relativize(file.getParent());
                                String subpackageName = StringUtil.getQualifiedName((String)relativePath.toString().replace(pathSeparator, "."), (String)FileUtil.getNameWithoutExtension((String)fName));
                                String fqName = StringUtil.getQualifiedName((String)packageName, (String)subpackageName);
                                Class<?> aClass = Class.forName(fqName, false, classLoader);
                                int modifiers = aClass.getModifiers();
                                if (Modifier.isAbstract(modifiers) || !Modifier.isPublic(modifiers) || aClass.isMemberClass() && !Modifier.isStatic(modifiers)) {
                                    return result;
                                }
                                if (classPredicate.test(aClass)) {
                                    classes.add(fqName);
                                }
                            }
                            catch (Throwable e) {
                                LOG.info("error processing: " + fName + " of " + baseDir.toString(), e);
                            }
                        }
                        return result;
                    }
                });
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        return ArrayUtil.toStringArray(classes);
    }

    public static ClassLoader createUsersClassLoader(JavaTestConfigurationBase configuration) {
        Module module2 = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        ArrayList<URL> urls = new ArrayList<URL>();
        PathsList pathsList = (PathsList)ReadAction.compute(() -> (module2 == null || configuration.getTestSearchScope() == TestSearchScope.WHOLE_PROJECT ? OrderEnumerator.orderEntries((Project)configuration.getProject()) : OrderEnumerator.orderEntries((Module)module2)).runtimeOnly().recursively().getPathsList());
        for (VirtualFile file : pathsList.getVirtualFiles()) {
            try {
                urls.add(VfsUtilCore.virtualToIoFile((VirtualFile)file).toURI().toURL());
            }
            catch (MalformedURLException ignored) {
                LOG.info((Throwable)ignored);
            }
        }
        return UrlClassLoader.build().allowLock().useCache().urls(urls).get();
    }

    @Nullable
    public static Path getRootPath(Module module2, boolean chooseSingleModule) {
        VirtualFile tests;
        CompilerModuleExtension moduleExtension;
        if (chooseSingleModule && (moduleExtension = CompilerModuleExtension.getInstance((Module)module2)) != null && (tests = moduleExtension.getCompilerOutputPathForTests()) != null) {
            return Paths.get(VfsUtilCore.virtualToIoFile((VirtualFile)tests).toURI());
        }
        return null;
    }
}

