/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jshell;

import com.intellij.ProjectTopics;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.jshell.DropJShellStateAction;
import com.intellij.execution.jshell.ExecuteJShellAction;
import com.intellij.execution.jshell.JShellRootType;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SnippetEditorDecorator
extends EditorNotifications.Provider<ConfigurationPane> {
    public static final Key<ConfigurationPane> CONTEXT_KEY = Key.create((String)"jshell.editor.toolbar");
    private final Project myProject;

    public SnippetEditorDecorator(Project project2) {
        this.myProject = project2;
    }

    @NotNull
    public Key<ConfigurationPane> getKey() {
        Key<ConfigurationPane> key = CONTEXT_KEY;
        if (key == null) {
            SnippetEditorDecorator.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Nullable
    public ConfigurationPane createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        RootType root;
        if (file == null) {
            SnippetEditorDecorator.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            SnippetEditorDecorator.$$$reportNull$$$0(2);
        }
        if (!((root = ScratchFileService.getInstance().getRootType(file)) instanceof JShellRootType)) {
            return null;
        }
        return new ConfigurationPane(this.myProject);
    }

    @Nullable
    public static ConfigurationPane getJShellConfiguration(DataContext context) {
        return SnippetEditorDecorator.getJShellConfiguration((FileEditor)PlatformDataKeys.FILE_EDITOR.getData(context));
    }

    @Nullable
    public static ConfigurationPane getJShellConfiguration(FileEditor fileEditor) {
        return (ConfigurationPane)((Object)CONTEXT_KEY.get((UserDataHolder)fileEditor));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/jshell/SnippetEditorDecorator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/jshell/SnippetEditorDecorator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ConfigurationPane
    extends EditorHeaderComponent {
        private final Alarm myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        private final JrePathEditor myJreEditor;
        private final ConfigurationModuleSelector myModuleSelector;
        private MessageBusConnection myBusConnection;

        ConfigurationPane(Project project2) {
            DefaultActionGroup actions = new DefaultActionGroup(new AnAction[]{ExecuteJShellAction.getSharedInstance(), DropJShellStateAction.getSharedInstance()});
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("JShellSnippetEditor", (ActionGroup)actions, true);
            this.myJreEditor = new JrePathEditor(DefaultJreSelector.projectSdk(project2));
            this.myJreEditor.setToolTipText("Alternative JRE to run JShell");
            this.myJreEditor.setPathOrName(null, true);
            LabeledComponent modulePane = new LabeledComponent();
            ModulesComboBox modulesCombo = new ModulesComboBox();
            modulePane.setComponent((JComponent)modulesCombo);
            modulePane.setLabelLocation("West");
            modulePane.setText("Use classpath of:");
            this.myModuleSelector = new ConfigurationModuleSelector(project2, modulesCombo, "<whole project>");
            JPanel mainPane = new JPanel(new GridBagLayout());
            mainPane.add((Component)toolbar.getComponent(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insets((int)2, (int)3, (int)0, (int)0), 0, 0));
            mainPane.add((Component)modulePane, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insets((int)2, (int)3, (int)0, (int)0), 0, 0));
            mainPane.add((Component)this.myJreEditor, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)2, (int)15, (int)0, (int)0), 0, 0));
            this.add(mainPane, "Center");
        }

        public void addNotify() {
            super.addNotify();
            this.myBusConnection = this.myModuleSelector.getProject().getMessageBus().connect();
            this.myBusConnection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

                public void moduleAdded(@NotNull Project project2, @NotNull Module module2) {
                    if (project2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (module2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.reloadModules();
                }

                public void moduleRemoved(@NotNull Project project2, @NotNull Module module2) {
                    if (project2 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (module2 == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    this.reloadModules();
                }

                public void modulesRenamed(@NotNull Project project2, @NotNull List<Module> modules, @NotNull Function<Module, String> oldNameProvider) {
                    if (project2 == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    if (modules == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    if (oldNameProvider == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    this.reloadModules();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "module";
                            break;
                        }
                        case 5: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "modules";
                            break;
                        }
                        case 6: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "oldNameProvider";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/execution/jshell/SnippetEditorDecorator$ConfigurationPane$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "moduleAdded";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "moduleRemoved";
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 6: {
                            objectArray = objectArray2;
                            objectArray2[2] = "modulesRenamed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            this.reloadModules();
        }

        public void removeNotify() {
            super.removeNotify();
            MessageBusConnection conn = this.myBusConnection;
            if (conn != null) {
                this.myBusConnection = null;
                conn.disconnect();
                this.myUpdateAlarm.cancelAllRequests();
            }
        }

        private void reloadModules() {
            this.myUpdateAlarm.cancelAllRequests();
            this.myUpdateAlarm.addRequest(() -> this.myModuleSelector.reset(), 300L);
        }

        @Nullable
        public Module getContextModule() {
            return this.myModuleSelector.getModule();
        }

        @Nullable
        public Sdk getRuntimeSdk() {
            String pathOrName = this.myJreEditor.getJrePathOrName();
            if (pathOrName != null) {
                JavaSdk javaSdkType = JavaSdk.getInstance();
                ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
                Sdk sdkByName = jdkTable.findJdk(pathOrName, javaSdkType.getName());
                if (sdkByName != null) {
                    return sdkByName;
                }
                for (Sdk sdk : jdkTable.getSdksOfType((SdkTypeId)javaSdkType)) {
                    if (!FileUtil.pathsEqual((String)pathOrName, (String)sdk.getHomePath())) continue;
                    return sdk;
                }
            }
            return null;
        }
    }
}

