/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.generic;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VirtualFileSetState {
    public static final DataExternalizer<VirtualFileSetState> EXTERNALIZER = new VirtualFileWithDependenciesExternalizer();
    private Map<String, Long> myTimestamps = new HashMap<String, Long>();

    public VirtualFileSetState() {
    }

    public VirtualFileSetState(Collection<? extends VirtualFile> files) {
        for (VirtualFile virtualFile : files) {
            this.addFile(virtualFile);
        }
    }

    public void addFile(@NotNull VirtualFile file) {
        if (file == null) {
            VirtualFileSetState.$$$reportNull$$$0(0);
        }
        this.myTimestamps.put(file.getUrl(), file.getTimeStamp());
    }

    public boolean isUpToDate(Set<? extends VirtualFile> files) {
        if (files.size() != this.myTimestamps.size()) {
            return false;
        }
        for (VirtualFile virtualFile : files) {
            Long timestamp = this.myTimestamps.get(virtualFile.getUrl());
            if (timestamp != null && timestamp.longValue() == virtualFile.getTimeStamp()) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/compiler/generic/VirtualFileSetState", "addFile"));
    }

    private static class VirtualFileWithDependenciesExternalizer
    implements DataExternalizer<VirtualFileSetState> {
        private VirtualFileWithDependenciesExternalizer() {
        }

        public void save(@NotNull DataOutput out, VirtualFileSetState value) throws IOException {
            if (out == null) {
                VirtualFileWithDependenciesExternalizer.$$$reportNull$$$0(0);
            }
            Map dependencies = value.myTimestamps;
            out.writeInt(dependencies.size());
            for (Map.Entry entry : dependencies.entrySet()) {
                IOUtil.writeUTF((DataOutput)out, (String)((String)entry.getKey()));
                out.writeLong((Long)entry.getValue());
            }
        }

        public VirtualFileSetState read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                VirtualFileWithDependenciesExternalizer.$$$reportNull$$$0(1);
            }
            VirtualFileSetState state = new VirtualFileSetState();
            int size = in.readInt();
            while (size-- > 0) {
                String url = IOUtil.readUTF((DataInput)in);
                long timestamp = in.readLong();
                state.myTimestamps.put(url, timestamp);
            }
            return state;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/compiler/generic/VirtualFileSetState$VirtualFileWithDependenciesExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

