/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.configurationStore;

import com.intellij.ProjectTopics;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.StreamProviderFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.configurationStore.ExternalStorageSpec;
import com.intellij.openapi.externalSystem.configurationStore.ExternalSystemStreamProviderFactoryKt;
import com.intellij.openapi.externalSystem.configurationStore.ModuleFileSystemExternalSystemStorage;
import com.intellij.openapi.externalSystem.configurationStore.ProjectFileSystemExternalSystemStorage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.roots.ProjectModelElement;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.util.Function;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JB\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001c\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u00152\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u001eH\u0002J\u0010\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u0015R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/openapi/externalSystem/configurationStore/ExternalSystemStreamProviderFactory;", "Lcom/intellij/configurationStore/StreamProviderFactory;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "fileStorage", "Lcom/intellij/openapi/externalSystem/configurationStore/ProjectFileSystemExternalSystemStorage;", "getFileStorage", "()Lcom/intellij/openapi/externalSystem/configurationStore/ProjectFileSystemExternalSystemStorage;", "isReimportOnMissedExternalStorageScheduled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isStorageFlushInProgress", "", "moduleStorage", "Lcom/intellij/openapi/externalSystem/configurationStore/ModuleFileSystemExternalSystemStorage;", "getModuleStorage", "()Lcom/intellij/openapi/externalSystem/configurationStore/ModuleFileSystemExternalSystemStorage;", "storageSpecLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "storages", "Lgnu/trove/THashMap;", "", "Lcom/intellij/openapi/components/Storage;", "customizeStorageSpecs", "", "component", "Lcom/intellij/openapi/components/PersistentStateComponent;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManager;", "stateSpec", "Lcom/intellij/openapi/components/State;", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "getOrCreateExternalStorageSpec", "fileSpec", "inProjectStateSpec", "readModuleData", "Lorg/jdom/Element;", "name", "intellij.platform.externalSystem.impl"})
public final class ExternalSystemStreamProviderFactory
implements StreamProviderFactory {
    @NotNull
    private final ModuleFileSystemExternalSystemStorage moduleStorage;
    @NotNull
    private final ProjectFileSystemExternalSystemStorage fileStorage;
    private boolean isStorageFlushInProgress;
    private final AtomicBoolean isReimportOnMissedExternalStorageScheduled;
    private final ReentrantReadWriteLock storageSpecLock;
    private final THashMap<String, Storage> storages;
    private final Project project;

    @NotNull
    public final ModuleFileSystemExternalSystemStorage getModuleStorage() {
        return this.moduleStorage;
    }

    @NotNull
    public final ProjectFileSystemExternalSystemStorage getFileStorage() {
        return this.fileStorage;
    }

    @Nullable
    public List<Storage> customizeStorageSpecs(@NotNull PersistentStateComponent<?> component, @NotNull StateStorageManager storageManager, @NotNull State stateSpec, @NotNull List<Storage> storages, @NotNull StateStorageOperation operation) {
        Project project2;
        Intrinsics.checkParameterIsNotNull(component, (String)"component");
        Intrinsics.checkParameterIsNotNull((Object)storageManager, (String)"storageManager");
        Intrinsics.checkParameterIsNotNull((Object)stateSpec, (String)"stateSpec");
        Intrinsics.checkParameterIsNotNull(storages, (String)"storages");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        ComponentManager componentManager = storageManager.getComponentManager();
        ComponentManager componentManager2 = componentManager;
        if (!(componentManager2 instanceof Project)) {
            componentManager2 = null;
        }
        if ((project2 = (Project)componentManager2) == null) {
            ComponentManager componentManager3 = componentManager;
            if (componentManager3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.module.Module");
            }
            Project project3 = ((Module)componentManager3).getProject();
            project2 = project3;
            Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"(componentManager as Module).project");
        }
        Project project4 = project2;
        if (storages.size() == 1 && Intrinsics.areEqual((Object)((Storage)CollectionsKt.first(storages)).value(), (Object)"$WORKSPACE_FILE$") || !ProjectUtilCore.isExternalStorageEnabled((Project)project4)) {
            return null;
        }
        if (componentManager instanceof Project) {
            String fileSpec;
            Storage storage = (Storage)CollectionsKt.firstOrNull(storages);
            String string = fileSpec = storage != null ? storage.value() : null;
            if (Intrinsics.areEqual((Object)fileSpec, (Object)"libraries") || Intrinsics.areEqual((Object)fileSpec, (Object)"artifacts")) {
                Storage externalStorageSpec = this.getOrCreateExternalStorageSpec("" + fileSpec + ".xml", stateSpec);
                if (Intrinsics.areEqual((Object)operation, (Object)StateStorageOperation.READ)) {
                    return CollectionsKt.listOf((Object)externalStorageSpec);
                }
                ArrayList<Storage> result = new ArrayList<Storage>(storages.size() + 1);
                result.add(externalStorageSpec);
                result.addAll((Collection)storages);
                return result;
            }
        }
        if (!(component instanceof ProjectModelElement)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)operation, (Object)StateStorageOperation.WRITE) && ((ProjectModelElement)component).getExternalSource() == null) {
            return null;
        }
        Storage annotation = componentManager instanceof Project ? ExternalSystemStreamProviderFactory.getOrCreateExternalStorageSpec$default(this, storages.get(0).value(), null, 2, null) : ExternalSystemStreamProviderFactory.getOrCreateExternalStorageSpec$default(this, "$MODULE_FILE$", null, 2, null);
        if (stateSpec.externalStorageOnly()) {
            return CollectionsKt.listOf((Object)annotation);
        }
        ArrayList<Storage> result = new ArrayList<Storage>(storages.size() + 1);
        result.add(annotation);
        result.addAll((Collection)storages);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Storage getOrCreateExternalStorageSpec(String fileSpec, State inProjectStateSpec) {
        Storage storage;
        ReentrantReadWriteLock reentrantReadWriteLock = this.storageSpecLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            Storage storage2 = (Storage)this.storages.get((Object)fileSpec);
            storage = storage2;
        }
        finally {
            readLock.unlock();
        }
        if (storage == null) {
            Storage storage3;
            int n;
            reentrantReadWriteLock = this.storageSpecLock;
            readLock = reentrantReadWriteLock.readLock();
            int n2 = 0;
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n4 = n3 - 1;
            if (n2 <= n4) {
                do {
                    n = ++n2;
                    readLock.unlock();
                } while (n2 != n4);
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                Object object;
                void $receiver$iv;
                Map map = (Map)this.storages;
                String key$iv = fileSpec;
                Object value$iv = $receiver$iv.get(key$iv);
                if (value$iv == null) {
                    ExternalStorageSpec answer$iv = new ExternalStorageSpec(fileSpec, inProjectStateSpec);
                    $receiver$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                storage3 = (Storage)object;
            }
            finally {
                n = 0;
                int n5 = n3 - 1;
                if (n <= n5) {
                    do {
                        int n6 = ++n;
                        readLock.lock();
                    } while (n != n5);
                }
                writeLock.unlock();
            }
            return storage3;
        }
        return storage;
    }

    static /* bridge */ /* synthetic */ Storage getOrCreateExternalStorageSpec$default(ExternalSystemStreamProviderFactory externalSystemStreamProviderFactory, String string, State state, int n, Object object) {
        if ((n & 2) != 0) {
            state = null;
        }
        return externalSystemStreamProviderFactory.getOrCreateExternalStorageSpec(string, state);
    }

    @Nullable
    public final Element readModuleData(@NotNull String name2) {
        Element result;
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        if (!this.moduleStorage.getHasSomeData() && this.isReimportOnMissedExternalStorageScheduled.compareAndSet(false, true) && !this.project.isInitialized()) {
            StartupManager.getInstance((Project)this.project).runWhenProjectIsInitialized(new Runnable(this){
                final /* synthetic */ ExternalSystemStreamProviderFactory this$0;

                public final void run() {
                    ExternalProjectsManager externalProjectsManager = ExternalProjectsManager.getInstance((Project)ExternalSystemStreamProviderFactory.access$getProject$p(this.this$0));
                    externalProjectsManager.runWhenInitialized(new Runnable(externalProjectsManager){
                        final /* synthetic */ ExternalProjectsManager $externalProjectsManager;

                        public final void run() {
                            this.$externalProjectsManager.getExternalProjectsWatcher().markDirtyAllExternalProjects();
                        }
                        {
                            this.$externalProjectsManager = externalProjectsManager;
                        }
                    });
                }
                {
                    this.this$0 = externalSystemStreamProviderFactory;
                }
            });
        }
        if ((result = this.moduleStorage.read(name2)) != null) {
            // empty if block
        }
        return result;
    }

    public ExternalSystemStreamProviderFactory(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.project = project2;
        this.moduleStorage = new ModuleFileSystemExternalSystemStorage(this.project);
        this.fileStorage = new ProjectFileSystemExternalSystemStorage(this.project);
        this.isReimportOnMissedExternalStorageScheduled = new AtomicBoolean(false);
        this.storageSpecLock = new ReentrantReadWriteLock();
        this.storages = new THashMap();
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.project).subscribe(ProjectEx.ProjectSaved.TOPIC, (Object)new ProjectEx.ProjectSaved(){

            public final void saved(@NotNull Project it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (it == project && !isStorageFlushInProgress && this.getModuleStorage().isDirty()) {
                    isStorageFlushInProgress = true;
                    ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public final void run() {
                            try {
                                Logger $receiver$iv = ExternalSystemStreamProviderFactoryKt.access$getLOG$p();
                                try {
                                    this.getModuleStorage().forceSave();
                                }
                                catch (ProcessCanceledException e$iv) {
                                }
                                catch (Throwable e$iv) {
                                    $receiver$iv.error(e$iv);
                                }
                            }
                            finally {
                                isStorageFlushInProgress = false;
                            }
                        }
                    });
                }
            }
        });
        this.project.getMessageBus().connect().subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleRemoved(@NotNull Project project2, @NotNull Module module2) {
                Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
                ModuleFileSystemExternalSystemStorage moduleFileSystemExternalSystemStorage = this.getModuleStorage();
                String string = module2.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"module.name");
                moduleFileSystemExternalSystemStorage.remove(string);
            }

            public void modulesRenamed(@NotNull Project project2, @NotNull List<Module> modules, @NotNull Function<Module, String> oldNameProvider) {
                Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
                Intrinsics.checkParameterIsNotNull(modules, (String)"modules");
                Intrinsics.checkParameterIsNotNull(oldNameProvider, (String)"oldNameProvider");
                for (Module module2 : modules) {
                    ModuleFileSystemExternalSystemStorage moduleFileSystemExternalSystemStorage = this.getModuleStorage();
                    Object object = oldNameProvider.fun((Object)module2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"oldNameProvider.`fun`(module)");
                    String string = (String)object;
                    String string2 = module2.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"module.name");
                    moduleFileSystemExternalSystemStorage.rename(string, string2);
                }
            }
        });
    }

    @Nullable
    public StreamProvider createProvider(@NotNull ComponentManager componentManager, @NotNull StateStorageManager storageManager) {
        Intrinsics.checkParameterIsNotNull((Object)componentManager, (String)"componentManager");
        Intrinsics.checkParameterIsNotNull((Object)storageManager, (String)"storageManager");
        return StreamProviderFactory.DefaultImpls.createProvider((StreamProviderFactory)this, (ComponentManager)componentManager, (StateStorageManager)storageManager);
    }
}

