/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.settings;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.options.CompilerUIConfigurable;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.project.settings.ConfigurationData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.settings.ConfigurationHandler;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerConfigurationHandler
implements ConfigurationHandler {
    private static final Logger LOG = Logger.getInstance(CompilerConfigurationHandler.class);

    public void apply(@NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ConfigurationData configuration) {
        Object obj;
        if (project2 == null) {
            CompilerConfigurationHandler.$$$reportNull$$$0(0);
        }
        if (modelsProvider == null) {
            CompilerConfigurationHandler.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            CompilerConfigurationHandler.$$$reportNull$$$0(2);
        }
        if (!((obj = configuration.find("compiler")) instanceof Map)) {
            return;
        }
        Map configurationMap = (Map)obj;
        ApplicationManager.getApplication().invokeLater(() -> {
            String additionalVmOptions;
            Boolean rebuildOnDependencyChange;
            Boolean parallelCompilation;
            Boolean enableAutomake;
            Boolean addNotNullAssertions;
            Boolean clearOutputDirectory;
            Boolean displayNotificationPopup;
            Boolean autoShowFirstErrorInEditor;
            Number processHeapSize;
            if (project2 == null) {
                CompilerConfigurationHandler.$$$reportNull$$$0(3);
            }
            CompilerConfigurationImpl compilerConfiguration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project2);
            CompilerWorkspaceConfiguration workspaceConfiguration = CompilerWorkspaceConfiguration.getInstance((Project)project2);
            boolean changed = false;
            String resourcePatterns = CompilerConfigurationHandler.getString(configurationMap, "resourcePatterns");
            if (resourcePatterns != null) {
                try {
                    Object[] resourceFilePatterns = compilerConfiguration.getResourceFilePatterns();
                    compilerConfiguration.removeResourceFilePatterns();
                    CompilerUIConfigurable.applyResourcePatterns(resourcePatterns, compilerConfiguration);
                    if (!Arrays.equals(resourceFilePatterns, compilerConfiguration.getResourceFilePatterns())) {
                        changed = true;
                    }
                }
                catch (ConfigurationException e) {
                    LOG.warn("Unable to apply compiler resource patterns", (Throwable)e);
                }
            }
            if ((processHeapSize = CompilerConfigurationHandler.getNumber(configurationMap, "processHeapSize")) != null && processHeapSize.intValue() != compilerConfiguration.getBuildProcessHeapSize(0)) {
                compilerConfiguration.setBuildProcessHeapSize(processHeapSize.intValue());
                changed = true;
            }
            if ((autoShowFirstErrorInEditor = CompilerConfigurationHandler.getBoolean(configurationMap, "autoShowFirstErrorInEditor")) != null && workspaceConfiguration.AUTO_SHOW_ERRORS_IN_EDITOR != autoShowFirstErrorInEditor) {
                workspaceConfiguration.AUTO_SHOW_ERRORS_IN_EDITOR = autoShowFirstErrorInEditor;
                changed = true;
            }
            if ((displayNotificationPopup = CompilerConfigurationHandler.getBoolean(configurationMap, "displayNotificationPopup")) != null && workspaceConfiguration.DISPLAY_NOTIFICATION_POPUP != displayNotificationPopup) {
                workspaceConfiguration.DISPLAY_NOTIFICATION_POPUP = displayNotificationPopup;
                changed = true;
            }
            if ((clearOutputDirectory = CompilerConfigurationHandler.getBoolean(configurationMap, "clearOutputDirectory")) != null && workspaceConfiguration.CLEAR_OUTPUT_DIRECTORY != clearOutputDirectory) {
                workspaceConfiguration.CLEAR_OUTPUT_DIRECTORY = clearOutputDirectory;
                changed = true;
            }
            if ((addNotNullAssertions = CompilerConfigurationHandler.getBoolean(configurationMap, "addNotNullAssertions")) != null && compilerConfiguration.isAddNotNullAssertions() != addNotNullAssertions.booleanValue()) {
                compilerConfiguration.setAddNotNullAssertions(addNotNullAssertions);
                changed = true;
            }
            if ((enableAutomake = CompilerConfigurationHandler.getBoolean(configurationMap, "enableAutomake")) != null && workspaceConfiguration.MAKE_PROJECT_ON_SAVE != enableAutomake) {
                workspaceConfiguration.MAKE_PROJECT_ON_SAVE = enableAutomake;
                changed = true;
            }
            if ((parallelCompilation = CompilerConfigurationHandler.getBoolean(configurationMap, "parallelCompilation")) != null && workspaceConfiguration.PARALLEL_COMPILATION != parallelCompilation) {
                workspaceConfiguration.PARALLEL_COMPILATION = parallelCompilation;
                changed = true;
            }
            if ((rebuildOnDependencyChange = CompilerConfigurationHandler.getBoolean(configurationMap, "rebuildModuleOnDependencyChange")) != null && workspaceConfiguration.REBUILD_ON_DEPENDENCY_CHANGE != rebuildOnDependencyChange) {
                workspaceConfiguration.REBUILD_ON_DEPENDENCY_CHANGE = rebuildOnDependencyChange;
                changed = true;
            }
            if ((additionalVmOptions = CompilerConfigurationHandler.getString(configurationMap, "additionalVmOptions")) != null && workspaceConfiguration.COMPILER_PROCESS_ADDITIONAL_VM_OPTIONS != additionalVmOptions) {
                workspaceConfiguration.COMPILER_PROCESS_ADDITIONAL_VM_OPTIONS = additionalVmOptions;
                changed = true;
            }
            if (changed) {
                BuildManager.getInstance().clearState(project2);
            }
        });
    }

    @Nullable
    private static Boolean getBoolean(Map map, String key) {
        Object o = map.get(key);
        return o instanceof Boolean ? (Boolean)o : null;
    }

    private static Number getNumber(Map map, String key) {
        Object o = map.get(key);
        return o instanceof Number ? (Number)((Number)o) : (Number)null;
    }

    @Nullable
    private static String getString(Map map, String key) {
        Object o = map.get(key);
        return o instanceof String ? (String)o : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/settings/CompilerConfigurationHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$apply$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

