/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.ide.DataManager;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkException;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.EnvironmentUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemJdkComboBox
extends ComboBoxWithWidePopup<JdkComboBoxItem> {
    private static final int MAX_PATH_LENGTH = 50;
    @Nullable
    private Project myProject;
    private boolean suggestJre = true;

    public ExternalSystemJdkComboBox() {
        this(null);
    }

    public ExternalSystemJdkComboBox(@Nullable Project project2) {
        this.myProject = project2;
        this.setRenderer((ListCellRenderer)new ColoredListCellRenderer<JdkComboBoxItem>(){

            protected void customizeCellRenderer(@NotNull JList list, JdkComboBoxItem value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                CompositeAppearance appearance = new CompositeAppearance();
                JavaSdk sdkType = JavaSdk.getInstance();
                appearance.setIcon(sdkType.getIcon());
                SimpleTextAttributes attributes = ExternalSystemJdkComboBox.getTextAttributes(value.valid, selected);
                CompositeAppearance.DequeEnd ending = appearance.getEnding();
                ending.addText(value.label, attributes);
                if (value.comment != null && !value.comment.equals(value.jdkName)) {
                    SimpleTextAttributes textAttributes = !value.valid ? SimpleTextAttributes.ERROR_ATTRIBUTES : (SystemInfo.isMac && selected ? new SimpleTextAttributes(0, (Color)JBColor.WHITE) : SimpleTextAttributes.GRAY_ATTRIBUTES);
                    ending.addComment(value.comment, textAttributes);
                }
                CompositeAppearance compositeAppearance = ending.getAppearance();
                compositeAppearance.customize((SimpleColoredComponent)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/externalSystem/service/ui/ExternalSystemJdkComboBox$1", "customizeCellRenderer"));
            }
        });
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public void setProject(@Nullable Project project2) {
        this.myProject = project2;
    }

    public void setSetupButton(@NotNull JButton setUpButton, @NotNull ProjectSdksModel jdksModel, @Nullable String actionGroupTitle, @Nullable Condition<SdkTypeId> creationFilter) {
        if (setUpButton == null) {
            ExternalSystemJdkComboBox.$$$reportNull$$$0(0);
        }
        if (jdksModel == null) {
            ExternalSystemJdkComboBox.$$$reportNull$$$0(1);
        }
        this.setSetupButton(setUpButton, jdksModel, actionGroupTitle, creationFilter, null);
    }

    public void setSetupButton(@NotNull JButton setUpButton, @NotNull ProjectSdksModel jdksModel, @Nullable String actionGroupTitle, @Nullable Condition<SdkTypeId> creationFilter, @Nullable WizardContext wizardContext) {
        if (setUpButton == null) {
            ExternalSystemJdkComboBox.$$$reportNull$$$0(2);
        }
        if (jdksModel == null) {
            ExternalSystemJdkComboBox.$$$reportNull$$$0(3);
        }
        Arrays.stream(setUpButton.getActionListeners()).forEach(setUpButton::removeActionListener);
        setUpButton.addActionListener(e -> {
            if (jdksModel == null) {
                ExternalSystemJdkComboBox.$$$reportNull$$$0(9);
            }
            if (setUpButton == null) {
                ExternalSystemJdkComboBox.$$$reportNull$$$0(10);
            }
            DefaultActionGroup group = new DefaultActionGroup();
            jdksModel.createAddActions(group, (JComponent)((Object)this), this.getSelectedJdk(), jdk -> {
                String jdkName;
                Sdk existingJdk = Arrays.stream(ProjectJdkTable.getInstance().getAllJdks()).filter(sdk -> StringUtil.equals((CharSequence)sdk.getHomePath(), (CharSequence)jdk.getHomePath())).findFirst().orElse(null);
                if (existingJdk == null) {
                    SdkConfigurationUtil.addSdk((Sdk)jdk);
                    jdkName = jdk.getName();
                } else {
                    jdkName = existingJdk.getName();
                }
                this.refreshData(jdkName, wizardContext != null ? wizardContext.getProjectJdk() : null);
            }, creationFilter);
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)this));
            if (group.getChildrenCount() > 1) {
                JBPopupFactory.getInstance().createActionGroupPopup(actionGroupTitle, (ActionGroup)group, dataContext, JBPopupFactory.ActionSelectionAid.MNEMONICS, false).showUnderneathOf((Component)setUpButton);
            } else {
                AnActionEvent event = new AnActionEvent(null, dataContext, "unknown", new Presentation(""), ActionManager.getInstance(), 0);
                group.getChildren(event)[0].actionPerformed(event);
            }
        });
    }

    @Nullable
    public Sdk getSelectedJdk() {
        String jdkName = this.getSelectedValue();
        Sdk jdk = null;
        try {
            jdk = ExternalSystemJdkUtil.getJdk(this.myProject, jdkName);
        }
        catch (ExternalSystemJdkException externalSystemJdkException) {
            // empty catch block
        }
        return jdk;
    }

    @NotNull
    public ExternalSystemJdkComboBox withoutJre() {
        this.suggestJre = false;
        ExternalSystemJdkComboBox externalSystemJdkComboBox = this;
        if (externalSystemJdkComboBox == null) {
            ExternalSystemJdkComboBox.$$$reportNull$$$0(4);
        }
        return externalSystemJdkComboBox;
    }

    public void refreshData(@Nullable String selectedValue) {
        this.refreshData(selectedValue, null);
    }

    public void refreshData(@Nullable String selectedValue, @Nullable Sdk projectJdk) {
        Map<String, JdkComboBoxItem> jdkMap = this.collectComboBoxItem(projectJdk);
        if (selectedValue != null && !jdkMap.containsKey(selectedValue)) {
            assert (selectedValue.length() > 0);
            jdkMap.put(selectedValue, new JdkComboBoxItem(selectedValue, selectedValue, "", false));
        }
        this.removeAllItems();
        ComboBoxModel comboBoxModel = this.getModel();
        for (Map.Entry<String, JdkComboBoxItem> entry : jdkMap.entrySet()) {
            ((MutableComboBoxModel)comboBoxModel).addElement(entry.getValue());
        }
        ExternalSystemJdkComboBox.select(comboBoxModel, selectedValue);
    }

    private static void select(ComboBoxModel<JdkComboBoxItem> model, Object value) {
        for (int i = 0; i < model.getSize(); ++i) {
            JdkComboBoxItem item = (JdkComboBoxItem)model.getElementAt(i);
            if (!item.jdkName.equals(value)) continue;
            model.setSelectedItem(item);
            return;
        }
        if (model.getSize() != 0) {
            model.setSelectedItem(model.getElementAt(0));
        }
    }

    @Nullable
    public String getSelectedValue() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        Object item = model.getSelectedItem();
        return item != null ? ((JdkComboBoxItem)item).jdkName : null;
    }

    private Map<String, JdkComboBoxItem> collectComboBoxItem(@Nullable Sdk projectSdk) {
        String javaHomePath;
        LinkedHashMap<String, JdkComboBoxItem> result = new LinkedHashMap<String, JdkComboBoxItem>();
        for (Sdk sdk : ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)JavaSdk.getInstance())) {
            if (!((SdkType)sdk.getSdkType()).sdkHasValidPath(sdk)) continue;
            String name2 = sdk.getName();
            String comment = ExternalSystemJdkComboBox.buildComment(sdk);
            result.put(name2, new JdkComboBoxItem(name2, name2, comment, true));
        }
        if (this.suggestJre) {
            Sdk internalJdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
            assert (internalJdk.getHomePath() != null);
            result.put("#JAVA_INTERNAL", new JdkComboBoxItem("#JAVA_INTERNAL", ExternalSystemBundle.message((String)"external.system.java.internal.jre", (Object[])new Object[0]), ExternalSystemJdkComboBox.buildComment(internalJdk), true));
        }
        if (projectSdk == null && this.myProject != null && !this.myProject.isDisposed()) {
            projectSdk = ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk();
        }
        if (projectSdk != null) {
            result.put("#USE_PROJECT_JDK", new JdkComboBoxItem("#USE_PROJECT_JDK", "Use Project JDK", ExternalSystemJdkComboBox.buildComment(projectSdk), true));
        }
        if (ExternalSystemJdkUtil.isValidJdk(javaHomePath = (String)EnvironmentUtil.getEnvironmentMap().get("JAVA_HOME"))) {
            result.put("#JAVA_HOME", new JdkComboBoxItem("#JAVA_HOME", ExternalSystemBundle.message((String)"external.system.java.home.env", (Object[])new Object[0]), ExternalSystemJdkComboBox.truncateLongPath(javaHomePath), true));
        }
        return result;
    }

    private static String buildComment(@NotNull Sdk sdk) {
        if (sdk == null) {
            ExternalSystemJdkComboBox.$$$reportNull$$$0(5);
        }
        String versionString = sdk.getVersionString();
        String path = sdk.getHomePath();
        StringBuilder buf = new StringBuilder();
        if (versionString != null) {
            buf.append(versionString);
        }
        if (path != null) {
            buf.append(versionString != null ? ", " : "");
            buf.append("path: ").append(ExternalSystemJdkComboBox.truncateLongPath(path));
        }
        return buf.toString();
    }

    @NotNull
    private static String truncateLongPath(@NotNull String path) {
        if (path == null) {
            ExternalSystemJdkComboBox.$$$reportNull$$$0(6);
        }
        if (path.length() > 50) {
            String string = path.substring(0, 25) + "..." + path.substring(path.length() - 25 - 3);
            if (string == null) {
                ExternalSystemJdkComboBox.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            ExternalSystemJdkComboBox.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static SimpleTextAttributes getTextAttributes(boolean valid, boolean selected) {
        if (!valid) {
            return SimpleTextAttributes.ERROR_ATTRIBUTES;
        }
        if (!(!selected || SystemInfo.isWinVistaOrNewer && UIManager.getLookAndFeel().getName().contains("Windows"))) {
            return SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES;
        }
        return SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setUpButton";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdksModel";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/ui/ExternalSystemJdkComboBox";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/ui/ExternalSystemJdkComboBox";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutJre";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "truncateLongPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setSetupButton";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildComment";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "truncateLongPath";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setSetupButton$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class JdkComboBoxItem {
        private String jdkName;
        private String label;
        private String comment;
        private boolean valid;

        public JdkComboBoxItem(String jdkName, String label, String comment, boolean valid) {
            this.jdkName = jdkName;
            this.label = label;
            this.comment = comment;
            this.valid = valid;
        }
    }
}

