/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesAlphaComparator;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.elements.ManifestFileUtil;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarArtifactFromModulesDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private TextFieldWithBrowseButton myMainClassField;
    private JComboBox myModuleComboBox;
    private JLabel myMainClassLabel;
    private TextFieldWithBrowseButton myManifestDirField;
    private JLabel myManifestDirLabel;
    private JRadioButton myExtractJarsRadioButton;
    private JRadioButton myCopyJarsRadioButton;
    private JCheckBox myIncludeTestsCheckBox;
    private PackagingElementResolvingContext myContext;

    public JarArtifactFromModulesDialog(PackagingElementResolvingContext context) {
        super(context.getProject());
        this.myContext = context;
        this.$$$setupUI$$$();
        this.setTitle("Create JAR from Modules");
        this.myMainClassLabel.setLabelFor(this.myMainClassField.getTextField());
        this.myManifestDirLabel.setLabelFor(this.myManifestDirField.getTextField());
        Project project2 = this.myContext.getProject();
        ManifestFileUtil.setupMainClassField(project2, this.myMainClassField);
        this.myMainClassField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                JarArtifactFromModulesDialog.this.updateManifestDirField();
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JarArtifactFromModulesDialog.this.updateManifestDirField();
            }
        };
        this.myExtractJarsRadioButton.addActionListener(actionListener);
        this.myCopyJarsRadioButton.addActionListener(actionListener);
        this.updateManifestDirField();
        this.myManifestDirField.addBrowseFolderListener(null, null, project2, ManifestFileUtil.createDescriptorForManifestDirectory());
        this.setupModulesCombobox(context);
        this.init();
    }

    private void setupModulesCombobox(PackagingElementResolvingContext context) {
        Module[] modules = (Module[])context.getModulesProvider().getModules().clone();
        Arrays.sort(modules, ModulesAlphaComparator.INSTANCE);
        if (modules.length > 1) {
            this.myModuleComboBox.addItem(null);
        }
        for (Module module2 : modules) {
            this.myModuleComboBox.addItem(module2);
        }
        this.myModuleComboBox.setRenderer(new ModuleListRenderer(this.myModuleComboBox));
        new ComboboxSpeedSearch(this.myModuleComboBox){

            protected String getElementText(Object element) {
                return element instanceof Module ? ((Module)element).getName() : "";
            }
        };
    }

    private void updateManifestDirField() {
        VirtualFile file;
        boolean enable = !this.myMainClassField.getText().isEmpty() || !this.myExtractJarsRadioButton.isSelected();
        this.setManifestDirFieldEnabled(enable);
        if (enable && this.myManifestDirField.getText().isEmpty() && (file = ManifestFileUtil.suggestManifestFileDirectory(this.myContext.getProject(), this.getSelectedModule())) != null) {
            this.myManifestDirField.setText(FileUtil.toSystemDependentName((String)file.getPath()));
        }
    }

    @Nullable
    private Module getSelectedModule() {
        return (Module)this.myModuleComboBox.getSelectedItem();
    }

    @NotNull
    public Module[] getSelectedModules() {
        Module module2 = this.getSelectedModule();
        if (module2 != null) {
            Module[] moduleArray = new Module[]{module2};
            if (moduleArray == null) {
                JarArtifactFromModulesDialog.$$$reportNull$$$0(0);
            }
            return moduleArray;
        }
        Module[] moduleArray = this.myContext.getModulesProvider().getModules();
        if (moduleArray == null) {
            JarArtifactFromModulesDialog.$$$reportNull$$$0(1);
        }
        return moduleArray;
    }

    @NotNull
    public String getDirectoryForManifest() {
        String string = FileUtil.toSystemIndependentName((String)this.myManifestDirField.getText());
        if (string == null) {
            JarArtifactFromModulesDialog.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isExtractLibrariesToJar() {
        return this.myExtractJarsRadioButton.isSelected();
    }

    public boolean isIncludeTests() {
        return this.myIncludeTestsCheckBox.isSelected();
    }

    public String getMainClassName() {
        return this.myMainClassField.getText();
    }

    private void setManifestDirFieldEnabled(boolean enabled) {
        this.myManifestDirLabel.setEnabled(enabled);
        this.myManifestDirField.setEnabled(enabled);
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    protected String getHelpId() {
        return "reference.project.structure.artifacts.jar.from.module";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/packaging/impl/artifacts/JarArtifactFromModulesDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedModules";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoryForManifest";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel;
        JComboBox jComboBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JLabel jLabel2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myMainClassLabel = jLabel2 = new JLabel();
        jLabel2.setText("Main Class:");
        jLabel2.setDisplayedMnemonic('C');
        jLabel2.setDisplayedMnemonicIndex(5);
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myMainClassField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Module:");
        jLabel3.setDisplayedMnemonic('M');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myModuleComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(400, -1), null));
        this.myManifestDirLabel = jLabel = new JLabel();
        jLabel.setText("Directory for META-INF/MANIFEST.MF:");
        jLabel.setDisplayedMnemonic('D');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myManifestDirField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 0, 1, 2, 0, 1, 6, 0, null, null, null, 2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"JAR files from libraries", (int)0, (int)0, null, null));
        this.myExtractJarsRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        jRadioButton2.setText("extract to the target JAR");
        jRadioButton2.setMnemonic('E');
        jRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myCopyJarsRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("copy to the output directory and link via manifest");
        jRadioButton.setMnemonic('T');
        jRadioButton.setDisplayedMnemonicIndex(5);
        jPanel2.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myIncludeTestsCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Include tests");
        jCheckBox.setMnemonic('I');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox, new GridConstraints(5, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        jLabel3.setLabelFor(jComboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static class ModuleListRenderer
    extends ListCellRendererWrapper<Module> {
        public ModuleListRenderer(JComboBox comboBox) {
        }

        public void customize(JList list, Module value, int index, boolean selected, boolean hasFocus) {
            if (value != null) {
                this.setIcon(ModuleType.get((Module)value).getIcon());
                this.setText(value.getName());
            } else {
                this.setText("<All Modules>");
                this.setIcon(null);
            }
        }
    }
}

