/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.project.IntelliJProjectConfiguration;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.library.JpsLibraryCollection;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.serialization.JpsSerializationManager;
import org.jetbrains.jps.util.JpsPathUtil;
import org.junit.Assert;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \t2\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002R&\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/project/IntelliJProjectConfiguration;", "", "()V", "moduleLibraries", "", "", "Lcom/intellij/project/IntelliJProjectConfiguration$LibraryRoots;", "projectHome", "projectLibraries", "Companion", "LibraryRoots", "intellij.platform.testFramework"})
public final class IntelliJProjectConfiguration {
    private final String projectHome = PathManager.getHomePath();
    private final Map<String, LibraryRoots> projectLibraries;
    private final Map<String, Map<String, LibraryRoots>> moduleLibraries;
    private static final Lazy instance$delegate;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public IntelliJProjectConfiguration() {
        Map map;
        void $receiver$iv$iv;
        void $receiver$iv;
        String m2Repo = FileUtil.toSystemIndependentName((String)new File(SystemProperties.getUserHome(), ".m2/repository").getAbsolutePath());
        JpsProject project2 = JpsSerializationManager.getInstance().loadProject(this.projectHome, MapsKt.mapOf((Pair)TuplesKt.to((Object)"MAVEN_REPOSITORY", (Object)m2Repo)));
        1 extractLibrariesRoots$ = 1.INSTANCE;
        JpsLibraryCollection jpsLibraryCollection = project2.getLibraryCollection();
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsLibraryCollection, (String)"project.libraryCollection");
        this.projectLibraries = extractLibrariesRoots$.invoke(jpsLibraryCollection);
        Iterable iterable = project2.getModules();
        IntelliJProjectConfiguration intelliJProjectConfiguration = this;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        void var6_7 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Map libraries;
            JpsModule it;
            JpsModule jpsModule = (JpsModule)element$iv$iv;
            map = destination$iv$iv;
            String string = it.getName();
            it = (JpsModule)element$iv$iv;
            JpsLibraryCollection jpsLibraryCollection2 = it.getLibraryCollection();
            Intrinsics.checkExpressionValueIsNotNull((Object)jpsLibraryCollection2, (String)"it.libraryCollection");
            Map map2 = libraries = 1.INSTANCE.invoke(jpsLibraryCollection2);
            Map map3 = !map2.isEmpty() ? libraries : MapsKt.emptyMap();
            map.put(string, map3);
        }
        intelliJProjectConfiguration.moduleLibraries = map = destination$iv$iv;
    }

    static {
        Companion = new Companion(null);
        instance$delegate = LazyKt.lazy((Function0)Companion.instance.2.INSTANCE);
    }

    @JvmStatic
    @NotNull
    public static final List<String> getProjectLibraryClassesRootPaths(@NotNull String libraryName) {
        return Companion.getProjectLibraryClassesRootPaths(libraryName);
    }

    @JvmStatic
    @NotNull
    public static final List<String> getProjectLibraryClassesRootUrls(@NotNull String libraryName) {
        return Companion.getProjectLibraryClassesRootUrls(libraryName);
    }

    @JvmStatic
    @NotNull
    public static final LibraryRoots getProjectLibrary(@NotNull String libraryName) {
        return Companion.getProjectLibrary(libraryName);
    }

    @JvmStatic
    @NotNull
    public static final LibraryRoots getModuleLibrary(@NotNull String moduleName, @NotNull String libraryName) {
        return Companion.getModuleLibrary(moduleName, libraryName);
    }

    @JvmStatic
    @NotNull
    public static final VirtualFile getJarFromSingleJarProjectLibrary(@NotNull String projectLibraryName) {
        return Companion.getJarFromSingleJarProjectLibrary(projectLibraryName);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u001f\u0010\f\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\n0\n0\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u001f\u0010\u0010\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\n0\n0\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/project/IntelliJProjectConfiguration$LibraryRoots;", "", "classes", "", "Ljava/io/File;", "sources", "(Ljava/util/List;Ljava/util/List;)V", "getClasses", "()Ljava/util/List;", "classesPaths", "", "getClassesPaths", "classesUrls", "kotlin.jvm.PlatformType", "getClassesUrls", "getSources", "sourcesUrls", "getSourcesUrls", "intellij.platform.testFramework"})
    public static final class LibraryRoots {
        @NotNull
        private final List<File> classes;
        @NotNull
        private final List<File> sources;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> getClassesPaths() {
            void var3_3;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)this.classes;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                String string = FileUtil.toSystemIndependentName((String)it.getAbsolutePath());
                collection.add(string);
            }
            return (List)var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> getClassesUrls() {
            void var3_3;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)this.classes;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                String string = JpsPathUtil.getLibraryRootUrl((File)it);
                collection.add(string);
            }
            return (List)var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> getSourcesUrls() {
            void var3_3;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)this.sources;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                String string = JpsPathUtil.getLibraryRootUrl((File)it);
                collection.add(string);
            }
            return (List)var3_3;
        }

        @NotNull
        public final List<File> getClasses() {
            return this.classes;
        }

        @NotNull
        public final List<File> getSources() {
            return this.sources;
        }

        public LibraryRoots(@NotNull List<? extends File> classes, @NotNull List<? extends File> sources) {
            Intrinsics.checkParameterIsNotNull(classes, (String)"classes");
            Intrinsics.checkParameterIsNotNull(sources, (String)"sources");
            this.classes = classes;
            this.sources = sources;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0007J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\fH\u0007J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u00132\u0006\u0010\u0010\u001a\u00020\fH\u0007J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00132\u0006\u0010\u0010\u001a\u00020\fH\u0007R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/intellij/project/IntelliJProjectConfiguration$Companion;", "", "()V", "instance", "Lcom/intellij/project/IntelliJProjectConfiguration;", "getInstance", "()Lcom/intellij/project/IntelliJProjectConfiguration;", "instance$delegate", "Lkotlin/Lazy;", "getJarFromSingleJarProjectLibrary", "Lcom/intellij/openapi/vfs/VirtualFile;", "projectLibraryName", "", "getModuleLibrary", "Lcom/intellij/project/IntelliJProjectConfiguration$LibraryRoots;", "moduleName", "libraryName", "getProjectLibrary", "getProjectLibraryClassesRootPaths", "", "getProjectLibraryClassesRootUrls", "intellij.platform.testFramework"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "instance", "getInstance()Lcom/intellij/project/IntelliJProjectConfiguration;"))};
        }

        private final IntelliJProjectConfiguration getInstance() {
            Lazy lazy = instance$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[0];
            return (IntelliJProjectConfiguration)lazy.getValue();
        }

        @JvmStatic
        @NotNull
        public final List<String> getProjectLibraryClassesRootPaths(@NotNull String libraryName) {
            Intrinsics.checkParameterIsNotNull((Object)libraryName, (String)"libraryName");
            return this.getProjectLibrary(libraryName).getClassesPaths();
        }

        @JvmStatic
        @NotNull
        public final List<String> getProjectLibraryClassesRootUrls(@NotNull String libraryName) {
            Intrinsics.checkParameterIsNotNull((Object)libraryName, (String)"libraryName");
            return this.getProjectLibrary(libraryName).getClassesUrls();
        }

        @JvmStatic
        @NotNull
        public final LibraryRoots getProjectLibrary(@NotNull String libraryName) {
            Intrinsics.checkParameterIsNotNull((Object)libraryName, (String)"libraryName");
            LibraryRoots libraryRoots = (LibraryRoots)this.getInstance().projectLibraries.get(libraryName);
            if (libraryRoots == null) {
                throw (Throwable)new IllegalArgumentException("Cannot find project library '" + libraryName + "' in " + this.getInstance().projectHome);
            }
            return libraryRoots;
        }

        @JvmStatic
        @NotNull
        public final LibraryRoots getModuleLibrary(@NotNull String moduleName, @NotNull String libraryName) {
            Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
            Intrinsics.checkParameterIsNotNull((Object)libraryName, (String)"libraryName");
            Map map = (Map)this.getInstance().moduleLibraries.get(moduleName);
            if (map == null) {
                throw (Throwable)new IllegalArgumentException("Cannot find module '" + moduleName + "' in " + this.getInstance().projectHome);
            }
            Map moduleLibraries = map;
            LibraryRoots libraryRoots = (LibraryRoots)moduleLibraries.get(libraryName);
            if (libraryRoots == null) {
                throw (Throwable)new IllegalArgumentException("Cannot find module library '" + libraryName + "' in " + moduleName);
            }
            return libraryRoots;
        }

        @JvmStatic
        @NotNull
        public final VirtualFile getJarFromSingleJarProjectLibrary(@NotNull String projectLibraryName) {
            Intrinsics.checkParameterIsNotNull((Object)projectLibraryName, (String)"projectLibraryName");
            String jarUrl = (String)UsefulTestCase.assertOneElement((Collection)this.getProjectLibraryClassesRootUrls(projectLibraryName));
            VirtualFile jarRoot = VirtualFileManager.getInstance().refreshAndFindFileByUrl(jarUrl);
            Assert.assertNotNull((Object)jarRoot);
            VirtualFile virtualFile = jarRoot;
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            return virtualFile;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

