/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementContext;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacerUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.siyeh.ig.psiutils.ImportUtils;
import com.siyeh.ig.psiutils.PsiElementOrderComparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class JavaReplaceHandler
extends StructuralReplaceHandler {
    private final ReplacementContext myContext;
    private final PsiElement[] patternElements;

    public JavaReplaceHandler(ReplacementContext context) {
        this.myContext = context;
        this.patternElements = MatcherImplUtil.createTreeFromText(this.myContext.getOptions().getMatchOptions().getSearchPattern(), PatternTreeContext.Block, this.myContext.getOptions().getMatchOptions().getFileType(), this.myContext.getProject());
    }

    private static PsiElement findRealSubstitutionElement(PsiElement el) {
        if (el instanceof PsiIdentifier) {
            el = el.getParent();
        }
        if (el instanceof PsiReferenceExpression && el.getParent() instanceof PsiMethodCallExpression) {
            el = el.getParent();
        }
        if (el instanceof PsiDeclarationStatement && ((PsiDeclarationStatement)el).getDeclaredElements()[0] instanceof PsiClass) {
            el = ((PsiDeclarationStatement)el).getDeclaredElements()[0];
        }
        return el;
    }

    private static boolean isListContext(PsiElement el) {
        if (el instanceof PsiParameter) {
            return true;
        }
        PsiElement parent = el.getParent();
        return parent instanceof PsiExpressionList && !parent.getClass().getSimpleName().startsWith("Jsp") || parent instanceof PsiCodeBlock || parent instanceof PsiClass || parent instanceof PsiIfStatement && (((PsiIfStatement)parent).getThenBranch() == el || ((PsiIfStatement)parent).getElseBranch() == el) || parent instanceof PsiLoopStatement && ((PsiLoopStatement)parent).getBody() == el;
    }

    @Nullable
    private PsiNamedElement getSymbolReplacementTarget(PsiElement el) {
        PsiExpression expression;
        if (this.patternElements.length == 1 && this.patternElements[0] instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)this.patternElements[0]).getExpression()) instanceof PsiReferenceExpression && ((PsiReferenceExpression)expression).getQualifierExpression() == null && el instanceof PsiNamedElement) {
            return (PsiNamedElement)el;
        }
        return null;
    }

    private static PsiElement getMatchExpr(PsiElement replacement, PsiElement elementToReplace) {
        if (replacement instanceof PsiExpressionStatement && !(replacement.getLastChild() instanceof PsiJavaToken) && !(replacement.getLastChild() instanceof PsiComment)) {
            replacement = ((PsiExpressionStatement)replacement).getExpression();
        } else {
            if (replacement instanceof PsiDeclarationStatement && ((PsiDeclarationStatement)replacement).getDeclaredElements().length == 1 && (elementToReplace instanceof PsiVariable || elementToReplace instanceof PsiClass)) {
                return ((PsiDeclarationStatement)replacement).getDeclaredElements()[0];
            }
            if (replacement instanceof PsiBlockStatement && elementToReplace instanceof PsiCodeBlock) {
                return ((PsiBlockStatement)replacement).getCodeBlock();
            }
        }
        return replacement;
    }

    private boolean isSymbolReplacement(PsiElement el) {
        return this.getSymbolReplacementTarget(el) != null;
    }

    private void copyUnmatchedElements(PsiElement original, PsiElement replacement, ReplacementInfo info) {
        Map<String, PsiNamedElement> originalNamedElements = Collector.collectNamedElements(original);
        Map<String, PsiNamedElement> replacedNamedElements = Collector.collectNamedElements(replacement);
        if (originalNamedElements.size() == 0 && replacedNamedElements.size() == 0) {
            Replacer.handleComments(original, replacement, info);
            return;
        }
        Map<String, PsiNamedElement> patternNamedElements = Collector.collectNamedElements(this.patternElements);
        for (String name2 : originalNamedElements.keySet()) {
            PsiNamedElement originalNamedElement = originalNamedElements.get(name2);
            PsiNamedElement replacementNamedElement = replacedNamedElements.get(name2);
            String key = (String)ObjectUtils.notNull((Object)info.getSearchPatternName(name2), (Object)name2);
            PsiNamedElement patternNamedElement = patternNamedElements.get(key);
            if (replacementNamedElement == null && originalNamedElements.size() == 1 && replacedNamedElements.size() == 1) {
                replacementNamedElement = replacedNamedElements.entrySet().iterator().next().getValue();
            }
            PsiDocComment comment = null;
            if (originalNamedElement instanceof PsiDocCommentOwner && (comment = ((PsiDocCommentOwner)originalNamedElement).getDocComment()) == null) {
                PsiElement prevElement = originalNamedElement.getPrevSibling();
                if (prevElement instanceof PsiWhiteSpace) {
                    prevElement = prevElement.getPrevSibling();
                }
                if (prevElement instanceof PsiComment) {
                    comment = prevElement;
                }
            }
            if (replacementNamedElement != null && patternNamedElement != null) {
                Replacer.handleComments((PsiElement)originalNamedElement, (PsiElement)replacementNamedElement, info);
            }
            if (comment != null && replacementNamedElement instanceof PsiDocCommentOwner && !(replacementNamedElement.getFirstChild() instanceof PsiDocComment)) {
                PsiElement nextSibling = comment.getNextSibling();
                PsiElement prevSibling = comment.getPrevSibling();
                replacementNamedElement.addRangeBefore((PsiElement)(prevSibling instanceof PsiWhiteSpace ? prevSibling : comment), (PsiElement)(nextSibling instanceof PsiWhiteSpace ? nextSibling : comment), replacementNamedElement.getFirstChild());
            }
            if (originalNamedElement instanceof PsiModifierListOwner && patternNamedElement instanceof PsiModifierListOwner && replacementNamedElement instanceof PsiModifierListOwner) {
                JavaReplaceHandler.copyModifiersAndAnnotations((PsiModifierListOwner)originalNamedElement, (PsiModifierListOwner)patternNamedElement, (PsiModifierListOwner)replacementNamedElement);
            }
            if (originalNamedElement instanceof PsiMethod && patternNamedElement instanceof PsiMethod && replacementNamedElement instanceof PsiMethod) {
                JavaReplaceHandler.copyMethodBodyIfNotReplaced((PsiMethod)originalNamedElement, (PsiMethod)patternNamedElement, (PsiMethod)replacementNamedElement);
            }
            if (originalNamedElement instanceof PsiVariable && patternNamedElement instanceof PsiVariable && replacementNamedElement instanceof PsiVariable) {
                PsiVariable originalVariable = (PsiVariable)originalNamedElement;
                PsiVariable queryVariable = (PsiVariable)patternNamedElement;
                PsiVariable replacementVariable = (PsiVariable)replacementNamedElement;
                if (originalVariable.hasInitializer() && !queryVariable.hasInitializer() && !replacementVariable.hasInitializer()) {
                    replacementVariable.setInitializer(originalVariable.getInitializer());
                }
            }
            if (!(originalNamedElement instanceof PsiClass) || !(patternNamedElement instanceof PsiClass) || !(replacementNamedElement instanceof PsiClass)) continue;
            PsiClass originalClass = (PsiClass)originalNamedElement;
            PsiClass queryClass = (PsiClass)patternNamedElement;
            PsiClass replacementClass = (PsiClass)replacementNamedElement;
            JavaReplaceHandler.copyExtendsListIfNotReplaced(originalClass, queryClass, replacementClass);
            JavaReplaceHandler.copyImplementsListIfNotReplaced(originalClass, queryClass, replacementClass);
            JavaReplaceHandler.copyTypeParameterListIfNotReplaced(originalClass, queryClass, replacementClass);
            JavaReplaceHandler.copyUnmatchedMembers(originalClass, originalNamedElements, replacementClass);
        }
    }

    private static void copyUnmatchedMembers(PsiClass originalClass, Map<String, PsiNamedElement> originalNamedElements, PsiClass replacementClass) {
        List elements = (List)originalClass.getUserData(GlobalMatchingVisitor.UNMATCHED_ELEMENTS_KEY);
        if (elements == null) {
            return;
        }
        List anchors = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)replacementClass, PsiNamedElement.class);
        block0: for (PsiNamedElement anchor : anchors) {
            String replacedMemberName = anchor.getName();
            PsiNamedElement originalMember = originalNamedElements.get(replacedMemberName);
            if (originalMember == null) continue;
            Iterator iterator = elements.iterator();
            while (iterator.hasNext()) {
                PsiElement element = (PsiElement)iterator.next();
                if (PsiElementOrderComparator.getInstance().compare(element, (PsiElement)originalMember) >= 0) continue block0;
                JavaReplaceHandler.addElementAndWhitespaceBeforeAnchor(replacementClass, element, (PsiElement)anchor);
                iterator.remove();
            }
        }
        PsiElement anchor = replacementClass.getRBrace();
        if (anchor == null) {
            return;
        }
        for (PsiElement element : elements) {
            JavaReplaceHandler.addElementAndWhitespaceBeforeAnchor(replacementClass, element, anchor);
        }
    }

    private static void addElementAndWhitespaceBeforeAnchor(PsiClass replacementClass, PsiElement element, PsiElement anchor) {
        PsiElement prevSibling;
        PsiElement replacementSibling = anchor.getPrevSibling();
        if (replacementSibling instanceof PsiWhiteSpace) {
            replacementSibling.delete();
        }
        if ((prevSibling = element.getPrevSibling()) instanceof PsiWhiteSpace || PsiUtil.isJavaToken((PsiElement)prevSibling, (IElementType)JavaTokenType.COMMA)) {
            PsiElement prevPrevSibling = prevSibling.getPrevSibling();
            if (PsiUtil.isJavaToken((PsiElement)prevPrevSibling, (IElementType)JavaTokenType.COMMA)) {
                replacementClass.addBefore(prevPrevSibling, anchor);
            }
            replacementClass.addBefore(prevSibling, anchor);
        }
        replacementClass.addBefore(element, anchor);
        PsiElement nextSibling = element.getNextSibling();
        if (nextSibling instanceof PsiWhiteSpace) {
            replacementClass.addBefore(nextSibling, anchor);
        }
    }

    private static void copyMethodBodyIfNotReplaced(PsiMethod original, PsiMethod query, PsiMethod replacement) {
        PsiCodeBlock originalBody = original.getBody();
        if (originalBody != null && query.getBody() == null && replacement.getBody() == null) {
            PsiElement sibling = originalBody.getPrevSibling();
            if (sibling instanceof PsiWhiteSpace) {
                replacement.add(sibling);
            }
            replacement.add((PsiElement)originalBody);
        }
    }

    private static void copyModifiersAndAnnotations(PsiModifierListOwner original, PsiModifierListOwner query, PsiModifierListOwner replacement) {
        PsiModifierList originalModifierList = original.getModifierList();
        PsiModifierList queryModifierList = query.getModifierList();
        PsiModifierList replacementModifierList = replacement.getModifierList();
        if (originalModifierList == null || queryModifierList == null || replacementModifierList == null) {
            return;
        }
        if (originalModifierList.getTextLength() != 0) {
            PsiModifierList copy = (PsiModifierList)originalModifierList.copy();
            for (String string : PsiModifier.MODIFIERS) {
                if (replacementModifierList.hasExplicitModifier(string)) {
                    copy.setModifierProperty(string, true);
                    continue;
                }
                if (!queryModifierList.hasExplicitModifier(string) || replacementModifierList.hasModifierProperty(string)) continue;
                copy.setModifierProperty(string, false);
            }
            for (String string : copy.getAnnotations()) {
                for (PsiAnnotation queryAnnotation : query.getAnnotations()) {
                    if (!JavaReplaceHandler.matches(queryAnnotation, (PsiAnnotation)string)) continue;
                    string.delete();
                }
            }
            for (String string : replacementModifierList.getAnnotations()) {
                copy.addBefore((PsiElement)string, copy.getFirstChild());
            }
            replacementModifierList.replace((PsiElement)copy);
        }
    }

    private static boolean matches(PsiAnnotation queryAnnotation, PsiAnnotation originalAnnotation) {
        PsiJavaCodeReferenceElement queryReferenceElement = queryAnnotation.getNameReferenceElement();
        if (queryReferenceElement == null) {
            return false;
        }
        PsiJavaCodeReferenceElement originalReferenceElement = originalAnnotation.getNameReferenceElement();
        if (originalReferenceElement == null) {
            return false;
        }
        String queryQualifiedName = queryReferenceElement.getQualifiedName();
        return queryQualifiedName.equals(originalReferenceElement.getQualifiedName()) || queryQualifiedName.equals(originalReferenceElement.getReferenceName());
    }

    private PsiElement handleSymbolReplacement(PsiElement replacement, PsiElement el) {
        PsiNamedElement nameElement = this.getSymbolReplacementTarget(el);
        if (nameElement != null) {
            PsiElement oldReplacement = replacement;
            replacement = el.copy();
            ((PsiNamedElement)replacement).setName(oldReplacement.getText());
        }
        return replacement;
    }

    @Override
    public void replace(ReplacementInfo info, ReplaceOptions options) {
        PsiElement replacement;
        PsiElement elementToReplace = info.getMatch(0);
        if (elementToReplace == null) {
            return;
        }
        elementToReplace = JavaReplaceHandler.findRealSubstitutionElement(elementToReplace);
        PsiElement elementParent = elementToReplace.getParent();
        String replacementToMake = info.getReplacement();
        boolean listContext = JavaReplaceHandler.isListContext(elementToReplace);
        if (elementToReplace instanceof PsiAnnotation && !replacementToMake.isEmpty() && !StringUtil.startsWithChar((CharSequence)replacementToMake, (char)'@')) {
            replacementToMake = "@" + replacementToMake;
        }
        PsiElement[] replacements = ReplacerUtil.createTreeForReplacement(replacementToMake, elementToReplace instanceof PsiMember && !this.isSymbolReplacement(elementToReplace) ? PatternTreeContext.Class : PatternTreeContext.Block, this.myContext);
        if (elementToReplace instanceof PsiAnnotation && replacements.length == 1) {
            PsiDeclarationStatement declarationStatement;
            PsiElement firstChild;
            PsiElement replacement2 = replacements[0];
            if (replacement2 instanceof PsiDeclarationStatement && (firstChild = (declarationStatement = (PsiDeclarationStatement)replacement2).getFirstChild()) instanceof PsiModifierList) {
                PsiModifierList modifierList = (PsiModifierList)firstChild;
                for (PsiElement child : modifierList.getChildren()) {
                    elementParent.addBefore(child, elementToReplace);
                }
            }
            elementToReplace.delete();
            return;
        }
        if (listContext) {
            if (replacements.length > 1) {
                replacement = elementParent.addRangeBefore(replacements[0], replacements[replacements.length - 1], elementToReplace);
                this.copyUnmatchedElements(elementToReplace, replacement, info);
            } else if (replacements.length == 1) {
                replacement = JavaReplaceHandler.getMatchExpr(replacements[0], elementToReplace);
                if (elementToReplace instanceof PsiParameter && replacement instanceof PsiLocalVariable) {
                    PsiVariable variable = (PsiVariable)replacement;
                    PsiIdentifier identifier = variable.getNameIdentifier();
                    assert (identifier != null);
                    String text = variable.getText();
                    String parameterText = text.substring(0, identifier.getStartOffsetInParent() + identifier.getTextLength());
                    replacement = JavaPsiFacade.getElementFactory((Project)variable.getProject()).createParameterFromText(parameterText, (PsiElement)variable);
                }
                this.copyUnmatchedElements(elementToReplace, replacement, info);
                replacement = this.handleSymbolReplacement(replacement, elementToReplace);
                if (replacement instanceof PsiTryStatement) {
                    PsiTryStatement tryStatement = (PsiTryStatement)replacement;
                    List unmatchedElements = (List)elementToReplace.getUserData(GlobalMatchingVisitor.UNMATCHED_ELEMENTS_KEY);
                    if (unmatchedElements != null) {
                        PsiCatchSection[] catches;
                        PsiElement firstElement = (PsiElement)unmatchedElements.get(0);
                        if (firstElement instanceof PsiResourceList) {
                            JavaReplaceHandler.addElementAfterAnchor((PsiElement)tryStatement, firstElement, tryStatement.getFirstChild());
                        }
                        PsiCodeBlock anchor = (catches = tryStatement.getCatchSections()).length == 0 ? tryStatement.getTryBlock() : catches[catches.length - 1];
                        for (int i = unmatchedElements.size() - 1; i >= 0; --i) {
                            PsiElement element = (PsiElement)unmatchedElements.get(i);
                            if (!(element instanceof PsiCatchSection)) continue;
                            JavaReplaceHandler.addElementAfterAnchor((PsiElement)tryStatement, element, (PsiElement)anchor);
                        }
                        PsiElement lastElement = (PsiElement)unmatchedElements.get(unmatchedElements.size() - 1);
                        if (lastElement instanceof PsiCodeBlock) {
                            PsiElement finallyKeyword = PsiTreeUtil.skipWhitespacesBackward((PsiElement)lastElement);
                            assert (finallyKeyword != null);
                            PsiElement finallyAnchor = tryStatement.getLastChild();
                            JavaReplaceHandler.addElementAfterAnchor((PsiElement)tryStatement, lastElement, finallyAnchor);
                            JavaReplaceHandler.addElementAfterAnchor((PsiElement)tryStatement, finallyKeyword, finallyAnchor);
                        }
                    }
                }
                try {
                    PsiElement inserted = elementParent.addBefore(replacement, elementToReplace);
                    if (replacement instanceof PsiComment && (elementParent instanceof PsiIfStatement || elementParent instanceof PsiLoopStatement)) {
                        elementParent.addAfter(JavaReplaceHandler.createSemicolon(replacement), inserted);
                    }
                }
                catch (IncorrectOperationException e) {
                    elementToReplace.replace(replacement);
                }
            }
        } else if (replacements.length > 0) {
            replacement = ReplacerUtil.copySpacesAndCommentsBefore(elementToReplace, replacements, replacementToMake, elementParent);
            if ((replacement = JavaReplaceHandler.getMatchExpr(replacement, elementToReplace)) instanceof PsiStatement && !(replacement.getLastChild() instanceof PsiJavaToken) && !(replacement.getLastChild() instanceof PsiComment)) {
                PsiElement prevLastChildInParent = replacement.getLastChild().getPrevSibling();
                if (prevLastChildInParent != null) {
                    elementParent.addRangeBefore(replacement.getFirstChild(), prevLastChildInParent, elementToReplace);
                } else {
                    elementParent.addBefore(replacement.getFirstChild(), elementToReplace);
                }
                elementToReplace.getNode().getTreeParent().removeChild(elementToReplace.getNode());
            } else {
                this.copyUnmatchedElements(elementToReplace, replacement, info);
                replacement = this.handleSymbolReplacement(replacement, elementToReplace);
                elementToReplace.replace(replacement);
            }
        } else {
            PsiElement nextSibling = elementToReplace.getNextSibling();
            elementToReplace.delete();
            if (nextSibling instanceof PsiWhiteSpace && nextSibling.isValid()) {
                nextSibling.delete();
            }
        }
        if (listContext) {
            int matchSize = info.getMatchesCount();
            for (int i = 0; i < matchSize; ++i) {
                PsiElement matchElement = info.getMatch(i);
                PsiElement element = JavaReplaceHandler.findRealSubstitutionElement(matchElement);
                if (element == null) continue;
                PsiElement firstToDelete = element;
                PsiElement lastToDelete = element;
                PsiElement prevSibling = element.getPrevSibling();
                PsiElement nextSibling = element.getNextSibling();
                if (prevSibling instanceof PsiWhiteSpace) {
                    firstToDelete = prevSibling;
                    prevSibling = prevSibling.getPrevSibling();
                } else if (prevSibling == null && nextSibling instanceof PsiWhiteSpace) {
                    lastToDelete = nextSibling;
                }
                if (element instanceof PsiExpression) {
                    PsiElement parent = element.getParent().getParent();
                    if ((parent instanceof PsiCall || parent instanceof PsiAnonymousClass) && PsiUtil.isJavaToken((PsiElement)prevSibling, (IElementType)JavaTokenType.COMMA)) {
                        firstToDelete = prevSibling;
                    }
                } else if (element instanceof PsiParameter && PsiUtil.isJavaToken((PsiElement)prevSibling, (IElementType)JavaTokenType.COMMA)) {
                    firstToDelete = prevSibling;
                } else if (element instanceof PsiField) {
                    while (PsiUtil.isJavaToken((PsiElement)nextSibling, (IElementType)JavaTokenType.COMMA)) {
                        lastToDelete = PsiTreeUtil.skipWhitespacesForward((PsiElement)nextSibling);
                        nextSibling = PsiTreeUtil.skipWhitespacesForward((PsiElement)lastToDelete);
                    }
                }
                element.getParent().deleteChildRange(firstToDelete, lastToDelete);
            }
        }
    }

    private static void copyTypeParameterListIfNotReplaced(PsiClass original, PsiClass query, PsiClass replacement) {
        PsiTypeParameterList originalTypeParameterList = original.getTypeParameterList();
        PsiTypeParameterList queryTypeParameterList = query.getTypeParameterList();
        PsiTypeParameterList replacementTypeParameterList = replacement.getTypeParameterList();
        if (originalTypeParameterList == null || queryTypeParameterList == null || replacementTypeParameterList == null) {
            return;
        }
        if (originalTypeParameterList.getTypeParameters().length != 0 && queryTypeParameterList.getTypeParameters().length == 0 && replacementTypeParameterList.getTypeParameters().length == 0) {
            replacementTypeParameterList.replace((PsiElement)originalTypeParameterList);
        }
    }

    private static void copyImplementsListIfNotReplaced(PsiClass original, PsiClass query, PsiClass replacement) {
        JavaReplaceHandler.copyReferenceListIfNotReplaced(original.getImplementsList(), query.getImplementsList(), replacement.getImplementsList());
    }

    private static void copyExtendsListIfNotReplaced(PsiClass original, PsiClass query, PsiClass replacement) {
        JavaReplaceHandler.copyReferenceListIfNotReplaced(original.getExtendsList(), query.getExtendsList(), replacement.getExtendsList());
    }

    private static void copyReferenceListIfNotReplaced(PsiReferenceList originalReferenceList, PsiReferenceList queryReferenceList, PsiReferenceList replacementReferenceList) {
        if (originalReferenceList == null || queryReferenceList == null || replacementReferenceList == null) {
            return;
        }
        if (originalReferenceList.getReferenceElements().length != 0 && queryReferenceList.getReferenceElements().length == 0 && replacementReferenceList.getReferenceElements().length == 0) {
            replacementReferenceList.replace((PsiElement)originalReferenceList);
        }
    }

    private static void addElementAfterAnchor(PsiElement parentElement, PsiElement element, PsiElement anchor) {
        parentElement.addAfter(element, anchor);
        PsiElement sibling = element.getPrevSibling();
        if (sibling instanceof PsiWhiteSpace) {
            parentElement.addAfter(sibling, anchor);
        }
    }

    @Override
    public void postProcess(PsiElement affectedElement, ReplaceOptions options) {
        if (!affectedElement.isValid()) {
            return;
        }
        if (options.isToUseStaticImport()) {
            JavaReplaceHandler.shortenWithStaticImports(affectedElement, 0, affectedElement.getTextLength());
        }
        if (options.isToShortenFQN()) {
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)affectedElement.getProject());
            codeStyleManager.shortenClassReferences(affectedElement, 0, affectedElement.getTextLength());
        }
    }

    private static void shortenWithStaticImports(PsiElement affectedElement, int startOffset, int endOffset) {
        int elementOffset = affectedElement.getTextOffset();
        final int finalStartOffset = startOffset + elementOffset;
        final int finalEndOffset = endOffset + elementOffset;
        SmartList references = new SmartList();
        JavaRecursiveElementVisitor collector = new JavaRecursiveElementVisitor((List)references){
            final /* synthetic */ List val$references;
            {
                this.val$references = list;
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                int offset = reference.getTextOffset();
                if (offset > finalEndOffset) {
                    return;
                }
                super.visitReferenceElement(reference);
                if (offset + reference.getTextLength() < finalStartOffset) {
                    return;
                }
                if (reference.getTypeParameters().length != 0) {
                    return;
                }
                PsiElement target = reference.resolve();
                if (!(target instanceof PsiMember)) {
                    return;
                }
                PsiMember member = (PsiMember)target;
                if (!member.hasModifierProperty("static")) {
                    return;
                }
                if (reference.getQualifier() == null) {
                    return;
                }
                this.val$references.add(reference);
            }
        };
        affectedElement.accept((PsiElementVisitor)collector);
        for (PsiJavaCodeReferenceElement expression : references) {
            PsiElement qualifier;
            String name2;
            String className;
            PsiMember member;
            PsiClass containingClass;
            PsiElement target = expression.resolve();
            if (!(target instanceof PsiMember) || (containingClass = (member = (PsiMember)target).getContainingClass()) == null || (className = containingClass.getQualifiedName()) == null || (name2 = member.getName()) == null || !ImportUtils.addStaticImport((String)className, (String)name2, (PsiElement)expression) || (qualifier = expression.getQualifier()) == null) continue;
            qualifier.delete();
        }
    }

    @Nullable
    private static PsiElement createSemicolon(PsiElement space) {
        PsiStatement text = JavaPsiFacade.getInstance((Project)space.getProject()).getElementFactory().createStatementFromText(";", null);
        return text.getFirstChild();
    }

    private static class Collector
    extends JavaRecursiveElementWalkingVisitor {
        private final HashMap<String, PsiNamedElement> namedElements = new HashMap(1);

        private Collector() {
        }

        public static Map<String, PsiNamedElement> collectNamedElements(PsiElement ... elements) {
            Collector collector = new Collector();
            for (PsiElement element : elements) {
                element.accept((PsiElementVisitor)collector);
            }
            return collector.namedElements;
        }

        public void visitClass(PsiClass aClass) {
            if (aClass instanceof PsiAnonymousClass) {
                return;
            }
            this.handleNamedElement((PsiNamedElement)aClass);
        }

        private void handleNamedElement(PsiNamedElement named) {
            String name2 = named.getName();
            assert (name2 != null);
            if (StructuralSearchUtil.isTypedVariable(name2)) {
                name2 = name2.substring(1, name2.length() - 1);
            }
            if (!this.namedElements.containsKey(name2)) {
                this.namedElements.put(name2, named);
            }
            named.acceptChildren((PsiElementVisitor)this);
        }

        public void visitVariable(PsiVariable var) {
            this.handleNamedElement((PsiNamedElement)var);
        }

        public void visitMethod(PsiMethod method) {
            this.handleNamedElement((PsiNamedElement)method);
        }
    }
}

