/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.dupLocator.iterators.ArrayBackedNodeIterator;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SimpleHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompiledPattern {
    private SearchScope scope;
    private NodeIterator nodes;
    private MatchingStrategy strategy;
    private PsiElement targetNode;
    private int optionsHashStamp;
    private int nodeCount;
    public static final Key<Object> HANDLER_KEY = Key.create((String)"ss.handler");
    private final HashMap<Object, MatchingHandler> handlers = new HashMap();
    private PsiElement last;
    private MatchingHandler lastHandler;

    public abstract String[] getTypedVarPrefixes();

    public abstract boolean isTypedVar(String var1);

    public void setTargetNode(PsiElement element) {
        this.targetNode = element;
    }

    public PsiElement getTargetNode() {
        return this.targetNode;
    }

    public int getOptionsHashStamp() {
        return this.optionsHashStamp;
    }

    public void setOptionsHashStamp(int optionsHashStamp) {
        this.optionsHashStamp = optionsHashStamp;
    }

    public MatchingStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(MatchingStrategy strategy) {
        this.strategy = strategy;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public NodeIterator getNodes() {
        return this.nodes;
    }

    public void setNodes(List<PsiElement> elements) {
        this.nodes = new ArrayBackedNodeIterator(PsiUtilCore.toPsiElementArray(elements));
        this.nodeCount = elements.size();
    }

    public boolean isTypedVar(PsiElement element) {
        return element != null && this.isTypedVar(element.getText());
    }

    public boolean isRealTypedVar(PsiElement element) {
        if (element == null || element.getTextLength() <= 0) {
            return false;
        }
        String str = this.getTypedVarString(element);
        return !str.isEmpty() && this.isTypedVar(str);
    }

    @NotNull
    public String getTypedVarString(PsiElement element) {
        StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByPsiElement(element);
        if (profile2 == null) {
            String string = element.getText();
            if (string == null) {
                CompiledPattern.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = profile2.getTypedVarString(element);
        if (string == null) {
            CompiledPattern.$$$reportNull$$$0(1);
        }
        return string;
    }

    public MatchingHandler getHandlerSimple(PsiElement node) {
        return this.handlers.get(node);
    }

    public MatchingHandler getHandler(PsiElement node) {
        if (node == this.last) {
            return this.lastHandler;
        }
        MatchingHandler handler = this.handlers.get(node);
        if (handler == null) {
            handler = new SimpleHandler();
            this.setHandler(node, handler);
        }
        this.last = node;
        this.lastHandler = handler;
        return handler;
    }

    public MatchingHandler getHandler(String name2) {
        return this.handlers.get(name2);
    }

    public void setHandler(PsiElement node, MatchingHandler handler) {
        this.last = null;
        this.handlers.put(node, handler);
    }

    public SubstitutionHandler createSubstitutionHandler(String name2, String compiledName, boolean target, int minOccurs, int maxOccurs, boolean greedy) {
        SubstitutionHandler handler = (SubstitutionHandler)this.handlers.get(compiledName);
        if (handler != null) {
            return handler;
        }
        handler = this.doCreateSubstitutionHandler(name2, target, minOccurs, maxOccurs, greedy);
        this.handlers.put(compiledName, handler);
        return handler;
    }

    protected SubstitutionHandler doCreateSubstitutionHandler(String name2, boolean target, int minOccurs, int maxOccurs, boolean greedy) {
        return new SubstitutionHandler(name2, target, minOccurs, maxOccurs, greedy);
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public void setScope(SearchScope scope) {
        this.scope = scope;
    }

    public void clearHandlers() {
        this.handlers.clear();
        this.last = null;
        this.lastHandler = null;
    }

    void clearHandlersState() {
        for (MatchingHandler h : this.handlers.values()) {
            if (h == null) continue;
            h.reset();
        }
    }

    public boolean isToResetHandler(PsiElement element) {
        return true;
    }

    @Nullable
    public String getAlternativeTextToMatch(PsiElement node, String previousText) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/impl/matcher/CompiledPattern", "getTypedVarString"));
    }
}

