/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.replace.ui;

import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.util.ObjectUtils;
import org.jdom.Element;

public class ReplaceConfiguration
extends Configuration {
    private final ReplaceOptions myReplaceOptions;
    public static final String REPLACEMENT_VARIABLE_SUFFIX = "$replacement";

    public ReplaceConfiguration() {
        this.myReplaceOptions = new ReplaceOptions();
    }

    ReplaceConfiguration(Configuration configuration) {
        super(configuration);
        if (configuration instanceof ReplaceConfiguration) {
            this.myReplaceOptions = ((ReplaceConfiguration)configuration).myReplaceOptions.copy();
        } else {
            MatchOptions matchOptions = configuration.getMatchOptions();
            this.myReplaceOptions = new ReplaceOptions(matchOptions);
            this.myReplaceOptions.setReplacement(matchOptions.getSearchPattern());
        }
    }

    public ReplaceConfiguration(String name2, String category) {
        super(name2, category);
        this.myReplaceOptions = new ReplaceOptions();
    }

    @Override
    public ReplaceConfiguration copy() {
        return new ReplaceConfiguration(this);
    }

    public ReplaceOptions getReplaceOptions() {
        return this.myReplaceOptions;
    }

    @Override
    public MatchOptions getMatchOptions() {
        return this.myReplaceOptions.getMatchOptions();
    }

    @Override
    public NamedScriptableDefinition findVariable(String name2) {
        return (NamedScriptableDefinition)ObjectUtils.chooseNotNull((Object)this.myReplaceOptions.getVariableDefinition(name2), (Object)this.getMatchOptions().getVariableConstraint(name2));
    }

    @Override
    public void readExternal(Element element) {
        super.readExternal(element);
        this.myReplaceOptions.readExternal(element);
    }

    @Override
    public void writeExternal(Element element) {
        super.writeExternal(element);
        this.myReplaceOptions.writeExternal(element);
    }

    @Override
    public boolean equals(Object configuration) {
        if (this == configuration) {
            return true;
        }
        if (!(configuration instanceof ReplaceConfiguration)) {
            return false;
        }
        if (!super.equals(configuration)) {
            return false;
        }
        return this.myReplaceOptions.equals(((ReplaceConfiguration)configuration).myReplaceOptions);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.myReplaceOptions.hashCode();
    }
}

