/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.find.FindManager;
import com.intellij.find.FindProgressIndicator;
import com.intellij.find.FindSettings;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchResultSink;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.MatchingProcess;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchException;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.MatchResultImpl;
import com.intellij.structuralsearch.plugin.StructuralSearchPlugin;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.UsageViewContext;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class SearchCommand {
    protected final SearchContext mySearchContext;
    protected final Configuration myConfiguration;
    private MatchingProcess process;

    public SearchCommand(Configuration configuration, SearchContext searchContext) {
        this.myConfiguration = configuration;
        this.mySearchContext = searchContext;
    }

    protected UsageViewContext createUsageViewContext() {
        Runnable searchStarter = () -> new SearchCommand(this.myConfiguration, this.mySearchContext).startSearching();
        return new UsageViewContext(this.myConfiguration, this.mySearchContext, searchStarter);
    }

    public void startSearching() {
        final UsageViewContext context = this.createUsageViewContext();
        final UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setOpenInNewTab(FindSettings.getInstance().isShowResultsInSeparateView());
        context.configure(presentation);
        FindUsagesProcessPresentation processPresentation = new FindUsagesProcessPresentation(presentation);
        processPresentation.setShowNotFoundMessage(true);
        processPresentation.setShowPanelIfOnlyOneUsage(true);
        processPresentation.setProgressIndicatorFactory((Factory)new Factory<ProgressIndicator>(){

            public ProgressIndicator create() {
                FindProgressIndicator indicator = new FindProgressIndicator(SearchCommand.this.mySearchContext.getProject(), presentation.getScopeText());
                indicator.addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

                    public void cancel() {
                        super.cancel();
                        SearchCommand.this.stopAsyncSearch();
                    }
                });
                return indicator;
            }
        });
        PsiDocumentManager.getInstance((Project)this.mySearchContext.getProject()).commitAllDocuments();
        ConfigurableUsageTarget target = context.getTarget();
        ((FindManagerImpl)FindManager.getInstance((Project)this.mySearchContext.getProject())).getFindUsagesManager().addToHistory(target);
        UsageViewManager.getInstance((Project)this.mySearchContext.getProject()).searchAndShowUsages(new UsageTarget[]{target}, () -> new UsageSearcher(){

            public void generate(@NotNull Processor<Usage> processor) {
                if (processor == null) {
                    3.$$$reportNull$$$0(0);
                }
                SearchCommand.this.findUsages(processor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/structuralsearch/plugin/ui/SearchCommand$3", "generate"));
            }
        }, processPresentation, presentation, new UsageViewManager.UsageViewStateListener(){

            public void usageViewCreated(@NotNull UsageView usageView) {
                if (usageView == null) {
                    2.$$$reportNull$$$0(0);
                }
                context.setUsageView(usageView);
                context.configureActions();
            }

            public void findingUsagesFinished(UsageView usageView) {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/structuralsearch/plugin/ui/SearchCommand$2", "usageViewCreated"));
            }
        });
    }

    public void findUsages(final Processor<Usage> processor) {
        final ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        progress.setIndeterminate(false);
        MatchResultSink sink = new MatchResultSink(){
            int count;

            @Override
            public void setMatchingProcess(MatchingProcess _process) {
                SearchCommand.this.process = _process;
                SearchCommand.this.findStarted();
            }

            @Override
            public void processFile(PsiFile element) {
                VirtualFile virtualFile = element.getVirtualFile();
                if (virtualFile != null) {
                    progress.setText(SSRBundle.message("looking.in.progress.message", virtualFile.getPresentableName()));
                }
            }

            @Override
            public void matchingFinished() {
                if (SearchCommand.this.mySearchContext.getProject().isDisposed()) {
                    return;
                }
                SearchCommand.this.findEnded();
                progress.setText(SSRBundle.message("found.progress.message", this.count));
            }

            @Override
            public ProgressIndicator getProgressIndicator() {
                return progress;
            }

            @Override
            public void newMatch(MatchResult result) {
                UsageInfo info;
                if ("__multi_line__".equals(result.getName())) {
                    int start = -1;
                    int end = -1;
                    PsiElement parent = result.getMatch().getParent();
                    for (MatchResult matchResult : ((MatchResultImpl)result).getMatches()) {
                        int newend;
                        PsiElement el = matchResult.getMatch();
                        int elementStart = el.getTextRange().getStartOffset();
                        if (start == -1 || start > elementStart) {
                            start = elementStart;
                        }
                        if ((newend = elementStart + el.getTextLength()) <= end) continue;
                        end = newend;
                    }
                    int parentStart = parent.getTextRange().getStartOffset();
                    int startOffset = start - parentStart;
                    info = new UsageInfo(parent, startOffset, end - parentStart);
                } else {
                    PsiElement match = StructuralSearchUtil.getPresentableElement(result.getMatch());
                    if (!match.isPhysical()) {
                        return;
                    }
                    info = new UsageInfo(match);
                }
                UsageInfo2UsageAdapter usage = new UsageInfo2UsageAdapter(info);
                processor.process((Object)usage);
                SearchCommand.this.foundUsage(result, (Usage)usage);
                ++this.count;
            }
        };
        try {
            new Matcher(this.mySearchContext.getProject()).findMatches(sink, this.myConfiguration.getMatchOptions());
        }
        catch (StructuralSearchException e) {
            Alarm alarm = new Alarm();
            alarm.addRequest(() -> NotificationGroup.toolWindowGroup((String)"Structural Search", (String)ToolWindowId.FIND).createNotification(SSRBundle.message("problem", e.getMessage()), MessageType.ERROR).notify(this.mySearchContext.getProject()), 100, ModalityState.NON_MODAL);
        }
    }

    public void stopAsyncSearch() {
        if (this.process != null) {
            this.process.stop();
        }
    }

    protected void findStarted() {
        StructuralSearchPlugin.getInstance(this.mySearchContext.getProject()).setSearchInProgress(true);
    }

    protected void findEnded() {
        StructuralSearchPlugin.getInstance(this.mySearchContext.getProject()).setSearchInProgress(false);
    }

    protected void foundUsage(MatchResult result, Usage usage) {
    }
}

