/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.ArrayUtil;
import java.lang.management.ManagementFactory;
import java.math.BigInteger;
import java.util.stream.LongStream;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class CpuTimings {
    final long[] rawData;
    final long average;
    final double stdDev;
    final int attempt;

    private CpuTimings(long[] rawData, int attempt) {
        this.rawData = rawData;
        this.attempt = attempt;
        this.average = ArrayUtil.averageAmongMedians((long[])rawData, (int)2);
        this.stdDev = CpuTimings.standardDeviation(rawData);
    }

    private static double standardDeviation(long[] elapsed) {
        double average = LongStream.of(elapsed).mapToDouble(value -> value).average().getAsDouble();
        double variance = 0.0;
        for (long l : elapsed) {
            variance += Math.pow(average - (double)l, 2.0);
        }
        return Math.sqrt(variance / average);
    }

    public String toString() {
        return this.average + ", sd=" + this.stdDev + ", attempt=" + this.attempt;
    }

    static CpuTimings calcStableCpuTiming() {
        int maxIterations = UsefulTestCase.IS_UNDER_TEAMCITY ? 100 : 10;
        int i = 0;
        while (true) {
            CpuTimings timings = CpuTimings.calcCpuTiming(20, CpuTimings::addBigIntegers, i);
            if (timings.stdDev < 1.8) {
                return timings;
            }
            if (i == maxIterations) {
                System.out.printf("CPU Timings: %d, sd=%.2f; not stable enough, giving up%n", timings.average, timings.stdDev);
                return timings;
            }
            if (i > 3) {
                System.out.printf("CPU Timings: %d, sd=%.2f; unstable (getProcessCpuLoad() = %s; getSystemCpuLoad() = %s)%n", timings.average, timings.stdDev, CpuTimings.getProcessCpuLoad(), CpuTimings.getSystemCpuLoad());
            }
            System.gc();
            PlatformTestUtil.waitForAllBackgroundActivityToCalmDown();
            ++i;
        }
    }

    private static CpuTimings calcCpuTiming(int iterationCount, Runnable oneIteration, int attempt) {
        long[] elapsed = new long[iterationCount];
        for (int i = 0; i < iterationCount; ++i) {
            long start = System.currentTimeMillis();
            oneIteration.run();
            elapsed[i] = System.currentTimeMillis() - start;
        }
        return new CpuTimings(elapsed, attempt);
    }

    private static void addBigIntegers() {
        BigInteger k = new BigInteger("1");
        for (int i = 0; i < 1000000; ++i) {
            k = k.add(new BigInteger("1"));
        }
    }

    private static void mulDiv() {
        long k = 241L;
        for (int i = 0; i < 22222222; ++i) {
            k = i % 10 == 3 ? k * 239L : k % 12342L;
        }
        CpuTimings.ensureOdd(k);
    }

    private static void ensureOdd(long k) {
        if (k % 2L == 0L) {
            throw new AssertionError((Object)"Should be an odd value");
        }
    }

    private static void mulDivMemAccess() {
        int[] array = new int[240000];
        for (int i = 0; i < array.length; ++i) {
            array[i] = i * 42 + 1;
        }
        int k = 241;
        for (int i = 0; i < 5750000; ++i) {
            k *= array[Math.abs(k) % array.length];
        }
        CpuTimings.ensureOdd(k);
    }

    public static double getProcessCpuLoad() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name2 = ObjectName.getInstance("java.lang:type=OperatingSystem");
            AttributeList list = mbs.getAttributes(name2, new String[]{"ProcessCpuLoad"});
            if (list.isEmpty()) {
                return Double.NaN;
            }
            Attribute att = (Attribute)list.get(0);
            Double value = (Double)att.getValue();
            if (value == -1.0) {
                return Double.NaN;
            }
            return (double)((int)(value * 1000.0)) / 10.0;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static double getSystemCpuLoad() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name2 = ObjectName.getInstance("java.lang:type=OperatingSystem");
            AttributeList list = mbs.getAttributes(name2, new String[]{"SystemCpuLoad"});
            if (list.isEmpty()) {
                return Double.NaN;
            }
            Attribute att = (Attribute)list.get(0);
            Double value = (Double)att.getValue();
            if (value == -1.0) {
                return Double.NaN;
            }
            return (double)((int)(value * 1000.0)) / 10.0;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        for (int i = 0; i < 20; ++i) {
        }
    }
}

