/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class ExpectedHighlightingData {
    private static final String ERROR_MARKER = "error";
    private static final String WARNING_MARKER = "warning";
    private static final String WEAK_WARNING_MARKER = "weak_warning";
    private static final String INFO_MARKER = "info";
    private static final String END_LINE_HIGHLIGHT_MARKER = "EOLError";
    private static final String END_LINE_WARNING_MARKER = "EOLWarning";
    private static final String INJECT_MARKER = "inject";
    private static final String SYMBOL_NAME_MARKER = "symbolName";
    private static final String LINE_MARKER = "lineMarker";
    private static final String ANY_TEXT = "*";
    private static final HighlightInfoType WHATEVER = new HighlightInfoType.HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, HighlighterColors.TEXT);
    private final Map<String, ExpectedHighlightingSet> myHighlightingTypes;
    private final Map<RangeMarker, LineMarkerInfo> myLineMarkerInfos;
    private final Document myDocument;
    private final PsiFile myFile;
    private final String myText;
    private boolean myIgnoreExtraHighlighting;

    public ExpectedHighlightingData(@NotNull Document document, boolean checkWarnings, boolean checkInfos) {
        if (document == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(0);
        }
        this(document, checkWarnings, false, checkInfos);
    }

    public ExpectedHighlightingData(@NotNull Document document, boolean checkWarnings, boolean checkWeakWarnings, boolean checkInfos) {
        if (document == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(1);
        }
        this(document, checkWarnings, checkWeakWarnings, checkInfos, null);
    }

    public ExpectedHighlightingData(@NotNull Document document, boolean checkWarnings, boolean checkWeakWarnings, boolean checkInfos, @Nullable PsiFile file) {
        if (document == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(2);
        }
        this(document, checkWarnings, checkWeakWarnings, checkInfos, false, file);
    }

    public ExpectedHighlightingData(@NotNull Document document, boolean checkWarnings, boolean checkWeakWarnings, boolean checkInfos, boolean ignoreExtraHighlighting, @Nullable PsiFile file) {
        if (document == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(3);
        }
        this(document, file);
        this.myIgnoreExtraHighlighting = ignoreExtraHighlighting;
        if (checkWarnings) {
            this.checkWarnings();
        }
        if (checkWeakWarnings) {
            this.checkWeakWarnings();
        }
        if (checkInfos) {
            this.checkInfos();
        }
    }

    public ExpectedHighlightingData(@NotNull Document document, @Nullable PsiFile file) {
        if (document == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(4);
        }
        this.myHighlightingTypes = new LinkedHashMap<String, ExpectedHighlightingSet>();
        this.myLineMarkerInfos = new THashMap();
        this.myDocument = document;
        this.myFile = file;
        this.myText = document.getText();
        this.registerHighlightingType(ERROR_MARKER, new ExpectedHighlightingSet(HighlightSeverity.ERROR, false, true));
        this.registerHighlightingType(WARNING_MARKER, new ExpectedHighlightingSet(HighlightSeverity.WARNING, false, false));
        this.registerHighlightingType(WEAK_WARNING_MARKER, new ExpectedHighlightingSet(HighlightSeverity.WEAK_WARNING, false, false));
        this.registerHighlightingType(INJECT_MARKER, new ExpectedHighlightingSet(HighlightInfoType.INJECTED_FRAGMENT_SEVERITY, false, false));
        this.registerHighlightingType(INFO_MARKER, new ExpectedHighlightingSet(HighlightSeverity.INFORMATION, false, false));
        this.registerHighlightingType(SYMBOL_NAME_MARKER, new ExpectedHighlightingSet(HighlightInfoType.SYMBOL_TYPE_SEVERITY, false, false));
        for (SeveritiesProvider provider : (SeveritiesProvider[])Extensions.getExtensions((ExtensionPointName)SeveritiesProvider.EP_NAME)) {
            for (HighlightInfoType type : provider.getSeveritiesHighlightInfoTypes()) {
                HighlightSeverity severity = type.getSeverity(null);
                this.registerHighlightingType(severity.getName(), new ExpectedHighlightingSet(severity, false, true));
            }
        }
        this.registerHighlightingType(END_LINE_HIGHLIGHT_MARKER, new ExpectedHighlightingSet(HighlightSeverity.ERROR, true, true));
        this.registerHighlightingType(END_LINE_WARNING_MARKER, new ExpectedHighlightingSet(HighlightSeverity.WARNING, true, false));
    }

    public boolean hasLineMarkers() {
        return !this.myLineMarkerInfos.isEmpty();
    }

    public void init() {
        WriteCommandAction.writeCommandAction(null).run(() -> {
            this.extractExpectedLineMarkerSet(this.myDocument);
            this.extractExpectedHighlightsSet(this.myDocument);
            this.refreshLineMarkers();
        });
    }

    public void checkWarnings() {
        this.registerHighlightingType(WARNING_MARKER, new ExpectedHighlightingSet(HighlightSeverity.WARNING, false, true));
        this.registerHighlightingType(END_LINE_WARNING_MARKER, new ExpectedHighlightingSet(HighlightSeverity.WARNING, true, true));
    }

    public void checkWeakWarnings() {
        this.registerHighlightingType(WEAK_WARNING_MARKER, new ExpectedHighlightingSet(HighlightSeverity.WEAK_WARNING, false, true));
    }

    public void checkInfos() {
        this.registerHighlightingType(INFO_MARKER, new ExpectedHighlightingSet(HighlightSeverity.INFORMATION, false, true));
        this.registerHighlightingType(INJECT_MARKER, new ExpectedHighlightingSet(HighlightInfoType.INJECTED_FRAGMENT_SEVERITY, false, true));
    }

    public void checkSymbolNames() {
        this.registerHighlightingType(SYMBOL_NAME_MARKER, new ExpectedHighlightingSet(HighlightInfoType.SYMBOL_TYPE_SEVERITY, false, true));
    }

    public void registerHighlightingType(@NotNull String key, @NotNull ExpectedHighlightingSet highlightingSet) {
        if (key == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(5);
        }
        if (highlightingSet == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(6);
        }
        this.myHighlightingTypes.put(key, highlightingSet);
    }

    private void refreshLineMarkers() {
        for (Map.Entry<RangeMarker, LineMarkerInfo> entry : this.myLineMarkerInfos.entrySet()) {
            RangeMarker rangeMarker = entry.getKey();
            int startOffset = rangeMarker.getStartOffset();
            int endOffset = rangeMarker.getEndOffset();
            LineMarkerInfo value = entry.getValue();
            PsiElement element = value.getElement();
            assert (element != null) : value;
            TextRange range = new TextRange(startOffset, endOffset);
            String tooltip = value.getLineMarkerTooltip();
            MyLineMarkerInfo markerInfo = new MyLineMarkerInfo(element, range, value.updatePass, GutterIconRenderer.Alignment.RIGHT, tooltip);
            entry.setValue(markerInfo);
        }
    }

    private void extractExpectedLineMarkerSet(Document document) {
        Matcher opening;
        String text = document.getText();
        String pat = ".*?((<lineMarker)(?: descr=\"((?:[^\"\\\\]|\\\\\")*)\")?>)(.*)";
        Pattern openingTagRx = Pattern.compile(pat, 32);
        Pattern closingTagRx = Pattern.compile("(.*?)(</lineMarker>)(.*)", 32);
        while ((opening = openingTagRx.matcher(text)).matches()) {
            int startOffset = opening.start(1);
            String descr = opening.group(3) != null ? opening.group(3) : ANY_TEXT;
            String rest = opening.group(4);
            Matcher closing = closingTagRx.matcher(rest);
            if (!closing.matches()) {
                Assert.fail((String)"Cannot find closing </lineMarker>");
            }
            document.replaceString(startOffset, opening.end(1), (CharSequence)"");
            String content = closing.group(1);
            int endOffset = startOffset + closing.start(3);
            String endTag = closing.group(2);
            document.replaceString(startOffset, endOffset, (CharSequence)content);
            PsiElement leaf = Objects.requireNonNull(this.myFile.findElementAt(startOffset));
            TextRange range = new TextRange(startOffset, endOffset -= endTag.length());
            String tooltip = StringUtil.unescapeStringCharacters((String)descr);
            MyLineMarkerInfo markerInfo = new MyLineMarkerInfo(leaf, range, 11, GutterIconRenderer.Alignment.RIGHT, tooltip);
            this.myLineMarkerInfos.put(document.createRangeMarker(startOffset, endOffset), markerInfo);
            text = document.getText();
        }
    }

    private void extractExpectedHighlightsSet(Document document) {
        String text = document.getText();
        Set<String> markers = this.myHighlightingTypes.keySet();
        String typesRx = "(?:" + StringUtil.join(markers, (String)")|(?:") + ")";
        String openingTagRx = "<(" + typesRx + ")(?:\\s+descr=\"((?:[^\"]|\\\\\"|\\\\\\\\\"|\\\\\\[|\\\\])*)\")?(?:\\s+type=\"([0-9A-Z_]+)\")?(?:\\s+foreground=\"([0-9xa-f]+)\")?(?:\\s+background=\"([0-9xa-f]+)\")?(?:\\s+effectcolor=\"([0-9xa-f]+)\")?(?:\\s+effecttype=\"([A-Z]+)\")?(?:\\s+fonttype=\"([0-9]+)\")?(?:\\s+textAttributesKey=\"((?:[^\"]|\\\\\"|\\\\\\\\\"|\\\\\\[|\\\\])*)\")?(?:\\s+bundleMsg=\"((?:[^\"]|\\\\\"|\\\\\\\\\")*)\")?(/)?>";
        Matcher matcher = Pattern.compile(openingTagRx).matcher(text);
        int pos = 0;
        Ref textOffset = Ref.create((Object)0);
        while (matcher.find(pos)) {
            textOffset.set((Object)((Integer)textOffset.get() + matcher.start() - pos));
            pos = this.extractExpectedHighlight(matcher, text, document, (Ref<Integer>)textOffset);
        }
    }

    private int extractExpectedHighlight(Matcher matcher, String text, Document document, Ref<Integer> textOffset) {
        int toContinueFrom;
        boolean closed;
        document.deleteString(((Integer)textOffset.get()).intValue(), (Integer)textOffset.get() + matcher.end() - matcher.start());
        int groupIdx = 1;
        String marker = matcher.group(groupIdx++);
        String descr = matcher.group(groupIdx++);
        String typeString = matcher.group(groupIdx++);
        String foregroundColor = matcher.group(groupIdx++);
        String backgroundColor = matcher.group(groupIdx++);
        String effectColor = matcher.group(groupIdx++);
        String effectType = matcher.group(groupIdx++);
        String fontType = matcher.group(groupIdx++);
        String attrKey = matcher.group(groupIdx++);
        String bundleMessage = matcher.group(groupIdx++);
        boolean bl = closed = matcher.group(groupIdx) != null;
        if (descr == null) {
            descr = ANY_TEXT;
        } else if (descr.equals("null")) {
            descr = null;
        }
        if (descr != null) {
            descr = descr.replaceAll("\\\\\\\\\"", "\"");
            descr = descr.replaceAll("\\\\\"", "\"");
        }
        HighlightInfoType type = WHATEVER;
        if (typeString != null) {
            try {
                type = this.getTypeByName(typeString);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (type == null) {
                Assert.fail((String)("Wrong highlight type: " + typeString));
            }
        }
        TextAttributes forcedAttributes = null;
        if (foregroundColor != null) {
            int ft = Integer.parseInt(fontType);
            forcedAttributes = new TextAttributes(Color.decode(foregroundColor), Color.decode(backgroundColor), Color.decode(effectColor), EffectType.valueOf((String)effectType), ft);
        }
        int rangeStart = (Integer)textOffset.get();
        if (closed) {
            toContinueFrom = matcher.end();
        } else {
            int pos = matcher.end();
            Matcher closingTagMatcher = Pattern.compile("</" + marker + ">").matcher(text);
            while (true) {
                int nextTagStart;
                if (!closingTagMatcher.find(pos)) {
                    toContinueFrom = pos;
                    break;
                }
                int n = nextTagStart = matcher.find(pos) ? matcher.start() : text.length();
                if (closingTagMatcher.start() < nextTagStart) {
                    textOffset.set((Object)((Integer)textOffset.get() + closingTagMatcher.start() - pos));
                    document.deleteString(((Integer)textOffset.get()).intValue(), (Integer)textOffset.get() + closingTagMatcher.end() - closingTagMatcher.start());
                    toContinueFrom = closingTagMatcher.end();
                    break;
                }
                textOffset.set((Object)((Integer)textOffset.get() + nextTagStart - pos));
                pos = this.extractExpectedHighlight(matcher, text, document, textOffset);
            }
        }
        ExpectedHighlightingSet expectedHighlightingSet = this.myHighlightingTypes.get(marker);
        if (expectedHighlightingSet.enabled) {
            TextAttributesKey forcedTextAttributesKey = attrKey == null ? null : TextAttributesKey.createTextAttributesKey((String)attrKey);
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)type).range(rangeStart, ((Integer)textOffset.get()).intValue()).severity(expectedHighlightingSet.severity);
            if (forcedAttributes != null) {
                builder.textAttributes(forcedAttributes);
            }
            if (forcedTextAttributesKey != null) {
                builder.textAttributes(forcedTextAttributesKey);
            }
            if (bundleMessage != null) {
                List split = StringUtil.split((String)bundleMessage, (String)"|");
                ResourceBundle bundle = ResourceBundle.getBundle((String)split.get(0));
                descr = CommonBundle.message((ResourceBundle)bundle, (String)((String)split.get(1)), (Object[])split.stream().skip(2L).toArray());
            }
            if (descr != null) {
                builder.description(descr);
                builder.unescapedToolTip(descr);
            }
            if (expectedHighlightingSet.endOfLine) {
                builder.endOfLine();
            }
            HighlightInfo highlightInfo = builder.createUnconditionally();
            expectedHighlightingSet.infos.add(highlightInfo);
        }
        return toContinueFrom;
    }

    protected HighlightInfoType getTypeByName(String typeString) throws Exception {
        Field field = HighlightInfoType.class.getField(typeString);
        return (HighlightInfoType)field.get(null);
    }

    public void checkLineMarkers(@NotNull Collection<LineMarkerInfo> markerInfos, @NotNull String text) {
        if (markerInfos == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(7);
        }
        if (text == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(8);
        }
        String fileName = this.myFile == null ? "" : this.myFile.getName() + ": ";
        StringBuilder failMessage = new StringBuilder();
        for (LineMarkerInfo info : markerInfos) {
            if (ExpectedHighlightingData.containsLineMarker(info, this.myLineMarkerInfos.values())) continue;
            if (failMessage.length() > 0) {
                failMessage.append('\n');
            }
            failMessage.append(fileName).append("extra ").append(ExpectedHighlightingData.rangeString(text, info.startOffset, info.endOffset)).append(": '").append(info.getLineMarkerTooltip()).append('\'');
        }
        for (LineMarkerInfo expectedLineMarker : this.myLineMarkerInfos.values()) {
            if (!markerInfos.isEmpty() && ExpectedHighlightingData.containsLineMarker(expectedLineMarker, markerInfos)) continue;
            if (failMessage.length() > 0) {
                failMessage.append('\n');
            }
            failMessage.append(fileName).append("missing ").append(ExpectedHighlightingData.rangeString(text, expectedLineMarker.startOffset, expectedLineMarker.endOffset)).append(": '").append(expectedLineMarker.getLineMarkerTooltip()).append('\'');
        }
        if (failMessage.length() > 0) {
            Assert.fail((String)failMessage.toString());
        }
    }

    private static boolean containsLineMarker(LineMarkerInfo info, Collection<LineMarkerInfo> where) {
        String infoTooltip = info.getLineMarkerTooltip();
        for (LineMarkerInfo markerInfo : where) {
            String markerInfoTooltip;
            if (markerInfo.startOffset != info.startOffset || markerInfo.endOffset != info.endOffset || !Comparing.equal((String)infoTooltip, (String)(markerInfoTooltip = markerInfo.getLineMarkerTooltip())) && !ANY_TEXT.equals(markerInfoTooltip) && !ANY_TEXT.equals(infoTooltip)) continue;
            return true;
        }
        return false;
    }

    public void checkResult(Collection<HighlightInfo> infos, String text) {
        this.checkResult(infos, text, null);
    }

    public void checkResult(Collection<HighlightInfo> infos, String text, @Nullable String filePath) {
        String fileName = this.myFile == null ? "" : this.myFile.getName() + ": ";
        StringBuilder failMessage = new StringBuilder();
        for (HighlightInfo highlightInfo : ExpectedHighlightingData.reverseCollection(infos)) {
            if (this.expectedInfosContainsInfo(highlightInfo) || this.myIgnoreExtraHighlighting) continue;
            int startOffset = highlightInfo.startOffset;
            int endOffset = highlightInfo.endOffset;
            String s = text.substring(startOffset, endOffset);
            String desc = highlightInfo.getDescription();
            if (failMessage.length() > 0) {
                failMessage.append('\n');
            }
            failMessage.append(fileName).append("extra ").append(ExpectedHighlightingData.rangeString(text, startOffset, endOffset)).append(": '").append(s).append('\'');
            if (desc != null) {
                failMessage.append(" (").append(desc).append(')');
            }
            failMessage.append(" [").append(highlightInfo.type).append(']');
        }
        Collection<ExpectedHighlightingSet> expectedHighlights = this.myHighlightingTypes.values();
        for (ExpectedHighlightingSet highlightingSet : ExpectedHighlightingData.reverseCollection(expectedHighlights)) {
            Set expInfos = highlightingSet.infos;
            for (HighlightInfo expectedInfo : expInfos) {
                if (ExpectedHighlightingData.infosContainsExpectedInfo(infos, expectedInfo) || !highlightingSet.enabled) continue;
                int startOffset = expectedInfo.startOffset;
                int endOffset = expectedInfo.endOffset;
                String s = text.substring(startOffset, endOffset);
                String desc = expectedInfo.getDescription();
                if (failMessage.length() > 0) {
                    failMessage.append('\n');
                }
                failMessage.append(fileName).append("missing ").append(ExpectedHighlightingData.rangeString(text, startOffset, endOffset)).append(": '").append(s).append('\'');
                if (desc == null) continue;
                failMessage.append(" (").append(desc).append(")");
            }
        }
        if (failMessage.length() > 0) {
            VirtualFile virtualFile;
            if (filePath == null && this.myFile != null && (virtualFile = this.myFile.getVirtualFile()) != null) {
                filePath = (String)virtualFile.getUserData(VfsTestUtil.TEST_DATA_FILE_PATH);
            }
            failMessage.append('\n');
            this.compareTexts(infos, text, failMessage.toString(), filePath);
        }
    }

    private static <T> List<T> reverseCollection(Collection<T> infos) {
        return ContainerUtil.reverse((List)(infos instanceof List ? (List<Object>)infos : new ArrayList<T>(infos)));
    }

    private void compareTexts(Collection<HighlightInfo> infos, String text, String failMessage, @Nullable String filePath) {
        String actual = ExpectedHighlightingData.composeText(this.myHighlightingTypes, infos, text);
        if (filePath != null && !this.myText.equals(actual)) {
            throw new FileComparisonFailure(failMessage, this.myText, actual, filePath);
        }
        Assert.assertEquals((String)(failMessage + "\n"), (Object)this.myText, (Object)actual);
        Assert.fail((String)failMessage);
    }

    private static String findTag(Map<String, ExpectedHighlightingSet> types, HighlightInfo info) {
        Map.Entry entry = (Map.Entry)ContainerUtil.find(types.entrySet(), e -> ((ExpectedHighlightingSet)e.getValue()).enabled && ((ExpectedHighlightingSet)e.getValue()).severity == info.getSeverity() && ((ExpectedHighlightingSet)e.getValue()).endOfLine == info.isAfterEndOfLine());
        return entry != null ? (String)entry.getKey() : null;
    }

    public static String composeText(Map<String, ExpectedHighlightingSet> types, Collection<HighlightInfo> infos, String text) {
        List<Pair<String, HighlightInfo>> list = infos.stream().map(info -> Pair.pair((Object)ExpectedHighlightingData.findTag(types, info), (Object)info)).filter(p -> p.first != null).collect(Collectors.toList());
        boolean showAttributesKeys = types.values().stream().flatMap(set -> ((ExpectedHighlightingSet)set).infos.stream()).anyMatch(i -> i.forcedTextAttributesKey != null);
        Collections.sort(list, (o1, o2) -> {
            int bySeverity;
            HighlightInfo i1 = (HighlightInfo)o1.second;
            HighlightInfo i2 = (HighlightInfo)o2.second;
            int byEnds = i2.endOffset - i1.endOffset;
            if (byEnds != 0) {
                return byEnds;
            }
            if (!i1.isAfterEndOfLine() && !i2.isAfterEndOfLine()) {
                int byStarts = i1.startOffset - i2.startOffset;
                if (byStarts != 0) {
                    return byStarts;
                }
            } else {
                int byEOL = Comparing.compare((boolean)i2.isAfterEndOfLine(), (boolean)i1.isAfterEndOfLine());
                if (byEOL != 0) {
                    return byEOL;
                }
            }
            if ((bySeverity = i2.getSeverity().compareTo(i1.getSeverity())) != 0) {
                return bySeverity;
            }
            return Comparing.compare((Comparable)((Object)i1.getDescription()), (Comparable)((Object)i2.getDescription()));
        });
        StringBuilder sb = new StringBuilder();
        int[] offsets = ExpectedHighlightingData.composeText(sb, list, 0, text, text.length(), -1, showAttributesKeys);
        sb.insert(0, text.substring(0, offsets[1]));
        return sb.toString();
    }

    private static int[] composeText(StringBuilder sb, List<Pair<String, HighlightInfo>> list, int index, String text, int endPos, int startPos, boolean showAttributesKeys) {
        int i;
        for (i = index; i < list.size(); ++i) {
            Pair<String, HighlightInfo> pair2 = list.get(i);
            HighlightInfo info = (HighlightInfo)pair2.second;
            if (info.endOffset <= startPos) break;
            String severity = (String)pair2.first;
            HighlightInfo prev = i < list.size() - 1 ? (HighlightInfo)list.get((int)(i + 1)).second : null;
            sb.insert(0, text.substring(info.endOffset, endPos));
            sb.insert(0, "</" + severity + '>');
            endPos = info.endOffset;
            if (prev != null && prev.endOffset > info.startOffset) {
                int[] offsets = ExpectedHighlightingData.composeText(sb, list, i + 1, text, endPos, info.startOffset, showAttributesKeys);
                i = offsets[0] - 1;
                endPos = offsets[1];
            }
            sb.insert(0, text.substring(info.startOffset, endPos));
            String str = '<' + severity + " descr=\"" + StringUtil.escapeQuotes((String)String.valueOf(info.getDescription())) + '\"';
            if (showAttributesKeys) {
                str = str + " textAttributesKey=\"" + info.forcedTextAttributesKey + '\"';
            }
            str = str + '>';
            sb.insert(0, str);
            endPos = info.startOffset;
        }
        return new int[]{i, endPos};
    }

    private static boolean infosContainsExpectedInfo(Collection<HighlightInfo> infos, HighlightInfo expectedInfo) {
        for (HighlightInfo info : infos) {
            if (!ExpectedHighlightingData.infoEquals(expectedInfo, info)) continue;
            return true;
        }
        return false;
    }

    private boolean expectedInfosContainsInfo(HighlightInfo info) {
        if (info.getTextAttributes(null, null) == TextAttributes.ERASE_MARKER) {
            return true;
        }
        Collection<ExpectedHighlightingSet> expectedHighlights = this.myHighlightingTypes.values();
        for (ExpectedHighlightingSet highlightingSet : expectedHighlights) {
            if (highlightingSet.severity != info.getSeverity()) continue;
            if (!highlightingSet.enabled) {
                return true;
            }
            Set infos = highlightingSet.infos;
            for (HighlightInfo expectedInfo : infos) {
                if (!ExpectedHighlightingData.infoEquals(expectedInfo, info)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean infoEquals(HighlightInfo expectedInfo, HighlightInfo info) {
        if (expectedInfo == info) {
            return true;
        }
        return !(info.getSeverity() != expectedInfo.getSeverity() || info.startOffset != expectedInfo.startOffset || info.endOffset != expectedInfo.endOffset || info.isAfterEndOfLine() != expectedInfo.isAfterEndOfLine() || expectedInfo.type != WHATEVER && !expectedInfo.type.equals(info.type) || !Comparing.strEqual((String)ANY_TEXT, (String)expectedInfo.getDescription()) && !Comparing.strEqual((String)info.getDescription(), (String)expectedInfo.getDescription()) || expectedInfo.forcedTextAttributes != null && !Comparing.equal((Object)expectedInfo.getTextAttributes(null, null), (Object)info.getTextAttributes(null, null)) || expectedInfo.forcedTextAttributesKey != null && !expectedInfo.forcedTextAttributesKey.equals((Object)info.forcedTextAttributesKey));
    }

    private static String rangeString(String text, int startOffset, int endOffset) {
        int startLine = StringUtil.offsetToLineNumber((CharSequence)text, (int)startOffset);
        int endLine = StringUtil.offsetToLineNumber((CharSequence)text, (int)endOffset);
        int startCol = startOffset - StringUtil.lineColToOffset((CharSequence)text, (int)startLine, (int)0);
        int endCol = endOffset - StringUtil.lineColToOffset((CharSequence)text, (int)endLine, (int)0);
        if (startLine == endLine) {
            return String.format("(%d:%d/%d)", startLine + 1, startCol + 1, endCol - startCol);
        }
        return String.format("(%d:%d..%d:%d)", startLine + 1, endLine + 1, startCol + 1, endCol + 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightingSet";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markerInfos";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/ExpectedHighlightingData";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "registerHighlightingType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkLineMarkers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        private final String myTooltip;

        public MyLineMarkerInfo(PsiElement element, TextRange range, int updatePass, GutterIconRenderer.Alignment alignment, String tooltip) {
            super(element, range, null, updatePass, null, null, alignment);
            this.myTooltip = tooltip;
        }

        public String getLineMarkerTooltip() {
            return this.myTooltip;
        }
    }

    public static class ExpectedHighlightingSet {
        private final HighlightSeverity severity;
        private final boolean endOfLine;
        private final boolean enabled;
        private final Set<HighlightInfo> infos;

        public ExpectedHighlightingSet(@NotNull HighlightSeverity severity, boolean endOfLine, boolean enabled) {
            if (severity == null) {
                ExpectedHighlightingSet.$$$reportNull$$$0(0);
            }
            this.severity = severity;
            this.endOfLine = endOfLine;
            this.enabled = enabled;
            this.infos = new THashSet();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/testFramework/ExpectedHighlightingData$ExpectedHighlightingSet", "<init>"));
        }
    }
}

