/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import com.intellij.util.PathUtil;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class LightTempDirTestFixtureImpl
extends BaseFixture
implements TempDirTestFixture {
    private final VirtualFile mySourceRoot;
    private final boolean myUsePlatformSourceRoot;

    public LightTempDirTestFixtureImpl() {
        final VirtualFile fsRoot = VirtualFileManager.getInstance().findFileByUrl("temp:///");
        Assert.assertNotNull((Object)fsRoot);
        this.mySourceRoot = (VirtualFile)new WriteAction<VirtualFile>(){

            protected void run(@NotNull Result<VirtualFile> result) throws Throwable {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                result.setResult((Object)fsRoot.createChildDirectory((Object)this, "root"));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl$1", "run"));
            }
        }.execute().getResultObject();
        this.myUsePlatformSourceRoot = false;
    }

    public LightTempDirTestFixtureImpl(boolean usePlatformSourceRoot) {
        this.myUsePlatformSourceRoot = usePlatformSourceRoot;
        this.mySourceRoot = null;
    }

    @Override
    public void tearDown() throws Exception {
        try {
            this.deleteAll();
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    @NotNull
    public VirtualFile findOrCreateDir(@NotNull String path) {
        if (path == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(0);
        }
        VirtualFile virtualFile = (VirtualFile)WriteAction.compute(() -> {
            if (path == null) {
                LightTempDirTestFixtureImpl.$$$reportNull$$$0(18);
            }
            try {
                return this.findOrCreateChildDir(this.getSourceRoot(), path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        if (virtualFile == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(1);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile copyAll(@NotNull String dataDir, @NotNull String targetDir) {
        if (dataDir == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(2);
        }
        if (targetDir == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(3);
        }
        VirtualFile virtualFile = this.copyAll(dataDir, targetDir, VirtualFileFilter.ALL);
        if (virtualFile == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile copyAll(final @NotNull String dataDir, final @NotNull String targetDir, final @NotNull VirtualFileFilter filter) {
        if (dataDir == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(5);
        }
        if (targetDir == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(6);
        }
        if (filter == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(7);
        }
        VirtualFile virtualFile = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                VirtualFile from = LocalFileSystem.getInstance().refreshAndFindFileByPath(dataDir);
                Assert.assertNotNull((String)("Cannot find testdata directory " + dataDir), (Object)from);
                try {
                    UsefulTestCase.refreshRecursively(from);
                    VirtualFile tempDir = LightTempDirTestFixtureImpl.this.getSourceRoot();
                    if (targetDir.length() > 0) {
                        tempDir = LightTempDirTestFixtureImpl.this.findOrCreateChildDir(tempDir, targetDir);
                    }
                    VfsUtil.copyDirectory((Object)this, (VirtualFile)from, (VirtualFile)tempDir, (VirtualFileFilter)filter);
                    return tempDir;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        if (virtualFile == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(8);
        }
        return virtualFile;
    }

    private VirtualFile findOrCreateChildDir(VirtualFile root, String relativePath) throws IOException {
        if (relativePath.length() == 0) {
            return root;
        }
        String trimPath = StringUtil.trimStart((String)relativePath, (String)"/");
        List dirs = StringUtil.split((String)trimPath, (String)"/");
        for (String dirName : dirs) {
            if (dirName.equals(".")) continue;
            if (dirName.equals("..")) {
                if ((root = root.getParent()) != null) continue;
                throw new IllegalArgumentException("Invalid path: " + relativePath);
            }
            VirtualFile dir = root.findChild(dirName);
            if (dir != null) {
                root = dir;
                continue;
            }
            try {
                root = root.createChildDirectory((Object)this, dirName);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return root;
    }

    @Override
    @NotNull
    public String getTempDirPath() {
        if ("temp:///root" == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(9);
        }
        return "temp:///root";
    }

    @Override
    public VirtualFile getFile(@NotNull String path) {
        VirtualFile sourceRoot;
        VirtualFile result;
        if (path == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(10);
        }
        if ((result = (sourceRoot = this.getSourceRoot()).findFileByRelativePath(path)) == null) {
            sourceRoot.refresh(false, true);
            result = sourceRoot.findFileByRelativePath(path);
        }
        return result;
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String targetPath) {
        if (targetPath == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(11);
        }
        final String path = PathUtil.getParentPath((String)targetPath);
        final String name2 = PathUtil.getFileName((String)targetPath);
        VirtualFile virtualFile = (VirtualFile)new WriteAction<VirtualFile>(){

            protected void run(@NotNull Result<VirtualFile> result) throws IOException {
                if (result == null) {
                    3.$$$reportNull$$$0(0);
                }
                VirtualFile targetDir = LightTempDirTestFixtureImpl.this.findOrCreateDir(path);
                result.setResult((Object)targetDir.createChildData((Object)this, name2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl$3", "run"));
            }
        }.execute().getResultObject();
        if (virtualFile == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(12);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String name2, final @NotNull String text) throws IOException {
        if (name2 == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(13);
        }
        if (text == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(14);
        }
        final VirtualFile file = this.createFile(name2);
        new WriteAction(){

            protected void run(@NotNull Result result) throws IOException {
                if (result == null) {
                    4.$$$reportNull$$$0(0);
                }
                VfsUtil.saveText((VirtualFile)file, (String)text);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl$4", "run"));
            }
        }.execute();
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(15);
        }
        return virtualFile;
    }

    public void deleteAll() {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                VirtualFile[] toDelete = LightTempDirTestFixtureImpl.this.myUsePlatformSourceRoot ? LightTempDirTestFixtureImpl.this.getSourceRoot().getChildren() : new VirtualFile[]{LightTempDirTestFixtureImpl.this.mySourceRoot};
                for (VirtualFile file : toDelete) {
                    try {
                        file.delete((Object)this);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    @NotNull
    private VirtualFile getSourceRoot() {
        if (this.myUsePlatformSourceRoot) {
            VirtualFile virtualFile = LightPlatformTestCase.getSourceRoot();
            if (virtualFile == null) {
                LightTempDirTestFixtureImpl.$$$reportNull$$$0(16);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = this.mySourceRoot;
        if (virtualFile == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(17);
        }
        return virtualFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataDir";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateDir";
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "copyAll";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirPath";
                break;
            }
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateDir";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyAll";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findOrCreateDir$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

