/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.utils.inlays;

import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.utils.inlays.CaretAndInlaysInfo;
import com.intellij.testFramework.utils.inlays.ParamHintInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.ComparisonFailure;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J \u0010\u0010\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0006\u0010\u0014\u001a\u00020\bJ\u0006\u0010\u0015\u001a\u00020\bJ\u0016\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsChecker;", "", "myFixture", "Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;", "(Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;)V", "isParamHintsEnabledBefore", "", "checkInlays", "", "extractInlaysAndCaretInfo", "Lcom/intellij/testFramework/utils/inlays/CaretAndInlaysInfo;", "document", "Lcom/intellij/openapi/editor/Document;", "getActualInlays", "", "Lcom/intellij/testFramework/utils/inlays/ParamHintInfo;", "removeText", "realStartOffset", "", "matchedLength", "setUp", "tearDown", "verifyInlaysAndCaretInfo", "expectedInlaysAndCaret", "originalText", "", "Companion", "intellij.platform.testFramework"})
public final class InlayHintsChecker {
    private boolean isParamHintsEnabledBefore;
    private final CodeInsightTestFixture myFixture;
    @NotNull
    private static final Pattern pattern;
    private static final ParameterNameHintsSettings default;
    public static final Companion Companion;

    public final void setUp() {
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        this.isParamHintsEnabledBefore = settings.isShowParameterNameHints();
        settings.setShowParameterNameHints(true);
    }

    public final void tearDown() {
        EditorSettingsExternalizable.getInstance().setShowParameterNameHints(this.isParamHintsEnabledBefore);
        ParameterNameHintsSettings hintSettings = ParameterNameHintsSettings.Companion.getInstance();
        hintSettings.loadState(InlayHintsChecker.Companion.getDefault().getState());
    }

    public final void checkInlays() {
        PsiFile file = this.myFixture.getFile();
        Document document = this.myFixture.getDocument(file);
        String originalText = document.getText();
        Document document2 = document;
        Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"document");
        CaretAndInlaysInfo expectedInlaysAndCaret = this.extractInlaysAndCaretInfo(document2);
        this.myFixture.doHighlighting();
        String string = originalText;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"originalText");
        this.verifyInlaysAndCaretInfo(expectedInlaysAndCaret, string);
    }

    public final void verifyInlaysAndCaretInfo(@NotNull CaretAndInlaysInfo expectedInlaysAndCaret, @NotNull String originalText) {
        block17: {
            List<ParamHintInfo> actual;
            Document document;
            PsiFile file;
            block16: {
                boolean bl;
                block14: {
                    Intrinsics.checkParameterIsNotNull((Object)expectedInlaysAndCaret, (String)"expectedInlaysAndCaret");
                    Intrinsics.checkParameterIsNotNull((Object)originalText, (String)"originalText");
                    file = this.myFixture.getFile();
                    document = this.myFixture.getDocument(file);
                    actual = this.getActualInlays();
                    List<ParamHintInfo> expected = expectedInlaysAndCaret.getInlays();
                    if (expectedInlaysAndCaret.getInlays().size() != actual.size()) break block16;
                    Iterable $receiver$iv = CollectionsKt.zip((Iterable)actual, (Iterable)expected);
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Iterator element$iv : $receiver$iv) {
                            Pair it = (Pair)element$iv;
                            if (!(Intrinsics.areEqual((Object)((ParamHintInfo)it.getFirst()), (Object)((ParamHintInfo)it.getSecond())) ^ true)) continue;
                            bl = true;
                            break block14;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block17;
            }
            List entries = new ArrayList();
            Iterable $receiver$iv = actual;
            for (Object element$iv : $receiver$iv) {
                String string;
                StringBuilder stringBuilder;
                Pair pair2;
                ParamHintInfo it = (ParamHintInfo)element$iv;
                Integer $i$f$any = it.getOffset();
                Pair pair3 = pair2;
                Pair pair4 = pair2;
                List list = entries;
                StringBuilder $receiver = stringBuilder = new StringBuilder();
                $receiver.append("<");
                $receiver.append(it.getHighlighted() ? "H" : "h");
                $receiver.append(it.getCurrent() ? "INT" : "int");
                $receiver.append(" text=\"");
                $receiver.append(it.getText());
                $receiver.append("\"/>");
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder.toString(), (String)"StringBuilder().apply(builderAction).toString()");
                pair3((Object)$i$f$any, (Object)string);
                list.add(pair4);
            }
            if (expectedInlaysAndCaret.getCaretOffset() != null) {
                int n;
                int actualInlaysBeforeCaret;
                int actualCaretOffset;
                block15: {
                    actualCaretOffset = this.myFixture.getEditor().getCaretModel().getOffset();
                    actualInlaysBeforeCaret = this.myFixture.getEditor().getCaretModel().getVisualPosition().column - this.myFixture.getEditor().offsetToVisualPosition((int)actualCaretOffset).column;
                    List $receiver$iv2 = entries;
                    int index$iv = 0;
                    for (Object item$iv : $receiver$iv2) {
                        Pair it = (Pair)item$iv;
                        if (((Number)it.getFirst()).intValue() == actualCaretOffset) {
                            n = index$iv;
                            break block15;
                        }
                        ++index$iv;
                    }
                    n = -1;
                }
                int first = n;
                int insertIndex2 = first == -1 ? -CollectionsKt.binarySearch$default((List)entries, (int)0, (int)0, (Function1)((Function1)new Function1<Pair<? extends Integer, ? extends String>, Integer>(actualCaretOffset){
                    final /* synthetic */ int $actualCaretOffset;

                    public final int invoke(@NotNull Pair<Integer, String> it) {
                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                        return ((Number)it.getFirst()).intValue() - this.$actualCaretOffset;
                    }
                    {
                        this.$actualCaretOffset = n;
                        super(1);
                    }
                }), (int)3, null) - 1 : first + actualInlaysBeforeCaret;
                entries.add(insertIndex2, new Pair((Object)actualCaretOffset, (Object)"<caret>"));
            }
            StringBuilder proposedText = new StringBuilder(document.getText());
            Iterable $receiver$iv3 = CollectionsKt.asReversedMutable((List)entries);
            for (Object element$iv : $receiver$iv3) {
                Pair it = (Pair)element$iv;
                proposedText.insert(((Number)it.getFirst()).intValue(), (String)it.getSecond());
            }
            String string = (String)VfsTestUtil.TEST_DATA_FILE_PATH.get((UserDataHolder)file.getVirtualFile());
            if (string != null) {
                String string2;
                String originalPath = string2 = string;
                throw (Throwable)new FileComparisonFailure("Hints differ", originalText, proposedText.toString(), originalPath);
            }
            throw (Throwable)new ComparisonFailure("Hints differ", originalText, proposedText.toString());
        }
        if (expectedInlaysAndCaret.getCaretOffset() != null) {
            Assert.assertEquals((String)"Unexpected caret offset", (Object)expectedInlaysAndCaret.getCaretOffset(), (Object)this.myFixture.getEditor().getCaretModel().getOffset());
            VisualPosition position = this.myFixture.getEditor().offsetToVisualPosition(expectedInlaysAndCaret.getCaretOffset().intValue());
            Assert.assertEquals((String)"Unexpected caret visual position", (Object)new VisualPosition(position.line, position.column + expectedInlaysAndCaret.getInlaysBeforeCaret()), (Object)this.myFixture.getEditor().getCaretModel().getVisualPosition());
            SelectionModel selectionModel = this.myFixture.getEditor().getSelectionModel();
            if (expectedInlaysAndCaret.getSelection() == null) {
                Assert.assertFalse((boolean)selectionModel.hasSelection());
            } else {
                Assert.assertEquals((String)"Unexpected selection", (Object)expectedInlaysAndCaret.getSelection(), (Object)new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd()));
            }
        }
    }

    private final List<ParamHintInfo> getActualInlays() {
        Inlay it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Editor editor = this.myFixture.getEditor();
        List allInlays = editor.getInlayModel().getInlineElementsInRange(0, editor.getDocument().getTextLength());
        ParameterHintsPresentationManager hintManager = ParameterHintsPresentationManager.getInstance();
        Iterable iterable = allInlays;
        Iterable iterable2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Inlay)element$iv$iv;
            if (!hintManager.isParameterHint(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (Inlay)item$iv$iv;
            Collection collection = destination$iv$iv;
            int n = it.getOffset();
            String string = hintManager.getHintText(it);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"hintManager.getHintText(it)");
            ParamHintInfo paramHintInfo = new ParamHintInfo(n, string, hintManager.isHighlighted(it), hintManager.isCurrent(it));
            collection.add(paramHintInfo);
        }
        $receiver$iv = (List)destination$iv$iv;
        iterable2 = $receiver$iv;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                ParamHintInfo it = (ParamHintInfo)a;
                Comparable comparable = Integer.valueOf(it.getOffset());
                it = (ParamHintInfo)b;
                Comparable comparable2 = comparable;
                Integer n = it.getOffset();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        };
        return CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)comparator);
    }

    @NotNull
    public final CaretAndInlaysInfo extractInlaysAndCaretInfo(@NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        String text = document.getText();
        Matcher matcher = Companion.getPattern().matcher(text);
        List inlays = new ArrayList();
        int extractedLength = 0;
        Integer caretOffset = null;
        int inlaysBeforeCaret = 0;
        Integer selectionStart = null;
        Integer selectionEnd = null;
        while (matcher.find()) {
            Iterable iterable;
            int start = matcher.start();
            int matchedLength = matcher.end() - start;
            int realStartOffset = start - extractedLength;
            if (matcher.group(1) != null) {
                Object item$iv;
                ParamHintInfo it;
                Iterable $receiver$iv;
                caretOffset = realStartOffset;
                iterable = CollectionsKt.asReversedMutable((List)inlays);
                ArrayList list$iv = new ArrayList();
                Iterator iterator = $receiver$iv.iterator();
                while (iterator.hasNext() && (it = (ParamHintInfo)(item$iv = iterator.next())).getOffset() == caretOffset.intValue()) {
                    list$iv.add(item$iv);
                }
                $receiver$iv = list$iv;
                for (Object element$iv : $receiver$iv) {
                    ParamHintInfo it2 = (ParamHintInfo)element$iv;
                    int n = inlaysBeforeCaret;
                    inlaysBeforeCaret = n + 1;
                }
            } else if (matcher.group(2) != null) {
                selectionStart = realStartOffset;
            } else if (matcher.group(3) != null) {
                selectionEnd = realStartOffset;
            } else {
                iterable = inlays;
                String string = matcher.group(5);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"matcher.group(5)");
                ParamHintInfo paramHintInfo = new ParamHintInfo(realStartOffset, string, StringsKt.startsWith$default((String)matcher.group(4), (String)"H", (boolean)false, (int)2, null), StringsKt.endsWith$default((String)matcher.group(4), (String)"INT", (boolean)false, (int)2, null));
                iterable.add(paramHintInfo);
            }
            this.removeText(document, realStartOffset, matchedLength);
            extractedLength += matcher.end() - start;
        }
        return new CaretAndInlaysInfo(caretOffset, inlaysBeforeCaret, selectionStart == null || selectionEnd == null ? null : new TextRange(selectionStart.intValue(), selectionEnd.intValue()), inlays);
    }

    private final void removeText(Document document, int realStartOffset, int matchedLength) {
        WriteCommandAction.runWriteCommandAction((Project)this.myFixture.getProject(), (Runnable)new Runnable(document, realStartOffset, matchedLength){
            final /* synthetic */ Document $document;
            final /* synthetic */ int $realStartOffset;
            final /* synthetic */ int $matchedLength;

            public final void run() {
                this.$document.replaceString(this.$realStartOffset, this.$realStartOffset + this.$matchedLength, (CharSequence)"");
            }
            {
                this.$document = document;
                this.$realStartOffset = n;
                this.$matchedLength = n2;
            }
        });
    }

    public InlayHintsChecker(@NotNull CodeInsightTestFixture myFixture) {
        Intrinsics.checkParameterIsNotNull((Object)myFixture, (String)"myFixture");
        this.myFixture = myFixture;
    }

    static {
        Companion = new Companion(null);
        Pattern pattern = Pattern.compile("(<caret>)|(<selection>)|(</selection>)|<(hint|HINT|Hint|hINT)\\s+text=\"([^\"\n\r]+)\"\\s*/>");
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(\"(<caret\u2026=\\\"([^\\\"\\n\\r]+)\\\"\\\\s*/>\")");
        InlayHintsChecker.pattern = pattern;
        default = new ParameterNameHintsSettings();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsChecker$Companion;", "", "()V", "default", "Lcom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings;", "getDefault", "()Lcom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings;", "pattern", "Ljava/util/regex/Pattern;", "getPattern", "()Ljava/util/regex/Pattern;", "intellij.platform.testFramework"})
    public static final class Companion {
        @NotNull
        public final Pattern getPattern() {
            return pattern;
        }

        private final ParameterNameHintsSettings getDefault() {
            return default;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

