/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.testIntegration.ConfigurationsCollector;
import com.intellij.testIntegration.RecentTestsDataKt;
import com.intellij.testIntegration.RecentTestsPopupEntry;
import com.intellij.testIntegration.RunConfigurationEntry;
import com.intellij.testIntegration.SingleTestCollector;
import com.intellij.testIntegration.SingleTestEntry;
import com.intellij.testIntegration.SingleTestInfo;
import com.intellij.testIntegration.SuiteEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001aH\u0002J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0018J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/testIntegration/RecentTestsData;", "", "()V", "runConfigurationSuites", "Ljava/util/HashMap;", "", "Lcom/intellij/testIntegration/RunConfigurationEntry;", "Lkotlin/collections/HashMap;", "testsWithoutSuites", "Ljava/util/ArrayList;", "Lcom/intellij/testIntegration/SingleTestInfo;", "Lkotlin/collections/ArrayList;", "addSuite", "", "suite", "Lcom/intellij/testIntegration/SuiteEntry;", "addTest", "test", "Lcom/intellij/testIntegration/SingleTestEntry;", "findRunConfigurationSuite", "url", "runConfiguration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "getFailedTests", "", "allConfigurations", "", "getTestsToShow", "Lcom/intellij/testIntegration/RecentTestsPopupEntry;", "moveSuiteTestsToSuite", "intellij.java.execution.impl"})
public final class RecentTestsData {
    private final HashMap<String, RunConfigurationEntry> runConfigurationSuites;
    private ArrayList<SingleTestInfo> testsWithoutSuites;

    public final void addSuite(@NotNull SuiteEntry suite) {
        Intrinsics.checkParameterIsNotNull((Object)suite, (String)"suite");
        this.moveSuiteTestsToSuite(suite);
        String id = suite.getRunConfiguration().getUniqueID();
        RunConfigurationEntry entry = this.runConfigurationSuites.get(id);
        if (entry != null) {
            entry.addSuite(suite);
        } else {
            RunConfigurationEntry configurationEntry = new RunConfigurationEntry(suite.getRunConfiguration());
            configurationEntry.addSuite(suite);
            this.runConfigurationSuites.put(id, configurationEntry);
        }
    }

    private final void moveSuiteTestsToSuite(SuiteEntry suite) {
        RunnerAndConfigurationSettings suiteConfiguration = suite.getRunConfiguration();
        ArrayList<SingleTestInfo> filteredTests = new ArrayList<SingleTestInfo>();
        Iterable $receiver$iv = this.testsWithoutSuites;
        for (Object element$iv : $receiver$iv) {
            SingleTestInfo it = (SingleTestInfo)element$iv;
            if (RecentTestsDataKt.isMyTest(suite, it.getTest()) && Intrinsics.areEqual((Object)suiteConfiguration.getName(), (Object)it.getRunConfigurationName())) {
                suite.addTest(it.getTest());
                continue;
            }
            filteredTests.add(it);
        }
        this.testsWithoutSuites = filteredTests;
    }

    public final void addTest(@NotNull SingleTestEntry test) {
        Intrinsics.checkParameterIsNotNull((Object)test, (String)"test");
        SuiteEntry suiteEntry = this.findRunConfigurationSuite(test.getUrl(), test.getRunConfiguration());
        if (suiteEntry != null) {
            suiteEntry.addTest(test);
        } else {
            String string = test.getRunConfiguration().getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"test.runConfiguration.name");
            this.testsWithoutSuites.add(new SingleTestInfo(test, string));
        }
    }

    private final SuiteEntry findRunConfigurationSuite(String url, RunnerAndConfigurationSettings runConfiguration) {
        RunConfigurationEntry runConfigurationEntry = this.runConfigurationSuites.get(runConfiguration.getUniqueID());
        if (runConfigurationEntry == null) {
            return null;
        }
        RunConfigurationEntry pack = runConfigurationEntry;
        String testName = VirtualFileManager.extractPath((String)url);
        Iterable $receiver$iv = pack.getSuites();
        for (Object element$iv : $receiver$iv) {
            SuiteEntry it = (SuiteEntry)element$iv;
            String string = it.getSuiteName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.suiteName");
            if (!StringsKt.startsWith$default((String)testName, (String)string, (boolean)false, (int)2, null)) continue;
            return it;
        }
        return null;
    }

    @NotNull
    public final List<RecentTestsPopupEntry> getTestsToShow() {
        SingleTestEntry it;
        Collection<SingleTestEntry> collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable $receiver$iv$iv2;
        Object element$iv2;
        Collection<RunConfigurationEntry> allConfigurations;
        Collection<RunConfigurationEntry> collection2 = allConfigurations = this.runConfigurationSuites.values();
        Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"allConfigurations");
        List<SingleTestEntry> failedTests = this.getFailedTests(collection2);
        ConfigurationsCollector configsCollector = new ConfigurationsCollector();
        Iterable $receiver$iv2 = allConfigurations;
        for (Object element$iv2 : $receiver$iv2) {
            RunConfigurationEntry it2 = (RunConfigurationEntry)element$iv2;
            it2.accept(configsCollector);
        }
        Iterable $receiver$iv3 = configsCollector.getEntries();
        element$iv2 = $receiver$iv3;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            RecentTestsPopupEntry it3 = (RecentTestsPopupEntry)element$iv$iv;
            if (!(!it3.getFailed())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List passedConfigurations = (List)destination$iv$iv;
        $receiver$iv$iv2 = this.testsWithoutSuites;
        Collection collection3 = CollectionsKt.plus((Collection)failedTests, (Iterable)passedConfigurations);
        destination$iv$iv = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            SingleTestInfo $i$a$1$filter = (SingleTestInfo)item$iv$iv;
            collection = destination$iv$iv2;
            SingleTestEntry singleTestEntry = ((SingleTestInfo)((Object)it)).getTest();
            collection.add(singleTestEntry);
        }
        collection = (List)destination$iv$iv2;
        $receiver$iv$iv = $receiver$iv = (Iterable)collection;
        destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (SingleTestEntry)element$iv$iv;
            if (!it.getFailed()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        collection = (List)destination$iv$iv2;
        List entriesToShow = CollectionsKt.plus((Collection)collection3, (Iterable)collection);
        Iterable iterable = $receiver$iv = (Iterable)entriesToShow;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                RecentTestsPopupEntry it = (RecentTestsPopupEntry)b;
                Comparable comparable = it.getRunDate();
                it = (RecentTestsPopupEntry)a;
                Comparable comparable2 = comparable;
                Date date = it.getRunDate();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)date);
            }
        };
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
    }

    /*
     * WARNING - void declaration
     */
    private final List<SingleTestEntry> getFailedTests(Collection<RunConfigurationEntry> allConfigurations) {
        void $receiver$iv$iv;
        Object element$iv2;
        SingleTestCollector testsCollector = new SingleTestCollector();
        Iterable $receiver$iv = allConfigurations;
        for (Object element$iv2 : $receiver$iv) {
            RunConfigurationEntry it = (RunConfigurationEntry)element$iv2;
            it.accept(testsCollector);
        }
        Iterable $receiver$iv2 = testsCollector.getTests();
        element$iv2 = $receiver$iv2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            SingleTestEntry it = (SingleTestEntry)element$iv$iv;
            if (!it.getFailed()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List failedTests = (List)destination$iv$iv;
        return failedTests;
    }

    public RecentTestsData() {
        RecentTestsData recentTestsData = this;
        Cloneable cloneable = new HashMap();
        recentTestsData.runConfigurationSuites = cloneable;
        recentTestsData = this;
        cloneable = new ArrayList();
        recentTestsData.testsWithoutSuites = cloneable;
    }
}

