/*
 * Decompiled with CFR 0.152.
 */
package io.nettyjarjar.handler.codec.serialization;

import io.nettyjarjar.buffer.ByteBuf;
import io.nettyjarjar.buffer.ByteBufOutputStream;
import io.nettyjarjar.channel.ChannelHandler;
import io.nettyjarjar.channel.ChannelHandlerContext;
import io.nettyjarjar.handler.codec.MessageToByteEncoder;
import io.nettyjarjar.handler.codec.serialization.CompactObjectOutputStream;
import java.io.Serializable;

@ChannelHandler.Sharable
public class ObjectEncoder
extends MessageToByteEncoder<Serializable> {
    private static final byte[] LENGTH_PLACEHOLDER = new byte[4];

    @Override
    protected void encode(ChannelHandlerContext ctx, Serializable msg, ByteBuf out) throws Exception {
        int startIdx = out.writerIndex();
        ByteBufOutputStream bout = new ByteBufOutputStream(out);
        bout.write(LENGTH_PLACEHOLDER);
        CompactObjectOutputStream oout = new CompactObjectOutputStream(bout);
        oout.writeObject(msg);
        oout.flush();
        oout.close();
        int endIdx = out.writerIndex();
        out.setInt(startIdx, endIdx - startIdx - 4);
    }
}

