/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.psi.PsiElement;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenPluginDomUtil;
import org.jetbrains.idea.maven.dom.converters.MavenDomSoftAwareConverter;
import org.jetbrains.idea.maven.dom.plugin.MavenDomMojo;
import org.jetbrains.idea.maven.dom.plugin.MavenDomPluginModel;

public class MavenPluginGoalConverter
extends ResolvingConverter<String>
implements MavenDomSoftAwareConverter {
    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        return this.getVariants(context).contains(s) ? s : null;
    }

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }

    @NotNull
    public Collection<String> getVariants(ConvertContext context) {
        MavenDomPluginModel model = MavenPluginDomUtil.getMavenPluginModel(context.getInvocationElement());
        if (model == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                MavenPluginGoalConverter.$$$reportNull$$$0(0);
            }
            return list;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (MavenDomMojo each : model.getMojos().getMojos()) {
            String goal = each.getGoal().getStringValue();
            if (goal == null) continue;
            result.add(goal);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            MavenPluginGoalConverter.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public PsiElement resolve(String text, ConvertContext context) {
        MavenDomPluginModel model = MavenPluginDomUtil.getMavenPluginModel(context.getInvocationElement());
        if (model == null) {
            return null;
        }
        for (MavenDomMojo each : model.getMojos().getMojos()) {
            String goal = each.getGoal().getStringValue();
            if (!text.equals(goal)) continue;
            return each.getXmlElement();
        }
        return super.resolve((Object)text, context);
    }

    @Override
    public boolean isSoft(@NotNull DomElement element) {
        if (element == null) {
            MavenPluginGoalConverter.$$$reportNull$$$0(2);
        }
        return MavenPluginDomUtil.getMavenPluginModel(element) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/converters/MavenPluginGoalConverter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/converters/MavenPluginGoalConverter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSoft";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

