/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.JavaContext;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaPsiVisitor {
    private static final int SAME_TYPE_COUNT = 8;
    private final Map<String, List<VisitingDetector>> methodDetectors = Maps.newHashMapWithExpectedSize((int)80);
    private final Map<String, List<VisitingDetector>> constructorDetectors = Maps.newHashMapWithExpectedSize((int)12);
    private final Map<String, List<VisitingDetector>> referenceDetectors = Maps.newHashMapWithExpectedSize((int)10);
    private final List<VisitingDetector> resourceFieldDetectors = new ArrayList<VisitingDetector>();
    private final List<VisitingDetector> allDetectors;
    private final List<VisitingDetector> fullTreeDetectors;
    private final Map<Class<? extends PsiElement>, List<VisitingDetector>> nodePsiTypeDetectors = new HashMap<Class<? extends PsiElement>, List<VisitingDetector>>(16);
    private final JavaParser parser;
    private final Map<String, List<VisitingDetector>> superClassDetectors = new HashMap<String, List<VisitingDetector>>();
    private boolean disposeUnitsAfterUse = true;

    /*
     * WARNING - void declaration
     */
    JavaPsiVisitor(JavaParser parser, List<Detector> detectors) {
        this.parser = parser;
        this.allDetectors = new ArrayList<VisitingDetector>(detectors.size());
        this.fullTreeDetectors = new ArrayList<VisitingDetector>(detectors.size());
        for (Detector detector : detectors) {
            List<String> list;
            List<String> types;
            List<String> list2;
            List<Class<? extends PsiElement>> nodePsiTypes;
            Detector.JavaPsiScanner javaPsiScanner = (Detector.JavaPsiScanner)((Object)detector);
            VisitingDetector v = new VisitingDetector(detector, javaPsiScanner);
            this.allDetectors.add(v);
            List<String> applicableSuperClasses = detector.applicableSuperClasses();
            if (applicableSuperClasses != null) {
                for (String string : applicableSuperClasses) {
                    List<VisitingDetector> list3 = this.superClassDetectors.get(string);
                    if (list3 == null) {
                        list3 = new ArrayList<VisitingDetector>(8);
                        this.superClassDetectors.put(string, list3);
                    }
                    list3.add(v);
                }
            }
            if ((nodePsiTypes = detector.getApplicablePsiTypes()) != null) {
                for (Class<? extends PsiElement> type : nodePsiTypes) {
                    void var11_19;
                    List<VisitingDetector> list4 = this.nodePsiTypeDetectors.get(type);
                    if (list4 == null) {
                        ArrayList arrayList = new ArrayList(8);
                        this.nodePsiTypeDetectors.put(type, arrayList);
                    }
                    var11_19.add(v);
                }
            }
            if ((list2 = detector.getApplicableMethodNames()) != null) {
                Class<? extends PsiElement> type;
                assert (list2 != Detector.XmlScanner.ALL);
                type = list2.iterator();
                while (type.hasNext()) {
                    String string = (String)type.next();
                    List<VisitingDetector> list5 = this.methodDetectors.get(string);
                    if (list5 == null) {
                        list5 = new ArrayList<VisitingDetector>(8);
                        this.methodDetectors.put(string, list5);
                    }
                    list5.add(v);
                }
            }
            if ((types = detector.getApplicableConstructorTypes()) != null) {
                assert (types != Detector.XmlScanner.ALL);
                for (String type : types) {
                    List<VisitingDetector> list6 = this.constructorDetectors.get(type);
                    if (list6 == null) {
                        list6 = new ArrayList<VisitingDetector>(8);
                        this.constructorDetectors.put(type, list6);
                    }
                    list6.add(v);
                }
            }
            if ((list = detector.getApplicableReferenceNames()) != null) {
                assert (list != Detector.XmlScanner.ALL);
                for (String name : list) {
                    List<VisitingDetector> list7 = this.referenceDetectors.get(name);
                    if (list7 == null) {
                        list7 = new ArrayList<VisitingDetector>(8);
                        this.referenceDetectors.put(name, list7);
                    }
                    list7.add(v);
                }
            }
            if (detector.appliesToResourceRefs()) {
                this.resourceFieldDetectors.add(v);
                continue;
            }
            if (applicableSuperClasses != null && !applicableSuperClasses.isEmpty() || list != null && !list.isEmpty() || nodePsiTypes != null && !nodePsiTypes.isEmpty() || types != null && !types.isEmpty()) continue;
            this.fullTreeDetectors.add(v);
        }
    }

    public void setDisposeUnitsAfterUse(boolean disposeUnitsAfterUse) {
        this.disposeUnitsAfterUse = disposeUnitsAfterUse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visitFile(JavaContext context) {
        try {
            PsiJavaFile javaFile = this.parser.parseJavaToPsi(context);
            if (javaFile == null) {
                return;
            }
            try {
                context.setJavaFile((PsiFile)javaFile);
                LintClient client = context.getClient();
                client.runReadAction(() -> {
                    for (VisitingDetector v : this.allDetectors) {
                        v.setContext(context);
                        v.getDetector().beforeCheckFile(context);
                    }
                });
                if (!this.superClassDetectors.isEmpty()) {
                    client.runReadAction(() -> {
                        SuperclassPsiVisitor visitor = new SuperclassPsiVisitor(context);
                        javaFile.accept((PsiElementVisitor)visitor);
                    });
                }
                for (VisitingDetector v : this.fullTreeDetectors) {
                    client.runReadAction(() -> {
                        JavaElementVisitor visitor = v.getVisitor();
                        javaFile.accept((PsiElementVisitor)visitor);
                    });
                }
                if (!(this.methodDetectors.isEmpty() && this.resourceFieldDetectors.isEmpty() && this.constructorDetectors.isEmpty() && this.referenceDetectors.isEmpty())) {
                    client.runReadAction(() -> {
                        DelegatingPsiVisitor visitor = new DelegatingPsiVisitor(context);
                        javaFile.accept((PsiElementVisitor)visitor);
                    });
                } else if (!this.nodePsiTypeDetectors.isEmpty()) {
                    client.runReadAction(() -> {
                        DispatchPsiVisitor visitor = new DispatchPsiVisitor();
                        javaFile.accept((PsiElementVisitor)visitor);
                    });
                }
                client.runReadAction(() -> {
                    for (VisitingDetector v : this.allDetectors) {
                        v.getDetector().afterCheckFile(context);
                    }
                });
            }
            finally {
                if (this.disposeUnitsAfterUse) {
                    this.parser.dispose(context, javaFile);
                }
                context.setJavaFile(null);
            }
        }
        catch (RuntimeException e) {
            LintDriver.handleDetectorError(context, context.getDriver(), e);
        }
    }

    public boolean prepare(List<JavaContext> contexts) {
        return this.parser.prepareJavaParse(contexts);
    }

    public void dispose() {
        this.parser.dispose();
    }

    private static Set<String> getInterfaceNames(Set<String> addTo, PsiClass cls) {
        for (PsiClass resolvedInterface : cls.getInterfaces()) {
            String name = resolvedInterface.getQualifiedName();
            if (addTo == null) {
                addTo = Sets.newHashSet();
            } else if (addTo.contains(name)) continue;
            addTo.add(name);
            JavaPsiVisitor.getInterfaceNames(addTo, resolvedInterface);
        }
        return addTo;
    }

    private class DelegatingPsiVisitor
    extends DispatchPsiVisitor {
        private final JavaContext mContext;
        private final boolean mVisitResources;
        private final boolean mVisitMethods;
        private final boolean mVisitConstructors;
        private final boolean mVisitReferences;

        public DelegatingPsiVisitor(JavaContext context) {
            this.mContext = context;
            this.mVisitMethods = !JavaPsiVisitor.this.methodDetectors.isEmpty();
            this.mVisitConstructors = !JavaPsiVisitor.this.constructorDetectors.isEmpty();
            this.mVisitResources = !JavaPsiVisitor.this.resourceFieldDetectors.isEmpty();
            this.mVisitReferences = !JavaPsiVisitor.this.referenceDetectors.isEmpty();
        }

        @Override
        public void visitReferenceElement(PsiJavaCodeReferenceElement element) {
            PsiElement referenced;
            List list;
            String name;
            if (this.mVisitReferences && (name = element.getReferenceName()) != null && (list = (List)JavaPsiVisitor.this.referenceDetectors.get(name)) != null && (referenced = element.resolve()) != null) {
                for (VisitingDetector v : list) {
                    Detector.JavaPsiScanner javaPsiScanner = v.getJavaScanner();
                    if (javaPsiScanner == null) continue;
                    javaPsiScanner.visitReference(this.mContext, v.getVisitor(), element, referenced);
                }
            }
            super.visitReferenceElement(element);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression node) {
            if (this.mVisitResources) {
                PsiElement grandParent;
                PsiElement parent;
                String name;
                PsiReferenceExpression reference;
                PsiReferenceExpression select;
                PsiElement qualifier = node.getQualifier();
                if (qualifier instanceof PsiReferenceExpression && (select = (PsiReferenceExpression)qualifier).getQualifier() instanceof PsiReferenceExpression && "R".equals((reference = (PsiReferenceExpression)select.getQualifier()).getReferenceName())) {
                    String typeName = select.getReferenceName();
                    name = node.getReferenceName();
                    ResourceType type = ResourceType.getEnum((String)typeName);
                    if (type != null) {
                        boolean isFramework = reference.getQualifier() instanceof PsiReferenceExpression && "android".equals(((PsiReferenceExpression)reference.getQualifier()).getReferenceName());
                        for (VisitingDetector v : JavaPsiVisitor.this.resourceFieldDetectors) {
                            Detector.JavaPsiScanner detector = v.getJavaScanner();
                            if (detector == null) continue;
                            detector.visitResourceReference(this.mContext, v.getVisitor(), (PsiElement)node, type, name, isFramework);
                        }
                    }
                }
                if (qualifier != null && "R".equals(node.getReferenceName()) && (parent = node.getParent()) instanceof PsiReferenceExpression && (grandParent = parent.getParent()) instanceof PsiReferenceExpression) {
                    PsiReferenceExpression select2 = (PsiReferenceExpression)grandParent;
                    name = select2.getReferenceName();
                    PsiElement typeOperand = select2.getQualifier();
                    if (name != null && typeOperand instanceof PsiReferenceExpression) {
                        ResourceType type;
                        PsiReferenceExpression typeSelect = (PsiReferenceExpression)typeOperand;
                        String typeName = typeSelect.getReferenceName();
                        ResourceType resourceType = type = typeName != null ? ResourceType.getEnum((String)typeName) : null;
                        if (type != null) {
                            boolean isFramework = qualifier.textMatches((CharSequence)"android");
                            for (VisitingDetector v : JavaPsiVisitor.this.resourceFieldDetectors) {
                                Detector.JavaPsiScanner detector = v.getJavaScanner();
                                if (detector == null) continue;
                                detector.visitResourceReference(this.mContext, v.getVisitor(), (PsiElement)node, type, name, isFramework);
                            }
                        }
                    }
                }
            }
            super.visitReferenceExpression(node);
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression node) {
            PsiMethod method;
            List list;
            String methodName;
            super.visitMethodCallExpression(node);
            if (this.mVisitMethods && (methodName = node.getMethodExpression().getReferenceName()) != null && (list = (List)JavaPsiVisitor.this.methodDetectors.get(methodName)) != null && (method = node.resolveMethod()) != null) {
                for (VisitingDetector v : list) {
                    Detector.JavaPsiScanner javaPsiScanner = v.getJavaScanner();
                    if (javaPsiScanner == null) continue;
                    javaPsiScanner.visitMethod(this.mContext, v.getVisitor(), node, method);
                }
            }
        }

        @Override
        public void visitNewExpression(PsiNewExpression node) {
            PsiMethod method;
            List list;
            String type;
            PsiJavaCodeReferenceElement typeReference;
            super.visitNewExpression(node);
            if (this.mVisitConstructors && (typeReference = node.getClassReference()) != null && (type = typeReference.getQualifiedName()) != null && (list = (List)JavaPsiVisitor.this.constructorDetectors.get(type)) != null && (method = node.resolveMethod()) != null) {
                for (VisitingDetector v : list) {
                    Detector.JavaPsiScanner javaPsiScanner = v.getJavaScanner();
                    if (javaPsiScanner == null) continue;
                    javaPsiScanner.visitConstructor(this.mContext, v.getVisitor(), node, method);
                }
            }
        }
    }

    private class DispatchPsiVisitor
    extends JavaRecursiveElementVisitor {
        private DispatchPsiVisitor() {
        }

        public void visitAnonymousClass(PsiAnonymousClass node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiAnonymousClass.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitAnonymousClass(node);
                }
            }
            super.visitAnonymousClass(node);
        }

        public void visitArrayAccessExpression(PsiArrayAccessExpression node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiArrayAccessExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitArrayAccessExpression(node);
                }
            }
            super.visitArrayAccessExpression(node);
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiArrayInitializerExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitArrayInitializerExpression(node);
                }
            }
            super.visitArrayInitializerExpression(node);
        }

        public void visitAssertStatement(PsiAssertStatement node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiAssertStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitAssertStatement(node);
                }
            }
            super.visitAssertStatement(node);
        }

        public void visitAssignmentExpression(PsiAssignmentExpression node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiAssignmentExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitAssignmentExpression(node);
                }
            }
            super.visitAssignmentExpression(node);
        }

        public void visitBinaryExpression(PsiBinaryExpression node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiBinaryExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitBinaryExpression(node);
                }
            }
            super.visitBinaryExpression(node);
        }

        public void visitBlockStatement(PsiBlockStatement node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiBlockStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitBlockStatement(node);
                }
            }
            super.visitBlockStatement(node);
        }

        public void visitBreakStatement(PsiBreakStatement node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiBreakStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitBreakStatement(node);
                }
            }
            super.visitBreakStatement(node);
        }

        public void visitClass(PsiClass node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiClass.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitClass(node);
                }
            }
            super.visitClass(node);
        }

        public void visitClassInitializer(PsiClassInitializer node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiClassInitializer.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitClassInitializer(node);
                }
            }
            super.visitClassInitializer(node);
        }

        public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiClassObjectAccessExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitClassObjectAccessExpression(node);
                }
            }
            super.visitClassObjectAccessExpression(node);
        }

        public void visitCodeBlock(PsiCodeBlock node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiCodeBlock.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitCodeBlock(node);
                }
            }
            super.visitCodeBlock(node);
        }

        public void visitConditionalExpression(PsiConditionalExpression node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiConditionalExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitConditionalExpression(node);
                }
            }
            super.visitConditionalExpression(node);
        }

        public void visitContinueStatement(PsiContinueStatement node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiContinueStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitContinueStatement(node);
                }
            }
            super.visitContinueStatement(node);
        }

        public void visitDeclarationStatement(PsiDeclarationStatement node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiDeclarationStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitDeclarationStatement(node);
                }
            }
            super.visitDeclarationStatement(node);
        }

        public void visitDocComment(PsiDocComment node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiDocComment.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitDocComment(node);
                }
            }
            super.visitDocComment(node);
        }

        public void visitDocTag(PsiDocTag node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiDocTag.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitDocTag(node);
                }
            }
            super.visitDocTag(node);
        }

        public void visitDocTagValue(PsiDocTagValue node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiDocTagValue.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitDocTagValue(node);
                }
            }
            super.visitDocTagValue(node);
        }

        public void visitDoWhileStatement(PsiDoWhileStatement node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiDoWhileStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitDoWhileStatement(node);
                }
            }
            super.visitDoWhileStatement(node);
        }

        public void visitEmptyStatement(PsiEmptyStatement node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiEmptyStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitEmptyStatement(node);
                }
            }
            super.visitEmptyStatement(node);
        }

        public void visitExpression(PsiExpression node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitExpression(node);
                }
            }
            super.visitExpression(node);
        }

        public void visitExpressionList(PsiExpressionList node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiExpressionList.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitExpressionList(node);
                }
            }
            super.visitExpressionList(node);
        }

        public void visitExpressionListStatement(PsiExpressionListStatement node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiExpressionListStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitExpressionListStatement(node);
                }
            }
            super.visitExpressionListStatement(node);
        }

        public void visitExpressionStatement(PsiExpressionStatement node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiExpressionStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitExpressionStatement(node);
                }
            }
            super.visitExpressionStatement(node);
        }

        public void visitField(PsiField node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiField.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitField(node);
                }
            }
            super.visitField(node);
        }

        public void visitForStatement(PsiForStatement node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiForStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitForStatement(node);
                }
            }
            super.visitForStatement(node);
        }

        public void visitForeachStatement(PsiForeachStatement node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiForeachStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitForeachStatement(node);
                }
            }
            super.visitForeachStatement(node);
        }

        public void visitIdentifier(PsiIdentifier node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiIdentifier.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitIdentifier(node);
                }
            }
            super.visitIdentifier(node);
        }

        public void visitIfStatement(PsiIfStatement node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiIfStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitIfStatement(node);
                }
            }
            super.visitIfStatement(node);
        }

        public void visitImportList(PsiImportList node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiImportList.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitImportList(node);
                }
            }
            super.visitImportList(node);
        }

        public void visitImportStatement(PsiImportStatement node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiImportStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitImportStatement(node);
                }
            }
            super.visitImportStatement(node);
        }

        public void visitImportStaticStatement(PsiImportStaticStatement node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiImportStaticStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitImportStaticStatement(node);
                }
            }
            super.visitImportStaticStatement(node);
        }

        public void visitInlineDocTag(PsiInlineDocTag node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiInlineDocTag.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitInlineDocTag(node);
                }
            }
            super.visitInlineDocTag(node);
        }

        public void visitInstanceOfExpression(PsiInstanceOfExpression node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiInstanceOfExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitInstanceOfExpression(node);
                }
            }
            super.visitInstanceOfExpression(node);
        }

        public void visitJavaToken(PsiJavaToken node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiJavaToken.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitJavaToken(node);
                }
            }
            super.visitJavaToken(node);
        }

        public void visitKeyword(PsiKeyword node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiKeyword.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitKeyword(node);
                }
            }
            super.visitKeyword(node);
        }

        public void visitLabeledStatement(PsiLabeledStatement node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiLabeledStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitLabeledStatement(node);
                }
            }
            super.visitLabeledStatement(node);
        }

        public void visitLiteralExpression(PsiLiteralExpression node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiLiteralExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitLiteralExpression(node);
                }
            }
            super.visitLiteralExpression(node);
        }

        public void visitLocalVariable(PsiLocalVariable node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiLocalVariable.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitLocalVariable(node);
                }
            }
            super.visitLocalVariable(node);
        }

        public void visitMethod(PsiMethod node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiMethod.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitMethod(node);
                }
            }
            super.visitMethod(node);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiMethodCallExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitMethodCallExpression(node);
                }
            }
            super.visitMethodCallExpression(node);
        }

        public void visitCallExpression(PsiCallExpression node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiCallExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitCallExpression(node);
                }
            }
            super.visitCallExpression(node);
        }

        public void visitModifierList(PsiModifierList node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiModifierList.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitModifierList(node);
                }
            }
            super.visitModifierList(node);
        }

        public void visitNewExpression(PsiNewExpression node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiNewExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitNewExpression(node);
                }
            }
            super.visitNewExpression(node);
        }

        public void visitPackage(PsiPackage node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiPackage.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitPackage(node);
                }
            }
            super.visitPackage(node);
        }

        public void visitPackageStatement(PsiPackageStatement node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiPackageStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitPackageStatement(node);
                }
            }
            super.visitPackageStatement(node);
        }

        public void visitParameter(PsiParameter node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiParameter.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitParameter(node);
                }
            }
            super.visitParameter(node);
        }

        public void visitReceiverParameter(PsiReceiverParameter node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiReceiverParameter.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitReceiverParameter(node);
                }
            }
            super.visitReceiverParameter(node);
        }

        public void visitParameterList(PsiParameterList node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiParameterList.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitParameterList(node);
                }
            }
            super.visitParameterList(node);
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiParenthesizedExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitParenthesizedExpression(node);
                }
            }
            super.visitParenthesizedExpression(node);
        }

        public void visitPostfixExpression(PsiPostfixExpression node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiPostfixExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitPostfixExpression(node);
                }
            }
            super.visitPostfixExpression(node);
        }

        public void visitPrefixExpression(PsiPrefixExpression node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiPrefixExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitPrefixExpression(node);
                }
            }
            super.visitPrefixExpression(node);
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiJavaCodeReferenceElement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitReferenceElement(node);
                }
            }
            super.visitReferenceElement(node);
        }

        public void visitImportStaticReferenceElement(PsiImportStaticReferenceElement node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiImportStaticReferenceElement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitImportStaticReferenceElement(node);
                }
            }
            super.visitImportStaticReferenceElement(node);
        }

        public void visitReferenceExpression(PsiReferenceExpression node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiReferenceExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitReferenceExpression(node);
                }
            }
            super.visitReferenceExpression(node);
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiMethodReferenceExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitMethodReferenceExpression(node);
                }
            }
            super.visitMethodReferenceExpression(node);
        }

        public void visitReferenceList(PsiReferenceList node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiReferenceList.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitReferenceList(node);
                }
            }
            super.visitReferenceList(node);
        }

        public void visitReferenceParameterList(PsiReferenceParameterList node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiReferenceParameterList.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitReferenceParameterList(node);
                }
            }
            super.visitReferenceParameterList(node);
        }

        public void visitTypeParameterList(PsiTypeParameterList node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiTypeParameterList.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitTypeParameterList(node);
                }
            }
            super.visitTypeParameterList(node);
        }

        public void visitReturnStatement(PsiReturnStatement node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiReturnStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitReturnStatement(node);
                }
            }
            super.visitReturnStatement(node);
        }

        public void visitStatement(PsiStatement node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitStatement(node);
                }
            }
            super.visitStatement(node);
        }

        public void visitSuperExpression(PsiSuperExpression node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiSuperExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitSuperExpression(node);
                }
            }
            super.visitSuperExpression(node);
        }

        public void visitSwitchLabelStatement(PsiSwitchLabelStatement node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiSwitchLabelStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitSwitchLabelStatement(node);
                }
            }
            super.visitSwitchLabelStatement(node);
        }

        public void visitSwitchStatement(PsiSwitchStatement node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiSwitchStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitSwitchStatement(node);
                }
            }
            super.visitSwitchStatement(node);
        }

        public void visitSynchronizedStatement(PsiSynchronizedStatement node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiSynchronizedStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitSynchronizedStatement(node);
                }
            }
            super.visitSynchronizedStatement(node);
        }

        public void visitThisExpression(PsiThisExpression node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiThisExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitThisExpression(node);
                }
            }
            super.visitThisExpression(node);
        }

        public void visitThrowStatement(PsiThrowStatement node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiThrowStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitThrowStatement(node);
                }
            }
            super.visitThrowStatement(node);
        }

        public void visitTryStatement(PsiTryStatement node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiTryStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitTryStatement(node);
                }
            }
            super.visitTryStatement(node);
        }

        public void visitCatchSection(PsiCatchSection node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiCatchSection.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitCatchSection(node);
                }
            }
            super.visitCatchSection(node);
        }

        public void visitResourceList(PsiResourceList node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiResourceList.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitResourceList(node);
                }
            }
            super.visitResourceList(node);
        }

        public void visitResourceVariable(PsiResourceVariable node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiResourceVariable.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitResourceVariable(node);
                }
            }
            super.visitResourceVariable(node);
        }

        public void visitTypeElement(PsiTypeElement node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiTypeElement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitTypeElement(node);
                }
            }
            super.visitTypeElement(node);
        }

        public void visitTypeCastExpression(PsiTypeCastExpression node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiTypeCastExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitTypeCastExpression(node);
                }
            }
            super.visitTypeCastExpression(node);
        }

        public void visitVariable(PsiVariable node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiVariable.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitVariable(node);
                }
            }
            super.visitVariable(node);
        }

        public void visitWhileStatement(PsiWhileStatement node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiWhileStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitWhileStatement(node);
                }
            }
            super.visitWhileStatement(node);
        }

        public void visitJavaFile(PsiJavaFile node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiJavaFile.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitJavaFile(node);
                }
            }
            super.visitJavaFile(node);
        }

        public void visitImplicitVariable(ImplicitVariable node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(ImplicitVariable.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitImplicitVariable(node);
                }
            }
            super.visitImplicitVariable(node);
        }

        public void visitDocToken(PsiDocToken node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiDocToken.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitDocToken(node);
                }
            }
            super.visitDocToken(node);
        }

        public void visitTypeParameter(PsiTypeParameter node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiTypeParameter.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitTypeParameter(node);
                }
            }
            super.visitTypeParameter(node);
        }

        public void visitAnnotation(PsiAnnotation node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiAnnotation.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitAnnotation(node);
                }
            }
            super.visitAnnotation(node);
        }

        public void visitAnnotationParameterList(PsiAnnotationParameterList node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiAnnotationParameterList.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitAnnotationParameterList(node);
                }
            }
            super.visitAnnotationParameterList(node);
        }

        public void visitAnnotationArrayInitializer(PsiArrayInitializerMemberValue node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiArrayInitializerMemberValue.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitAnnotationArrayInitializer(node);
                }
            }
            super.visitAnnotationArrayInitializer(node);
        }

        public void visitNameValuePair(PsiNameValuePair node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiNameValuePair.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitNameValuePair(node);
                }
            }
            super.visitNameValuePair(node);
        }

        public void visitAnnotationMethod(PsiAnnotationMethod node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiAnnotationMethod.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitAnnotationMethod(node);
                }
            }
            super.visitAnnotationMethod(node);
        }

        public void visitEnumConstant(PsiEnumConstant node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiEnumConstant.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitEnumConstant(node);
                }
            }
            super.visitEnumConstant(node);
        }

        public void visitEnumConstantInitializer(PsiEnumConstantInitializer node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiEnumConstantInitializer.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitEnumConstantInitializer(node);
                }
            }
            super.visitEnumConstantInitializer(node);
        }

        public void visitPolyadicExpression(PsiPolyadicExpression node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiPolyadicExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitPolyadicExpression(node);
                }
            }
            super.visitPolyadicExpression(node);
        }

        public void visitLambdaExpression(PsiLambdaExpression node) {
            List list = (List)JavaPsiVisitor.this.nodePsiTypeDetectors.get(PsiLambdaExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitLambdaExpression(node);
                }
            }
            super.visitLambdaExpression(node);
        }
    }

    private class SuperclassPsiVisitor
    extends JavaRecursiveElementVisitor {
        private final JavaContext mContext;

        public SuperclassPsiVisitor(JavaContext context) {
            this.mContext = context;
        }

        public void visitClass(PsiClass node) {
            super.visitClass(node);
            this.checkClass(node);
        }

        private void checkClass(PsiClass node) {
            if (node instanceof PsiTypeParameter) {
                return;
            }
            int depth = 0;
            for (PsiClass cls = node; cls != null; cls = cls.getSuperClass()) {
                Set interfaceNames;
                List list = (List)JavaPsiVisitor.this.superClassDetectors.get(cls.getQualifiedName());
                if (list != null) {
                    for (VisitingDetector v : list) {
                        Detector.JavaPsiScanner javaPsiScanner = v.getJavaScanner();
                        if (javaPsiScanner == null) continue;
                        javaPsiScanner.checkClass(this.mContext, node);
                    }
                }
                if ((interfaceNames = JavaPsiVisitor.getInterfaceNames(null, cls)) == null) continue;
                for (String name : interfaceNames) {
                    list = (List)JavaPsiVisitor.this.superClassDetectors.get(name);
                    if (list == null) continue;
                    for (VisitingDetector v : list) {
                        Detector.JavaPsiScanner javaPsiScanner = v.getJavaScanner();
                        if (javaPsiScanner == null) continue;
                        javaPsiScanner.checkClass(this.mContext, node);
                    }
                }
                if (++depth != 500) continue;
                break;
            }
        }
    }

    private static class VisitingDetector {
        private JavaElementVisitor mVisitor;
        private JavaContext mContext;
        public final Detector mDetector;
        public final Detector.JavaPsiScanner mJavaScanner;

        public VisitingDetector(Detector detector, Detector.JavaPsiScanner javaScanner) {
            this.mDetector = detector;
            this.mJavaScanner = javaScanner;
        }

        public Detector getDetector() {
            return this.mDetector;
        }

        public Detector.JavaPsiScanner getJavaScanner() {
            return this.mJavaScanner;
        }

        public void setContext(JavaContext context) {
            this.mContext = context;
            this.mVisitor = null;
        }

        JavaElementVisitor getVisitor() {
            if (this.mVisitor == null) {
                this.mVisitor = this.mDetector.createPsiVisitor(this.mContext);
                assert (!(this.mVisitor instanceof JavaRecursiveElementVisitor)) : "Your visitor (returned by " + this.mDetector.getClass().getSimpleName() + "#createPsiVisitor(...) should *not* extend  JavaRecursiveElementVisitor; use a plain JavaElementVisitor instead. The lint infrastructure does its own recursion calling *just* your visit methods specified in getApplicablePsiTypes";
                if (this.mVisitor == null) {
                    this.mVisitor = new JavaElementVisitor(){

                        public void visitElement(PsiElement element) {
                        }
                    };
                }
            }
            return this.mVisitor;
        }
    }
}

