/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor.fonts;

import com.intellij.application.options.colors.AbstractFontOptionsPanel;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.ModifiableFontPreferences;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class AppEditorFontOptionsPanel
extends AbstractFontOptionsPanel {
    private final EditorColorsScheme myScheme;
    private JPanel myWarningPanel;
    private JLabel myEditorFontLabel;
    private JButton myRestoreButton;
    private final FontPreferences myDefaultPreferences;

    protected AppEditorFontOptionsPanel(EditorColorsScheme scheme2) {
        this.myScheme = scheme2;
        this.myDefaultPreferences = new FontPreferencesImpl();
        AppEditorFontOptions.initDefaults((ModifiableFontPreferences)this.myDefaultPreferences);
        this.updateOptionsList();
    }

    @Override
    protected JComponent createControls() {
        JPanel topPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = JBUI.emptyInsets();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        this.myWarningPanel = this.createMessagePanel();
        topPanel.add((Component)this.myWarningPanel, c);
        c.gridy = 1;
        topPanel.add((Component)this.createFontSettingsPanel(), c);
        c.insets = JBUI.insets((int)5, (int)0, (int)0, (int)0);
        c.fill = 2;
        c.gridy = 2;
        topPanel.add((Component)new JSeparator(), c);
        c.gridy = 3;
        c.fill = 0;
        this.myRestoreButton = new JButton(ApplicationBundle.message((String)"settings.editor.font.restored.defaults", (Object[])new Object[0]));
        this.myRestoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppEditorFontOptionsPanel.this.restoreDefaults();
            }
        });
        this.addListener(new ColorAndFontSettingsListener.Abstract(){

            @Override
            public void fontChanged() {
                AppEditorFontOptionsPanel.this.updateWarning();
                AppEditorFontOptionsPanel.this.updateRestoreButtonState();
            }
        });
        topPanel.add((Component)this.myRestoreButton, c);
        return topPanel;
    }

    private void restoreDefaults() {
        AppEditorFontOptions.initDefaults((ModifiableFontPreferences)this.getFontPreferences());
        this.updateOnChangedFont();
    }

    public void updateOnChangedFont() {
        this.updateOptionsList();
        this.fireFontChanged();
    }

    private void updateRestoreButtonState() {
        this.myRestoreButton.setEnabled(!this.myDefaultPreferences.equals(this.getFontPreferences()));
    }

    private JPanel createMessagePanel() {
        JPanel messagePanel = new JPanel(new FlowLayout(0));
        messagePanel.add(new JLabel(AllIcons.General.BalloonWarning));
        this.myEditorFontLabel = this.createHyperlinkLabel();
        messagePanel.add(this.myEditorFontLabel);
        JLabel commentLabel = new JLabel(ApplicationBundle.message((String)"settings.editor.font.defined.in.color.scheme.message", (Object[])new Object[0]));
        commentLabel.setForeground((Color)JBColor.GRAY);
        messagePanel.add(commentLabel);
        return messagePanel;
    }

    public void updateWarning() {
        EditorColorsScheme scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
        if (!scheme2.isUseAppFontPreferencesInEditor()) {
            this.myEditorFontLabel.setText(ApplicationBundle.message((String)"settings.editor.font.overridden.message", (Object[])new Object[]{scheme2.getEditorFontName(), scheme2.getEditorFontSize()}));
            this.myWarningPanel.setVisible(true);
        } else {
            this.myWarningPanel.setVisible(false);
        }
    }

    @Override
    protected boolean isReadOnly() {
        return false;
    }

    @Override
    protected boolean isDelegating() {
        return false;
    }

    @Override
    @NotNull
    protected FontPreferences getFontPreferences() {
        FontPreferences fontPreferences = this.myScheme.getFontPreferences();
        if (fontPreferences == null) {
            AppEditorFontOptionsPanel.$$$reportNull$$$0(0);
        }
        return fontPreferences;
    }

    @Override
    protected void setFontSize(int fontSize) {
        this.myScheme.setEditorFontSize(fontSize);
    }

    @Override
    protected float getLineSpacing() {
        return this.myScheme.getLineSpacing();
    }

    @Override
    protected void setCurrentLineSpacing(float lineSpacing) {
        this.myScheme.setLineSpacing(lineSpacing);
    }

    @NotNull
    private JLabel createHyperlinkLabel() {
        HoverHyperlinkLabel label = new HoverHyperlinkLabel("");
        label.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    AppEditorFontOptionsPanel.this.navigateToColorSchemeFontConfigurable();
                }
            }
        });
        HoverHyperlinkLabel hoverHyperlinkLabel = label;
        if (hoverHyperlinkLabel == null) {
            AppEditorFontOptionsPanel.$$$reportNull$$$0(1);
        }
        return hoverHyperlinkLabel;
    }

    protected void navigateToColorSchemeFontConfigurable() {
        SearchableConfigurable fontOptions;
        Configurable colorSchemeConfigurable;
        Settings allSettings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)this.getPanel()));
        if (allSettings != null && (colorSchemeConfigurable = allSettings.find("reference.settingsdialog.IDE.editor.colors")) instanceof ColorAndFontOptions && (fontOptions = ((ColorAndFontOptions)colorSchemeConfigurable).findSubConfigurable("Color Scheme Font")) != null) {
            allSettings.select((Configurable)fontOptions);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/application/options/editor/fonts/AppEditorFontOptionsPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontPreferences";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createHyperlinkLabel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

