/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.ActionTracker;
import com.intellij.codeInsight.completion.AsyncCompletion;
import com.intellij.codeInsight.completion.AutoCompletionContext;
import com.intellij.codeInsight.completion.AutoCompletionDecision;
import com.intellij.codeInsight.completion.CompletionAssertions;
import com.intellij.codeInsight.completion.CompletionConfidence;
import com.intellij.codeInsight.completion.CompletionConfidenceEP;
import com.intellij.codeInsight.completion.CompletionContext;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.OffsetTranslator;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.codeInsight.completion.StatisticsUpdate;
import com.intellij.codeInsight.completion.actions.BaseCodeCompletionAction;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessors;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.util.ThreeState;
import java.awt.Component;
import java.lang.ref.Reference;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeCompletionHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.CodeCompletionHandlerBase");
    private static final Key<Boolean> CARET_PROCESSED = Key.create((String)"CodeCompletionHandlerBase.caretProcessed");
    @NotNull
    final CompletionType completionType;
    final boolean invokedExplicitly;
    final boolean synchronous;
    final boolean autopopup;
    private static int ourAutoInsertItemTimeout = 2000;
    private static final Key<SoftReference<Pair<PsiFile, Document>>> FILE_COPY_KEY = Key.create((String)"CompletionFileCopy");

    public static CodeCompletionHandlerBase createHandler(@NotNull CompletionType completionType) {
        if (completionType == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(0);
        }
        return CodeCompletionHandlerBase.createHandler(completionType, true, false, true);
    }

    public static CodeCompletionHandlerBase createHandler(@NotNull CompletionType completionType, boolean invokedExplicitly, boolean autopopup, boolean synchronous) {
        if (completionType == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(1);
        }
        AnAction codeCompletionAction = ActionManager.getInstance().getAction("CodeCompletion");
        assert (codeCompletionAction instanceof BaseCodeCompletionAction);
        BaseCodeCompletionAction baseCodeCompletionAction = (BaseCodeCompletionAction)codeCompletionAction;
        return baseCodeCompletionAction.createHandler(completionType, invokedExplicitly, autopopup, synchronous);
    }

    public CodeCompletionHandlerBase(@NotNull CompletionType completionType) {
        if (completionType == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(2);
        }
        this(completionType, true, false, true);
    }

    public CodeCompletionHandlerBase(@NotNull CompletionType completionType, boolean invokedExplicitly, boolean autopopup, boolean synchronous) {
        if (completionType == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(3);
        }
        this.completionType = completionType;
        this.invokedExplicitly = invokedExplicitly;
        this.autopopup = autopopup;
        this.synchronous = synchronous;
        if (invokedExplicitly) assert (synchronous);
        if (autopopup) assert (!invokedExplicitly);
    }

    public final void invokeCompletion(Project project, Editor editor) {
        try {
            this.invokeCompletion(project, editor, 1);
        }
        catch (IndexNotReadyException e) {
            DumbService.getInstance((Project)project).showDumbModeNotification("Code completion is not available here while indices are being built");
        }
    }

    public final void invokeCompletion(@NotNull Project project, @NotNull Editor editor, int time) {
        if (project == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(5);
        }
        this.invokeCompletion(project, editor, time, false, false);
    }

    public final void invokeCompletion(@NotNull Project project, @NotNull Editor editor, int time, boolean hasModifiers, boolean restarted) {
        if (project == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(7);
        }
        CodeCompletionHandlerBase.clearCaretMarkers(editor);
        this.invokeCompletion(project, editor, time, hasModifiers, restarted, editor.getCaretModel().getPrimaryCaret());
    }

    public final void invokeCompletion(@NotNull Project project, @NotNull Editor editor, int time, boolean hasModifiers, boolean restarted, @NotNull Caret caret) {
        if (project == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(9);
        }
        if (caret == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(10);
        }
        CodeCompletionHandlerBase.markCaretAsProcessed(caret);
        if (this.invokedExplicitly) {
            StatisticsUpdate.applyLastCompletionStatisticsUpdate();
        }
        CodeCompletionHandlerBase.checkNoWriteAccess();
        CompletionAssertions.checkEditorValid(editor);
        int offset = editor.getCaretModel().getOffset();
        if (editor.isViewer() || editor.getDocument().getRangeGuard(offset, offset) != null) {
            editor.getDocument().fireReadOnlyModificationAttempt();
            EditorModificationUtil.checkModificationAllowed((Editor)editor);
            return;
        }
        if (!FileDocumentManager.getInstance().requestWriting(editor.getDocument(), project)) {
            return;
        }
        CompletionPhase phase = CompletionServiceImpl.getCompletionPhase();
        boolean repeated = phase.indicator != null && phase.indicator.isRepeatedInvocation(this.completionType, editor);
        int newTime = phase.newCompletionStarted(time, repeated);
        if (this.invokedExplicitly) {
            time = newTime;
        }
        int invocationCount = time;
        if (CompletionServiceImpl.isPhase(CompletionPhase.InsertedSingleItem.class)) {
            CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
        }
        CompletionServiceImpl.assertPhase(CompletionPhase.NoCompletion.getClass(), CompletionPhase.CommittingDocuments.class);
        if (invocationCount > 1 && this.completionType == CompletionType.BASIC) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.second.basic");
        }
        Runnable initCmd = () -> {
            if (editor == null) {
                CodeCompletionHandlerBase.$$$reportNull$$$0(22);
            }
            if (project == null) {
                CodeCompletionHandlerBase.$$$reportNull$$$0(23);
            }
            if (caret == null) {
                CodeCompletionHandlerBase.$$$reportNull$$$0(24);
            }
            CompletionInitializationContext context = (CompletionInitializationContext)WriteAction.compute(() -> {
                if (editor == null) {
                    CodeCompletionHandlerBase.$$$reportNull$$$0(25);
                }
                if (project == null) {
                    CodeCompletionHandlerBase.$$$reportNull$$$0(26);
                }
                if (caret == null) {
                    CodeCompletionHandlerBase.$$$reportNull$$$0(27);
                }
                EditorUtil.fillVirtualSpaceUntilCaret(editor);
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                CompletionAssertions.checkEditorValid(editor);
                PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Caret)caret, (Project)project);
                assert (psiFile != null) : "no PSI file: " + FileDocumentManager.getInstance().getFile(editor.getDocument());
                psiFile.putUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING, (Object)Boolean.TRUE);
                CompletionAssertions.assertCommitSuccessful(editor, psiFile);
                return this.runContributorsBeforeCompletion(editor, psiFile, invocationCount, caret);
            });
            this.doComplete(context, hasModifiers);
        };
        if (this.autopopup) {
            CommandProcessor.getInstance().runUndoTransparentAction(initCmd);
        } else {
            CommandProcessor.getInstance().executeCommand(project, initCmd, null, null);
        }
    }

    private CompletionInitializationContext runContributorsBeforeCompletion(Editor editor, PsiFile psiFile, int invocationCount, @NotNull Caret caret) {
        if (caret == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(11);
        }
        final Ref current = Ref.create(null);
        CompletionInitializationContext context = new CompletionInitializationContext(editor, caret, psiFile, this.completionType, invocationCount){
            CompletionContributor dummyIdentifierChanger;

            public void setDummyIdentifier(@NotNull String dummyIdentifier) {
                if (dummyIdentifier == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.setDummyIdentifier(dummyIdentifier);
                if (this.dummyIdentifierChanger != null) {
                    LOG.error("Changing the dummy identifier twice, already changed by " + this.dummyIdentifierChanger);
                }
                this.dummyIdentifierChanger = (CompletionContributor)current.get();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dummyIdentifier", "com/intellij/codeInsight/completion/CodeCompletionHandlerBase$1", "setDummyIdentifier"));
            }
        };
        Project project = psiFile.getProject();
        for (CompletionContributor contributor : CompletionContributor.forLanguageHonorDumbness((Language)context.getPositionLanguage(), (Project)project)) {
            current.set((Object)contributor);
            contributor.beforeCompletion(context);
            CompletionAssertions.checkEditorValid(editor);
            assert (!PsiDocumentManager.getInstance((Project)project).isUncommited(editor.getDocument())) : "Contributor " + contributor + " left the document uncommitted";
        }
        return context;
    }

    private static void checkNoWriteAccess() {
        if (!ApplicationManager.getApplication().isUnitTestMode() && ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new AssertionError((Object)"Completion should not be invoked inside write action");
        }
    }

    private static boolean shouldSkipAutoPopup(Editor editor, PsiFile psiFile) {
        int offset = editor.getCaretModel().getOffset();
        int psiOffset = Math.max(0, offset - 1);
        PsiElement elementAt = InjectedLanguageManager.getInstance((Project)psiFile.getProject()).findInjectedElementAt(psiFile, psiOffset);
        if (elementAt == null) {
            elementAt = psiFile.findElementAt(psiOffset);
        }
        if (elementAt == null) {
            return true;
        }
        Language language = PsiUtilCore.findLanguageFromElement((PsiElement)elementAt);
        for (CompletionConfidence confidence : CompletionConfidenceEP.forLanguage((Language)language)) {
            ThreeState result2 = confidence.shouldSkipAutopopup(elementAt, psiFile, offset);
            if (result2 == ThreeState.UNSURE) continue;
            LOG.debug(confidence + " has returned shouldSkipAutopopup=" + result2);
            return result2 == ThreeState.YES;
        }
        return false;
    }

    @NotNull
    private LookupImpl obtainLookup(Editor editor, Project project) {
        CompletionAssertions.checkEditorValid(editor);
        LookupImpl existing = (LookupImpl)LookupManager.getActiveLookup(editor);
        if (existing != null && existing.isCompletion()) {
            existing.markReused();
            if (!this.autopopup) {
                existing.setFocusDegree(LookupImpl.FocusDegree.FOCUSED);
            }
            LookupImpl lookupImpl = existing;
            if (lookupImpl == null) {
                CodeCompletionHandlerBase.$$$reportNull$$$0(12);
            }
            return lookupImpl;
        }
        LookupImpl lookup = (LookupImpl)LookupManager.getInstance(project).createLookup(editor, LookupElement.EMPTY_ARRAY, "", new LookupArranger.DefaultArranger());
        if (editor.isOneLineMode()) {
            lookup.setCancelOnClickOutside(true);
            lookup.setCancelOnOtherWindowOpen(true);
        }
        lookup.setFocusDegree(this.autopopup ? LookupImpl.FocusDegree.UNFOCUSED : LookupImpl.FocusDegree.FOCUSED);
        LookupImpl lookupImpl = lookup;
        if (lookupImpl == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(13);
        }
        return lookupImpl;
    }

    private void doComplete(CompletionInitializationContext initContext, boolean hasModifiers) {
        Editor editor = initContext.getEditor();
        CompletionAssertions.checkEditorValid(editor);
        OffsetsInFile hostOffsets = new OffsetsInFile(initContext.getFile(), initContext.getOffsetMap()).toTopLevelFile();
        LookupImpl lookup = this.obtainLookup(editor, initContext.getProject());
        CompletionPhase phase = CompletionServiceImpl.getCompletionPhase();
        if (phase instanceof CompletionPhase.CommittingDocuments) {
            if (phase.indicator != null) {
                phase.indicator.closeAndFinish(false);
            }
            ((CompletionPhase.CommittingDocuments)phase).replaced = true;
        } else {
            CompletionServiceImpl.assertPhase(CompletionPhase.NoCompletion.getClass());
        }
        CompletionProgressIndicator indicator = new CompletionProgressIndicator(editor, initContext.getCaret(), initContext.getInvocationCount(), this, initContext.getOffsetMap(), hostOffsets, hasModifiers, lookup);
        CompletionServiceImpl.setCompletionPhase(this.synchronous ? new CompletionPhase.Synchronous(indicator) : new CompletionPhase.BgCalculation(indicator));
        indicator.getCompletionThreading().startThread(indicator, () -> AsyncCompletion.tryReadOrCancel(indicator, () -> {
            CompletionParameters parameters = this.prepareCompletionParameters(initContext, indicator);
            if (parameters != null) {
                indicator.runContributors(initContext, parameters);
            }
        }));
        if (!this.synchronous) {
            return;
        }
        indicator.makeSureLookupIsShown(ourAutoInsertItemTimeout);
        if (indicator.blockingWaitForFinish(ourAutoInsertItemTimeout)) {
            try {
                indicator.getLookup().refreshUi(true, false);
            }
            catch (Exception e) {
                CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                LOG.error((Throwable)e);
                return;
            }
            this.completionFinished(indicator, hasModifiers);
            return;
        }
        CompletionServiceImpl.setCompletionPhase(new CompletionPhase.BgCalculation(indicator));
        indicator.showLookup();
    }

    @Nullable
    private CompletionParameters prepareCompletionParameters(CompletionInitializationContext initContext, CompletionProgressIndicator indicator) {
        if (this.autopopup && CodeCompletionHandlerBase.shouldSkipAutoPopup(initContext.getEditor(), initContext.getFile())) {
            return null;
        }
        OffsetsInFile hostCopyOffsets = CodeCompletionHandlerBase.insertDummyIdentifier(initContext, indicator, indicator.getHostOffsets());
        if (hostCopyOffsets == null) {
            return null;
        }
        indicator.registerChildDisposable(hostCopyOffsets::getOffsets);
        OffsetsInFile finalOffsets = CodeCompletionHandlerBase.toInjectedIfAny(initContext.getFile(), hostCopyOffsets);
        indicator.registerChildDisposable(finalOffsets::getOffsets);
        return this.createCompletionParameters(initContext, indicator, finalOffsets);
    }

    @NotNull
    private CompletionParameters createCompletionParameters(CompletionInitializationContext initContext, CompletionProgressIndicator indicator, OffsetsInFile finalOffsets) {
        int offset = finalOffsets.getOffsets().getOffset(CompletionInitializationContext.START_OFFSET);
        PsiFile fileCopy = finalOffsets.getFile();
        PsiFile originalFile = fileCopy.getOriginalFile();
        PsiElement insertedElement = CodeCompletionHandlerBase.findCompletionPositionLeaf(finalOffsets, offset, originalFile);
        insertedElement.putUserData(CompletionContext.COMPLETION_CONTEXT_KEY, (Object)new CompletionContext(fileCopy, finalOffsets.getOffsets()));
        CompletionParameters completionParameters = new CompletionParameters(insertedElement, originalFile, this.completionType, offset, initContext.getInvocationCount(), initContext.getEditor(), (CompletionProcess)indicator);
        if (completionParameters == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(14);
        }
        return completionParameters;
    }

    @NotNull
    private static PsiElement findCompletionPositionLeaf(OffsetsInFile offsets, int offset, PsiFile originalFile) {
        PsiElement insertedElement = offsets.getFile().findElementAt(offset);
        CompletionAssertions.assertCompletionPositionPsiConsistent(offsets, offset, originalFile, insertedElement);
        PsiElement psiElement = insertedElement;
        if (psiElement == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(15);
        }
        return psiElement;
    }

    private static void checkNotSync(CompletionProgressIndicator indicator, List<LookupElement> allItems) {
        if (CompletionServiceImpl.isPhase(CompletionPhase.Synchronous.class)) {
            LOG.error("sync phase survived: " + allItems + "; indicator=" + CompletionServiceImpl.getCompletionPhase().indicator + "; myIndicator=" + indicator);
            CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
        }
    }

    private AutoCompletionDecision shouldAutoComplete(CompletionProgressIndicator indicator, List<LookupElement> items, CompletionParameters parameters) {
        if (!this.invokedExplicitly) {
            return AutoCompletionDecision.SHOW_LOOKUP;
        }
        LookupElement item = items.get(0);
        if (items.size() == 1) {
            AutoCompletionPolicy policy = CodeCompletionHandlerBase.getAutocompletionPolicy(item);
            if (policy == AutoCompletionPolicy.NEVER_AUTOCOMPLETE) {
                return AutoCompletionDecision.SHOW_LOOKUP;
            }
            if (policy == AutoCompletionPolicy.ALWAYS_AUTOCOMPLETE) {
                return AutoCompletionDecision.insertItem((LookupElement)item);
            }
            if (!indicator.getLookup().itemMatcher(item).isStartMatch(item)) {
                return AutoCompletionDecision.SHOW_LOOKUP;
            }
        }
        if (!CodeCompletionHandlerBase.isAutocompleteOnInvocation(parameters.getCompletionType())) {
            return AutoCompletionDecision.SHOW_LOOKUP;
        }
        if (CodeCompletionHandlerBase.isInsideIdentifier(indicator.getOffsetMap())) {
            return AutoCompletionDecision.SHOW_LOOKUP;
        }
        if (items.size() == 1 && CodeCompletionHandlerBase.getAutocompletionPolicy(item) == AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE) {
            return AutoCompletionDecision.insertItem((LookupElement)item);
        }
        AutoCompletionContext context = new AutoCompletionContext(parameters, items.toArray(LookupElement.EMPTY_ARRAY), indicator.getOffsetMap(), (Lookup)indicator.getLookup());
        for (CompletionContributor contributor : CompletionContributor.forParameters((CompletionParameters)parameters)) {
            AutoCompletionDecision decision = contributor.handleAutoCompletionPossibility(context);
            if (decision == null) continue;
            return decision;
        }
        return AutoCompletionDecision.SHOW_LOOKUP;
    }

    @Nullable
    private static AutoCompletionPolicy getAutocompletionPolicy(LookupElement element) {
        return element.getAutoCompletionPolicy();
    }

    private static boolean isInsideIdentifier(OffsetMap offsetMap) {
        return offsetMap.getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET) != offsetMap.getOffset(CompletionInitializationContext.SELECTION_END_OFFSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completionFinished(CompletionProgressIndicator indicator, boolean hasModifiers) {
        List<LookupElement> items = indicator.getLookup().getItems();
        CompletionParameters parameters = Objects.requireNonNull(indicator.getParameters());
        if (items.isEmpty()) {
            LookupManager.getInstance(indicator.getProject()).hideActiveLookup();
            Caret nextCaret = CodeCompletionHandlerBase.getNextCaretToProcess(indicator.getEditor());
            if (nextCaret != null) {
                this.invokeCompletion(indicator.getProject(), indicator.getEditor(), parameters.getInvocationCount(), hasModifiers, false, nextCaret);
            } else {
                indicator.handleEmptyLookup(true);
                CodeCompletionHandlerBase.checkNotSync(indicator, items);
            }
            return;
        }
        LOG.assertTrue(!indicator.isRunning(), (Object)"running");
        LOG.assertTrue(!indicator.isCanceled(), (Object)"canceled");
        try {
            AutoCompletionDecision decision = this.shouldAutoComplete(indicator, items, parameters);
            if (decision == AutoCompletionDecision.SHOW_LOOKUP) {
                CompletionServiceImpl.setCompletionPhase(new CompletionPhase.ItemsCalculated(indicator));
                indicator.getLookup().setCalculating(false);
                indicator.showLookup();
            } else if (decision instanceof AutoCompletionDecision.InsertItem) {
                Runnable restorePrefix = CodeCompletionHandlerBase.rememberDocumentState(indicator.getEditor());
                LookupElement item = ((AutoCompletionDecision.InsertItem)decision).getElement();
                CommandProcessor.getInstance().executeCommand(indicator.getProject(), () -> {
                    indicator.setMergeCommand();
                    indicator.getLookup().finishLookup('\u0000', item);
                }, "Autocompletion", null);
                if (CompletionService.getCompletionService().getCurrentCompletion() == null && !CompletionServiceImpl.isPhase(CompletionPhase.CommittingDocuments.class)) {
                    CompletionServiceImpl.setCompletionPhase(hasModifiers ? new CompletionPhase.InsertedSingleItem(indicator, restorePrefix) : CompletionPhase.NoCompletion);
                }
            } else if (decision == AutoCompletionDecision.CLOSE_LOOKUP) {
                LookupManager.getInstance(indicator.getProject()).hideActiveLookup();
            }
        }
        catch (Throwable e) {
            CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
            LOG.error(e);
        }
        finally {
            CodeCompletionHandlerBase.checkNotSync(indicator, items);
        }
    }

    private static OffsetsInFile insertDummyIdentifier(CompletionInitializationContext initContext, CompletionProgressIndicator indicator, OffsetsInFile topLevelOffsets) {
        CompletionAssertions.checkEditorValid(initContext.getEditor());
        Editor hostEditor = InjectedLanguageUtil.getTopLevelEditor(initContext.getEditor());
        OffsetMap hostMap = topLevelOffsets.getOffsets();
        PsiFile hostCopy = CodeCompletionHandlerBase.obtainFileCopy(topLevelOffsets.getFile());
        Document copyDocument = Objects.requireNonNull(hostCopy.getViewProvider().getDocument());
        String dummyIdentifier = initContext.getDummyIdentifier();
        int startOffset = hostMap.getOffset(CompletionInitializationContext.START_OFFSET);
        int endOffset = hostMap.getOffset(CompletionInitializationContext.SELECTION_END_OFFSET);
        indicator.registerChildDisposable(() -> new OffsetTranslator(hostEditor.getDocument(), initContext.getFile(), copyDocument, startOffset, endOffset, dummyIdentifier));
        OffsetsInFile copyOffsets = topLevelOffsets.replaceInCopy(hostCopy, startOffset, endOffset, dummyIdentifier);
        return hostCopy.isValid() ? copyOffsets : null;
    }

    private static OffsetsInFile toInjectedIfAny(PsiFile originalFile, OffsetsInFile hostCopyOffsets) {
        CompletionAssertions.assertHostInfo(hostCopyOffsets.getFile(), hostCopyOffsets.getOffsets());
        int hostStartOffset = hostCopyOffsets.getOffsets().getOffset(CompletionInitializationContext.START_OFFSET);
        OffsetsInFile translatedOffsets = hostCopyOffsets.toInjectedIfAny(hostStartOffset);
        if (translatedOffsets != hostCopyOffsets) {
            PsiFile injected = translatedOffsets.getFile();
            if (injected instanceof PsiFileImpl) {
                ((PsiFileImpl)injected).setOriginalFile(originalFile);
            }
            DocumentWindow documentWindow = InjectedLanguageUtil.getDocumentWindow((PsiElement)injected);
            CompletionAssertions.assertInjectedOffsets(hostStartOffset, injected, documentWindow);
            if (injected.getTextRange().contains(translatedOffsets.getOffsets().getOffset(CompletionInitializationContext.START_OFFSET))) {
                return translatedOffsets;
            }
        }
        return hostCopyOffsets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lookupItemSelected(CompletionProgressIndicator indicator, @NotNull LookupElement item, char completionChar, List<LookupElement> items) {
        Runnable runnable2;
        if (item == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(16);
        }
        if (indicator.isAutopopupCompletion()) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.basic");
        }
        CompletionAssertions.WatchingInsertionContext context = null;
        try {
            StatisticsUpdate update = StatisticsUpdate.collectStatisticChanges(item);
            context = CodeCompletionHandlerBase.insertItemHonorBlockSelection(indicator, item, completionChar, items, update);
            update.trackStatistics(context);
            runnable2 = context == null ? null : context.getLaterRunnable();
        }
        catch (Throwable throwable) {
            CodeCompletionHandlerBase.afterItemInsertion(indicator, context == null ? null : context.getLaterRunnable());
            throw throwable;
        }
        CodeCompletionHandlerBase.afterItemInsertion(indicator, runnable2);
    }

    private static CompletionAssertions.WatchingInsertionContext insertItemHonorBlockSelection(final CompletionProgressIndicator indicator, final LookupElement item, final char completionChar, final List<LookupElement> items, final StatisticsUpdate update) {
        CompletionAssertions.WatchingInsertionContext context;
        Editor editor = indicator.getEditor();
        int caretOffset = indicator.getCaret().getOffset();
        int idEndOffset = indicator.getOffsetMap().containsOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET) ? indicator.getIdentifierEndOffset() : CompletionInitializationContext.calcDefaultIdentifierEnd((Editor)editor, (int)caretOffset);
        final int idEndOffsetDelta = idEndOffset - caretOffset;
        if (editor.getCaretModel().supportsMultipleCarets()) {
            final Ref lastContext = Ref.create();
            final Editor hostEditor = InjectedLanguageUtil.getTopLevelEditor(editor);
            final boolean wasInjected = hostEditor != editor;
            final OffsetsInFile topLevelOffsets = indicator.getHostOffsets();
            hostEditor.getCaretModel().runForEachCaret(new CaretAction(){

                public void perform(Caret caret) {
                    OffsetsInFile targetOffsets = this.findInjectedOffsetsIfAny(caret);
                    PsiFile targetFile = targetOffsets.getFile();
                    Editor targetEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(hostEditor, targetFile);
                    int targetCaretOffset = targetEditor.getCaretModel().getOffset();
                    int idEnd = targetCaretOffset + idEndOffsetDelta;
                    if (idEnd > targetEditor.getDocument().getTextLength()) {
                        idEnd = targetCaretOffset;
                    }
                    CompletionAssertions.WatchingInsertionContext currentContext = CodeCompletionHandlerBase.insertItem(indicator, item, completionChar, items, update, targetEditor, targetFile, targetCaretOffset, idEnd, targetOffsets.getOffsets());
                    lastContext.set((Object)currentContext);
                }

                private OffsetsInFile findInjectedOffsetsIfAny(Caret caret) {
                    if (!wasInjected) {
                        return topLevelOffsets;
                    }
                    PsiDocumentManager.getInstance((Project)indicator.getProject()).commitDocument(hostEditor.getDocument());
                    return topLevelOffsets.toInjectedIfAny(caret.getOffset());
                }
            });
            context = (CompletionAssertions.WatchingInsertionContext)((Object)lastContext.get());
        } else {
            context = CodeCompletionHandlerBase.insertItem(indicator, item, completionChar, items, update, editor, PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)indicator.getProject()), caretOffset, idEndOffset, indicator.getOffsetMap());
        }
        if (context.shouldAddCompletionChar()) {
            WriteAction.run(() -> CodeCompletionHandlerBase.addCompletionChar(context, item, editor, indicator, completionChar));
        }
        return context;
    }

    public static void afterItemInsertion(CompletionProgressIndicator indicator, Runnable laterRunnable) {
        if (laterRunnable != null) {
            ActionTracker tracker = new ActionTracker(indicator.getEditor(), indicator);
            Runnable wrapper = () -> {
                if (!indicator.getProject().isDisposed() && !tracker.hasAnythingHappened()) {
                    laterRunnable.run();
                }
                indicator.disposeIndicator();
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                wrapper.run();
            } else {
                TransactionGuard.getInstance().submitTransactionLater((Disposable)indicator, wrapper);
            }
        } else {
            indicator.disposeIndicator();
        }
    }

    private static CompletionAssertions.WatchingInsertionContext insertItem(CompletionProgressIndicator indicator, LookupElement item, char completionChar, List<LookupElement> items, StatisticsUpdate update, Editor editor, PsiFile psiFile, int caretOffset, int idEndOffset, OffsetMap offsetMap) {
        editor.getCaretModel().moveToOffset(caretOffset);
        int initialStartOffset = Math.max(0, caretOffset - item.getLookupString().length());
        offsetMap.addOffset(CompletionInitializationContext.START_OFFSET, initialStartOffset);
        offsetMap.addOffset(CompletionInitializationContext.SELECTION_END_OFFSET, caretOffset);
        offsetMap.addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, idEndOffset);
        CompletionAssertions.WatchingInsertionContext context = new CompletionAssertions.WatchingInsertionContext(offsetMap, psiFile, completionChar, items, editor);
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                if (caretOffset < idEndOffset && completionChar == '\t') {
                    editor.getDocument().deleteString(caretOffset, idEndOffset);
                }
                assert (context.getStartOffset() >= 0) : "stale startOffset: was " + initialStartOffset + "; selEnd=" + caretOffset + "; idEnd=" + idEndOffset + "; file=" + context.getFile();
                assert (context.getTailOffset() >= 0) : "stale tail: was " + initialStartOffset + "; selEnd=" + caretOffset + "; idEnd=" + idEndOffset + "; file=" + context.getFile();
                Project project = indicator.getProject();
                if (item.requiresCommittedDocuments()) {
                    PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                }
                item.handleInsert((InsertionContext)context);
                PostprocessReformattingAspect.getInstance(project).doPostponedFormatting();
            }
            finally {
                context.stopWatching();
            }
            EditorModificationUtil.scrollToCaret((Editor)editor);
        });
        update.addSparedChars(indicator, item, context);
        return context;
    }

    private static void addCompletionChar(CompletionAssertions.WatchingInsertionContext context, LookupElement item, Editor editor, CompletionProgressIndicator indicator, char completionChar) {
        if (!context.getOffsetMap().containsOffset(InsertionContext.TAIL_OFFSET)) {
            LOG.info("tailOffset<0 after inserting " + item + " of " + item.getClass() + "; invalidated at: " + context.invalidateTrace + "\n--------");
        } else if (!CompletionAssertions.isEditorValid(context.getEditor())) {
            LOG.info("Injected editor invalidated " + context.getEditor());
        } else {
            context.getEditor().getCaretModel().moveToOffset(context.getTailOffset());
        }
        if (context.getCompletionChar() == '\r') {
            Language language = PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)indicator.getProject());
            if (language != null) {
                SmartEnterProcessor processor2;
                Iterator iterator = SmartEnterProcessors.INSTANCE.allForLanguage(language).iterator();
                while (iterator.hasNext() && !(processor2 = (SmartEnterProcessor)iterator.next()).processAfterCompletion(editor, context.getFile())) {
                }
            }
        } else {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor.getContentComponent());
            EditorActionManager.getInstance().getTypedAction().getHandler().execute(editor, completionChar, dataContext);
        }
    }

    private static boolean isCopyUpToDate(Document document, @NotNull PsiFile copyFile, @NotNull PsiFile originalFile) {
        if (copyFile == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(17);
        }
        if (originalFile == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(18);
        }
        if (!(copyFile.getClass().equals(originalFile.getClass()) && copyFile.isValid() && copyFile.getName().equals(originalFile.getName()))) {
            return false;
        }
        PsiFile current = PsiDocumentManager.getInstance((Project)copyFile.getProject()).getPsiFile(document);
        return current != null && current.getViewProvider().getPsi(copyFile.getLanguage()) == copyFile;
    }

    private static PsiFile obtainFileCopy(PsiFile file2) {
        Pair cached;
        boolean mayCacheCopy;
        VirtualFile virtualFile = file2.getVirtualFile();
        boolean bl = mayCacheCopy = file2.isPhysical() && virtualFile != null && virtualFile.isInLocalFileSystem();
        if (mayCacheCopy && (cached = (Pair)SoftReference.dereference((Reference)((Reference)file2.getUserData(FILE_COPY_KEY)))) != null && CodeCompletionHandlerBase.isCopyUpToDate((Document)cached.second, (PsiFile)cached.first, file2)) {
            PsiFile copy = (PsiFile)cached.first;
            CompletionAssertions.assertCorrectOriginalFile("Cached", file2, copy);
            return copy;
        }
        PsiFile copy = (PsiFile)file2.copy();
        if (copy.isPhysical() || copy.getViewProvider().isEventSystemEnabled()) {
            LOG.error("File copy should be non-physical and non-event-system-enabled! Language=" + file2.getLanguage() + "; file=" + file2 + " of " + file2.getClass());
        }
        CompletionAssertions.assertCorrectOriginalFile("New", file2, copy);
        if (mayCacheCopy) {
            Document document = copy.getViewProvider().getDocument();
            assert (document != null);
            CodeCompletionHandlerBase.syncAcceptSlashR(file2.getViewProvider().getDocument(), document);
            file2.putUserData(FILE_COPY_KEY, (Object)new SoftReference((Object)Pair.create((Object)copy, (Object)document)));
        }
        return copy;
    }

    private static void syncAcceptSlashR(Document originalDocument, Document documentCopy) {
        if (!(originalDocument instanceof DocumentImpl) || !(documentCopy instanceof DocumentImpl)) {
            return;
        }
        ((DocumentImpl)documentCopy).setAcceptSlashR(((DocumentImpl)originalDocument).acceptsSlashR());
    }

    private static boolean isAutocompleteOnInvocation(CompletionType type) {
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        if (type == CompletionType.SMART) {
            return settings.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION;
        }
        return settings.AUTOCOMPLETE_ON_CODE_COMPLETION;
    }

    private static Runnable rememberDocumentState(Editor _editor) {
        Editor editor = InjectedLanguageUtil.getTopLevelEditor(_editor);
        String documentText = editor.getDocument().getText();
        int caret = editor.getCaretModel().getOffset();
        int selStart = editor.getSelectionModel().getSelectionStart();
        int selEnd = editor.getSelectionModel().getSelectionEnd();
        int vOffset = editor.getScrollingModel().getVerticalScrollOffset();
        int hOffset = editor.getScrollingModel().getHorizontalScrollOffset();
        return () -> {
            DocumentEx document = (DocumentEx)editor.getDocument();
            document.replaceString(0, document.getTextLength(), documentText);
            editor.getCaretModel().moveToOffset(caret);
            editor.getSelectionModel().setSelection(selStart, selEnd);
            editor.getScrollingModel().scrollHorizontally(hOffset);
            editor.getScrollingModel().scrollVertically(vOffset);
        };
    }

    private static void clearCaretMarkers(@NotNull Editor editor) {
        if (editor == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(19);
        }
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            caret.putUserData(CARET_PROCESSED, null);
        }
    }

    private static void markCaretAsProcessed(@NotNull Caret caret) {
        if (caret == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(20);
        }
        caret.putUserData(CARET_PROCESSED, (Object)Boolean.TRUE);
    }

    private static Caret getNextCaretToProcess(@NotNull Editor editor) {
        if (editor == null) {
            CodeCompletionHandlerBase.$$$reportNull$$$0(21);
        }
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            if (caret.getUserData(CARET_PROCESSED) != null) continue;
            return caret;
        }
        return null;
    }

    public static void setAutoInsertTimeout(int timeout) {
        ourAutoInsertItemTimeout = timeout;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionType";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 19: 
            case 21: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: 
            case 11: 
            case 20: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/CodeCompletionHandlerBase";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/CodeCompletionHandlerBase";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainLookup";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompletionParameters";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findCompletionPositionLeaf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invokeCompletion";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runContributorsBeforeCompletion";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lookupItemSelected";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isCopyUpToDate";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "clearCaretMarkers";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "markCaretAsProcessed";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getNextCaretToProcess";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invokeCompletion$1";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

