/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.LookupAdapter;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.actions.BaseNavigateToSourceAction;
import com.intellij.ide.actions.ExternalJavaDocAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.options.FontSize;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupPositionManager;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;

public class DocumentationComponent
extends JPanel
implements Disposable,
DataProvider {
    private static final Logger LOG = Logger.getInstance(DocumentationComponent.class);
    private static final Color DOCUMENTATION_COLOR = new JBColor(new Color(0xF7F7F7), new Color(4606026));
    static final JBColor BORDER_COLOR = new JBColor(new Color(0xADADAD), new Color(0x616366));
    public static final ColorKey COLOR_KEY = ColorKey.createColorKey((String)"DOCUMENTATION_COLOR", (Color)DOCUMENTATION_COLOR);
    private static final Highlighter.HighlightPainter LINK_HIGHLIGHTER = new LinkHighlighter();
    @NonNls
    private static final String DOCUMENTATION_TOPIC_ID = "reference.toolWindows.Documentation";
    private static final int PREFERRED_HEIGHT_MAX_EM = 10;
    private static final JBDimension MAX_DEFAULT = new JBDimension(650, 500);
    private static final JBDimension MIN_DEFAULT = new JBDimension(300, 59);
    private final ExternalDocAction myExternalDocAction;
    private DocumentationManager myManager;
    private SmartPsiElementPointer myElement;
    private long myModificationCount;
    public static final String QUICK_DOC_FONT_SIZE_PROPERTY = "quick.doc.font.size";
    private final Stack<Context> myBackStack = new Stack();
    private final Stack<Context> myForwardStack = new Stack();
    private final ActionToolbar myToolBar;
    private volatile boolean myIsEmpty;
    private boolean myIsShown;
    private boolean myResizing;
    private JSlider myFontSizeSlider;
    private final JComponent mySettingsPanel;
    private boolean myIgnoreFontSizeSliderChange;
    private String myEffectiveExternalUrl;
    private final MyDictionary<String, Image> myImageProvider = new MyDictionary<String, Image>(){

        @Override
        public Image get(Object key) {
            if (DocumentationComponent.this.myManager == null || key == null) {
                return null;
            }
            PsiElement element = DocumentationComponent.this.getElement();
            if (element == null) {
                return null;
            }
            URL url = (URL)key;
            Image inMemory = DocumentationComponent.this.myManager.getElementImage(element, url.toExternalForm());
            if (inMemory != null) {
                return inMemory;
            }
            Url parsedUrl = Urls.parseEncoded(url.toExternalForm());
            BuiltInServerManager builtInServerManager = BuiltInServerManager.getInstance();
            if (parsedUrl != null && builtInServerManager.isOnBuiltInWebServer(parsedUrl)) {
                try {
                    url = new URL(builtInServerManager.addAuthToken(parsedUrl).toExternalForm());
                }
                catch (MalformedURLException e) {
                    LOG.warn((Throwable)e);
                }
            }
            return Toolkit.getDefaultToolkit().createImage(url);
        }
    };
    private Runnable myToolwindowCallback;
    private final ActionButton myCorner;
    private final MyScrollPane myScrollPane;
    private final JEditorPane myEditorPane;
    private String myText;
    private final JPanel myControlPanel;
    private boolean myControlPanelVisible;
    private int myHighlightedLink = -1;
    private Object myHighlightingTag;
    private AbstractPopup myHint;
    private final Map<KeyStroke, ActionListener> myKeyboardActions = new HashMap<KeyStroke, ActionListener>();

    public AnAction[] getActions() {
        return (AnAction[])this.myToolBar.getActions().stream().filter(action -> !(action instanceof Separator)).toArray(AnAction[]::new);
    }

    public AnAction getFontSizeAction() {
        return new MyShowSettingsAction();
    }

    public void removeCornerMenu() {
        this.myCorner.setVisible(false);
    }

    public void setToolwindowCallback(Runnable callback) {
        this.myToolwindowCallback = callback;
    }

    public void showExternalDoc() {
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this);
        this.myExternalDocAction.actionPerformed(AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext));
    }

    @Override
    public boolean requestFocusInWindow() {
        if (ScreenReader.isActive()) {
            return this.myEditorPane.requestFocusInWindow();
        }
        return this.myScrollPane.requestFocusInWindow();
    }

    @Override
    public void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> {
            if (ScreenReader.isActive()) {
                IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEditorPane, true);
            } else {
                IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this.myScrollPane), true);
            }
        });
    }

    public static DocumentationComponent createAndFetch(Project project, PsiElement element, Disposable disposable) {
        DocumentationManager manager = DocumentationManager.getInstance(project);
        DocumentationComponent component = new DocumentationComponent(manager);
        Disposer.register((Disposable)disposable, (Disposable)component);
        manager.fetchDocInfo(element, component);
        return component;
    }

    public DocumentationComponent(final DocumentationManager manager) {
        this.myManager = manager;
        this.myIsEmpty = true;
        this.myIsShown = false;
        this.myEditorPane = new JEditorPane("text/html", ""){
            private Point initialClick;
            {
                this.enableEvents(8L);
            }

            @Override
            protected void processKeyEvent(KeyEvent e) {
                KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
                ActionListener listener2 = (ActionListener)DocumentationComponent.this.myKeyboardActions.get(keyStroke);
                if (listener2 != null) {
                    listener2.actionPerformed(new ActionEvent(DocumentationComponent.this, 0, ""));
                    e.consume();
                    return;
                }
                super.processKeyEvent(e);
            }

            @Override
            protected void processMouseEvent(MouseEvent e) {
                if (e.getID() == 501 && DocumentationComponent.this.myHint != null) {
                    int y;
                    int x;
                    this.initialClick = null;
                    StyledDocument document = (StyledDocument)this.getDocument();
                    if (!(this.hasTextAt(document, x = e.getX(), y = e.getY()) || this.hasTextAt(document, x + 3, y) || this.hasTextAt(document, x - 3, y) || this.hasTextAt(document, x, y + 3) || this.hasTextAt(document, x, y - 3))) {
                        this.initialClick = e.getPoint();
                    }
                }
                super.processMouseEvent(e);
            }

            private boolean hasTextAt(StyledDocument document, int x, int y) {
                Element element = document.getCharacterElement(this.viewToModel(new Point(x, y)));
                try {
                    String text = document.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
                    if (StringUtil.isEmpty((String)text.trim())) {
                        return false;
                    }
                }
                catch (BadLocationException ignored) {
                    return false;
                }
                return true;
            }

            @Override
            protected void processMouseMotionEvent(MouseEvent e) {
                if (e.getID() == 506 && DocumentationComponent.this.myHint != null && this.initialClick != null) {
                    Point location = DocumentationComponent.this.myHint.getLocationOnScreen();
                    DocumentationComponent.this.myHint.setLocation(new Point(location.x + e.getX() - this.initialClick.x, location.y + e.getY() - this.initialClick.y));
                    e.consume();
                    return;
                }
                super.processMouseMotionEvent(e);
            }

            @Override
            protected void paintComponent(Graphics g) {
                GraphicsUtil.setupAntialiasing((Graphics)g);
                super.paintComponent(g);
            }

            @Override
            public void setDocument(Document doc) {
                super.setDocument(doc);
                doc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
                if (doc instanceof StyledDocument) {
                    doc.putProperty("imageCache", DocumentationComponent.this.myImageProvider);
                }
            }
        };
        DataProvider helpDataProvider = new DataProvider(){

            public Object getData(@NonNls String dataId) {
                return PlatformDataKeys.HELP_ID.is(dataId) ? DocumentationComponent.DOCUMENTATION_TOPIC_ID : null;
            }
        };
        this.myEditorPane.putClientProperty("DataProvider", helpDataProvider);
        this.myText = "";
        this.myEditorPane.setEditable(false);
        if (ScreenReader.isActive()) {
            this.myEditorPane.getCaret().setVisible(true);
        }
        this.myEditorPane.setBackground(EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)COLOR_KEY));
        UIUtil.JBHtmlEditorKit editorKit = new UIUtil.JBHtmlEditorKit(true){

            public ViewFactory getViewFactory() {
                return new HTMLEditorKit.HTMLFactory(){

                    @Override
                    public View create(Element elem) {
                        if ("icon".equals(elem.getName())) {
                            ModuleType id;
                            Icon icon;
                            Object src = elem.getAttributes().getAttribute(HTML.Attribute.SRC);
                            Icon icon2 = icon = src != null ? IconLoader.findIcon((String)((String)src), (boolean)false) : null;
                            if (icon == null && (id = ModuleTypeManager.getInstance().findByID((String)src)) != null) {
                                icon = id.getIcon();
                            }
                            if (icon != null) {
                                final Icon viewIcon = icon;
                                return new View(elem){

                                    @Override
                                    public float getPreferredSpan(int axis) {
                                        switch (axis) {
                                            case 0: {
                                                return viewIcon.getIconWidth();
                                            }
                                            case 1: {
                                                return viewIcon.getIconHeight();
                                            }
                                        }
                                        throw new IllegalArgumentException("Invalid axis: " + axis);
                                    }

                                    @Override
                                    public void paint(Graphics g, Shape allocation) {
                                        viewIcon.paintIcon(null, g, allocation.getBounds().x, allocation.getBounds().y - 4);
                                    }

                                    @Override
                                    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
                                        int p0 = this.getStartOffset();
                                        int p1 = this.getEndOffset();
                                        if (pos >= p0 && pos <= p1) {
                                            Rectangle r = a.getBounds();
                                            if (pos == p1) {
                                                r.x += r.width;
                                            }
                                            r.width = 0;
                                            return r;
                                        }
                                        throw new BadLocationException(pos + " not in range " + p0 + "," + p1, pos);
                                    }

                                    @Override
                                    public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
                                        Rectangle alloc = (Rectangle)a;
                                        if (x < (float)(alloc.x + alloc.width / 2)) {
                                            bias[0] = Position.Bias.Forward;
                                            return this.getStartOffset();
                                        }
                                        bias[0] = Position.Bias.Backward;
                                        return this.getEndOffset();
                                    }
                                };
                            }
                        }
                        return super.create(elem);
                    }
                };
            }
        };
        DocumentationComponent.prepareCSS((HTMLEditorKit)editorKit);
        this.myEditorPane.setEditorKit((EditorKit)editorKit);
        this.myEditorPane.setBorder((Border)JBUI.Borders.empty());
        this.myScrollPane = new MyScrollPane();
        this.myScrollPane.putClientProperty("DataProvider", helpDataProvider);
        final FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Component previouslyFocused = WindowManagerEx.getInstanceEx().getFocusedComponent(manager.getProject(DocumentationComponent.this.getElement()));
                if (previouslyFocused != DocumentationComponent.this.myEditorPane && DocumentationComponent.this.myHint != null && !DocumentationComponent.this.myHint.isDisposed()) {
                    DocumentationComponent.this.myHint.cancel();
                }
            }
        };
        this.myEditorPane.addFocusListener(focusAdapter);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                DocumentationComponent.this.myEditorPane.removeFocusListener(focusAdapter);
            }
        });
        this.setLayout(new BorderLayout());
        this.mySettingsPanel = this.createSettingsPanel();
        this.setOpaque(true);
        this.myScrollPane.setBorder((Border)JBUI.Borders.empty());
        DefaultActionGroup actions = new DefaultActionGroup();
        BackAction back = new BackAction();
        ForwardAction forward = new ForwardAction();
        EditDocumentationSourceAction edit = new EditDocumentationSourceAction();
        this.myExternalDocAction = new ExternalDocAction();
        actions.add((AnAction)back);
        actions.add((AnAction)forward);
        actions.add((AnAction)edit);
        try {
            String backKey = ScreenReader.isActive() ? "alt LEFT" : "LEFT";
            CustomShortcutSet backShortcutSet = new CustomShortcutSet(new Shortcut[]{KeyboardShortcut.fromString((String)backKey), KeymapUtil.parseMouseShortcut((String)"button4")});
            String forwardKey = ScreenReader.isActive() ? "alt RIGHT" : "RIGHT";
            CustomShortcutSet forwardShortcutSet = new CustomShortcutSet(new Shortcut[]{KeyboardShortcut.fromString((String)forwardKey), KeymapUtil.parseMouseShortcut((String)"button5")});
            back.registerCustomShortcutSet((ShortcutSet)backShortcutSet, this);
            forward.registerCustomShortcutSet((ShortcutSet)forwardShortcutSet, this);
            back.registerCustomShortcutSet((ShortcutSet)backShortcutSet, this.myEditorPane);
            forward.registerCustomShortcutSet((ShortcutSet)forwardShortcutSet, this.myEditorPane);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
        this.myExternalDocAction.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"UP"}), this);
        this.myExternalDocAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("ExternalJavaDoc").getShortcutSet(), this.myEditorPane);
        edit.registerCustomShortcutSet(CommonShortcuts.getEditSource(), this);
        final ActionPopupMenu contextMenu = ((ActionManagerImpl)ActionManager.getInstance()).createActionPopupMenu("JavadocToolbar", (ActionGroup)actions, new MenuItemPresentationFactory(true));
        PopupHandler popupHandler = new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                contextMenu.getComponent().show(comp, x, y);
            }
        };
        this.myEditorPane.addMouseListener((MouseListener)popupHandler);
        Disposer.register((Disposable)this, () -> this.myEditorPane.removeMouseListener((MouseListener)popupHandler));
        new NextLinkAction().registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"TAB"}), this);
        new PreviousLinkAction().registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"shift TAB"}), this);
        new ActivateLinkAction().registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ENTER"}), this);
        this.myToolBar = ActionManager.getInstance().createActionToolbar("JavadocToolbar", (ActionGroup)actions, true);
        JBLayeredPane layeredPane = new JBLayeredPane(){

            public void doLayout() {
                Rectangle r = this.getBounds();
                for (Component component : this.getComponents()) {
                    if (component instanceof JScrollPane) {
                        component.setBounds(0, 0, r.width, r.height);
                        continue;
                    }
                    int insets = 3;
                    Dimension d = component.getPreferredSize();
                    component.setBounds(r.width - d.width - insets, r.height - d.height - insets, d.width, d.height);
                }
            }

            public Dimension getPreferredSize() {
                Dimension size = DocumentationComponent.this.myScrollPane.getPreferredSize();
                if (DocumentationComponent.this.myHint == null && ((DocumentationComponent)DocumentationComponent.this).myManager.myToolWindow == null) {
                    int em = DocumentationComponent.this.myEditorPane.getFont().getSize();
                    int prefHeightMax = 10 * em;
                    return new Dimension(size.width, Math.min(prefHeightMax, size.height + (DocumentationComponent.this.needsToolbar() ? ((DocumentationComponent)DocumentationComponent.this).myControlPanel.getPreferredSize().height : 0)));
                }
                return size;
            }
        };
        layeredPane.add((Component)((Object)this.myScrollPane));
        layeredPane.setLayer((Component)((Object)this.myScrollPane), 0);
        MyGearActionGroup gearActions = new MyGearActionGroup(new AnAction[0]);
        gearActions.add(new ShowAsToolwindowAction());
        gearActions.add(new MyShowSettingsAction());
        gearActions.add((AnAction)new ShowToolbarAction());
        gearActions.add(new RestoreDefaultSizeAction());
        gearActions.addSeparator();
        gearActions.addAll((ActionGroup)actions);
        Presentation presentation = new Presentation();
        presentation.setIcon(AllIcons.General.GearPlain);
        this.myCorner = new ActionButton((AnAction)gearActions, presentation, "unknown", new Dimension(22, 22)){

            @Override
            public void paintComponent(Graphics g) {
                g.setColor(DocumentationComponent.this.myEditorPane.getBackground());
                g.fillRect(0, 0, this.getSize().width, this.getSize().height);
                this.paintButtonLook(g);
            }
        };
        this.myCorner.setOpaque(true);
        this.myCorner.setNoIconsInPopup(true);
        layeredPane.add(this.myCorner);
        layeredPane.setLayer(this.myCorner, JLayeredPane.POPUP_LAYER);
        this.add((Component)layeredPane, "Center");
        this.myControlPanel = new JPanel(new BorderLayout(5, 5));
        this.myControlPanel.setBorder(IdeBorderFactory.createBorder((int)8));
        this.myControlPanel.add((Component)this.myToolBar.getComponent(), "West");
        this.myControlPanel.add((Component)new MyShowSettingsButton(), "East");
        this.myControlPanelVisible = false;
        final HyperlinkListener hyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                HyperlinkEvent.EventType type = e.getEventType();
                if (type == HyperlinkEvent.EventType.ACTIVATED) {
                    manager.navigateByLink(DocumentationComponent.this, e.getDescription());
                }
            }
        };
        this.myEditorPane.addHyperlinkListener(hyperlinkListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                DocumentationComponent.this.myEditorPane.removeHyperlinkListener(hyperlinkListener);
            }
        });
        this.registerActions();
        this.updateControlState();
    }

    private static void prepareCSS(HTMLEditorKit editorKit) {
        String editorFontName = StringUtil.escapeQuotes((String)EditorColorsManager.getInstance().getGlobalScheme().getEditorFontName());
        editorKit.getStyleSheet().addRule("code {font-family:\"" + editorFontName + "\"}");
        editorKit.getStyleSheet().addRule("pre {font-family:\"" + editorFontName + "\"}");
        editorKit.getStyleSheet().addRule("html { padding-bottom: 5px; }");
        editorKit.getStyleSheet().addRule("a { color: #" + ColorUtil.toHex((Color)DocumentationComponent.getLinkColor()) + "; text-decoration: none;}");
        editorKit.getStyleSheet().addRule(".definition { padding: 3px 10px 1px 7px; border-bottom: thin solid #" + ColorUtil.toHex((Color)ColorUtil.mix((Color)DOCUMENTATION_COLOR, (Color)BORDER_COLOR, (double)0.5)) + "; }");
        editorKit.getStyleSheet().addRule(".content { padding: 5px 9px 0 7px; }");
        editorKit.getStyleSheet().addRule(".bottom { padding: 3px 9px 0 7px; }");
        editorKit.getStyleSheet().addRule(".bottom-no-content { padding: 5px 9px 0 7px; }");
        editorKit.getStyleSheet().addRule("p { padding: 1px 0 2px 0; }");
        editorKit.getStyleSheet().addRule("ul { padding: 5px 9px 0 7px; }");
        editorKit.getStyleSheet().addRule("li { padding: 1px 0 2px 0; }");
        editorKit.getStyleSheet().addRule(".sections { padding: 0 9px 0 7px; border-spacing: 0; }");
        editorKit.getStyleSheet().addRule("tr { margin: 0 0 0 0; padding: 0 0 0 0; }");
        editorKit.getStyleSheet().addRule("td { margin: 2px 0 3.5px 0; padding: 0 0 0 0; }");
        editorKit.getStyleSheet().addRule(".section { color: #909090; padding-right: 4px}");
    }

    private static Color getLinkColor() {
        Color color = UIManager.getColor("link.foreground");
        return color != null ? color : IdeTooltipManager.getInstance().getLinkForeground(false);
    }

    public Object getData(@NonNls String dataId) {
        if (DocumentationManager.SELECTED_QUICK_DOC_TEXT.getName().equals(dataId)) {
            String selectedText = this.myEditorPane.getSelectedText();
            return selectedText == null ? null : selectedText.replace('\u00a0', ' ');
        }
        return null;
    }

    private JComponent createSettingsPanel() {
        JPanel result2 = new JPanel(new FlowLayout(2, 3, 0));
        result2.add(new JLabel(ApplicationBundle.message((String)"label.font.size", (Object[])new Object[0])));
        this.myFontSizeSlider = new JSlider(0, 0, FontSize.values().length - 1, 3);
        this.myFontSizeSlider.setMinorTickSpacing(1);
        this.myFontSizeSlider.setPaintTicks(true);
        this.myFontSizeSlider.setPaintTrack(true);
        this.myFontSizeSlider.setSnapToTicks(true);
        UIUtil.setSliderIsFilled((JSlider)this.myFontSizeSlider, (boolean)true);
        result2.add(this.myFontSizeSlider);
        result2.setBorder(BorderFactory.createLineBorder(JBColor.border(), 1));
        this.myFontSizeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (DocumentationComponent.this.myIgnoreFontSizeSliderChange) {
                    return;
                }
                DocumentationComponent.this.setQuickDocFontSize(FontSize.values()[DocumentationComponent.this.myFontSizeSlider.getValue()]);
                DocumentationComponent.this.applyFontProps();
            }
        });
        String tooltipText = ApplicationBundle.message((String)"quickdoc.tooltip.font.size.by.wheel", (Object[])new Object[0]);
        result2.setToolTipText(tooltipText);
        this.myFontSizeSlider.setToolTipText(tooltipText);
        result2.setVisible(false);
        result2.setOpaque(true);
        this.myFontSizeSlider.setOpaque(true);
        return result2;
    }

    @NotNull
    public static FontSize getQuickDocFontSize() {
        String strValue = PropertiesComponent.getInstance().getValue(QUICK_DOC_FONT_SIZE_PROPERTY);
        if (strValue != null) {
            FontSize fontSize;
            try {
                fontSize = FontSize.valueOf((String)strValue);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (fontSize == null) {
                DocumentationComponent.$$$reportNull$$$0(0);
            }
            return fontSize;
        }
        FontSize fontSize = FontSize.SMALL;
        if (fontSize == null) {
            DocumentationComponent.$$$reportNull$$$0(1);
        }
        return fontSize;
    }

    public void setQuickDocFontSize(@NotNull FontSize fontSize) {
        if (fontSize == null) {
            DocumentationComponent.$$$reportNull$$$0(2);
        }
        PropertiesComponent.getInstance().setValue(QUICK_DOC_FONT_SIZE_PROPERTY, fontSize.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFontSizeSliderSize(FontSize fontSize) {
        this.myIgnoreFontSizeSliderChange = true;
        try {
            FontSize[] sizes = FontSize.values();
            for (int i = 0; i < sizes.length; ++i) {
                if (fontSize != sizes[i]) continue;
                this.myFontSizeSlider.setValue(i);
                break;
            }
        }
        finally {
            this.myIgnoreFontSizeSliderChange = false;
        }
    }

    public boolean isEmpty() {
        return this.myIsEmpty;
    }

    public void startWait() {
        this.myIsEmpty = true;
    }

    private void setControlPanelVisible() {
        if (this.myControlPanelVisible) {
            return;
        }
        this.add((Component)this.myControlPanel, "North");
        this.myControlPanelVisible = true;
    }

    public void setHint(JBPopup hint) {
        this.myHint = (AbstractPopup)hint;
    }

    public JBPopup getHint() {
        return this.myHint;
    }

    public JComponent getComponent() {
        return this.myEditorPane;
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElement != null ? this.myElement.getElement() : null;
    }

    private void setElement(SmartPsiElementPointer element) {
        this.myElement = element;
        this.myModificationCount = this.getCurrentModificationCount();
    }

    public boolean isUpToDate() {
        return this.getElement() != null && this.myModificationCount == this.getCurrentModificationCount();
    }

    private long getCurrentModificationCount() {
        return this.myElement != null ? PsiModificationTracker.SERVICE.getInstance((Project)this.myElement.getProject()).getModificationCount() : -1L;
    }

    public void setText(String text, @Nullable PsiElement element, boolean clearHistory) {
        this.setText(text, element, false, clearHistory);
    }

    public void setText(String text, PsiElement element, boolean clean, boolean clearHistory) {
        if (clean && this.myElement != null) {
            this.myBackStack.push(this.saveContext());
            this.myForwardStack.clear();
        }
        this.setData(element, text, clearHistory, null);
        if (clean) {
            this.myIsEmpty = false;
        }
        if (clearHistory) {
            this.clearHistory();
        }
    }

    public void replaceText(String text, PsiElement element) {
        PsiElement current = this.getElement();
        if (current == null || !current.getManager().areElementsEquivalent(current, element)) {
            return;
        }
        this.setText(text, element, false);
        if (!this.myBackStack.empty()) {
            this.myBackStack.pop();
        }
    }

    private void clearHistory() {
        this.myForwardStack.clear();
        this.myBackStack.clear();
    }

    public void setData(PsiElement _element2, String text, boolean clearHistory, String effectiveExternalUrl) {
        this.setData(_element2, text, clearHistory, effectiveExternalUrl, null);
    }

    public void setData(PsiElement _element2, String text, boolean clearHistory, String effectiveExternalUrl, String ref) {
        SmartPsiElementPointer element;
        if (this.myElement != null) {
            this.myBackStack.push(this.saveContext());
            this.myForwardStack.clear();
        }
        this.myEffectiveExternalUrl = effectiveExternalUrl;
        SmartPsiElementPointer smartPsiElementPointer = element = _element2 != null && _element2.isValid() ? SmartPointerManager.getInstance((Project)_element2.getProject()).createSmartPsiElementPointer(_element2) : null;
        if (element != null) {
            this.setElement(element);
        }
        this.myIsEmpty = false;
        this.setDataInternal(element, text, new Rectangle(0, 0), ref);
        if (clearHistory) {
            this.clearHistory();
        }
    }

    private void setDataInternal(SmartPsiElementPointer element, String text, Rectangle viewRect, String ref) {
        if (this.myManager == null) {
            return;
        }
        this.updateControlState();
        this.setElement(element);
        this.highlightLink(-1);
        this.myEditorPane.setText(this.decorate(text));
        this.applyFontProps();
        this.showHint();
        this.myText = text;
        SwingUtilities.invokeLater(() -> {
            this.myEditorPane.scrollRectToVisible(viewRect);
            if (ref != null) {
                this.myEditorPane.scrollToReference(ref);
            } else if (ScreenReader.isActive()) {
                this.myEditorPane.setCaretPosition(0);
            }
        });
    }

    private void showHint() {
        int maxWidth;
        Editor editor = this.myManager.getEditor();
        Component popupAnchor = DocumentationComponent.getPopupAnchor(editor);
        int n = maxWidth = popupAnchor != null ? JBUI.scale((int)435) : DocumentationComponent.MAX_DEFAULT.width;
        if (this.myHint != null) {
            Dimension hintSize;
            if (this.myHint.getDimensionServiceKey() == null) {
                Dimension preferredSize = this.myEditorPane.getPreferredSize();
                int width = this.definitionPreferredWidth();
                width = width < 0 ? preferredSize.width : width;
                width = Math.min(maxWidth, Math.max(JBUI.scale((int)300), width));
                this.myEditorPane.setBounds(0, 0, width, DocumentationComponent.MAX_DEFAULT.height);
                this.myEditorPane.setText(this.myEditorPane.getText());
                preferredSize = this.myEditorPane.getPreferredSize();
                int height = preferredSize.height + (this.needsToolbar() ? this.myControlPanel.getPreferredSize().height : 0);
                height = Math.min(DocumentationComponent.MAX_DEFAULT.height, Math.max(DocumentationComponent.MIN_DEFAULT.height, height));
                hintSize = new Dimension(width, height);
            } else {
                hintSize = DimensionService.getInstance().getSize("javadoc.popup.new", this.myManager.myProject);
                hintSize = hintSize != null ? hintSize : MIN_DEFAULT;
            }
            Point location = this.myHint.getLocationOnScreen();
            if (popupAnchor != null && location.x < popupAnchor.getLocationOnScreen().x) {
                location = new RelativePoint(popupAnchor, new Point(-hintSize.width - 5, 0)).getScreenPoint();
                this.myHint.setLocation(location);
            } else if (editor != null && editor.getComponent().isShowing()) {
                Point preferredLocation = JBPopupFactory.getInstance().guessBestPopupLocation(editor).getScreenPoint();
                preferredLocation.y -= editor.getLineHeight();
                if (location.y < preferredLocation.y) {
                    location = new Point(location.x, preferredLocation.y - hintSize.height);
                    this.myHint.setLocation(location);
                }
            }
            if (this.myIsShown) {
                int yBottomOverdraft;
                int yTopOverdraft;
                int xRightOverdraft;
                Rectangle screen = ScreenUtil.getScreenRectangle((Component)this.myEditorPane);
                int xLeftOverdraft = screen.x - location.x;
                if (xLeftOverdraft > 0) {
                    location.x += xLeftOverdraft;
                    hintSize.width -= xLeftOverdraft;
                }
                if ((xRightOverdraft = location.x + hintSize.width - screen.x - screen.width) > 0) {
                    this.myHint.setLocation(new Point(location.x - xRightOverdraft, location.y));
                }
                if ((yTopOverdraft = screen.y - location.y) > 0) {
                    location.y += yTopOverdraft;
                    hintSize.height -= yTopOverdraft;
                }
                if ((yBottomOverdraft = location.y + hintSize.height - screen.y - screen.height) > 0) {
                    hintSize.height -= yBottomOverdraft;
                }
            }
            this.myResizing = true;
            this.myHint.setSize(hintSize);
            if (!this.myIsShown && !ApplicationManager.getApplication().isUnitTestMode()) {
                this.myResizing = true;
                Component focusOwner = IdeFocusManager.getInstance((Project)this.myManager.myProject).getFocusOwner();
                DataContext dataContext = DataManager.getInstance().getDataContext(focusOwner);
                if (popupAnchor != null) {
                    Point lookupPosition = popupAnchor.getLocationOnScreen();
                    Rectangle screenRectangle = ScreenUtil.getScreenRectangle((Component)popupAnchor);
                    int lookupWidthAndGap = popupAnchor.getWidth() + 5;
                    int x = lookupPosition.x + lookupWidthAndGap;
                    RelativePoint point = x + Math.max(hintSize.width, maxWidth) > screenRectangle.width ? new RelativePoint(popupAnchor, new Point(-hintSize.width - 5, 0)) : new RelativePoint(popupAnchor, new Point(lookupWidthAndGap, 0));
                    this.myHint.show(point);
                    LookupEx lookup = LookupManager.getActiveLookup(editor);
                    if (lookup != null) {
                        lookup.addLookupListener(new LookupAdapter(){

                            @Override
                            public void lookupCanceled(LookupEvent event) {
                                AbstractPopup hint = DocumentationComponent.this.myHint;
                                if (hint != null && hint.canClose() && hint.isVisible()) {
                                    hint.cancel();
                                }
                            }
                        });
                    }
                } else if (editor != null && editor.getComponent().isShowing()) {
                    Point preferredLocation = JBPopupFactory.getInstance().guessBestPopupLocation(editor).getScreenPoint();
                    Rectangle preferred = new Rectangle(preferredLocation.x, preferredLocation.y, DocumentationComponent.MAX_DEFAULT.width, DocumentationComponent.MAX_DEFAULT.height / 2);
                    Rectangle adjusted = (Rectangle)preferred.clone();
                    ScreenUtil.fitToScreen((Rectangle)adjusted);
                    if (preferred.y != adjusted.y) {
                        preferredLocation.y -= editor.getLineHeight() + hintSize.height;
                    }
                    this.myHint.show(new RelativePoint(preferredLocation));
                } else {
                    PopupPositionManager.positionPopupInBestPosition(this.myHint, editor, dataContext);
                }
                this.myIsShown = true;
                if (this.myHint.getDimensionServiceKey() == null) {
                    SwingUtilities.invokeLater(this::registerSizeTracker);
                }
            }
        }
    }

    private static Component getPopupAnchor(Editor editor) {
        LookupEx lookup = LookupManager.getActiveLookup(editor);
        if (lookup != null && lookup.getCurrentItem() != null && lookup.getComponent().isShowing()) {
            return lookup.getComponent();
        }
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        JBPopup popup2 = PopupUtil.getPopupContainerFor((Component)focusOwner);
        if (popup2 != null) {
            return popup2.getContent();
        }
        return null;
    }

    private void registerSizeTracker() {
        final AbstractPopup hint = this.myHint;
        if (hint == null) {
            return;
        }
        Window window = hint.getPopupWindow();
        ComponentAdapter listener2 = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (DocumentationComponent.this.myResizing) {
                    DocumentationComponent.this.myResizing = false;
                    return;
                }
                hint.setDimensionServiceKey("javadoc.popup.new");
            }
        };
        window.addComponentListener(listener2);
        Disposer.register((Disposable)this, () -> hint.getPopupWindow().removeComponentListener(listener2));
    }

    private int definitionPreferredWidth() {
        TextUI ui = this.myEditorPane.getUI();
        View view = ui.getRootView(this.myEditorPane);
        View definition = DocumentationComponent.findDefinition(view);
        return definition != null ? (int)definition.getPreferredSpan(0) : -1;
    }

    private static View findDefinition(View view) {
        if ("definition".equals(view.getElement().getAttributes().getAttribute(HTML.Attribute.CLASS))) {
            return view;
        }
        for (int i = 0; i < view.getViewCount(); ++i) {
            View definition = DocumentationComponent.findDefinition(view.getView(i));
            if (definition == null) continue;
            return definition;
        }
        return null;
    }

    private String decorate(String text) {
        String links;
        String location;
        text = text.trim();
        text = StringUtil.trimEnd((String)text, (String)"</html>", (boolean)true);
        text = text.trim();
        boolean hasContent = (text = StringUtil.trimEnd((String)text, (String)"</body>", (boolean)true)).contains("<div class='content'>");
        if (!hasContent && !text.contains("<div class='definition'><pre>")) {
            int bodyStart = DocumentationComponent.findContentStart(text);
            text = bodyStart > 0 ? text.substring(0, bodyStart) + "<div class='content'>" + text.substring(bodyStart) + "</div>" : "<div class='content'>" + text + "</div>";
            hasContent = true;
        }
        if ((location = this.getLocationText()) != null) {
            text = text + DocumentationComponent.getBottom(hasContent) + location + "</div>";
        }
        if ((links = this.getExternalText()) != null) {
            text = text + DocumentationComponent.getBottom(location != null) + links;
        }
        text = DocumentationComponent.addExternalLinksIcon(text);
        return text;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private String getExternalText() {
        PsiElement element = this.getElement();
        if (element == null) {
            return null;
        }
        String title = this.myManager.getTitle(element);
        DocumentationProvider provider = DocumentationManager.getProviderFromElement(element);
        if (this.myEffectiveExternalUrl == null) {
            if (DocumentationComponent.isExternalHandler(provider)) return "<a href='external_doc'>External documentation " + title + "<icon src='AllIcons.Ide.External_link_arrow'></a></div>";
            PsiElement originalElement = DocumentationManager.getOriginalElement(element);
            List urls = provider.getUrlFor(element, originalElement);
            if (urls == null) return null;
            boolean hasBadUrl = false;
            StringBuilder result2 = new StringBuilder();
            for (String url : urls) {
                String link = DocumentationComponent.getLink(title, url);
                if (link == null) {
                    hasBadUrl = true;
                    break;
                }
                if (result2.length() > 0) {
                    result2.append("<p>");
                }
                result2.append(link);
            }
            if (hasBadUrl) return "<a href='external_doc'>External documentation " + title + "<icon src='AllIcons.Ide.External_link_arrow'></a></div>";
            return result2.toString();
        }
        String link = DocumentationComponent.getLink(title, this.myEffectiveExternalUrl);
        if (link == null) return "<a href='external_doc'>External documentation " + title + "<icon src='AllIcons.Ide.External_link_arrow'></a></div>";
        return link;
    }

    private static String getLink(String title, String url) {
        StringBuilder result2 = new StringBuilder();
        String hostname = DocumentationComponent.getHostname(url);
        if (hostname == null) {
            return null;
        }
        result2.append("<a href='");
        result2.append(url);
        result2.append("'>");
        result2.append(title.substring(4)).append(" on ").append(hostname);
        result2.append("</a>");
        return result2.toString();
    }

    private static boolean isExternalHandler(DocumentationProvider provider) {
        if (provider instanceof CompositeDocumentationProvider) {
            for (DocumentationProvider documentationProvider : ((CompositeDocumentationProvider)provider).getProviders()) {
                if (!(documentationProvider instanceof ExternalDocumentationHandler)) continue;
                return true;
            }
            return false;
        }
        return provider instanceof ExternalDocumentationHandler;
    }

    private static String getHostname(String url) {
        try {
            return new URL(url).toURI().getHost();
        }
        catch (MalformedURLException | URISyntaxException exception) {
            return null;
        }
    }

    private static int findContentStart(String text) {
        int index = StringUtil.indexOfIgnoreCase((String)text, (String)"<body>", (int)0);
        if (index >= 0) {
            return index + 6;
        }
        index = StringUtil.indexOfIgnoreCase((String)text, (String)"</head>", (int)0);
        if (index >= 0) {
            return index + 7;
        }
        index = StringUtil.indexOfIgnoreCase((String)text, (String)"</style>", (int)0);
        if (index >= 0) {
            return index + 8;
        }
        index = StringUtil.indexOfIgnoreCase((String)text, (String)"<html>", (int)0);
        if (index >= 0) {
            return index + 6;
        }
        return -1;
    }

    @NotNull
    private static String getBottom(boolean hasContent) {
        String string = "<div class='" + (hasContent ? "bottom" : "bottom-no-content") + "'>";
        if (string == null) {
            DocumentationComponent.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static String addExternalLinksIcon(String text) {
        return text.replaceAll("(<a\\s*href=[\"']http[^>]*>)([^>]*)(</a>)", "$1$2<icon src='AllIcons.Ide.External_link_arrow'>$3");
    }

    private String getLocationText() {
        PsiElement element = this.getElement();
        if (element != null) {
            VirtualFile vfile;
            PsiFile file2 = element.getContainingFile();
            VirtualFile virtualFile = vfile = file2 == null ? null : file2.getVirtualFile();
            if (vfile == null) {
                return null;
            }
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
            Module module = fileIndex.getModuleForFile(vfile);
            if (module != null) {
                if (ModuleManager.getInstance((Project)element.getProject()).getModules().length == 1) {
                    return null;
                }
                return "<icon src='" + ModuleType.get((Module)module).getId() + "'>&nbsp;" + module.getName().replace("<", "&lt;");
            }
            List entries = fileIndex.getOrderEntriesForFile(vfile);
            for (OrderEntry order : entries) {
                if (!(order instanceof LibraryOrderEntry) && !(order instanceof JdkOrderEntry)) continue;
                return "<icon src='AllIcons.Nodes.PpLibFolder'>&nbsp;" + order.getPresentableName().replace("<", "&lt;");
            }
        }
        return null;
    }

    private void applyFontProps() {
        Document document = this.myEditorPane.getDocument();
        if (!(document instanceof StyledDocument)) {
            return;
        }
        String fontName = Registry.is((String)"documentation.component.editor.font") ? EditorColorsManager.getInstance().getGlobalScheme().getEditorFontName() : this.myEditorPane.getFont().getFontName();
        this.myEditorPane.setFont(UIUtil.getFontWithFallback((String)fontName, (int)0, (int)JBUI.scale((int)DocumentationComponent.getQuickDocFontSize().getSize())));
    }

    private void goBack() {
        if (this.myBackStack.isEmpty()) {
            return;
        }
        Context context = this.myBackStack.pop();
        this.myForwardStack.push(this.saveContext());
        this.restoreContext(context);
    }

    private void goForward() {
        if (this.myForwardStack.isEmpty()) {
            return;
        }
        Context context = this.myForwardStack.pop();
        this.myBackStack.push(this.saveContext());
        this.restoreContext(context);
    }

    private Context saveContext() {
        Rectangle rect = this.myScrollPane.getViewport().getViewRect();
        return new Context(this.myElement, this.myText, this.myEffectiveExternalUrl, rect, this.myHighlightedLink);
    }

    private void restoreContext(Context context) {
        this.myEffectiveExternalUrl = context.externalUrl;
        this.setDataInternal(context.element, context.text, context.viewRect, null);
        this.highlightLink(context.highlightedLink);
    }

    private void updateControlState() {
        if (this.needsToolbar()) {
            this.myToolBar.updateActionsImmediately();
            this.setControlPanelVisible();
            this.removeCornerMenu();
        } else {
            this.myControlPanelVisible = false;
            this.remove(this.myControlPanel);
            if (this.myManager.myToolWindow != null) {
                return;
            }
            this.myCorner.setVisible(true);
        }
    }

    private boolean needsToolbar() {
        return this.myManager.myToolWindow == null && Registry.is((String)"documentation.show.toolbar");
    }

    private static boolean isToolbar(AnActionEvent e) {
        return "JavadocToolbar".equals(e.getPlace());
    }

    private boolean hasExternalDoc() {
        boolean enabled = false;
        if (this.myElement != null) {
            PsiElement element = this.myElement.getElement();
            DocumentationProvider provider = DocumentationManager.getProviderFromElement(element);
            PsiElement originalElement = DocumentationManager.getOriginalElement(element);
            enabled = element != null && CompositeDocumentationProvider.hasUrlsFor((DocumentationProvider)provider, (PsiElement)element, (PsiElement)originalElement);
        }
        return enabled;
    }

    private void registerActions() {
        if (!ScreenReader.isActive()) {
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(38, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                    int value = scrollBar.getValue() - scrollBar.getUnitIncrement(-1);
                    value = Math.max(value, 0);
                    scrollBar.setValue(value);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(40, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                    int value = scrollBar.getValue() + scrollBar.getUnitIncrement(1);
                    value = Math.min(value, scrollBar.getMaximum());
                    scrollBar.setValue(value);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(37, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getHorizontalScrollBar();
                    int value = scrollBar.getValue() - scrollBar.getUnitIncrement(-1);
                    value = Math.max(value, 0);
                    scrollBar.setValue(value);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(39, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getHorizontalScrollBar();
                    int value = scrollBar.getValue() + scrollBar.getUnitIncrement(1);
                    value = Math.min(value, scrollBar.getMaximum());
                    scrollBar.setValue(value);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(33, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                    int value = scrollBar.getValue() - scrollBar.getBlockIncrement(-1);
                    value = Math.max(value, 0);
                    scrollBar.setValue(value);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(34, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                    int value = scrollBar.getValue() + scrollBar.getBlockIncrement(1);
                    value = Math.min(value, scrollBar.getMaximum());
                    scrollBar.setValue(value);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(36, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getHorizontalScrollBar();
                    scrollBar.setValue(0);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(35, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getHorizontalScrollBar();
                    scrollBar.setValue(scrollBar.getMaximum());
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(36, 2), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                    scrollBar.setValue(0);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(35, 2), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                    scrollBar.setValue(scrollBar.getMaximum());
                }
            });
        }
    }

    public String getText() {
        return this.myText;
    }

    public void dispose() {
        this.myBackStack.clear();
        this.myForwardStack.clear();
        this.myKeyboardActions.clear();
        this.myElement = null;
        this.myManager = null;
        this.myHint = null;
    }

    private int getLinkCount() {
        HTMLDocument document = (HTMLDocument)this.myEditorPane.getDocument();
        int linkCount = 0;
        HTMLDocument.Iterator it = document.getIterator(HTML.Tag.A);
        while (it.isValid()) {
            if (it.getAttributes().isDefined(HTML.Attribute.HREF)) {
                ++linkCount;
            }
            it.next();
        }
        return linkCount;
    }

    @Nullable
    private HTMLDocument.Iterator getLink(int n) {
        if (n >= 0) {
            HTMLDocument document = (HTMLDocument)this.myEditorPane.getDocument();
            int linkCount = 0;
            HTMLDocument.Iterator it = document.getIterator(HTML.Tag.A);
            while (it.isValid()) {
                if (it.getAttributes().isDefined(HTML.Attribute.HREF) && linkCount++ == n) {
                    return it;
                }
                it.next();
            }
        }
        return null;
    }

    private void highlightLink(int n) {
        this.myHighlightedLink = n;
        Highlighter highlighter = this.myEditorPane.getHighlighter();
        HTMLDocument.Iterator link = this.getLink(n);
        if (link != null) {
            int startOffset = link.getStartOffset();
            int endOffset = link.getEndOffset();
            try {
                if (this.myHighlightingTag == null) {
                    this.myHighlightingTag = highlighter.addHighlight(startOffset, endOffset, LINK_HIGHLIGHTER);
                } else {
                    highlighter.changeHighlight(this.myHighlightingTag, startOffset, endOffset);
                }
                this.myEditorPane.setCaretPosition(startOffset);
            }
            catch (BadLocationException e) {
                LOG.warn("Error highlighting link", (Throwable)e);
            }
        } else if (this.myHighlightingTag != null) {
            highlighter.removeHighlight(this.myHighlightingTag);
            this.myHighlightingTag = null;
        }
    }

    private void activateLink(int n) {
        HTMLDocument.Iterator link = this.getLink(n);
        if (link != null) {
            String href = (String)link.getAttributes().getAttribute(HTML.Attribute.HREF);
            this.myManager.navigateByLink(this, href);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/documentation/DocumentationComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickDocFontSize";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBottom";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setQuickDocFontSize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RestoreDefaultSizeAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        public RestoreDefaultSizeAction() {
            super("Restore Size");
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(DocumentationComponent.this.myHint != null && DocumentationComponent.this.myHint.getDimensionServiceKey() != null);
        }

        public void actionPerformed(AnActionEvent e) {
            DimensionService.getInstance().setSize("javadoc.popup.new", null, ((DocumentationComponent)DocumentationComponent.this).myManager.myProject);
            DocumentationComponent.this.myHint.setDimensionServiceKey(null);
            DocumentationComponent.this.showHint();
        }
    }

    private class ShowAsToolwindowAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        public ShowAsToolwindowAction() {
            super("Open as Tool Window");
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(DocumentationComponent.this.myToolwindowCallback != null);
        }

        public void actionPerformed(AnActionEvent e) {
            DocumentationComponent.this.myToolwindowCallback.run();
        }
    }

    private class MyScrollPane
    extends JBScrollPane {
        public MyScrollPane() {
            super((Component)DocumentationComponent.this.myEditorPane, 20, 30);
            this.setLayout((LayoutManager)new JBScrollPane.Layout(){

                public void layoutContainer(Container parent) {
                    Rectangle bounds;
                    super.layoutContainer(parent);
                    if (!DocumentationComponent.this.myCorner.isVisible()) {
                        return;
                    }
                    if (this.vsb != null) {
                        bounds = this.vsb.getBounds();
                        this.vsb.setBounds(bounds.x, bounds.y, bounds.width, bounds.height - ((DocumentationComponent)DocumentationComponent.this).myCorner.getPreferredSize().height - 3);
                    }
                    if (this.hsb != null) {
                        bounds = this.hsb.getBounds();
                        int vsbOffset = this.vsb != null ? this.vsb.getBounds().width : 0;
                        this.hsb.setBounds(bounds.x, bounds.y, bounds.width - ((DocumentationComponent)DocumentationComponent.this).myCorner.getPreferredSize().width - 3 + vsbOffset, bounds.height);
                    }
                }
            });
        }

        public Border getViewportBorder() {
            return null;
        }

        protected void processMouseWheelEvent(MouseWheelEvent e) {
            if (!EditorSettingsExternalizable.getInstance().isWheelFontChangeEnabled() || !EditorUtil.isChangeFontSize(e)) {
                super.processMouseWheelEvent(e);
                return;
            }
            int rotation = e.getWheelRotation();
            if (rotation == 0) {
                return;
            }
            boolean increase = rotation <= 0;
            FontSize newFontSize = DocumentationComponent.getQuickDocFontSize();
            for (int change = Math.abs(rotation); change > 0; --change) {
                newFontSize = increase ? newFontSize.larger() : newFontSize.smaller();
            }
            if (newFontSize == DocumentationComponent.getQuickDocFontSize()) {
                return;
            }
            DocumentationComponent.this.setQuickDocFontSize(newFontSize);
            DocumentationComponent.this.applyFontProps();
            DocumentationComponent.this.setFontSizeSliderSize(newFontSize);
        }
    }

    private class ShowToolbarAction
    extends ToggleAction
    implements HintManagerImpl.ActionToIgnore {
        public ShowToolbarAction() {
            super("Show Toolbar");
        }

        public boolean isSelected(AnActionEvent e) {
            return Registry.get((String)"documentation.show.toolbar").asBoolean();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            Registry.get((String)"documentation.show.toolbar").setValue(state);
            DocumentationComponent.this.updateControlState();
            DocumentationComponent.this.showHint();
        }
    }

    private static class LinkHighlighter
    implements Highlighter.HighlightPainter {
        private static final Stroke STROKE = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{1.0f}, 0.0f);

        private LinkHighlighter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g, int p0, int p1, Shape bounds, JTextComponent c) {
            try {
                Rectangle target2 = c.getUI().getRootView(c).modelToView(p0, Position.Bias.Forward, p1, Position.Bias.Backward, bounds).getBounds();
                Graphics2D g2d = (Graphics2D)g.create();
                try {
                    g2d.setStroke(STROKE);
                    g2d.setColor(c.getSelectionColor());
                    g2d.drawRect(target2.x, target2.y, target2.width - 1, target2.height - 1);
                }
                finally {
                    g2d.dispose();
                }
            }
            catch (Exception e) {
                LOG.warn("Error painting link highlight", (Throwable)e);
            }
        }
    }

    private class ActivateLinkAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        private ActivateLinkAction() {
        }

        public void actionPerformed(AnActionEvent e) {
            DocumentationComponent.this.activateLink(DocumentationComponent.this.myHighlightedLink);
        }
    }

    private class NextLinkAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        private NextLinkAction() {
        }

        public void actionPerformed(AnActionEvent e) {
            int linkCount = DocumentationComponent.this.getLinkCount();
            if (linkCount <= 0) {
                return;
            }
            DocumentationComponent.this.highlightLink((DocumentationComponent.this.myHighlightedLink + 1) % linkCount);
        }
    }

    private class PreviousLinkAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        private PreviousLinkAction() {
        }

        public void actionPerformed(AnActionEvent e) {
            int linkCount = DocumentationComponent.this.getLinkCount();
            if (linkCount <= 0) {
                return;
            }
            DocumentationComponent.this.highlightLink(DocumentationComponent.this.myHighlightedLink < 0 ? linkCount - 1 : (DocumentationComponent.this.myHighlightedLink + linkCount - 1) % linkCount);
        }
    }

    private static abstract class MyDictionary<K, V>
    extends Dictionary<K, V> {
        private MyDictionary() {
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Enumeration<K> keys() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Enumeration<V> elements() {
            throw new UnsupportedOperationException();
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException();
        }
    }

    private class MyShowSettingsAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        public MyShowSettingsAction() {
            super("Adjust font size...");
        }

        public void actionPerformed(AnActionEvent e) {
            JBPopup popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder(DocumentationComponent.this.mySettingsPanel, (JComponent)DocumentationComponent.this.myFontSizeSlider).createPopup();
            DocumentationComponent.this.setFontSizeSliderSize(DocumentationComponent.getQuickDocFontSize());
            DocumentationComponent.this.mySettingsPanel.setVisible(true);
            Point location = MouseInfo.getPointerInfo().getLocation();
            popup2.show(new RelativePoint(new Point(location.x - ((DocumentationComponent)DocumentationComponent.this).mySettingsPanel.getPreferredSize().width / 2, location.y - ((DocumentationComponent)DocumentationComponent.this).mySettingsPanel.getPreferredSize().height / 2)));
        }
    }

    private class MyShowSettingsButton
    extends ActionButton {
        public MyShowSettingsButton() {
            this((AnAction)new MyGearActionGroup(new AnAction[]{documentationComponent.new ShowAsToolwindowAction(), documentationComponent.new MyShowSettingsAction(), documentationComponent.new ShowToolbarAction(), documentationComponent.new RestoreDefaultSizeAction()}), new Presentation(), "JavadocInplaceSettings", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        }

        private MyShowSettingsButton(AnAction action, Presentation presentation, @NotNull String place, Dimension minimumSize) {
            if (minimumSize == null) {
                MyShowSettingsButton.$$$reportNull$$$0(0);
            }
            super(action, presentation, place, minimumSize);
            this.myPresentation.setIcon(AllIcons.General.SecondaryGroup);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimumSize", "com/intellij/codeInsight/documentation/DocumentationComponent$MyShowSettingsButton", "<init>"));
        }
    }

    private class ExternalDocAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        private ExternalDocAction() {
            super(CodeInsightBundle.message((String)"javadoc.action.view.external", (Object[])new Object[0]), null, AllIcons.Actions.Browser_externalJavaDoc);
            this.registerCustomShortcutSet(ActionManager.getInstance().getAction("ExternalJavaDoc").getShortcutSet(), null);
        }

        public void actionPerformed(AnActionEvent e) {
            if (DocumentationComponent.this.myElement == null) {
                return;
            }
            PsiElement element = DocumentationComponent.this.myElement.getElement();
            PsiElement originalElement = DocumentationManager.getOriginalElement(element);
            ExternalJavaDocAction.showExternalJavadoc(element, originalElement, DocumentationComponent.this.myEffectiveExternalUrl, e.getDataContext());
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(DocumentationComponent.this.hasExternalDoc());
        }
    }

    private class EditDocumentationSourceAction
    extends BaseNavigateToSourceAction {
        private EditDocumentationSourceAction() {
            super(true);
            this.getTemplatePresentation().setIcon(AllIcons.Actions.EditSource);
            this.getTemplatePresentation().setText("Edit Source");
        }

        @Override
        public void update(AnActionEvent e) {
            super.update(e);
            if (!DocumentationComponent.isToolbar(e)) {
                e.getPresentation().setIcon(AllIcons.General.Inline_edit);
                e.getPresentation().setHoveredIcon(AllIcons.General.Inline_edit_hovered);
            }
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            super.actionPerformed(e);
            AbstractPopup hint = DocumentationComponent.this.myHint;
            if (hint != null && hint.isVisible()) {
                hint.cancel();
            }
        }

        @Override
        @Nullable
        protected Navigatable[] getNavigatables(DataContext dataContext) {
            SmartPsiElementPointer element = DocumentationComponent.this.myElement;
            if (element != null) {
                Navigatable[] navigatableArray;
                PsiElement psiElement = element.getElement();
                if (psiElement instanceof Navigatable) {
                    Navigatable[] navigatableArray2 = new Navigatable[1];
                    navigatableArray = navigatableArray2;
                    navigatableArray2[0] = (Navigatable)psiElement;
                } else {
                    navigatableArray = null;
                }
                return navigatableArray;
            }
            return null;
        }
    }

    private class ForwardAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        public ForwardAction() {
            super(CodeInsightBundle.message((String)"javadoc.action.forward", (Object[])new Object[0]), null, AllIcons.Actions.Forward);
        }

        public void actionPerformed(AnActionEvent e) {
            DocumentationComponent.this.goForward();
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(!DocumentationComponent.this.myForwardStack.isEmpty());
            if (!DocumentationComponent.isToolbar(e)) {
                presentation.setVisible(presentation.isEnabled());
                presentation.setIcon(AllIcons.Actions.Right);
            }
        }
    }

    private class BackAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        public BackAction() {
            super(CodeInsightBundle.message((String)"javadoc.action.back", (Object[])new Object[0]), null, AllIcons.Actions.Back);
        }

        public void actionPerformed(AnActionEvent e) {
            DocumentationComponent.this.goBack();
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(!DocumentationComponent.this.myBackStack.isEmpty());
            if (!DocumentationComponent.isToolbar(e)) {
                presentation.setVisible(presentation.isEnabled());
                presentation.setIcon(AllIcons.Actions.Left);
            }
        }
    }

    private static class MyGearActionGroup
    extends DefaultActionGroup
    implements HintManagerImpl.ActionToIgnore {
        public MyGearActionGroup(AnAction ... actions) {
            if (actions == null) {
                MyGearActionGroup.$$$reportNull$$$0(0);
            }
            super(actions);
            this.setPopup(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/codeInsight/documentation/DocumentationComponent$MyGearActionGroup", "<init>"));
        }
    }

    private static class Context {
        private final SmartPsiElementPointer element;
        private final String text;
        private final String externalUrl;
        private final Rectangle viewRect;
        private final int highlightedLink;

        public Context(SmartPsiElementPointer element, String text, String externalUrl, Rectangle viewRect, int highlightedLink) {
            this.element = element;
            this.text = text;
            this.externalUrl = externalUrl;
            this.viewRect = viewRect;
            this.highlightedLink = highlightedLink;
        }
    }
}

