/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.dvcs.DvcsRememberedInputs;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.hosting.RepositoryHostingService;
import com.intellij.dvcs.hosting.RepositoryListLoader;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ComboBoxCompositeEditor;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CloneDvcsDialog
extends DialogWrapper {
    private static final Pattern SSH_URL_PATTERN;
    private ComboBox<String> myRepositoryUrlCombobox;
    private EditorTextField myRepositoryUrlField;
    private ComponentVisibilityProgressManager mySpinnerProgressManager;
    private JButton myTestButton;
    private MyTextFieldWithBrowseButton myDirectoryField;
    private LoginButtonComponent myLoginButtonComponent;
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final String myVcsDirectoryName;
    @Nullable
    private ValidationInfo myCreateDirectoryValidationInfo;
    @Nullable
    private ValidationInfo myRepositoryTestValidationInfo;
    @Nullable
    private ProgressIndicator myRepositoryTestProgressIndicator;
    @NotNull
    private final List<String> myLoadedRepositoryHostingServicesNames;
    @Nullable
    private Alarm myRepositoryUrlAutoCompletionTooltipAlarm;
    @NotNull
    private final List<String> myAvailableRepositories;

    public CloneDvcsDialog(@NotNull Project project, @NotNull String displayName, @NotNull String vcsDirectoryName) {
        if (project == null) {
            CloneDvcsDialog.$$$reportNull$$$0(0);
        }
        if (displayName == null) {
            CloneDvcsDialog.$$$reportNull$$$0(1);
        }
        if (vcsDirectoryName == null) {
            CloneDvcsDialog.$$$reportNull$$$0(2);
        }
        this(project, displayName, vcsDirectoryName, null);
    }

    public CloneDvcsDialog(@NotNull Project project, @NotNull String displayName, @NotNull String vcsDirectoryName, @Nullable String defaultUrl) {
        if (project == null) {
            CloneDvcsDialog.$$$reportNull$$$0(3);
        }
        if (displayName == null) {
            CloneDvcsDialog.$$$reportNull$$$0(4);
        }
        if (vcsDirectoryName == null) {
            CloneDvcsDialog.$$$reportNull$$$0(5);
        }
        super(project, true);
        this.myProject = project;
        this.myVcsDirectoryName = vcsDirectoryName;
        this.myLoadedRepositoryHostingServicesNames = new ArrayList<String>();
        this.myAvailableRepositories = new ArrayList<String>();
        this.initComponents(defaultUrl);
        this.initUrlAutocomplete();
        this.setTitle(DvcsBundle.getString("clone.title"));
        this.setOKButtonText(DvcsBundle.getString("clone.button"));
        this.init();
    }

    protected void doOKAction() {
        this.myCreateDirectoryValidationInfo = this.createDestination();
        super.doOKAction();
    }

    @Nullable
    private ValidationInfo createDestination() {
        Path directoryPath = Paths.get(this.myDirectoryField.getText(), new String[0]);
        if (!Files.exists(directoryPath, new LinkOption[0])) {
            try {
                Files.createDirectories(directoryPath, new FileAttribute[0]);
            }
            catch (Exception e) {
                return new ValidationInfo(DvcsBundle.getString("clone.destination.directory.error.access"));
            }
        } else if (!Files.isDirectory(directoryPath, new LinkOption[0]) || !Files.isWritable(directoryPath)) {
            return new ValidationInfo(DvcsBundle.getString("clone.destination.directory.error.access"));
        }
        return null;
    }

    @NotNull
    public String getSourceRepositoryURL() {
        String string = this.getCurrentUrlText();
        if (string == null) {
            CloneDvcsDialog.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getParentDirectory() {
        Path parent = Paths.get(this.myDirectoryField.getText(), new String[0]).toAbsolutePath().getParent();
        String string = ((Path)ObjectUtils.assertNotNull((Object)parent)).toAbsolutePath().toString();
        if (string == null) {
            CloneDvcsDialog.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getDirectoryName() {
        String string = Paths.get(this.myDirectoryField.getText(), new String[0]).getFileName().toString();
        if (string == null) {
            CloneDvcsDialog.$$$reportNull$$$0(8);
        }
        return string;
    }

    private void initComponents(@Nullable String defaultUrl) {
        DvcsRememberedInputs rememberedInputs = this.getRememberedInputs();
        String parentDirectory = rememberedInputs.getCloneParentDir();
        this.myRepositoryUrlField = TextFieldWithAutoCompletion.create(this.myProject, this.myAvailableRepositories, false, "");
        JLabel repositoryUrlFieldSpinner = new JLabel(new AnimatedIcon.Default());
        repositoryUrlFieldSpinner.setVisible(false);
        this.mySpinnerProgressManager = new ComponentVisibilityProgressManager(repositoryUrlFieldSpinner);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.mySpinnerProgressManager);
        this.myRepositoryUrlCombobox = new ComboBox();
        this.myRepositoryUrlCombobox.setEditable(true);
        this.myRepositoryUrlCombobox.setEditor(ComboBoxCompositeEditor.withComponents(this.myRepositoryUrlField, repositoryUrlFieldSpinner));
        this.myRepositoryUrlField.addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent event) {
                CloneDvcsDialog.this.startTrackingValidation();
            }
        });
        this.myRepositoryUrlField.addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent event) {
                CloneDvcsDialog.this.myDirectoryField.trySetChildPath(CloneDvcsDialog.this.defaultDirectoryName(CloneDvcsDialog.this.myRepositoryUrlField.getText().trim()));
            }
        });
        this.myRepositoryUrlField.addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent event) {
                CloneDvcsDialog.this.myRepositoryTestValidationInfo = null;
            }
        });
        this.myTestButton = new JButton(DvcsBundle.getString("clone.repository.url.test.label"));
        this.myTestButton.addActionListener(e -> this.test());
        FileChooserDescriptor fcd = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fcd.setShowFileSystemRoots(true);
        fcd.setHideIgnored(false);
        this.myDirectoryField = new MyTextFieldWithBrowseButton(StringUtil.isEmptyOrSpaces((String)parentDirectory) ? ProjectUtil.getBaseDir() : parentDirectory);
        this.myDirectoryField.addBrowseFolderListener(DvcsBundle.getString("clone.destination.directory.browser.title"), DvcsBundle.getString("clone.destination.directory.browser.description"), this.myProject, fcd);
        this.myDirectoryField.getTextField().getDocument().addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(){

            protected void textChanged(javax.swing.event.DocumentEvent e) {
                CloneDvcsDialog.this.startTrackingValidation();
            }
        });
        boolean defaultAlreadyAdded = false;
        for (String url : rememberedInputs.getVisitedUrls()) {
            this.myRepositoryUrlCombobox.addItem((Object)url);
            if (defaultUrl == null) continue;
            defaultAlreadyAdded = defaultUrl.equalsIgnoreCase(url);
        }
        if (defaultUrl != null && !defaultAlreadyAdded) {
            this.myRepositoryUrlCombobox.addItem((Object)defaultUrl);
            this.myRepositoryUrlField.setText(defaultUrl);
        }
        this.myTestButton.setEnabled(!this.getCurrentUrlText().isEmpty());
    }

    private void initUrlAutocomplete() {
        Collection<RepositoryHostingService> repositoryHostingServices = this.getRepositoryHostingServices();
        if (repositoryHostingServices.size() > 1) {
            this.myRepositoryUrlAutoCompletionTooltipAlarm = new Alarm(this.getDisposable());
            this.myRepositoryUrlAutoCompletionTooltipAlarm.setActivationComponent(this.myRepositoryUrlCombobox);
        }
        ArrayList<Action> loginActions = new ArrayList<Action>();
        for (RepositoryHostingService service : repositoryHostingServices) {
            final String serviceDisplayName = service.getServiceDisplayName();
            final RepositoryListLoader loader = service.getRepositoryListLoader(this.myProject);
            if (loader.isEnabled()) {
                ApplicationManager.getApplication().invokeLater(() -> this.schedule(serviceDisplayName, loader), ModalityState.stateForComponent((Component)this.getRootPane()));
                continue;
            }
            loginActions.add(new AbstractAction(DvcsBundle.message("clone.repository.url.autocomplete.login.text", serviceDisplayName)){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (loader.enable()) {
                        CloneDvcsDialog.this.myLoginButtonComponent.removeAction(this);
                        CloneDvcsDialog.this.schedule(serviceDisplayName, loader);
                    }
                }
            });
        }
        this.myRepositoryUrlField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CloneDvcsDialog.this.showRepositoryUrlAutoCompletionTooltip();
            }
        });
        this.myLoginButtonComponent = new LoginButtonComponent(loginActions);
    }

    @NotNull
    protected Collection<RepositoryHostingService> getRepositoryHostingServices() {
        List<RepositoryHostingService> list2 = Collections.emptyList();
        if (list2 == null) {
            CloneDvcsDialog.$$$reportNull$$$0(9);
        }
        return list2;
    }

    private void schedule(final @NotNull String serviceDisplayName, final @NotNull RepositoryListLoader loader) {
        if (serviceDisplayName == null) {
            CloneDvcsDialog.$$$reportNull$$$0(10);
        }
        if (loader == null) {
            CloneDvcsDialog.$$$reportNull$$$0(11);
        }
        this.mySpinnerProgressManager.run(new Task.Backgroundable(this.myProject, "Not Visible"){
            private List<String> myLoadedRepositories;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    7.$$$reportNull$$$0(0);
                }
                this.myLoadedRepositories = loader.getAvailableRepositories(indicator);
            }

            public void onSuccess() {
                CloneDvcsDialog.this.myAvailableRepositories.addAll(this.myLoadedRepositories);
                CloneDvcsDialog.this.myLoadedRepositoryHostingServicesNames.add(serviceDisplayName);
                CloneDvcsDialog.this.showRepositoryUrlAutoCompletionTooltip();
            }

            public void onThrowable(@NotNull Throwable error) {
                if (error == null) {
                    7.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "error";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/dvcs/ui/CloneDvcsDialog$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onThrowable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void showRepositoryUrlAutoCompletionTooltip() {
        if (this.myRepositoryUrlAutoCompletionTooltipAlarm == null) {
            this.showRepositoryUrlAutoCompletionTooltipNow();
        } else {
            this.myRepositoryUrlAutoCompletionTooltipAlarm.cancelAllRequests();
            this.myRepositoryUrlAutoCompletionTooltipAlarm.addComponentRequest(this::showRepositoryUrlAutoCompletionTooltipNow, 1);
        }
    }

    private void showRepositoryUrlAutoCompletionTooltipNow() {
        if (!this.hasErrors((JComponent)this.myRepositoryUrlCombobox) && !this.myLoadedRepositoryHostingServicesNames.isEmpty()) {
            String completionShortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("CodeCompletion"));
            HintManager.getInstance().showInformationHint(Objects.requireNonNull(this.myRepositoryUrlField.getEditor()), DvcsBundle.message("clone.repository.url.autocomplete.hint", DvcsUtil.joinWithAnd(this.myLoadedRepositoryHostingServicesNames, 0), completionShortcutText));
        }
    }

    private void test() {
        final String testUrl = this.getCurrentUrlText();
        if (this.myRepositoryTestProgressIndicator != null) {
            this.myRepositoryTestProgressIndicator.cancel();
            this.myRepositoryTestProgressIndicator = null;
        }
        this.myRepositoryTestProgressIndicator = this.mySpinnerProgressManager.run(new Task.Backgroundable(this.myProject, DvcsBundle.message("clone.repository.url.test.title", testUrl), true){
            private TestResult myTestResult;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    8.$$$reportNull$$$0(0);
                }
                this.myTestResult = CloneDvcsDialog.this.test(testUrl);
            }

            public void onSuccess() {
                if (this.myTestResult.isSuccess()) {
                    CloneDvcsDialog.this.myRepositoryTestValidationInfo = null;
                    JBPopupFactory.getInstance().createBalloonBuilder((JComponent)new JLabel(DvcsBundle.getString("clone.repository.url.test.success.message"))).setDisposable(CloneDvcsDialog.this.getDisposable()).createBalloon().show(new RelativePoint((Component)CloneDvcsDialog.this.myTestButton, new Point(CloneDvcsDialog.this.myTestButton.getWidth() / 2, CloneDvcsDialog.this.myTestButton.getHeight())), Balloon.Position.below);
                } else {
                    CloneDvcsDialog.this.myRepositoryTestValidationInfo = new ValidationInfo(DvcsBundle.message("clone.repository.url.test.failed.message", this.myTestResult.myErrorMessage), (JComponent)CloneDvcsDialog.this.myRepositoryUrlCombobox);
                }
                CloneDvcsDialog.this.myRepositoryTestProgressIndicator = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dvcs/ui/CloneDvcsDialog$8", "run"));
            }
        });
    }

    @NotNull
    protected abstract TestResult test(@NotNull String var1);

    @NotNull
    protected abstract DvcsRememberedInputs getRememberedInputs();

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        ValidationInfo urlValidation = this.checkRepositoryURL();
        ValidationInfo directoryValidation = this.checkDirectory();
        this.myTestButton.setEnabled(urlValidation == null);
        ArrayList<ValidationInfo> infoList = new ArrayList<ValidationInfo>();
        ContainerUtil.addIfNotNull(infoList, (Object)this.myRepositoryTestValidationInfo);
        ContainerUtil.addIfNotNull(infoList, (Object)this.myCreateDirectoryValidationInfo);
        ContainerUtil.addIfNotNull(infoList, (Object)urlValidation);
        ContainerUtil.addIfNotNull(infoList, (Object)directoryValidation);
        ArrayList<ValidationInfo> arrayList = infoList;
        if (arrayList == null) {
            CloneDvcsDialog.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @Nullable
    private ValidationInfo checkRepositoryURL() {
        String repository = this.getCurrentUrlText();
        if (repository.length() == 0) {
            return new ValidationInfo(DvcsBundle.getString("clone.repository.url.error.empty"), this.myRepositoryUrlCombobox);
        }
        try {
            if (new URI(repository).isAbsolute()) {
                return null;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (SSH_URL_PATTERN.matcher(repository).matches()) {
            return null;
        }
        try {
            Path path = Paths.get(repository, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    return new ValidationInfo(DvcsBundle.getString("clone.repository.url.error.not.directory"), this.myRepositoryUrlCombobox);
                }
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ValidationInfo(DvcsBundle.getString("clone.repository.url.error.invalid"), this.myRepositoryUrlCombobox);
    }

    @Nullable
    private ValidationInfo checkDirectory() {
        String directoryPath = this.myDirectoryField.getText();
        if (directoryPath.length() == 0) {
            return new ValidationInfo("");
        }
        try {
            Path path = Paths.get(directoryPath, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            if (!Files.isDirectory(path, new LinkOption[0])) {
                return new ValidationInfo(DvcsBundle.getString("clone.destination.directory.error.not.directory"), (JComponent)this.myDirectoryField.getTextField());
            }
            if (!CloneDvcsDialog.isDirectoryEmpty(path)) {
                return new ValidationInfo(DvcsBundle.message("clone.destination.directory.error.exists", new Object[0]), (JComponent)this.myDirectoryField.getTextField());
            }
        }
        catch (IOException | InvalidPathException e) {
            return new ValidationInfo(DvcsBundle.getString("clone.destination.directory.error.invalid"), (JComponent)this.myDirectoryField.getTextField());
        }
        return null;
    }

    private static boolean isDirectoryEmpty(@NotNull Path directory) throws IOException {
        DirectoryStream<Path> directoryStream;
        if (directory == null) {
            CloneDvcsDialog.$$$reportNull$$$0(13);
        }
        return !(directoryStream = Files.newDirectoryStream(directory)).iterator().hasNext();
    }

    @NotNull
    private String getCurrentUrlText() {
        String string = FileUtil.expandUserHome((String)this.myRepositoryUrlField.getText().trim());
        if (string == null) {
            CloneDvcsDialog.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Deprecated
    public void prependToHistory(@NotNull String item) {
        if (item == null) {
            CloneDvcsDialog.$$$reportNull$$$0(15);
        }
        this.myRepositoryUrlCombobox.addItem((Object)item);
    }

    public void rememberSettings() {
        DvcsRememberedInputs rememberedInputs = this.getRememberedInputs();
        rememberedInputs.addUrl(this.getSourceRepositoryURL());
        rememberedInputs.setCloneParentDir(this.getParentDirectory());
    }

    @NotNull
    private static String safeUrlDecode(@NotNull String encoded) {
        String string;
        if (encoded == null) {
            CloneDvcsDialog.$$$reportNull$$$0(16);
        }
        try {
            string = URLDecoder.decode(encoded, "UTF-8");
        }
        catch (Exception e) {
            String string2 = encoded;
            if (string2 == null) {
                CloneDvcsDialog.$$$reportNull$$$0(18);
            }
            return string2;
        }
        if (string == null) {
            CloneDvcsDialog.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private String defaultDirectoryName(@NotNull String url) {
        if (url == null) {
            CloneDvcsDialog.$$$reportNull$$$0(19);
        }
        String string = this.stripSuffix(CloneDvcsDialog.safeUrlDecode(CloneDvcsDialog.getLastPathFragment(url)));
        if (string == null) {
            CloneDvcsDialog.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    private String stripSuffix(@NotNull String directoryName) {
        if (directoryName == null) {
            CloneDvcsDialog.$$$reportNull$$$0(21);
        }
        String string = directoryName.endsWith(this.myVcsDirectoryName) ? directoryName.substring(0, directoryName.length() - this.myVcsDirectoryName.length()) : directoryName;
        if (string == null) {
            CloneDvcsDialog.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    private static String getLastPathFragment(@NotNull String url) {
        int i;
        if (url == null) {
            CloneDvcsDialog.$$$reportNull$$$0(23);
        }
        if ((i = url.lastIndexOf(47)) == -1 && File.separatorChar != '/') {
            i = url.lastIndexOf(File.separatorChar);
        }
        if (i < 0) {
            if ("" == null) {
                CloneDvcsDialog.$$$reportNull$$$0(24);
            }
            return "";
        }
        if (i == url.length() - 1) {
            String string = CloneDvcsDialog.getLastPathFragment(url.substring(0, i));
            if (string == null) {
                CloneDvcsDialog.$$$reportNull$$$0(25);
            }
            return string;
        }
        String string = url.substring(i + 1);
        if (string == null) {
            CloneDvcsDialog.$$$reportNull$$$0(26);
        }
        return string;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myRepositoryUrlField;
    }

    @NotNull
    protected JPanel createSouthAdditionalPanel() {
        JPanel jPanel = this.myLoginButtonComponent.getPanel();
        if (jPanel == null) {
            CloneDvcsDialog.$$$reportNull$$$0(27);
        }
        return jPanel;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel jPanel = UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JComponent)JBUI.Panels.simplePanel((int)10, (int)4).addToCenter(this.myRepositoryUrlCombobox).addToRight((Component)this.myTestButton)).withLabel(DvcsBundle.getString("clone.repository.url.label"))).add((PanelBuilder)UI.PanelFactory.panel((JComponent)((Object)this.myDirectoryField)).withLabel(DvcsBundle.getString("clone.destination.directory.label"))).createPanel();
        if (jPanel == null) {
            CloneDvcsDialog.$$$reportNull$$$0(28);
        }
        return jPanel;
    }

    static {
        String ch = "[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]";
        String host = "[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:\\.[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*";
        String path = "/?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:/[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*/?";
        String all = "(?:[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+@)?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:\\.[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*:/?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:/[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*/?";
        SSH_URL_PATTERN = Pattern.compile("(?:[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+@)?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:\\.[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*:/?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:/[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*/?");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsDirectoryName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/ui/CloneDvcsDialog";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceDisplayName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoded";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/ui/CloneDvcsDialog";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRepositoryURL";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentDirectory";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoryName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryHostingServices";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidateAll";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentUrlText";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "safeUrlDecode";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultDirectoryName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "stripSuffix";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastPathFragment";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createSouthAdditionalPanel";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "schedule";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isDirectoryEmpty";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "prependToHistory";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "safeUrlDecode";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "defaultDirectoryName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "stripSuffix";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLastPathFragment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LoginButtonComponent {
        @NotNull
        private final JBOptionButton myButton;
        @NotNull
        private final JPanel myPanel;
        @NotNull
        private final List<Action> myActions;

        public LoginButtonComponent(@NotNull List<Action> actions) {
            if (actions == null) {
                LoginButtonComponent.$$$reportNull$$$0(0);
            }
            this.myButton = new JBOptionButton((Action)ContainerUtil.getFirstItem(actions), LoginButtonComponent.getActionsAfterFirst(actions));
            this.myPanel = UI.PanelFactory.panel((JComponent)this.myButton).withTooltip(DvcsBundle.getString("clone.repository.url.autocomplete.login.tooltip")).createPanel();
            this.myPanel.setVisible(!actions.isEmpty());
            this.myActions = new ArrayList<Action>(actions);
        }

        void removeAction(@NotNull Action action) {
            if (action == null) {
                LoginButtonComponent.$$$reportNull$$$0(1);
            }
            if (this.myActions.remove(action)) {
                if (!this.myActions.isEmpty()) {
                    this.myButton.setAction((Action)ContainerUtil.getFirstItem(this.myActions));
                    this.myButton.setOptions(LoginButtonComponent.getActionsAfterFirst(this.myActions));
                } else {
                    this.myButton.setAction(null);
                    this.myButton.setOptions(null);
                    this.myPanel.setVisible(false);
                }
            }
        }

        @NotNull
        private static Action[] getActionsAfterFirst(@NotNull List<Action> actions) {
            if (actions == null) {
                LoginButtonComponent.$$$reportNull$$$0(2);
            }
            if (actions.size() <= 1) {
                Action[] actionArray = new Action[]{};
                if (actionArray == null) {
                    LoginButtonComponent.$$$reportNull$$$0(3);
                }
                return actionArray;
            }
            Action[] actionArray = actions.subList(1, actions.size()).toArray(new Action[actions.size() - 1]);
            if (actionArray == null) {
                LoginButtonComponent.$$$reportNull$$$0(4);
            }
            return actionArray;
        }

        @NotNull
        public JPanel getPanel() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                LoginButtonComponent.$$$reportNull$$$0(5);
            }
            return jPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dvcs/ui/CloneDvcsDialog$LoginButtonComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dvcs/ui/CloneDvcsDialog$LoginButtonComponent";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionsAfterFirst";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "removeAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getActionsAfterFirst";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ComponentVisibilityProgressManager
    implements Disposable {
        @NotNull
        private final JComponent myProgressDisplayComponent;
        @NotNull
        private final List<ProgressIndicator> myIndicators;

        public ComponentVisibilityProgressManager(@NotNull JComponent progressDisplayComponent) {
            if (progressDisplayComponent == null) {
                ComponentVisibilityProgressManager.$$$reportNull$$$0(0);
            }
            this.myProgressDisplayComponent = progressDisplayComponent;
            this.myIndicators = new ArrayList<ProgressIndicator>();
        }

        public ProgressIndicator run(@NotNull Task.Backgroundable task) {
            if (task == null) {
                ComponentVisibilityProgressManager.$$$reportNull$$$0(1);
            }
            EmptyProgressIndicator indicator = new EmptyProgressIndicator(ModalityState.stateForComponent((Component)this.myProgressDisplayComponent));
            this.myIndicators.add((ProgressIndicator)indicator);
            this.myProgressDisplayComponent.setVisible(true);
            ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(task, (ProgressIndicator)indicator, () -> this.lambda$run$1((ProgressIndicator)indicator));
            return indicator;
        }

        public void dispose() {
            for (ProgressIndicator indicator : this.myIndicators) {
                indicator.cancel();
            }
        }

        private /* synthetic */ void lambda$run$1(ProgressIndicator indicator) {
            ApplicationManager.getApplication().invokeLater(() -> {
                this.myIndicators.remove(indicator);
                this.myProgressDisplayComponent.setVisible(!this.myIndicators.isEmpty());
            }, indicator.getModalityState());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressDisplayComponent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/dvcs/ui/CloneDvcsDialog$ComponentVisibilityProgressManager";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyTextFieldWithBrowseButton
    extends TextFieldWithBrowseButton {
        @NotNull
        private final Path myDefaultParentPath;
        private boolean myModifiedByUser;

        private MyTextFieldWithBrowseButton(@NotNull String defaultParentPath) {
            if (defaultParentPath == null) {
                MyTextFieldWithBrowseButton.$$$reportNull$$$0(0);
            }
            this.myModifiedByUser = false;
            this.myDefaultParentPath = Paths.get(defaultParentPath, new String[0]).toAbsolutePath();
            this.setText(this.myDefaultParentPath.toString());
            this.getTextField().getDocument().addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(){

                protected void textChanged(javax.swing.event.DocumentEvent e) {
                    myModifiedByUser = true;
                }
            });
        }

        public void trySetChildPath(@NotNull String child) {
            if (child == null) {
                MyTextFieldWithBrowseButton.$$$reportNull$$$0(1);
            }
            if (!this.myModifiedByUser) {
                this.setText(this.myDefaultParentPath.resolve(child).toString());
                this.myModifiedByUser = false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultParentPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/dvcs/ui/CloneDvcsDialog$MyTextFieldWithBrowseButton";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "trySetChildPath";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class TestResult {
        @NotNull
        public static final TestResult SUCCESS = new TestResult(null);
        @Nullable
        private final String myErrorMessage;

        public TestResult(@Nullable String errorMessage) {
            this.myErrorMessage = errorMessage;
        }

        public boolean isSuccess() {
            return this.myErrorMessage == null;
        }

        @Nullable
        public String getError() {
            return this.myErrorMessage;
        }
    }
}

