/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.revertion;

import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.util.text.DateFormatUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class Reverter {
    private final Project myProject;
    protected LocalHistoryFacade myVcs;
    protected IdeaGateway myGateway;

    protected Reverter(Project p, LocalHistoryFacade vcs, IdeaGateway gw) {
        this.myProject = p;
        this.myVcs = vcs;
        this.myGateway = gw;
    }

    public List<String> askUserForProceeding() throws IOException {
        return Collections.emptyList();
    }

    public List<String> checkCanRevert() throws IOException {
        if (!this.askForReadOnlyStatusClearing()) {
            return Collections.singletonList(LocalHistoryBundle.message("revert.error.files.are.read.only", new Object[0]));
        }
        return Collections.emptyList();
    }

    protected boolean askForReadOnlyStatusClearing() throws IOException {
        return this.myGateway.ensureFilesAreWritable(this.myProject, this.getFilesToClearROStatus());
    }

    protected List<VirtualFile> getFilesToClearROStatus() throws IOException {
        final HashSet files = new HashSet();
        this.myVcs.accept(this.selective(new ChangeVisitor(){

            @Override
            public void visit(StructuralChange c) throws ChangeVisitor.StopVisitingException {
                files.addAll(Reverter.this.myGateway.getAllFilesFrom(c.getPath()));
            }
        }));
        return new ArrayList<VirtualFile>(files);
    }

    protected ChangeVisitor selective(ChangeVisitor v) {
        return v;
    }

    public void revert() throws IOException {
        try {
            new WriteCommandAction(this.myProject, this.getCommandName(), new PsiFile[0]){

                protected void run(@NotNull Result objectResult) throws Throwable {
                    if (objectResult == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    Reverter.this.myGateway.saveAllUnsavedDocuments();
                    Reverter.this.doRevert();
                    Reverter.this.myGateway.saveAllUnsavedDocuments();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectResult", "com/intellij/history/integration/revertion/Reverter$2", "run"));
                }
            }.execute();
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw e;
        }
    }

    public String getCommandName() {
        Revision to = this.getTargetRevision();
        String name = to.getChangeSetName();
        String date = DateFormatUtil.formatDateTime((long)to.getTimestamp());
        if (name != null) {
            return LocalHistoryBundle.message("system.label.revert.to.change.date", name, date);
        }
        return LocalHistoryBundle.message("system.label.revert.to.date", date);
    }

    protected abstract Revision getTargetRevision();

    protected abstract void doRevert() throws IOException, FilesTooBigForDiffException;
}

