/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.impl.BundledFileTemplate;
import com.intellij.ide.fileTemplates.impl.CustomFileTemplate;
import com.intellij.ide.fileTemplates.impl.DefaultTemplate;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FTManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.fileTemplates.impl.FTManager");
    private static final String DEFAULT_TEMPLATE_EXTENSION = "ft";
    static final String TEMPLATE_EXTENSION_SUFFIX = ".ft";
    private static final String ENCODED_NAME_EXT_DELIMITER = "\u0f0fext\u0f0f.";
    private final String myName;
    private final boolean myInternal;
    private final File myTemplatesDir;
    @Nullable
    private final FTManager myOriginal;
    private final Map<String, FileTemplateBase> myTemplates;
    private volatile List<FileTemplateBase> mySortedTemplates;
    private final List<DefaultTemplate> myDefaultTemplates;

    FTManager(@NotNull @NonNls String name, @NotNull @NonNls File defaultTemplatesDirName) {
        if (name == null) {
            FTManager.$$$reportNull$$$0(0);
        }
        if (defaultTemplatesDirName == null) {
            FTManager.$$$reportNull$$$0(1);
        }
        this(name, defaultTemplatesDirName, false);
    }

    FTManager(@NotNull @NonNls String name, @NotNull @NonNls File defaultTemplatesDirName, boolean internal) {
        if (name == null) {
            FTManager.$$$reportNull$$$0(2);
        }
        if (defaultTemplatesDirName == null) {
            FTManager.$$$reportNull$$$0(3);
        }
        this.myTemplates = new HashMap<String, FileTemplateBase>();
        this.myDefaultTemplates = new ArrayList<DefaultTemplate>();
        this.myName = name;
        this.myInternal = internal;
        this.myTemplatesDir = defaultTemplatesDirName;
        this.myOriginal = null;
    }

    FTManager(@NotNull FTManager original) {
        if (original == null) {
            FTManager.$$$reportNull$$$0(4);
        }
        this.myTemplates = new HashMap<String, FileTemplateBase>();
        this.myDefaultTemplates = new ArrayList<DefaultTemplate>();
        this.myOriginal = original;
        this.myName = original.getName();
        this.myTemplatesDir = original.myTemplatesDir;
        this.myInternal = original.myInternal;
        this.myTemplates.putAll(original.myTemplates);
        this.myDefaultTemplates.addAll(original.myDefaultTemplates);
    }

    public String getName() {
        return this.myName;
    }

    @NotNull
    Collection<FileTemplateBase> getAllTemplates(boolean includeDisabled) {
        List<FileTemplateBase> sorted = this.mySortedTemplates;
        if (sorted == null) {
            sorted = new ArrayList<FileTemplateBase>(this.getTemplates().values());
            Collections.sort(sorted, (t1, t2) -> t1.getName().compareToIgnoreCase(t2.getName()));
            this.mySortedTemplates = sorted;
        }
        if (includeDisabled) {
            Collection<FileTemplateBase> collection = Collections.unmodifiableCollection(sorted);
            if (collection == null) {
                FTManager.$$$reportNull$$$0(5);
            }
            return collection;
        }
        ArrayList<FileTemplateBase> list2 = new ArrayList<FileTemplateBase>(sorted.size());
        for (FileTemplateBase template : sorted) {
            if (template instanceof BundledFileTemplate && !((BundledFileTemplate)template).isEnabled()) continue;
            list2.add(template);
        }
        ArrayList<FileTemplateBase> arrayList = list2;
        if (arrayList == null) {
            FTManager.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Nullable
    FileTemplateBase getTemplate(@NotNull String templateQname) {
        if (templateQname == null) {
            FTManager.$$$reportNull$$$0(7);
        }
        return this.getTemplates().get(templateQname);
    }

    @Nullable
    public FileTemplateBase findTemplateByName(@NotNull String templateName) {
        FileTemplateBase template;
        if (templateName == null) {
            FTManager.$$$reportNull$$$0(8);
        }
        if ((template = this.getTemplates().get(templateName)) != null) {
            boolean isEnabled;
            boolean bl = isEnabled = !(template instanceof BundledFileTemplate) || ((BundledFileTemplate)template).isEnabled();
            if (isEnabled) {
                return template;
            }
        }
        for (FileTemplateBase t : this.getAllTemplates(false)) {
            String remainder;
            String qName = t.getQualifiedName();
            if (!qName.startsWith(templateName) || qName.length() <= templateName.length() || !(remainder = qName.substring(templateName.length())).startsWith(ENCODED_NAME_EXT_DELIMITER) && remainder.charAt(0) != '.') continue;
            return t;
        }
        return null;
    }

    @NotNull
    public FileTemplateBase addTemplate(@NotNull String name, @NotNull String extension) {
        String qName;
        FileTemplateBase template;
        if (name == null) {
            FTManager.$$$reportNull$$$0(9);
        }
        if (extension == null) {
            FTManager.$$$reportNull$$$0(10);
        }
        if ((template = this.getTemplate(qName = FileTemplateBase.getQualifiedName(name, extension))) == null) {
            template = new CustomFileTemplate(name, extension);
            this.getTemplates().put(qName, template);
            this.mySortedTemplates = null;
        } else if (template instanceof BundledFileTemplate && !((BundledFileTemplate)template).isEnabled()) {
            ((BundledFileTemplate)template).setEnabled(true);
        }
        FileTemplateBase fileTemplateBase = template;
        if (fileTemplateBase == null) {
            FTManager.$$$reportNull$$$0(11);
        }
        return fileTemplateBase;
    }

    public void removeTemplate(@NotNull String qName) {
        FileTemplateBase template;
        if (qName == null) {
            FTManager.$$$reportNull$$$0(12);
        }
        if ((template = this.getTemplates().get(qName)) instanceof CustomFileTemplate) {
            this.getTemplates().remove(qName);
            this.mySortedTemplates = null;
        } else if (template instanceof BundledFileTemplate) {
            ((BundledFileTemplate)template).setEnabled(false);
        }
    }

    void updateTemplates(@NotNull Collection<FileTemplate> newTemplates) {
        if (newTemplates == null) {
            FTManager.$$$reportNull$$$0(13);
        }
        HashSet<String> toDisable = new HashSet<String>();
        for (DefaultTemplate defaultTemplate : this.myDefaultTemplates) {
            toDisable.add(defaultTemplate.getQualifiedName());
        }
        for (FileTemplate fileTemplate : newTemplates) {
            toDisable.remove(((FileTemplateBase)fileTemplate).getQualifiedName());
        }
        this.restoreDefaults(toDisable);
        for (FileTemplate fileTemplate : newTemplates) {
            FileTemplateBase _template = this.addTemplate(fileTemplate.getName(), fileTemplate.getExtension());
            _template.setText(fileTemplate.getText());
            _template.setReformatCode(fileTemplate.isReformatCode());
            _template.setLiveTemplateEnabled(fileTemplate.isLiveTemplateEnabled());
        }
        this.saveTemplates(true);
    }

    private void restoreDefaults(Set<String> toDisable) {
        this.getTemplates().clear();
        this.mySortedTemplates = null;
        for (DefaultTemplate template : this.myDefaultTemplates) {
            BundledFileTemplate bundled = this.createAndStoreBundledTemplate(template);
            if (!toDisable.contains(bundled.getQualifiedName())) continue;
            bundled.setEnabled(false);
        }
    }

    void addDefaultTemplate(DefaultTemplate template) {
        this.myDefaultTemplates.add(template);
        this.createAndStoreBundledTemplate(template);
    }

    private BundledFileTemplate createAndStoreBundledTemplate(DefaultTemplate template) {
        BundledFileTemplate bundled = new BundledFileTemplate(template, this.myInternal);
        String qName = bundled.getQualifiedName();
        FileTemplateBase previous = this.getTemplates().put(qName, bundled);
        this.mySortedTemplates = null;
        LOG.assertTrue(previous == null, (Object)("Duplicate bundled template " + qName + " [" + template.getTemplateURL() + ", " + previous + ']'));
        return bundled;
    }

    void loadCustomizedContent() {
        File configRoot = this.getConfigRoot(false);
        File[] configFiles = configRoot.listFiles();
        if (configFiles == null) {
            return;
        }
        ArrayList<File> templateWithDefaultExtension = new ArrayList<File>();
        HashSet<String> processedNames = new HashSet<String>();
        for (File file2 : configFiles) {
            if (file2.isDirectory() || FileTypeManager.getInstance().isFileIgnored(file2.getName()) || file2.isHidden()) continue;
            String name = file2.getName();
            if (name.endsWith(TEMPLATE_EXTENSION_SUFFIX)) {
                templateWithDefaultExtension.add(file2);
                continue;
            }
            processedNames.add(name);
            this.addTemplateFromFile(name, file2);
        }
        for (File file3 : templateWithDefaultExtension) {
            String name = file3.getName();
            if (!processedNames.contains(name = name.substring(0, name.length() - TEMPLATE_EXTENSION_SUFFIX.length()))) {
                this.addTemplateFromFile(name, file3);
            }
            FileUtil.delete((File)file3);
        }
    }

    private void addTemplateFromFile(@NotNull String fileName, @NotNull File file2) {
        if (fileName == null) {
            FTManager.$$$reportNull$$$0(14);
        }
        if (file2 == null) {
            FTManager.$$$reportNull$$$0(15);
        }
        Pair<String, String> nameExt = FTManager.decodeFileName(fileName);
        String extension = (String)nameExt.second;
        String templateQName = (String)nameExt.first;
        if (templateQName.isEmpty()) {
            return;
        }
        try {
            String text = FileUtil.loadFile((File)file2, (Charset)CharsetToolkit.UTF8_CHARSET);
            this.addTemplate(templateQName, extension).setText(text);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public void saveTemplates() {
        this.saveTemplates(false);
    }

    private void saveTemplates(boolean removeDeleted) {
        HashMap<String, File> templatesOnDisk;
        File configRoot = this.getConfigRoot(true);
        File[] files = configRoot.listFiles();
        HashSet<String> allNames = new HashSet<String>();
        HashMap<String, File> hashMap = templatesOnDisk = files != null && files.length > 0 ? new HashMap<String, File>() : Collections.emptyMap();
        if (files != null) {
            for (File file2 : files) {
                if (file2.isDirectory()) continue;
                String name = file2.getName();
                templatesOnDisk.put(name, file2);
                allNames.add(name);
            }
        }
        HashMap<String, FileTemplateBase> templatesToSave = new HashMap<String, FileTemplateBase>();
        for (FileTemplateBase template : this.getAllTemplates(true)) {
            if (template instanceof BundledFileTemplate && !((BundledFileTemplate)template).isTextModified()) continue;
            String name = template.getQualifiedName();
            templatesToSave.put(name, template);
            allNames.add(name);
        }
        if (!allNames.isEmpty()) {
            String lineSeparator = CodeStyle.getDefaultSettings().getLineSeparator();
            for (String name : allNames) {
                File customizedTemplateFile = (File)templatesOnDisk.get(name);
                FileTemplateBase templateToSave = (FileTemplateBase)templatesToSave.get(name);
                if (customizedTemplateFile == null) {
                    try {
                        FTManager.saveTemplate(configRoot, templateToSave, lineSeparator);
                    }
                    catch (IOException e) {
                        LOG.error("Unable to save template " + name, (Throwable)e);
                    }
                    continue;
                }
                if (templateToSave == null) {
                    if (!removeDeleted) continue;
                    FileUtil.delete((File)customizedTemplateFile);
                    continue;
                }
                try {
                    String templateText;
                    String diskText = StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)customizedTemplateFile, (Charset)CharsetToolkit.UTF8_CHARSET));
                    if (diskText.equals(templateText = templateToSave.getText())) continue;
                    FTManager.saveTemplate(configRoot, templateToSave, lineSeparator);
                }
                catch (IOException e) {
                    LOG.error("Unable to save template " + name, (Throwable)e);
                }
            }
        }
    }

    private static void saveTemplate(File parentDir, FileTemplateBase template, String lineSeparator) throws IOException {
        FileOutputStream fileOutputStream;
        File templateFile = new File(parentDir, FTManager.encodeFileName(template.getName(), template.getExtension()));
        try {
            fileOutputStream = new FileOutputStream(templateFile);
        }
        catch (FileNotFoundException e) {
            FileUtil.delete((File)templateFile);
            fileOutputStream = new FileOutputStream(templateFile);
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, CharsetToolkit.UTF8_CHARSET);
        String content = template.getText();
        if (!lineSeparator.equals("\n")) {
            content = StringUtil.convertLineSeparators((String)content, (String)lineSeparator);
        }
        outputStreamWriter.write(content);
        outputStreamWriter.close();
        fileOutputStream.close();
    }

    @NotNull
    File getConfigRoot(boolean create2) {
        if (create2 && !this.myTemplatesDir.mkdirs() && !this.myTemplatesDir.exists()) {
            LOG.info("Cannot create directory: " + this.myTemplatesDir.getAbsolutePath());
        }
        File file2 = this.myTemplatesDir;
        if (file2 == null) {
            FTManager.$$$reportNull$$$0(16);
        }
        return file2;
    }

    public String toString() {
        return this.myName + " file template manager";
    }

    @NotNull
    static String encodeFileName(@NotNull String templateName, @NotNull String extension) {
        if (templateName == null) {
            FTManager.$$$reportNull$$$0(17);
        }
        if (extension == null) {
            FTManager.$$$reportNull$$$0(18);
        }
        String nameExtDelimiter = extension.contains(".") ? ENCODED_NAME_EXT_DELIMITER : ".";
        String string = templateName + nameExtDelimiter + extension;
        if (string == null) {
            FTManager.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    private static Pair<String, String> decodeFileName(@NotNull String fileName) {
        if (fileName == null) {
            FTManager.$$$reportNull$$$0(20);
        }
        String name = fileName;
        String ext = "";
        String nameExtDelimiter = fileName.contains(ENCODED_NAME_EXT_DELIMITER) ? ENCODED_NAME_EXT_DELIMITER : ".";
        int extIndex = fileName.lastIndexOf(nameExtDelimiter);
        if (extIndex >= 0) {
            name = fileName.substring(0, extIndex);
            ext = fileName.substring(extIndex + nameExtDelimiter.length());
        }
        Pair pair = Pair.create((Object)name, (Object)ext);
        if (pair == null) {
            FTManager.$$$reportNull$$$0(21);
        }
        return pair;
    }

    public Map<String, FileTemplateBase> getTemplates() {
        return this.myOriginal != null ? this.myOriginal.myTemplates : this.myTemplates;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 16: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 16: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultTemplatesDirName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 16: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/fileTemplates/impl/FTManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateQname";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTemplates";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/fileTemplates/impl/FTManager";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTemplates";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "addTemplate";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigRoot";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "encodeFileName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "decodeFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 16: 
            case 19: 
            case 21: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTemplate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findTemplateByName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addTemplate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeTemplate";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateTemplates";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addTemplateFromFile";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "encodeFileName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "decodeFileName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 16: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

