/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.ImplementationConflictException;
import com.intellij.diagnostic.PluginConflictReporter;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.ClassUtilCore;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginManagerUISettings;
import com.intellij.idea.IdeaApplication;
import com.intellij.idea.Main;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.PicoPluginExtensionInitializationException;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginManager
extends PluginManagerCore {
    public static final String INSTALLED_TXT = "installed.txt";
    public static long startupStart;
    private static final Thread.UncaughtExceptionHandler HANDLER;

    protected static void start(String mainClass, String methodName, String[] args) {
        startupStart = System.nanoTime();
        Main.setFlags((String[])args);
        ThreadGroup threadGroup = new ThreadGroup("Idea Thread Group"){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                PluginManager.processException(e);
            }
        };
        Runnable runnable2 = () -> {
            try {
                ClassUtilCore.clearJarURLCache();
                Class<?> aClass = Class.forName(mainClass);
                Method method = aClass.getDeclaredMethod(methodName, ArrayUtil.EMPTY_STRING_ARRAY.getClass());
                method.setAccessible(true);
                Object[] argsArray = new Object[]{args};
                method.invoke(null, argsArray);
            }
            catch (Throwable t) {
                throw new StartupAbortedException(t);
            }
        };
        new Thread(threadGroup, runnable2, "Idea Main Thread").start();
    }

    @Nullable
    public static File getOnceInstalledIfExists() {
        File onceInstalledFile = new File(PathManager.getConfigPath(), INSTALLED_TXT);
        return onceInstalledFile.isFile() ? onceInstalledFile : null;
    }

    public static void processException(Throwable t) {
        if (!IdeaApplication.isLoaded()) {
            ImplementationConflictException conflictException;
            PluginException pe;
            PluginId pluginId;
            StartupAbortedException se;
            Set<String> pluginIds;
            String productName = ApplicationNamesInfo.getInstance().getFullProductName();
            PluginManagerCore.EssentialPluginMissingException exception = PluginManager.findCause(t, PluginManagerCore.EssentialPluginMissingException.class);
            Set<String> set2 = pluginIds = exception == null ? null : exception.pluginIds;
            if (pluginIds != null) {
                Object[] strings = ArrayUtil.toStringArray(pluginIds);
                Arrays.sort(strings);
                Main.showMessage((String)"Corrupted Installation", (String)("Missing essential plugin" + (strings.length == 1 ? "" : "s") + ":\n\n  " + StringUtil.join((String[])strings, (String)"\n  ") + "\n\nPlease reinstall " + productName + " from scratch."), (boolean)true);
                System.exit(12);
            }
            if ((se = PluginManager.findCause(t, StartupAbortedException.class)) == null) {
                se = new StartupAbortedException(t);
            }
            PluginId pluginId2 = pluginId = (pe = PluginManager.findCause(t, PluginException.class)) != null ? pe.getPluginId() : null;
            if (Logger.isInitialized() && !(t instanceof ProcessCanceledException)) {
                try {
                    PluginManager.getLogger().error(t);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (t instanceof StackOverflowError && "Nashorn AST Serializer".equals(Thread.currentThread().getName())) {
                    return;
                }
            }
            if ((conflictException = PluginManager.findCause(t, ImplementationConflictException.class)) != null) {
                PluginConflictReporter.INSTANCE.reportConflictByClasses(conflictException.getConflictingClasses());
            }
            if (pluginId != null && !ApplicationInfoImpl.getShadowInstance().isEssentialPlugin(pluginId.getIdString())) {
                PluginManager.disablePlugin(pluginId.getIdString());
                StringWriter message = new StringWriter();
                message.append("Plugin '").append(pluginId.getIdString()).append("' failed to initialize and will be disabled. ");
                message.append(" Please restart ").append(productName).append('.');
                message.append("\n\n");
                pe.getCause().printStackTrace(new PrintWriter(message));
                Main.showMessage((String)"Plugin Error", (String)message.toString(), (boolean)false);
                System.exit(8);
            } else {
                Main.showMessage((String)"Start Failed", (Throwable)t);
                System.exit(se.exitCode());
            }
        } else if (!(t instanceof ProcessCanceledException)) {
            PluginManager.getLogger().error(t);
        }
    }

    private static <T extends Throwable> T findCause(Throwable t, Class<T> clazz) {
        while (t != null) {
            if (clazz.isInstance(t)) {
                return (T)((Throwable)clazz.cast(t));
            }
            t = t.getCause();
        }
        return null;
    }

    public static void installExceptionHandler() {
        Thread.currentThread().setUncaughtExceptionHandler(HANDLER);
    }

    public static void reportPluginError() {
        if (myPluginError != null) {
            String title = IdeBundle.message((String)"title.plugin.error", (Object[])new Object[0]);
            Notifications.Bus.notify((Notification)new Notification(title, title, myPluginError, NotificationType.ERROR, new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (event == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    notification.expire();
                    String description = event.getDescription();
                    if ("edit".equals(description)) {
                        PluginManagerConfigurable configurable = new PluginManagerConfigurable(PluginManagerUISettings.getInstance());
                        IdeFrame ideFrame = WindowManagerEx.getInstanceEx().findFrameFor(null);
                        ShowSettingsUtil.getInstance().editConfigurable((Component)((JFrame)ideFrame), (Configurable)configurable);
                        return;
                    }
                    List<String> disabledPlugins = PluginManagerCore.getDisabledPlugins();
                    if (PluginManagerCore.myPlugins2Disable != null && "disable".equals(description)) {
                        for (String pluginId : PluginManagerCore.myPlugins2Disable) {
                            if (disabledPlugins.contains(pluginId)) continue;
                            disabledPlugins.add(pluginId);
                        }
                    } else if (PluginManagerCore.myPlugins2Enable != null && "enable".equals(description)) {
                        disabledPlugins.removeAll(PluginManagerCore.myPlugins2Enable);
                        PluginManagerMain.notifyPluginsUpdated(null);
                    }
                    try {
                        PluginManagerCore.saveDisabledPlugins(disabledPlugins, false);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    PluginManagerCore.myPlugins2Enable = null;
                    PluginManagerCore.myPlugins2Disable = null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/ide/plugins/PluginManager$2";
                    objectArray[2] = "hyperlinkUpdate";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }));
            myPluginError = null;
        }
    }

    public static boolean isPluginInstalled(PluginId id) {
        return PluginManager.getPlugin(id) != null;
    }

    @Nullable
    public static IdeaPluginDescriptor getPlugin(@Nullable PluginId id) {
        IdeaPluginDescriptor[] plugins2;
        for (IdeaPluginDescriptor plugin : plugins2 = PluginManager.getPlugins()) {
            if (!Comparing.equal((Object)id, (Object)plugin.getPluginId())) continue;
            return plugin;
        }
        return null;
    }

    public static void handleComponentError(Throwable t, @Nullable String componentClassName, @Nullable PluginId pluginId) {
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isUnitTestMode()) {
            ExceptionUtil.rethrow((Throwable)t);
        }
        if (t instanceof StartupAbortedException) {
            throw (StartupAbortedException)t;
        }
        if ((pluginId == null || "com.intellij".equals(pluginId.getIdString())) && componentClassName != null) {
            pluginId = PluginManager.getPluginByClassName(componentClassName);
        }
        if ((pluginId == null || "com.intellij".equals(pluginId.getIdString())) && t instanceof PicoPluginExtensionInitializationException) {
            pluginId = ((PicoPluginExtensionInitializationException)t).getPluginId();
        }
        if (pluginId != null && !"com.intellij".equals(pluginId.getIdString())) {
            throw new StartupAbortedException("Fatal error initializing plugin " + pluginId.getIdString(), (Throwable)new PluginException(t, pluginId));
        }
        throw new StartupAbortedException("Fatal error initializing '" + componentClassName + "'", t);
    }

    static {
        HANDLER = (t, e) -> PluginManager.processException(e);
    }

    private static class StartupAbortedException
    extends RuntimeException {
        private int exitCode = 3;

        public StartupAbortedException(Throwable cause) {
            super(cause);
        }

        public StartupAbortedException(String message, Throwable cause) {
            super(message, cause);
        }

        public int exitCode() {
            return this.exitCode;
        }

        public StartupAbortedException exitCode(int exitCode) {
            this.exitCode = exitCode;
            return this;
        }
    }
}

