/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MarkRootActionBase
extends DumbAwareAction {
    public MarkRootActionBase() {
    }

    public MarkRootActionBase(@Nullable String text) {
        super(text);
    }

    public MarkRootActionBase(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    public void actionPerformed(AnActionEvent e) {
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Module module = MarkRootActionBase.getModule(e, files);
        if (module == null) {
            return;
        }
        this.modifyRoots(e, module, files);
    }

    protected void modifyRoots(@NotNull AnActionEvent e, @NotNull Module module, @NotNull VirtualFile[] files) {
        if (e == null) {
            MarkRootActionBase.$$$reportNull$$$0(0);
        }
        if (module == null) {
            MarkRootActionBase.$$$reportNull$$$0(1);
        }
        if (files == null) {
            MarkRootActionBase.$$$reportNull$$$0(2);
        }
        ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        for (VirtualFile file2 : files) {
            SourceFolder[] sourceFolders;
            ContentEntry entry = MarkRootActionBase.findContentEntry((ModuleRootModel)model, file2);
            if (entry == null) continue;
            for (SourceFolder sourceFolder : sourceFolders = entry.getSourceFolders()) {
                if (!Comparing.equal((Object)sourceFolder.getFile(), (Object)file2)) continue;
                entry.removeSourceFolder(sourceFolder);
                break;
            }
            this.modifyRoots(file2, entry);
        }
        MarkRootActionBase.commitModel(module, model);
    }

    static void commitModel(@NotNull Module module, ModifiableRootModel model) {
        if (module == null) {
            MarkRootActionBase.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (module == null) {
                MarkRootActionBase.$$$reportNull$$$0(10);
            }
            model.commit();
            module.getProject().save();
        });
    }

    protected abstract void modifyRoots(VirtualFile var1, ContentEntry var2);

    @Nullable
    public static ContentEntry findContentEntry(@NotNull ModuleRootModel model, @NotNull VirtualFile vFile) {
        ContentEntry[] contentEntries;
        if (model == null) {
            MarkRootActionBase.$$$reportNull$$$0(4);
        }
        if (vFile == null) {
            MarkRootActionBase.$$$reportNull$$$0(5);
        }
        for (ContentEntry contentEntry : contentEntries = model.getContentEntries()) {
            VirtualFile contentEntryFile = contentEntry.getFile();
            if (contentEntryFile == null || !VfsUtilCore.isAncestor((VirtualFile)contentEntryFile, (VirtualFile)vFile, (boolean)false)) continue;
            return contentEntry;
        }
        return null;
    }

    public void update(AnActionEvent e) {
        RootsSelection selection = MarkRootActionBase.getSelection(e);
        this.doUpdate(e, selection.myModule, selection);
    }

    protected void doUpdate(@NotNull AnActionEvent e, @Nullable Module module, @NotNull RootsSelection selection) {
        if (e == null) {
            MarkRootActionBase.$$$reportNull$$$0(6);
        }
        if (selection == null) {
            MarkRootActionBase.$$$reportNull$$$0(7);
        }
        boolean enabled = module != null && (!selection.mySelectedRoots.isEmpty() || !selection.mySelectedDirectories.isEmpty()) && selection.mySelectedExcludeRoots.isEmpty() && this.isEnabled(selection, module);
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    protected abstract boolean isEnabled(@NotNull RootsSelection var1, @NotNull Module var2);

    protected static RootsSelection getSelection(AnActionEvent e) {
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Module module = MarkRootActionBase.getModule(e, files);
        if (module == null) {
            return RootsSelection.EMPTY;
        }
        RootsSelection selection = new RootsSelection(module);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        for (VirtualFile file2 : files) {
            if (!file2.isDirectory()) {
                return RootsSelection.EMPTY;
            }
            ExcludeFolder excludeFolder = ProjectRootsUtil.findExcludeFolder(module, file2);
            if (excludeFolder != null) {
                selection.mySelectedExcludeRoots.add(excludeFolder);
                continue;
            }
            SourceFolder folder = ProjectRootsUtil.findSourceFolder(module, file2);
            if (folder != null) {
                selection.mySelectedRoots.add(folder);
                continue;
            }
            selection.mySelectedDirectories.add(file2);
            if (!fileIndex.isInSourceContent(file2)) continue;
            selection.myHaveSelectedFilesUnderSourceRoots = true;
        }
        return selection;
    }

    @Nullable
    static Module getModule(@NotNull AnActionEvent e, @Nullable VirtualFile[] files) {
        if (e == null) {
            MarkRootActionBase.$$$reportNull$$$0(8);
        }
        if (files == null) {
            return null;
        }
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        if (module == null) {
            module = MarkRootActionBase.findParentModule(e.getProject(), files);
        }
        return module;
    }

    @Nullable
    private static Module findParentModule(@Nullable Project project, @NotNull VirtualFile[] files) {
        if (files == null) {
            MarkRootActionBase.$$$reportNull$$$0(9);
        }
        if (project == null) {
            return null;
        }
        Module result2 = null;
        DirectoryIndex index = DirectoryIndex.getInstance(project);
        for (VirtualFile file2 : files) {
            Module module = index.getInfoForFile(file2).getModule();
            if (module == null) {
                return null;
            }
            if (result2 == null) {
                result2 = module;
                continue;
            }
            if (result2.equals(module)) continue;
            return null;
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/projectView/actions/MarkRootActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "modifyRoots";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "commitModel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findContentEntry";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "doUpdate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getModule";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findParentModule";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$commitModel$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class RootsSelection {
        public static final RootsSelection EMPTY = new RootsSelection(null);
        public final Module myModule;
        public List<SourceFolder> mySelectedRoots = new ArrayList<SourceFolder>();
        public List<ExcludeFolder> mySelectedExcludeRoots = new ArrayList<ExcludeFolder>();
        public List<VirtualFile> mySelectedDirectories = new ArrayList<VirtualFile>();
        public boolean myHaveSelectedFilesUnderSourceRoots;

        public RootsSelection(Module module) {
            this.myModule = module;
        }
    }
}

