/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.IconCache;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalRadioButtonUI;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class DarculaRadioButtonUI
extends MetalRadioButtonUI {
    private static final Icon DEFAULT_ICON = ((EmptyIcon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)19))).asUIResource();

    public static ComponentUI createUI(JComponent c) {
        return new DarculaRadioButtonUI();
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setIconTextGap(JBUI.scale((int)4));
    }

    @Override
    public synchronized void paint(Graphics g2d, JComponent c) {
        Graphics2D g = (Graphics2D)g2d;
        Dimension size = c.getSize();
        Rectangle viewRect = new Rectangle(size);
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        AbstractButton b = (AbstractButton)c;
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = SwingUtilities2.getFontMetrics(c, g, f);
        JBInsets.removeFrom((Rectangle)viewRect, (Insets)c.getInsets());
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), this.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getIconTextGap());
        if (c.isOpaque()) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, size.width, size.height);
        }
        this.paintIcon(c, g, viewRect, iconRect);
        this.drawText(b, g, text, textRect, fm);
    }

    protected void paintIcon(JComponent c, Graphics2D g, Rectangle viewRect, Rectangle iconRect) {
        Icon icon = IconCache.getIcon("radio", ((AbstractButton)c).isSelected(), c.hasFocus(), c.isEnabled());
        icon.paintIcon(c, g, iconRect.x, iconRect.y);
    }

    protected void drawText(AbstractButton b, Graphics2D g, String text, Rectangle textRect, FontMetrics fm) {
        if (text != null) {
            View v = (View)b.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                int mnemonicIndex = b.getDisplayedMnemonicIndex();
                g.setColor(b.isEnabled() ? b.getForeground() : this.getDisabledTextColor());
                SwingUtilities2.drawStringUnderlineCharAt(b, g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
            }
        }
        if (b.hasFocus() && b.isFocusPainted() && textRect.width > 0 && textRect.height > 0) {
            this.paintFocus(g, textRect, b.getSize());
        }
    }

    @Override
    protected void paintFocus(Graphics g, Rectangle t, Dimension d) {
    }

    @Override
    public Icon getDefaultIcon() {
        return DEFAULT_ICON;
    }
}

