/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.NotNull;

public class WinIntelliJButtonBorder
implements Border,
UIResource {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (!(c instanceof AbstractButton) || UIUtil.isHelpButton((Component)c)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        AbstractButton b = (AbstractButton)c;
        ButtonModel bm = b.getModel();
        Rectangle outerRect = new Rectangle(x, y, width, height);
        try {
            JBInsets.removeFrom((Rectangle)outerRect, (Insets)this.getOuterInsets());
            if (UIUtil.getParentOfType(ActionToolbar.class, (Component)c) != null) {
                JBInsets.removeFrom((Rectangle)outerRect, (Insets)JBUI.insetsRight((int)3));
            }
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            Color color = UIManager.getColor("Button.intellij.native.borderColor");
            if (!c.isEnabled()) {
                g2.setComposite(AlphaComposite.getInstance(3, 0.47f));
            } else if (bm.isPressed()) {
                color = UIManager.getColor("Button.intellij.native.pressedBorderColor");
            } else if (b.hasFocus() || bm.isRollover()) {
                color = UIManager.getColor("Button.intellij.native.focusedBorderColor");
            } else if (DarculaButtonUI.isDefaultButton(b)) {
                color = UIManager.getColor("Button.intellij.native.focusedBorderColor");
            }
            int bw = WinIntelliJButtonBorder.getBorderWidth(b);
            Path2D.Float border = new Path2D.Float(0);
            border.append(outerRect, false);
            Rectangle innerRect = new Rectangle(outerRect);
            JBInsets.removeFrom((Rectangle)innerRect, (Insets)JBUI.insets((int)bw));
            border.append(innerRect, false);
            g2.setColor(color);
            g2.fill(border);
        }
        finally {
            g2.dispose();
        }
    }

    @NotNull
    public JBInsets getOuterInsets() {
        JBInsets jBInsets = JBUI.insets((int)1);
        if (jBInsets == null) {
            WinIntelliJButtonBorder.$$$reportNull$$$0(0);
        }
        return jBInsets;
    }

    public static boolean isWideBorder(@NotNull AbstractButton b) {
        if (b == null) {
            WinIntelliJButtonBorder.$$$reportNull$$$0(1);
        }
        ButtonModel bm = b.getModel();
        return b.isEnabled() && !bm.isPressed() && !b.hasFocus() && !bm.isRollover() && DarculaButtonUI.isDefaultButton(b);
    }

    public static int getBorderWidth(@NotNull AbstractButton b) {
        if (b == null) {
            WinIntelliJButtonBorder.$$$reportNull$$$0(2);
        }
        return WinIntelliJButtonBorder.isWideBorder(b) ? 2 : 1;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (DarculaButtonUI.isSquare(c)) {
            return JBUI.insets((int)2).asUIResource();
        }
        if (UIUtil.isHelpButton((Component)c)) {
            return JBUI.insets((int)0, (int)0, (int)0, (int)10).asUIResource();
        }
        if (DarculaButtonUI.isComboButton((JComponent)c)) {
            return JBUI.insets((int)4, (int)10).asUIResource();
        }
        return JBUI.insets((int)4, (int)18).asUIResource();
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/laf/intellij/WinIntelliJButtonBorder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOuterInsets";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/laf/intellij/WinIntelliJButtonBorder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isWideBorder";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBorderWidth";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

