/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.IconCache;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaComboBoxUI;
import com.intellij.openapi.editor.Editor;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Path2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class WinIntelliJComboBoxUI
extends DarculaComboBoxUI {
    private static final String HOVER_PROPERTY = "JComboBox.mouseHover";
    private static final String PRESSED_PROPERTY = "JComboBox.mousePressed";
    private static final Border DEFAULT_EDITOR_BORDER = JBUI.Borders.empty((int)1, (int)0);
    private static final JBDimension ARROW_BUTTON_SIZE = new JBDimension(21, 24);
    private MouseListener mouseListener;
    private MouseListener buttonReleaseListener;
    private MouseListener buttonHoverListener;
    private MouseListener editorHoverListener;

    public static ComponentUI createUI(JComponent c) {
        return new WinIntelliJComboBoxUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (!this.comboBox.isEditable()) {
            this.mouseListener = new ComboBoxMouseListener();
            this.comboBox.addMouseListener(this.mouseListener);
        }
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removeMouseListener(this.mouseListener);
    }

    @Override
    protected PropertyChangeListener createPropertyListener() {
        return e -> {
            if ("enabled".equals(e.getPropertyName())) {
                EditorTextField etf = (EditorTextField)((Object)UIUtil.findComponentOfType((JComponent)((JComponent)this.editor), EditorTextField.class));
                if (etf != null) {
                    etf.setBackground(this.getComboBackground(true));
                }
            } else if ("editable".equals(e.getPropertyName())) {
                if (e.getNewValue() == Boolean.TRUE) {
                    this.comboBox.removeMouseListener(this.mouseListener);
                } else {
                    this.comboBox.addMouseListener(this.mouseListener);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            boolean applyAlpha;
            Container parent;
            Rectangle r = new Rectangle(c.getSize());
            if (c.isOpaque() && (parent = c.getParent()) != null) {
                g2.setColor(WinIntelliJComboBoxUI.isTableCellEditor(c) && this.editor != null ? this.editor.getBackground() : parent.getBackground());
                g2.fill(r);
            }
            boolean isOpaque = this.editor != null && this.editor.isOpaque();
            g2.setColor(this.getComboBackground(isOpaque));
            JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)2));
            boolean bl = applyAlpha = !this.comboBox.isEnabled() && (!isOpaque || !this.comboBox.isEditable());
            if (applyAlpha) {
                float alpha = this.comboBox.isEditable() ? 0.35f : 0.47f;
                g2.setComposite(AlphaComposite.getInstance(3, alpha));
            }
            g2.fill(r);
            if (!this.comboBox.isEditable()) {
                this.hasFocus = this.comboBox.hasFocus();
                this.paintCurrentValue(g2, this.rectangleForCurrentValue(), this.hasFocus);
            }
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    protected Rectangle rectangleForCurrentValue() {
        int w = this.comboBox.getWidth();
        int h = this.comboBox.getHeight();
        Insets i = this.comboBox.getInsets();
        int buttonWidth = h;
        if (this.arrowButton != null) {
            buttonWidth = this.comboBox.getComponentOrientation().isLeftToRight() ? this.arrowButton.getWidth() - i.right : this.arrowButton.getWidth() - i.left;
        }
        return this.comboBox.getComponentOrientation().isLeftToRight() ? new Rectangle(i.left, i.top, w - (i.left + i.right + buttonWidth), h - (i.top + i.bottom)) : new Rectangle(i.left + buttonWidth, i.top, w - (i.left + i.right + buttonWidth), h - (i.top + i.bottom));
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        Component c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        c.setFont(this.comboBox.getFont());
        c.setForeground(this.comboBox.isEnabled() ? UIManager.getColor("Label.foreground") : UIManager.getColor("Label.disabledForeground"));
        Rectangle r = new Rectangle(bounds);
        boolean changeOpaque = false;
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            jc.setBorder(DEFAULT_EDITOR_BORDER);
            JBInsets.removeFrom((Rectangle)r, (Insets)jc.getInsets());
            changeOpaque = c.isOpaque();
            if (changeOpaque) {
                jc.setOpaque(false);
            }
        }
        this.currentValuePane.paintComponent(g, c, this.comboBox, r.x, r.y, r.width, r.height, c instanceof JPanel);
        if (changeOpaque) {
            ((JComponent)c).setOpaque(true);
        }
    }

    private Color getComboBackground(boolean opaque) {
        if (this.comboBox != null) {
            if (this.comboBox.isEnabled() && this.comboBox.isEditable()) {
                return UIManager.getColor("TextField.background");
            }
            if (!this.comboBox.isEnabled()) {
                return opaque ? UIManager.getColor("Button.background.opaque") : UIManager.getColor("Button.background");
            }
            if (!this.comboBox.isEditable()) {
                if (this.isPressed() || this.popup.isVisible()) {
                    return UIManager.getColor("Button.intellij.native.pressedBackgroundColor");
                }
                if (this.isHover()) {
                    return UIManager.getColor("Button.intellij.native.focusedBackgroundColor");
                }
            }
        }
        return UIManager.getColor("Button.background");
    }

    @Override
    protected JButton createArrowButton() {
        BasicArrowButton button = new BasicArrowButton(5){

            @Override
            public Dimension getPreferredSize() {
                return ARROW_BUTTON_SIZE;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paint(Graphics g) {
                if (!UIUtil.isUnderWin10LookAndFeel()) {
                    return;
                }
                Graphics2D g2 = (Graphics2D)g.create();
                try {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                    Rectangle outerRect = new Rectangle(this.getSize());
                    JBInsets.removeFrom((Rectangle)outerRect, (Insets)JBUI.insets((int)1));
                    Rectangle innerRect = new Rectangle(outerRect);
                    JBInsets.removeFrom((Rectangle)innerRect, (Insets)JBUI.insets((int)1));
                    if (WinIntelliJComboBoxUI.this.comboBox.isEditable() && WinIntelliJComboBoxUI.this.comboBox.isEnabled()) {
                        if (WinIntelliJComboBoxUI.this.isPressed() || WinIntelliJComboBoxUI.this.popup.isVisible()) {
                            g2.setColor(UIManager.getColor("Button.intellij.native.pressedBackgroundColor"));
                        } else if (WinIntelliJComboBoxUI.this.comboBox.hasFocus() || WinIntelliJComboBoxUI.this.isHover()) {
                            g2.setColor(UIManager.getColor("Button.intellij.native.focusedBackgroundColor"));
                        } else {
                            g2.setColor(WinIntelliJComboBoxUI.this.getComboBackground(false));
                        }
                        g2.fill(innerRect);
                    }
                    if (WinIntelliJComboBoxUI.this.comboBox.isEditable() && WinIntelliJComboBoxUI.this.comboBox.isEnabled()) {
                        Path2D.Float border = new Path2D.Float(0);
                        border.append(outerRect, false);
                        border.append(innerRect, false);
                        if (this.getModel().isPressed() || WinIntelliJComboBoxUI.this.popup.isVisible()) {
                            g2.setColor(UIManager.getColor("Button.intellij.native.pressedBorderColor"));
                            g2.fill(border);
                        } else if (WinIntelliJComboBoxUI.this.comboBox.hasFocus() || WinIntelliJComboBoxUI.this.isHover()) {
                            g2.setColor(UIManager.getColor("Button.intellij.native.focusedBorderColor"));
                            g2.fill(border);
                        }
                    }
                    Icon icon = WinIntelliJComboBoxUI.getArrowIcon(this);
                    int x = JBUI.scale((int)5);
                    int y = (this.getHeight() - icon.getIconHeight()) / 2;
                    icon.paintIcon(this, g2, x, y);
                }
                finally {
                    g2.dispose();
                }
            }
        };
        button.setOpaque(false);
        this.buttonReleaseListener = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!WinIntelliJComboBoxUI.this.comboBox.isEditable()) {
                    WinIntelliJComboBoxUI.this.comboBox.repaint();
                }
            }
        };
        this.buttonHoverListener = new DarculaUIUtil.MouseHoverPropertyTrigger(this.comboBox, HOVER_PROPERTY);
        button.addMouseListener(this.buttonHoverListener);
        button.addMouseListener(this.buttonReleaseListener);
        return button;
    }

    public static Icon getArrowIcon(@NotNull JComponent c) {
        if (c == null) {
            WinIntelliJComboBoxUI.$$$reportNull$$$0(0);
        }
        return IconCache.getIcon("comboDropTriangle", false, false, c.isEnabled());
    }

    @Override
    public void unconfigureArrowButton() {
        super.unconfigureArrowButton();
        if (this.arrowButton != null) {
            this.arrowButton.removeMouseListener(this.buttonReleaseListener);
            this.arrowButton.removeMouseListener(this.buttonHoverListener);
        }
    }

    @Override
    protected ComboBoxEditor createEditor() {
        BasicComboBoxEditor.UIResource comboBoxEditor = new BasicComboBoxEditor.UIResource(){

            @Override
            protected JTextField createEditorComponent() {
                return new JTextField(){

                    @Override
                    public void setText(String s) {
                        if (this.getText().equals(s)) {
                            return;
                        }
                        super.setText(s);
                    }

                    @Override
                    public Color getBackground() {
                        return WinIntelliJComboBoxUI.this.getComboBackground(false);
                    }

                    @Override
                    public Border getBorder() {
                        return DEFAULT_EDITOR_BORDER;
                    }

                    @Override
                    public Insets getInsets() {
                        return DEFAULT_EDITOR_BORDER.getBorderInsets(this);
                    }

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension size = super.getPreferredSize();
                        return new Dimension(size.width, Math.max(JBUI.scale((int)18), size.height));
                    }
                };
            }
        };
        this.installEditorKeyListener(comboBoxEditor);
        return comboBoxEditor;
    }

    @Override
    protected void configureEditor() {
        super.configureEditor();
        if (this.editor instanceof JComponent) {
            JComponent jEditor = (JComponent)this.editor;
            jEditor.setBorder(DEFAULT_EDITOR_BORDER);
            this.editorHoverListener = new DarculaUIUtil.MouseHoverPropertyTrigger(this.comboBox, HOVER_PROPERTY);
            if (this.editor instanceof JTextComponent) {
                this.editor.addMouseListener(this.editorHoverListener);
            } else {
                EditorTextField etf = (EditorTextField)((Object)UIUtil.findComponentOfType((JComponent)((JComponent)this.editor), EditorTextField.class));
                if (etf != null) {
                    etf.addMouseListener(this.editorHoverListener);
                    etf.setBackground(this.getComboBackground(true));
                }
            }
        }
    }

    @Override
    protected void unconfigureEditor() {
        super.unconfigureEditor();
        if (this.editor instanceof JTextComponent) {
            if (this.editorHoverListener != null) {
                this.editor.removeMouseListener(this.editorHoverListener);
            }
        } else {
            EditorTextField etf = (EditorTextField)((Object)UIUtil.findComponentOfType((JComponent)((JComponent)this.editor), EditorTextField.class));
            if (etf != null && this.editorHoverListener != null) {
                etf.removeMouseListener(this.editorHoverListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.comboBox == null || this.arrowButton == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            this.checkFocus();
            Rectangle r = new Rectangle(x, y, width, height);
            int bw = 1;
            Object op = this.comboBox.getClientProperty("JComponent.outline");
            if (op != null) {
                DarculaUIUtil.Outline.valueOf(op.toString()).setGraphicsColor(g2, this.hasFocus);
                bw = 2;
            } else if (this.comboBox.isEnabled()) {
                if (this.comboBox.isEditable()) {
                    if (this.hasFocus) {
                        g2.setColor(UIManager.getColor("TextField.focusedBorderColor"));
                    } else {
                        g2.setColor(UIManager.getColor(this.isEditorHover() ? "TextField.hoverBorderColor" : "TextField.borderColor"));
                    }
                } else if (this.isPressed() || this.popup.isVisible()) {
                    g2.setColor(UIManager.getColor("Button.intellij.native.pressedBorderColor"));
                } else if (this.isHover() || this.hasFocus) {
                    g2.setColor(UIManager.getColor("Button.intellij.native.focusedBorderColor"));
                } else {
                    g2.setColor(UIManager.getColor("Button.intellij.native.borderColor"));
                }
                JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1));
            } else {
                g2.setColor(UIManager.getColor("Button.intellij.native.borderColor"));
                float alpha = this.comboBox.isEditable() ? 0.35f : 0.47f;
                g2.setComposite(AlphaComposite.getInstance(3, alpha));
                JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1));
            }
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            Path2D.Float border = new Path2D.Float(0);
            border.append(r, false);
            Rectangle innerRect = new Rectangle(r);
            JBInsets.removeFrom((Rectangle)innerRect, (Insets)JBUI.insets((int)bw));
            border.append(innerRect, false);
            g2.fill(border);
        }
        finally {
            g2.dispose();
        }
    }

    private boolean isHover() {
        return this.comboBox != null && this.comboBox.getClientProperty(HOVER_PROPERTY) == Boolean.TRUE || this.arrowButton != null && this.arrowButton.getClientProperty(HOVER_PROPERTY) == Boolean.TRUE;
    }

    private boolean isEditorHover() {
        JComponent ec = (JComponent)this.comboBox.getEditor().getEditorComponent();
        EditorTextField etf = (EditorTextField)((Object)UIUtil.findComponentOfType((JComponent)((JComponent)this.editor), EditorTextField.class));
        Editor editor = etf != null ? etf.getEditor() : null;
        return this.arrowButton != null && this.arrowButton.getClientProperty(HOVER_PROPERTY) == Boolean.TRUE || ec != null && ec.getClientProperty(HOVER_PROPERTY) == Boolean.TRUE || editor != null && editor.getContentComponent().getClientProperty(HOVER_PROPERTY) == Boolean.TRUE;
    }

    private boolean isPressed() {
        return this.comboBox != null && this.comboBox.getClientProperty(PRESSED_PROPERTY) == Boolean.TRUE || this.arrowButton != null && this.arrowButton.getModel().isPressed();
    }

    @Override
    protected Insets getInsets() {
        return this.getBorderInsets(this.comboBox);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return c.getComponentOrientation().isLeftToRight() ? JBUI.insets((int)2, (int)7, (int)2, (int)2).asUIResource() : JBUI.insets((int)2, (int)2, (int)2, (int)7).asUIResource();
    }

    @Override
    protected Dimension getSizeWithButton(Dimension d) {
        ARROW_BUTTON_SIZE.update();
        Insets i = this.getInsets();
        int width = WinIntelliJComboBoxUI.ARROW_BUTTON_SIZE.width + i.left;
        int editorHeight = this.editor != null ? this.editor.getPreferredSize().height + i.top + i.bottom : 0;
        return new Dimension(Math.max(d.width + JBUI.scale((int)5), width), Math.max(editorHeight, Math.max(WinIntelliJComboBoxUI.ARROW_BUTTON_SIZE.height, d.height)));
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new BasicComboBoxUI.ComboBoxLayoutManager(){

            @Override
            public void layoutContainer(Container parent) {
                JComboBox cb = (JComboBox)parent;
                if (WinIntelliJComboBoxUI.this.arrowButton != null) {
                    if (cb.getComponentOrientation().isLeftToRight()) {
                        WinIntelliJComboBoxUI.this.arrowButton.setBounds(cb.getWidth() - ARROW_BUTTON_SIZE.width, 0, ARROW_BUTTON_SIZE.width, cb.getHeight());
                    } else {
                        WinIntelliJComboBoxUI.this.arrowButton.setBounds(0, 0, ARROW_BUTTON_SIZE.width, cb.getHeight());
                    }
                }
                WinIntelliJComboBoxUI.this.layoutEditor();
            }
        };
    }

    @Override
    protected ComboPopup createPopup() {
        return new BasicComboPopup(this.comboBox){

            @Override
            protected void configurePopup() {
                super.configurePopup();
                this.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                        comboBox.repaint();
                    }
                });
                this.setBorder(UIManager.getBorder("PopupMenu.border"));
            }

            @Override
            protected void configureList() {
                super.configureList();
                this.list.setBackground(UIManager.getColor("TextField.background"));
                this.wrapRenderer();
            }

            @Override
            protected PropertyChangeListener createPropertyChangeListener() {
                final PropertyChangeListener listener2 = super.createPropertyChangeListener();
                return new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        listener2.propertyChange(evt);
                        if ("renderer".equals(evt.getPropertyName())) {
                            this.wrapRenderer();
                        }
                    }
                };
            }

            private void wrapRenderer() {
                ListCellRenderer<Object> renderer = this.list.getCellRenderer();
                if (!(renderer instanceof ComboBoxRendererWrapper) && renderer != null) {
                    this.list.setCellRenderer(new ComboBoxRendererWrapper(renderer));
                }
            }

            @Override
            public void show(Component invoker, int x, int y) {
                super.show(invoker, x, y - JBUI.scale((int)1));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/ide/ui/laf/intellij/WinIntelliJComboBoxUI", "getArrowIcon"));
    }

    private static class ComboBoxRendererWrapper
    implements ListCellRenderer<Object> {
        private final ListCellRenderer<Object> myRenderer;

        public ComboBoxRendererWrapper(@NotNull ListCellRenderer<Object> renderer) {
            if (renderer == null) {
                ComboBoxRendererWrapper.$$$reportNull$$$0(0);
            }
            this.myRenderer = renderer;
        }

        @Override
        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = this.myRenderer.getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
            BorderLayoutPanel panel2 = (BorderLayoutPanel)JBUI.Panels.simplePanel((Component)c).withBorder((Border)(list2.getComponentOrientation().isLeftToRight() ? JBUI.Borders.empty((int)0, (int)5, (int)0, (int)1) : JBUI.Borders.empty((int)0, (int)1, (int)0, (int)5)));
            panel2.setBackground(c.getBackground());
            return panel2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/ide/ui/laf/intellij/WinIntelliJComboBoxUI$ComboBoxRendererWrapper", "<init>"));
        }
    }

    private class ComboBoxMouseListener
    extends MouseAdapter {
        private ComboBoxMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.setPressedProperty(true);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.setPressedProperty(false);
        }

        private void setPressedProperty(boolean isPressed) {
            if (!WinIntelliJComboBoxUI.this.comboBox.isEditable()) {
                WinIntelliJComboBoxUI.this.comboBox.putClientProperty(WinIntelliJComboBoxUI.PRESSED_PROPERTY, isPressed);
                WinIntelliJComboBoxUI.this.comboBox.repaint();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.setHoverProperty(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.setHoverProperty(false);
        }

        private void setHoverProperty(boolean isHover) {
            WinIntelliJComboBoxUI.this.comboBox.putClientProperty(WinIntelliJComboBoxUI.HOVER_PROPERTY, isHover);
            WinIntelliJComboBoxUI.this.comboBox.repaint();
        }
    }
}

