/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileTextField;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/internal/ShowUpdateInfoDialogAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.ide.impl"})
public final class ShowUpdateInfoDialogAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        String updateInfoText;
        FileTextField fileField;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = e.getProject();
        JTextArea textArea = new JTextArea(40, 100);
        UIUtil.addUndoRedoActions((JTextComponent)textArea);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        Disposable disposable = Disposer.newDisposable();
        FileTextField fileTextField = fileField = FileChooserFactory.getInstance().createFileTextField(BrowseFilesListener.SINGLE_FILE_DESCRIPTOR, disposable);
        Intrinsics.checkExpressionValueIsNotNull((Object)fileTextField, (String)"fileField");
        TextFieldWithBrowseButton fileCombo = new TextFieldWithBrowseButton(fileTextField.getField());
        FileChooserDescriptor fileDescriptor = FileChooserDescriptorFactory.createSingleLocalFileDescriptor();
        fileCombo.addBrowseFolderListener("Patch File", "Patch file", project, fileDescriptor);
        JPanel panel2 = new JPanel(new BorderLayout(0, JBUI.scale((int)10)));
        panel2.add((Component)ScrollPaneFactory.createScrollPane((Component)textArea), "Center");
        panel2.add((Component)LabeledComponent.create((JComponent)((JComponent)fileCombo), (String)"Patch file:"), "South");
        DialogBuilder builder = new DialogBuilder(project);
        builder.addDisposable(disposable);
        builder.setCenterPanel((JComponent)panel2);
        builder.setPreferredFocusComponent((JComponent)textArea);
        builder.setTitle("Updates.xml <channel> Text");
        builder.addOkAction();
        builder.addCancelAction();
        builder.setDimensionServiceKey("TEST_UPDATE_INFO_DIALOG");
        if (builder.showAndGet() && !StringUtil.isEmpty((String)(updateInfoText = StringUtil.trim((String)textArea.getText())))) {
            String patchFilePath = StringKt.nullize((String)fileCombo.getText(), (boolean)true);
            String string = updateInfoText;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"updateInfoText");
            UpdateChecker.INSTANCE.testPlatformUpdate(string, patchFilePath);
        }
    }
}

